# Production Update Guide - v2.0.0

## Pre-Update Checklist

- [ ] Schedule maintenance window
- [ ] Notify users of downtime
- [ ] Backup database
- [ ] Backup application files
- [ ] Test update in staging environment

---

## Step 1: Database Backup

### Windows (PowerShell)
```powershell
# Set password
$env:PGPASSWORD = "your_password"

# Full database backup
& "C:\Program Files\PostgreSQL\18\bin\pg_dump.exe" -U postgres -d your_database_name -F c -f "backup_pre_v2.0.0_$(Get-Date -Format 'yyyyMMdd_HHmmss').backup"

# Schema-only backup (for reference)
& "C:\Program Files\PostgreSQL\18\bin\pg_dump.exe" -U postgres -d your_database_name -s -f "schema_pre_v2.0.0.sql"
```

### Linux/Mac
```bash
export PGPASSWORD="your_password"

# Full database backup
pg_dump -U postgres -d your_database_name -F c -f "backup_pre_v2.0.0_$(date +%Y%m%d_%H%M%S).backup"
```

---

## Step 2: Application Backup

```bash
# Create a zip of the entire application
# Windows
Compress-Archive -Path "C:\xampp\htdocs\dmsnew" -DestinationPath "dmsnew_backup_pre_v2.0.0.zip"

# Linux/Mac
tar -czvf dmsnew_backup_pre_v2.0.0.tar.gz /path/to/dmsnew
```

---

## Step 3: Run Schema Update

### Windows (PowerShell)
```powershell
$env:PGPASSWORD = "your_password"
& "C:\Program Files\PostgreSQL\18\bin\psql.exe" -U postgres -d your_database_name -f "C:\xampp\htdocs\dmsnew\application\sql\production_update_v2.0.0.sql"
```

### Linux/Mac
```bash
export PGPASSWORD="your_password"
psql -U postgres -d your_database_name -f /path/to/dmsnew/application/sql/production_update_v2.0.0.sql
```

### Expected Output
```
NOTICE:  Added company_id to sub_type
NOTICE:  Added is_enabled to sub_type
NOTICE:  Added company_id to authority
... (more notices)
NOTICE:  Indexes created successfully
NOTICE:  VERIFICATION PASSED: All company_id columns added successfully (9 tables)

==============================================
MIGRATION COMPLETED SUCCESSFULLY
Version: 2.0.0 - Company-Wise Masters
==============================================
```

---

## Step 4: Deploy Application Code

1. Stop web server (if needed for your deployment)
2. Deploy updated files:
   - `application/models/Dashboard_model.php`
   - `application/models/Upload_Model.php`
   - `application/models/Reminder_model.php`
   - `application/models/Permission_model.php`
   - `application/models/Authority_model.php`
   - `application/models/Holiday_model.php`
   - `application/controllers/user.php`
   - `application/controllers/type.php`
   - `application/controllers/upload.php`
   - `application/controllers/company.php`
   - `application/controllers/Authority.php`
   - `application/controllers/document.php`
   - `application/controllers/Holiday.php`
   - `application/controllers/CompanyDocHeads.php`
   - `application/views/users/add_user.php`
   - `application/views/users/edit_user.php`
   - `application/helpers/permission_helper.php`

3. Restart web server

---

## Step 5: Verify Deployment

### Quick Verification Queries
```sql
-- Verify columns exist
SELECT table_name, column_name 
FROM information_schema.columns 
WHERE column_name IN ('company_id', 'is_enabled')
AND table_name IN ('sub_type', 'authority', 'documents', 'mandatory_documents')
ORDER BY table_name, column_name;

-- Verify indexes
SELECT indexname FROM pg_indexes 
WHERE indexname LIKE '%company%';
```

### Quick Application Test
1. Login as Super Admin
2. Navigate to Dashboard - should load without errors
3. Navigate to Users → Add User - new card-based UI should appear
4. Navigate to Masters → Authority - list should display
5. Navigate to Upload Documents - should work

---

## Step 6: Post-Update Tasks

1. Clear application cache (if applicable)
2. Clear browser cache
3. Monitor error logs for 1-2 hours
4. Run manual test cases (see MANUAL_TEST_CASES_v2.0.0.md)
5. Notify users system is back online

---

## Rollback Procedure

If issues are found:

### 1. Restore Database
```powershell
# Windows
$env:PGPASSWORD = "your_password"
& "C:\Program Files\PostgreSQL\18\bin\pg_restore.exe" -U postgres -d your_database_name -c "backup_pre_v2.0.0_TIMESTAMP.backup"
```

### 2. Restore Application Files
```powershell
# Windows
Expand-Archive -Path "dmsnew_backup_pre_v2.0.0.zip" -DestinationPath "C:\xampp\htdocs\" -Force
```

### 3. Restart Web Server

---

## Monitoring

### Log Files to Watch
- Apache error log: `C:\xampp\apache\logs\error.log`
- PHP error log (if configured)
- PostgreSQL log

### Common Issues

| Issue | Cause | Solution |
|-------|-------|----------|
| "column company_id does not exist" | SQL migration not run | Run production_update_v2.0.0.sql |
| "Undefined property: company_id" | Old model cached | Clear cache, restart server |
| Company access cards not showing | JavaScript error | Clear browser cache |
| User not seeing company data | company_id not set | Check user_companies table |

---

## Support Contact

For issues during deployment:
- Technical Lead: [Contact Info]
- Database Admin: [Contact Info]
- On-Call: [Contact Info]

---

## Version History

| Version | Date | Description |
|---------|------|-------------|
| 2.0.0 | Feb 2026 | Company-wise masters implementation |


