<style>
	/* Smaller input height to match header */
.filters-row input.column-search {
  padding: 46px 6px;
  font-size: 13px;
  box-sizing: border-box;
}
#example thead th { white-space: nowrap; }

table thead tr:first-child th {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    border: none;
}

table thead tr:first-child th a,
table thead tr:first-child th i {
    color: #fff; /* icons / links white */
}
</style>

<!-- Main Content -->
<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Add button fixed inside card -->
      <a href="<?= base_url('role/addRole') ?>" class="fab-top">
          <i class="fa-solid fa-plus"></i>
      </a>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table align-middle text-center mb-0">
              <thead>
                  <tr>
                  <!--<th>ID</th>-->
						<th>Sr no</th>
						<th style="text-align:left;">Role name</th>
						<th class="text-center">Action</th>
                  </tr>
              </thead>
				 <tbody>
					<?php $i=1;?>
					<?php foreach($role_list as $aut) {  ?>
					<tr>
						<td><?php echo $i;?></td>
						<td style="text-align:left;"><?php echo $aut['role_name'];?></td>
						<td>
							  <a href="<?= base_url('role/editRole/'.$aut['id']) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
							   <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon">
								<i class="fas fa-trash-alt"></i>
							  </button>
							  <?php if ($aut['status'] == '1'): ?>
								<button onclick="statusChange(<?= $aut['id'] ?>, '0')" 
										class="btn btn-success btn-icon rounded-circle" 
										title="Active">
								  <i class="fas fa-check"></i>
								</button>
							  <?php else: ?>
								<button onclick="statusChange(<?= $aut['id'] ?>, '1')" 
										class="btn btn-secondary btn-icon rounded-circle"
										title="Inactive">
								  <i class="fas fa-times"></i>
								</button>
							  <?php endif; ?>
						  </td>
					</tr>
					
					<?php $i++; }  ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // DataTable init
    new DataTable('#example');

    // SweetAlert flash message
    <?php if ($this->session->flashdata('message_name')): ?>
        Swal.fire({
            icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
            title: '<?= $this->session->flashdata('message_name') ?>',
            showConfirmButton: false,
            timer: 2000
        });
    <?php endif; ?>

    // SweetAlert confirm delete
    function confirmDelete(itemId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = `<?= base_url('role/deleteRole/') ?>${itemId}`;
            }
        });
    }
	function statusChange(itemId, status) {
		Swal.fire({
			title: 'Are you sure?',
			text: "This action cannot be undone!",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'Yes, change status!',
			cancelButtonText: 'Cancel'
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
					url: '<?= base_url("role/changeStatus"); ?>',
					method: 'POST',
					data: { id: itemId, status: status },
					success: function(response) {
						var res = JSON.parse(response);
						if (res.success) {
							Swal.fire('Success!', res.message, 'success').then(() => {
								location.reload();  // Reload OR update in place
							});
						} else {
							Swal.fire('Error!', res.message, 'error');
						}
					},
					error: function() {
						Swal.fire('Error!', 'Something went wrong!', 'error');
					}
				});
			}
		});
	}
</script>

</body>
</html>