<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>EightTech Projects</title>
  <!-- base:css -->
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/vendors/typicons/typicons.css">
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- plugin css for this page -->
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/css/style.css">
  <style>
.error { color: red; }

/* ===== PAGE BACKGROUND ===== */
body {
  margin: 0;
  height: 100%;
  background: radial-gradient(circle at 20% 30%, rgba(99,102,241,0.15), transparent 40%),
              radial-gradient(circle at 80% 70%, rgba(139,92,246,0.15), transparent 40%),
              linear-gradient(135deg, #1e293b, #0f172a);
  background-attachment: fixed;
}

/* ===== LAYOUT RESET ===== */
.content-wrapper { padding: 0 !important; }
.dms-split-container { min-height: 100vh; }

/* ===== LEFT PANEL ===== */
.dms-left-panel {
  position: relative;
  overflow: hidden;
  background: linear-gradient(135deg, #0f172a, #1e3a5f);
  color: #fff;
  padding: 60px 50px;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
}

.dms-left-content { max-width: 420px; z-index: 2; }

.dms-left-logo { width: 160px; margin-bottom: 25px; }

.dms-left-panel h2 { font-size: 26px; font-weight: 600; margin-bottom: 15px; }
.dms-left-panel p { font-size: 14px; opacity: 0.9; margin-bottom: 35px; }

.dms-illustration {
  width: 100%;
  max-width: 320px;
  opacity: 0.95;
  animation: floatIllustration 6s ease-in-out infinite;
}

@keyframes floatIllustration {
  0% { transform: translateY(0px); }
  50% { transform: translateY(-10px); }
  100% { transform: translateY(0px); }
}

/* Hide left panel on mobile */
@media (max-width: 768px) {
  .dms-left-panel { display: none !important; }
}

/* ===== ANIMATED GLOW BLOBS ===== */
.dms-left-panel::before,
.dms-left-panel::after {
  content: "";
  position: absolute;
  border-radius: 50%;
  filter: blur(100px);
  opacity: 0.6;
  animation: floatBlob 18s ease-in-out infinite alternate;
}

.dms-left-panel::before {
  width: 380px;
  height: 380px;
  background: #6366f1;
  top: -120px;
  left: -120px;
}

.dms-left-panel::after {
  width: 320px;
  height: 320px;
  background: #8b5cf6;
  bottom: -100px;
  right: -100px;
  animation-delay: 4s;
}

@keyframes floatBlob {
  0%   { transform: translate(0, 0) scale(1); }
  50%  { transform: translate(40px, -30px) scale(1.1); }
  100% { transform: translate(-30px, 40px) scale(1); }
}

/* ===== RIGHT LOGIN CARD ===== */
.dms-login-card {
  background: rgba(255,255,255,0.75);
  backdrop-filter: blur(14px);
  border-radius: 18px;
  padding: 40px 35px !important;
  box-shadow: 0 20px 40px rgba(0,0,0,0.15);
  width: 100%;
  max-width: 420px;
  animation: cardFade 0.8s ease forwards;
}

@keyframes cardFade {
  from { opacity: 0; transform: translateY(20px); }
  to { opacity: 1; transform: translateY(0); }
}

.dms-login-title { font-size: 22px; font-weight: 600; color: #1e293b; }
.dms-login-subtitle { font-size: 14px; color: #64748b; margin-bottom: 25px; }

/* ===== FLOATING INPUTS ===== */
.floating-group { position: relative; margin-bottom: 20px; }

.floating-group input {
  width: 100%;
  padding: 14px;
  border-radius: 10px;
  border: 1px solid #cbd5e1;
  font-size: 14px;
  background: #fff;
}

.floating-group label {
  position: absolute;
  top: 14px;
  left: 14px;
  font-size: 14px;
  color: #94a3b8;
  pointer-events: none;
  transition: all 0.2s ease;
  background: #fff;
  padding: 0 4px;
}

.floating-group input:focus + label,
.floating-group input:not(:placeholder-shown) + label {
  top: -8px;
  left: 10px;
  font-size: 11px;
  color: #6366f1;
}

/* ===== PASSWORD TOGGLE ===== */
.password-group { position: relative; }
.toggle-password {
  position: absolute;
  right: 12px;
  top: 50%;
  transform: translateY(-50%);
  cursor: pointer;
  color: #94a3b8;
  font-size: 20px;
}

/* ===== REMEMBER ME ===== */
.dms-remember {
  font-size: 13px;
  color: #475569;
  display: flex;
  align-items: center;
  gap: 6px;
}

/* ===== BUTTON ===== */
.dms-login-btn {
  background: linear-gradient(135deg, #6366f1, #8b5cf6);
  border: none;
  padding: 12px;
  border-radius: 10px;
  font-weight: 600;
  font-size: 15px;
  color: #fff;
  transition: all 0.25s ease;
}

.dms-login-btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 10px 18px rgba(99,102,241,0.3);
}
</style>

  <!-- endinject -->
  <link rel="shortcut icon" href="<?php echo site_url();?>public/assets/images/favicon.ico" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/jquery.validate.min.js"></script>
</head>

<body>
  <div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
    <div class="content-wrapper d-flex align-items-center auth px-0 dms-split-wrapper">
  <div class="row w-100 mx-0 dms-split-container">

    <!-- LEFT SIDE -->
    <div class="col-md-6 d-none d-md-flex dms-left-panel">
      <div class="dms-left-content">
        <!--<img src="<?php echo site_url();?>public/assets/images/dms-logo.png" class="dms-left-logo" alt="DMS Logo">-->
        <img src="<?= site_url();?>public/assets/images/dms-logo.svg" class="dms-left-logo" alt="DMS Logo">
        <h2>Document Management System</h2>
        <p>Securely manage, track and monitor all your compliance documents in one place.</p>
        <img src="<?= site_url();?>public/assets/images/login-illustration.svg" class="dms-illustration" alt="DMS Illustration">
      </div>
    </div>

    <!-- RIGHT SIDE LOGIN -->
    <div class="col-md-6 d-flex align-items-center justify-content-center">
      <div class="auth-form-light dms-login-card">

        <h4 class="dms-login-title">Welcome Back 👋</h4>
        <p class="dms-login-subtitle">Sign in to continue to DMS</p>

        <?php if ($this->session->flashdata('login_msg')): ?>
          <div class="alert alert-danger text-center">
              <?= $this->session->flashdata('login_msg'); ?>
          </div>
        <?php endif; ?>
        <form class="login_form" id="login_form" method="post" action="<?php echo base_url();?>index.php/login/secureLogin">
          <div class="form-group floating-group">
            <input type="email" id="user_email" name="user_email" placeholder=" " required>
            <label for="user_email">Email Address</label>
          </div>

          <div class="form-group floating-group password-group">
            <input type="password" id="user_password" name="user_password" placeholder=" " required>
            <label for="user_password">Password</label>
            <span class="toggle-password" onclick="togglePassword()">
              <i class="typcn typcn-eye-outline"></i>
            </span>
          </div>

          <div class="d-flex justify-content-between align-items-center mt-2 mb-2">
            <label class="dms-remember">
              <input type="checkbox" name="remember_me"> Remember me
            </label>
            <!--<a href="#" class="dms-forgot-link">Forgot password?</a>-->
          </div>
          <div class="d-grid mt-3">
            <button type="submit" class="btn dms-login-btn">Sign In</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
      <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->
  <!-- base:js -->
  <script>
	$(document).ready(function () {
		// Initialize the validation
		$('#login_form').validate({
			rules: {
				user_email: {
					required: true,
					email: true,
				},
				user_password: {
					required: true,
					minlength: 3,
				},
			},
			messages: {
				user_email: {
					required: "Please enter your email address.",
					email: "Please enter a valid email address.",
				},
				user_password: {
					required: "Please provide a password.",
					minlength: "Your password must be at least 3 characters long.",
				},
			},
			submitHandler: function (form) {
				form.submit(); // Submit the form
			},
		});
	});


function togglePassword() {
  const input = document.getElementById("user_password");
  const icon = document.querySelector(".toggle-password i");

  if (input.type === "password") {
    input.type = "text";
    icon.classList.remove("typcn-eye-outline");
    icon.classList.add("typcn-eye");
  } else {
    input.type = "password";
    icon.classList.remove("typcn-eye");
    icon.classList.add("typcn-eye-outline");
  }
}

</script>
</body>

</html>
