<!-- Main Content -->
<link rel="stylesheet" href="<?= site_url('public/assets/css/datatables-custom.css') ?>">
<style>
#example { table-layout: fixed; width: 100% !important; }
#example th, #example td { overflow: hidden; text-overflow: ellipsis; }
#example .btn-icon { padding: 4px 8px; font-size: 0.75rem; }
#example thead th { font-size: 0.8rem; padding: 8px 4px !important; white-space: nowrap; }
#example tbody td { font-size: 0.8rem; padding: 6px 4px !important; vertical-align: middle; }

/* Column widths */
#example th:nth-child(1), #example td:nth-child(1) { width: 4%; }
#example th:nth-child(2), #example td:nth-child(2) { width: 22%; }
#example th:nth-child(3), #example td:nth-child(3) { width: 10%; }
#example th:nth-child(4), #example td:nth-child(4) { width: 15%; }
#example th:nth-child(5), #example td:nth-child(5) { width: 18%; }
#example th:nth-child(6), #example td:nth-child(6) { width: 11%; }
#example th:nth-child(7), #example td:nth-child(7) { width: 20%; white-space: nowrap; }

/* Column Search Styles */
.column-search-row input, .column-search-row select {
    width: 100%;
    padding: 4px 6px;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    font-size: 0.7rem;
    background: #fff;
}
.column-search-row input:focus, .column-search-row select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);
}
.column-search-row input::placeholder { color: #94a3b8; font-size: 0.65rem; }
.column-search-row th { background: #f8fafc !important; padding: 4px !important; }

table thead tr:first-child th {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    border: none;
}
table thead tr:first-child th a, table thead tr:first-child th i { color: #fff; }

/* Hide Default Search */
.dataTables_filter, .dt-search { display: none !important; }

/* Page-length buttons */
.dt-length-buttons { display: flex; gap: 0; }
.dt-paging { display: flex; align-items: center; gap: 10px; }
.dt-info { white-space: nowrap; }
#example_wrapper .dt-layout-start { display: flex; align-items: center; gap: 6px; }
#example_wrapper .dt-layout-end { display: flex; align-items: center; justify-content: flex-end; }
#example_wrapper .dt-info { margin: 0; white-space: nowrap; }
</style>

<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
      <div class="fab-top-group" style="display: flex; gap: 8px; position: absolute; top: 8px; right: 25px; z-index: 10;">
        <button type="button" class="btn btn-outline-secondary btn-sm" onclick="resetSearch()" title="Reset Search" style="border-radius: 50%; width: 36px; height: 36px; padding: 0;">
          <i class="fa fa-undo"></i>
        </button>
        <a href="<?= base_url('company/addCompany') ?>" class="btn btn-primary btn-sm" style="border-radius: 50%; width: 36px; height: 36px; padding: 0; display: flex; align-items: center; justify-content: center;">
          <i class="fa-solid fa-plus"></i>
        </a>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table id="example" class="table align-middle text-center mb-0">
            <thead>
              <tr>
                <th>#</th>
                <th style="text-align:left;">Company Name</th>
                <th style="text-align:left;">Alias</th>
                <th style="text-align:left;">Contact Person</th>
                <th style="text-align:left;">Contact Email</th>
                <th>Start Date</th>
                <th>Action</th>
              </tr>
              <tr class="column-search-row">
                <th></th>
                <th><input type="text" class="column-search" data-column="1" placeholder="Search..."></th>
                <th><input type="text" class="column-search" data-column="2" placeholder="Search..."></th>
                <th><input type="text" class="column-search" data-column="3" placeholder="Search..."></th>
                <th><input type="text" class="column-search" data-column="4" placeholder="Search..."></th>
                <th><input type="text" class="column-search" data-column="5" placeholder="Search..."></th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <?php $i = 1; foreach($company_list as $aut): ?>
              <tr>
                <td><?= $i++ ?></td>
                <td style="text-align:left;"><?= $aut['company_name'] ?></td>
                <td style="text-align:left;"><?= $aut['short_name'] ?></td>
                <td style="text-align:left;"><?= $aut['contact_person'] ?></td>
                <td style="text-align:left;"><?= $aut['contact_email'] ?></td>
                <td><?php 
                if (!empty($aut['co_start_date']) && strtotime($aut['co_start_date'])) {
                    echo date('d-M-Y', strtotime($aut['co_start_date']));
                } else {
                    echo 'N/A';
                } ?>
                </td>
                <td style="white-space: nowrap;">
                  <a href="<?= base_url('company/editCompany/'.$aut['id']) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
                  <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon"><i class="fas fa-trash-alt"></i></button>
                  <?php /*if ($aut['status'] == '1'): ?>
                  <button onclick="statusChange(<?= $aut['id'] ?>, '0')" class="btn btn-success btn-icon rounded-circle" title="Active"><i class="fas fa-check"></i></button>
                  <?php else: ?>
                  <button onclick="statusChange(<?= $aut['id'] ?>, '1')" class="btn btn-secondary btn-icon rounded-circle" title="Inactive"><i class="fas fa-times"></i></button>
                  <?php endif; */ ?>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
var table;

$(document).ready(function() {
  table = $('#example').DataTable({
    orderCellsTop: true,
    pageLength: 10,
    order: [[1, 'asc']],
    columnDefs: [
      { orderable: false, targets: [0, 6] },
      { searchable: false, targets: [0, 6] }
    ]
  });

  // Recalculate serial numbers after sort/search/page
  table.on('draw.dt', function () {
    var start = table.page.info().start;
    table.column(0, {page:'current'}).nodes().each(function(cell, i) {
      cell.innerHTML = start + i + 1;
    });
    moveDtControls();
    replaceLengthDropdown();
  });

  // Column search
  $('#example .column-search').on('keyup change', function() {
    var columnIdx = $(this).data('column');
    table.column(columnIdx).search(this.value).draw();
  });

  function moveDtControls() {
    const $wrapper = $('#example_wrapper');
    const $topRow = $wrapper.children('.row').first();
    const $dtLength = $topRow.find('.dt-length');
    const $bottomRow = $wrapper.children('.row').last();
    const $bottomLeft = $bottomRow.find('.dt-layout-start');
    const $bottomRight = $bottomRow.find('.dt-layout-end');
    const $dtInfo = $bottomRow.find('.dt-info');
    if (!$bottomLeft.find('.dt-length').length) $dtLength.appendTo($bottomLeft);
    if (!$bottomRight.find('.dt-info').length) $dtInfo.prependTo($bottomRight);
  }

  function replaceLengthDropdown() {
    const $wrapper = $('#example_wrapper');
    const $lengthContainer = $wrapper.find('.dt-length');
    if ($lengthContainer.find('.dt-length-buttons').length) return;
    const pageLengths = [10, 20, 50, -1];
    const currentLength = table.page.len();
    $lengthContainer.find('select, label').hide();
    let html = '<ul class="pagination pagination-sm mb-0 dt-length-buttons">';
    pageLengths.forEach(len => {
      const label = len === -1 ? 'All' : len;
      const isActive = (len === -1 && currentLength === -1) || (len !== -1 && currentLength === len);
      html += `<li class="page-item ${isActive ? 'active' : ''}"><button class="page-link dt-len-btn" data-len="${len}">${label}</button></li>`;
    });
    html += '</ul>';
    $lengthContainer.append(html);
  }

  $(document).on('click', '.dt-len-btn', function () {
    const len = parseInt($(this).data('len'), 10);
    table.page.len(len).draw();
    $(this).closest('.dt-length-buttons').find('.page-item').removeClass('active');
    $(this).parent('.page-item').addClass('active');
  });

  moveDtControls();
  replaceLengthDropdown();

  <?php if ($this->session->flashdata('message_name')): ?>
  Swal.fire({
    icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
    title: '<?= $this->session->flashdata('message_name') ?>',
    showConfirmButton: false,
    timer: 2000
  });
  <?php endif; ?>
});

function resetSearch() {
  $('#example .column-search').val('');
  table.search('').columns().search('');
  table.order([[1, 'asc']]);
  table.page('first');
  table.draw();
}

function confirmDelete(itemId) {
  Swal.fire({
    title: 'Are you sure?',
    text: "This action cannot be undone!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, delete it!',
    cancelButtonText: 'Cancel'
  }).then((result) => {
    if (result.isConfirmed) {
      window.location.href = `<?= base_url('company/deleteCompany/') ?>${itemId}`;
    }
  });
}

function statusChange(itemId, status) {
  Swal.fire({
    title: 'Are you sure?',
    text: "This action cannot be undone!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    cancelButtonText: 'Cancel'
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: '<?= base_url("company/changeStatus"); ?>',
        method: 'POST',
        data: { id: itemId, status: status },
        success: function(response) {
          var res = JSON.parse(response);
          if (res.success) {
            Swal.fire('Success!', res.message, 'success').then(() => location.reload());
          } else {
            Swal.fire('Error!', res.message, 'error');
          }
        },
        error: function() { Swal.fire('Error!', 'Something went wrong!', 'error'); }
      });
    }
  });
}
</script>
