# DMS Application - Test User Credentials

## Test Environment
- **URL**: http://localhost/dmsnew/
- **Database**: dmstype (PostgreSQL)

---

## Test Users Created by Automation Script

### Super Admin
| Field | Value |
|-------|-------|
| Email | superadmin@dms.com |
| Password | Admin@123 |
| Role | Super Admin (1) |
| Access | Full access to all companies, all features |
| Permissions | View ✅ | Add/Edit ✅ | Delete ✅ |

---

### Admin Users

#### Admin Alpha
| Field | Value |
|-------|-------|
| Email | admin.alpha@test.com |
| Password | Admin@123 |
| Role | Admin (2) |
| Companies | Alpha Corp, Beta Industries |
| Permissions | View ✅ | Add/Edit ✅ | Delete ✅ |

#### Admin Gamma
| Field | Value |
|-------|-------|
| Email | admin.gamma@test.com |
| Password | Admin@123 |
| Role | Admin (2) |
| Companies | Gamma Solutions, Delta Technologies |
| Permissions | View ✅ | Add/Edit ✅ | Delete ❌ |

---

### Regular Users (Role 3)

#### User ViewOnly
| Field | Value |
|-------|-------|
| Email | user.viewonly@test.com |
| Password | User@123 |
| Role | User (3) |
| Companies | Alpha Corp |
| Authorities | Tax Authority, Labor Department |
| Permissions | View ✅ | Add/Edit ❌ | Delete ❌ |

#### User Editor
| Field | Value |
|-------|-------|
| Email | user.editor@test.com |
| Password | User@123 |
| Role | User (3) |
| Companies | Beta Industries, Gamma Solutions |
| Authorities | Tax Authority, Labor Department, Social Security |
| Permissions | View ✅ | Add/Edit ✅ | Delete ❌ |

#### User MultiCompany
| Field | Value |
|-------|-------|
| Email | user.multi@test.com |
| Password | User@123 |
| Role | User (3) |
| Companies | Alpha, Beta, Gamma, Delta |
| Authorities | All 5 authorities |
| Permissions | View ✅ | Add/Edit ✅ | Delete ❌ |

---

## Test Companies Created

| Company Name | Alias | Purpose |
|--------------|-------|---------|
| Alpha Corp | ALPHA | Admin Alpha's company |
| Beta Industries | BETA | Shared between Admin Alpha and Users |
| Gamma Solutions | GAMMA | Admin Gamma's company |
| Delta Technologies | DELTA | Admin Gamma's company |
| Epsilon Services | EPSILON | Available for Super Admin only |

---

## Test Authorities Created

| Authority Name | Alias | Document Heads |
|----------------|-------|----------------|
| Tax Authority | TAX | 5 document heads |
| Labor Department | LABOR | 5 document heads |
| Social Security | SS | 5 document heads |
| Health & Safety | HS | 5 document heads |
| Environmental Agency | ENV | 5 document heads |

---

## Test Scenarios by Role

### Super Admin Test Scenarios
1. ✅ Can view all companies
2. ✅ Can create/edit/delete companies
3. ✅ Can create/edit/delete users
4. ✅ Can manage all master data (authorities, document heads, documents)
5. ✅ Can access all reports
6. ✅ Can manage holidays
7. ✅ Can view reminder reports

### Admin Test Scenarios
1. ✅ Can only see assigned companies
2. ✅ Can manage users within assigned companies
3. ✅ Can upload documents for assigned companies
4. ✅ Can view/download documents for assigned companies
5. ❌ Cannot see other admin's companies
6. ⚠️ Delete permission varies by configuration

### User Test Scenarios
1. ✅ Can only see assigned companies and authorities
2. ✅ View-only users cannot add/edit/delete
3. ✅ Editor users can add/edit but not delete
4. ❌ No user can have delete permission
5. ✅ Document heads auto-selected based on authority assignment
6. ✅ Can add favourites (max 10)
7. ✅ Can use month-level favourites

---

## Running the Tests

### Prerequisites
1. PHP 7.4+ installed (C:\xampp\php\php.exe)
2. PostgreSQL running with dmstype database
3. Web server running (Apache/XAMPP)

### Commands

```batch
# Run all tests
run_tests.bat all

# Truncate database (WARNING: Deletes all data)
run_tests.bat truncate

# Run specific test suite
run_tests.bat setup      # Create test data
run_tests.bat company    # Company tests
run_tests.bat user       # User tests
run_tests.bat rbac       # Role-based access tests
run_tests.bat master     # Master data tests
run_tests.bat favourite  # Favourite tests
run_tests.bat integrity  # Data integrity tests
```

### Manual Testing Steps

1. **Login as Super Admin**
   - Verify all menu items visible
   - Create a new company
   - Create a new user with Admin role
   - Assign companies to the user

2. **Login as Admin Alpha**
   - Verify only Alpha Corp and Beta Industries visible
   - Try to access Gamma Solutions (should be restricted)
   - Upload a document for Alpha Corp

3. **Login as User ViewOnly**
   - Verify only Alpha Corp visible
   - Try to add a document (should be denied)
   - Try to delete anything (should be denied)
   - Can only view existing data

4. **Login as User Editor**
   - Can add/edit documents
   - Cannot delete anything
   - Can add favourites

---

## Notes

- All passwords use MD5 hashing (legacy system)
- Role IDs: 1=Super Admin, 2=Admin, 3=User
- Status values: '1'=Active, '0'=Inactive
- Users with role 3 automatically get document types based on their authority assignments

