<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

	function __construct(){ 
        parent::__construct();
		ini_set('display_errors', 1);
    }

	public function index()
	{
		redirect('user/users');
	}
	
	public function users()
    {   
		$this->session->set_userdata('menu','user');
		$login_id = $this->session->userdata('id');
		$role_id = $this->session->userdata('role_id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// View-only users cannot access user management
		if (function_exists('is_user') && is_user() && function_exists('can_edit') && !can_edit()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'You do not have permission to access user management.');
			redirect('dashboard');
			return;
		}
		
		// Super Admin sees all users
		if (is_super_admin()) {
			$sql = "SELECT * FROM users ORDER BY id DESC";
			$query = $this->db->query($sql);
			$user_list = $query->result_array();
		} else {
			// Admin sees only users who share at least one company with them
			$allowed_companies = get_allowed_companies();
			
			if (!empty($allowed_companies)) {
				// Get users whose user_company field has any overlap with admin's companies
				// OR users in user_companies table with matching companies
				$company_ids_str = implode(',', $allowed_companies);
				
				$sql = "SELECT DISTINCT u.* FROM users u 
					LEFT JOIN user_companies uc ON u.id = uc.user_id
					WHERE u.role_id != '1'
					AND (
						-- Check user_companies table
						uc.company_id IN ({$company_ids_str})
						OR
						-- Check old CSV field for backward compatibility
						EXISTS (
							SELECT 1 FROM unnest(string_to_array(u.user_company, ',')) AS comp_id
							WHERE comp_id::text IN ('" . implode("','", $allowed_companies) . "')
						)
					)
					ORDER BY u.id DESC";
				$query = $this->db->query($sql);
				$user_list = $query->result_array();
			} else {
				$user_list = [];
			}
		}
		
		$this->load->view('templates/header');
		$this->load->view('users/users', array('user_list' => $user_list));
	}
	public function details($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
				$this->session->set_userdata('menu','user');

		$sql="select * from users where id = '$id' order by id desc "; 
		$query = $this->db->query($sql);
		$user_list = $query->result_array();
		
		$this->load->view('templates/layout.php');
        $this->load->view('users/details',array('user_details'=>$user_list));
	}

	public function addUser() {		
		$this->session->set_userdata('menu','user');
		$CI = & get_instance();
		$login_id = $this->session->userdata('id');
		$current_role_id = $this->session->userdata('role_id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Role list - Admin can only create User role (3), not Super Admin or Admin
		if (is_super_admin()) {
			$sql = "SELECT * FROM role WHERE status='1' ORDER BY id ASC";
		} else {
			// Admin can only create User role
			$sql = "SELECT * FROM role WHERE status='1' AND id = '3' ORDER BY id ASC";
		}
		$query = $this->db->query($sql);
		$role_list = $query->result_array();
		
		// Company list - Admin can only assign their own companies
		if (is_super_admin()) {
			$company = "SELECT * FROM company WHERE status='1' ORDER BY company_name ASC";
			$company_query = $this->db->query($company);
			$company_list = $company_query->result_array();
		} else {
			// Admin can only see/assign their own companies
			$allowed_companies = get_allowed_companies();
			if (!empty($allowed_companies)) {
				$this->db->select('*')
					->from('company')
					->where('status', '1')
					->where_in('id', $allowed_companies)
					->order_by('company_name', 'ASC');
				$company_list = $this->db->get()->result_array();
			} else {
				$company_list = [];
			}
		}
		
		$sub_type = "SELECT t.*, a.authority_name FROM sub_type t LEFT JOIN authority a ON a.id::text=t.authority_id WHERE t.status='1' ORDER BY a.authority_name, t.type_name ASC";
		$sub_type_query = $this->db->query($sub_type);
		$sub_type_list = $sub_type_query->result_array();
		
		// Load authorities for user assignment
		$authority = "SELECT * FROM authority WHERE status='1' ORDER BY authority_name ASC";
		$authority_query = $this->db->query($authority);
		$authority_list = $authority_query->result_array();
		
        $this->load->view('templates/header.php');
        $this->load->view('users/add_user', array(
			'role_list' => $role_list,
			'company_list' => $company_list,
			'sub_type_list' => $sub_type_list,
			'authority_list' => $authority_list,
			'current_user_role' => $current_role_id
		));
	}

	public function saveUser() {
	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		
		$userdata = $_POST;
		$first_name = $this->db->escape_str($_POST['first_name']);
		$last_name = $this->db->escape_str($_POST['last_name']);
		$password = md5($_POST['password']);
		$email_id = $this->db->escape_str($_POST['email_id']);
		$role = $_POST['role'];
		$company = isset($_POST['company']) ? $_POST['company'] : [];
		$type_name = isset($_POST['type_name']) ? $_POST['type_name'] : [];
		$authority = isset($_POST['authority']) ? $_POST['authority'] : [];
		
		// Check for duplicate email
		$existing_email = $this->db->where('email_id', $email_id)->get('users')->row();
		if ($existing_email) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Email address already exists! Please use a different email.');
			redirect('user/addUser');
			return;
		}
		
		// Get permission flags
		$can_view = isset($_POST['can_view']) ? true : true; // View is always true
		$can_add_edit = isset($_POST['can_add_edit']) ? true : false;
		$can_delete = isset($_POST['can_delete']) ? true : false;
		
		// Users (role 3) can never delete
		if ($role == '3') {
			$can_delete = false;
		}
		
		$company_data = '';
		$type_data = '';
		$authority_data = '';
		
		if($role=='2') {
			// Admin - can access selected companies
			if(!empty($company)) {
				$company_data = implode(',',$company);
			}
		}
		if($role=='3') {
			// User - can access selected companies, types and authorities
			if(!empty($company)) {
				$company_data = implode(',',$company);
			}
			if(!empty($type_name)) {
				$type_data = implode(',',$type_name);
			}
			if(!empty($authority)) {
				$authority_data = implode(',',$authority);
			}
		}
		$created_date = date('Y-m-d h:i:s');
		$status = '1';
		
		// Insert user
		$query = "insert into users (first_name, last_name, password, email_id, status, parent_id,user_company,user_type,user_authority,role_id) values('".$first_name."','".$last_name."','".$password."','".$email_id."','".$status."','".$login_id."','".$company_data."','".$type_data."','".$authority_data."','".$role."')";
		$sql = $this->db->query($query);
		
		// Get the new user's ID
		$new_user_id = $this->db->insert_id();
		
		// Save user permissions
		if ($new_user_id) {
			$this->Permission_model->save_user_permissions($new_user_id, $can_view, $can_add_edit, $can_delete);
			
			// Save to normalized tables
			if (!empty($company)) {
				$this->Permission_model->save_user_companies($new_user_id, $company);
			}
			if (!empty($authority) && $role == '3') {
				$this->Permission_model->save_user_authorities($new_user_id, $authority);
			}
			if (!empty($type_name) && $role == '3') {
				$this->Permission_model->save_user_document_types($new_user_id, $type_name);
			}
		}
		
		$log_query ="insert into log_table(description, action, created_time, user_id) values('New User Added Successfully','New User Added','$created_date','$login_id')";
		$log_insert = $this->db->query($log_query);

		redirect('user/users');
	}
	public function changeUserStatus() {
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		// Convert 'Active' to 0 and anything else to 1
		$new_status = ($status == '0') ? '0' : '1';

		$sql = "UPDATE users SET status='$new_status' WHERE id='$id'";
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.',
				'new_status' => $new_status
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	

	public function modifyUser($id) {	
		error_reporting(0);
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		$current_role_id = $this->session->userdata('role_id');
		$login_id = $this->session->userdata('id');
		
		$sql1 = "SELECT * FROM users WHERE id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/users');
		}
		
		$business_data = $business_data[0];
		$user_id = $business_data['id'];
		
		// Admin cannot edit Super Admin or other Admin users
		if (!is_super_admin()) {
			if ($business_data['role_id'] == '1' || $business_data['role_id'] == '2') {
				$this->session->set_flashdata('message_type', 'error');
				$this->session->set_flashdata('message_name', 'You do not have permission to edit this user.');
				redirect('user/users');
			}
			
			// Check if user belongs to Admin's companies
			$allowed_companies = get_allowed_companies();
			$user_companies = array_filter(explode(',', $business_data['user_company'] ?? ''));
			$has_access = !empty(array_intersect($user_companies, $allowed_companies));
			
			if (!$has_access) {
				$this->session->set_flashdata('message_type', 'error');
				$this->session->set_flashdata('message_name', 'You do not have permission to edit this user.');
				redirect('user/users');
			}
		}
		
		$this->session->set_userdata('menu','user');
		
		// Company list - Admin can only see their own companies
		if (is_super_admin()) {
			$company = "SELECT * FROM company WHERE status='1' ORDER BY company_name ASC";
			$company_query = $this->db->query($company);
			$company_list = $company_query->result_array();
		} else {
			$allowed_companies = get_allowed_companies();
			if (!empty($allowed_companies)) {
				$this->db->select('*')
					->from('company')
					->where('status', '1')
					->where_in('id', $allowed_companies)
					->order_by('company_name', 'ASC');
				$company_list = $this->db->get()->result_array();
			} else {
				$company_list = [];
			}
		}
		
		$sub_type = "SELECT t.*, a.authority_name FROM sub_type t LEFT JOIN authority a ON a.id::text=t.authority_id WHERE t.status='1' ORDER BY a.authority_name, t.type_name ASC";
		$sub_type_query = $this->db->query($sub_type);
		$sub_type_list = $sub_type_query->result_array();
		
		// Role list - Admin can only assign User role
		if (is_super_admin()) {
			$sql = "SELECT * FROM role WHERE status='1' ORDER BY id ASC";
		} else {
			$sql = "SELECT * FROM role WHERE status='1' AND id = '3' ORDER BY id ASC";
		}
		$query = $this->db->query($sql);
		$role_list = $query->result_array();
		
		// Load authorities for user assignment
		$authority = "SELECT * FROM authority WHERE status='1' ORDER BY authority_name ASC";
		$authority_query = $this->db->query($authority);
		$authority_list = $authority_query->result_array();
		
		// Load user permissions
		$user_permissions = $this->Permission_model->get_user_permissions($user_id);
		
		$this->load->view('templates/header.php');
        $this->load->view('users/edit_user', array(
			'user_data' => $business_data,
			'company_list' => $company_list,
			'sub_type_list' => $sub_type_list,
			'role_list' => $role_list,
			'authority_list' => $authority_list,
			'user_permissions' => $user_permissions,
			'current_user_role' => $current_role_id
		));	
		$this->load->view('templates/footer.php');
	}
	public function updateUser() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		
		$id = $_POST['id'];
		$first_name = $this->db->escape_str($_POST['first_name']);
		$last_name = $this->db->escape_str($_POST['last_name']);
		$email_id = $this->db->escape_str($_POST['email_id']);
		$role = $_POST['role'];
		$company = isset($_POST['company']) ? $_POST['company'] : [];
		$type_name = isset($_POST['type_name']) ? $_POST['type_name'] : [];
		$authority = isset($_POST['authority']) ? $_POST['authority'] : [];
		
		// Check for duplicate email (excluding current user)
		$existing_email = $this->db->where('email_id', $email_id)->where('id !=', $id)->get('users')->row();
		if ($existing_email) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Email address already exists! Please use a different email.');
			redirect('user/modifyUser/' . $id);
			return;
		}
		
		// Get permission flags
		$can_view = true; // View is always true
		$can_add_edit = isset($_POST['can_add_edit']) ? true : false;
		$can_delete = isset($_POST['can_delete']) ? true : false;
		
		// Users (role 3) can never delete
		if ($role == '3') {
			$can_delete = false;
		}
		
		$company_data = '';
		$type_data = '';
		$authority_data = '';
		
		if($role=='2') {
			// Admin - can access selected companies
			if(!empty($company)) {
				$company_data = implode(',',$company);
			}
		}
		if($role=='3') {
			// User - can access selected companies, types and authorities
			if(!empty($company)) {
				$company_data = implode(',',$company);
			}
			if(!empty($type_name)) {
				$type_data = implode(',',$type_name);
			}
			if(!empty($authority)) {
				$authority_data = implode(',',$authority);
			}
		}
		
		$sql = "update users set first_name='$first_name',last_name='$last_name', email_id='$email_id',role_id='$role',user_company='$company_data',user_type='$type_data',user_authority='$authority_data' where id='$id'";
		$query1 = $this->db->query($sql);
		
		// Save user permissions
		$this->Permission_model->save_user_permissions($id, $can_view, $can_add_edit, $can_delete);
		
		// Save to normalized tables
		$this->Permission_model->save_user_companies($id, $company);
		
		if ($role == '3') {
			$this->Permission_model->save_user_authorities($id, $authority);
			$this->Permission_model->save_user_document_types($id, $type_name);
		} else {
			// Clear authority and document type assignments for non-User roles
			$this->Permission_model->save_user_authorities($id, []);
			$this->Permission_model->save_user_document_types($id, []);
		}
		
		$date = date('Y-m-d h:i:s');
		$sql1="insert into log_table (description,action, created_time, user_id) values('User updated','Modify User','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Successfully Updated');

		redirect('user/users');
		
	}
	
	public function changePassword($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$users = $this->db->where('id',$id)->get('users')->result_array();
		if(empty($users)) {
			redirect('user/users');
		}
		$users=$users[0];
		$parent_id = $users['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		$this->load->view('templates/layout.php');
        $this->load->view('users/change_password',array('users'=>$users));	
		$this->load->view('templates/footer.php');
		
	}
	public function passwordChange() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		$users = $this->db->where('id',$id)->get('users')->result_array();
		if(empty($users)) {
			redirect('user/users');
		}
		$users=$users[0];
		$parent_id = $users['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		$password = md5($_POST['password']);
		$sql = "update users set password = '$password' where id='$id'";
		$this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		
		$sql1="insert into log_table (description,action, created_time, user_id) values('Password Changed Successfully','Password Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		//$this->session->set_flashdata('message_name', 'Password Successfully Changed');
		redirect('user/users');
	}
	public function deleteUser($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - delete permission required
		require_delete_permission('user/users');
		
		$sql1="select * from users where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/users');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		else {
			$this->db->where('id', $id)->delete('users');
			
		}
		
		redirect('user/users');
		
	}
	
	public function userProjects($id) {
		$this->session->set_userdata('user_menu','Users');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$sql="select * from projects where user_id = '$id' ";    
		$query = $this->db->query($sql);
		$project_list = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/user_projects',array('project_list'=>$project_list,'user_id'=>$id));
		$this->load->view('templates/footer');
		
		
	}
	
	public function roles() {
		$this->session->set_userdata('user_menu','Users');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','users');

		$sql="select * from role where user_id = '$login_id' order by role_name asc ";    
		$query = $this->db->query($sql);
		$user_list = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/role',array('user_list'=>$user_list));
		$this->load->view('templates/footer');
	}
	public function addRole() {		
		$this->session->set_userdata('user_menu','Users');
		$CI = & get_instance();
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
        $this->load->view('templates/layout.php');
        $this->load->view('users/add_role');
		$this->load->view('templates/footer');
	}

	public function saveRole() {
	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$userdata = $_POST;
		$role_name = $_POST['role_name'];
		$status = '1';
		$query = "insert into role (role_name, user_id,status) values('".$role_name."','".$login_id."','".$status."')";
		$sql = $this->db->query($query);
				$this->session->set_flashdata('message_name', 'Role Created Successfully');

		redirect('user/roles');
	}
	public function editRole($id) {	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql1="select * from role where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/roles');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		if($parent_id != $login_id) {
			redirect('user/roles');
		}
		
		$this->load->view('templates/layout.php');
        $this->load->view('users/edit_role',array('user_data'=>$business_data));	
		$this->load->view('templates/footer.php');
		
	}
	public function updateRole() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		$role_name = $_POST['role_name'];
		
		$sql = "update role set role_name='$role_name' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Role Successfully Updated');

		redirect('user/roles');
		
	}
	public function deleteRole($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql1="select * from role where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/roles');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		if($parent_id != $login_id) {
			redirect('user/roles');
		}
		$sql = "delete from role where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Role Successfully Deleted');
		
		redirect('user/roles');
		
	}
	public function changeRoleStatus($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('user_menu','Master');
		$sql="select * from role where id='$id'";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$business_data  = $business_data[0];
		if($business_data['status']=='1') {
			$sql="update role set status='0' where id='$id'"; 
		} else {
			$sql="update role set status='1' where id='$id'"; 
		}
		$query = $this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		$login_id = $this->session->userdata('id');
		$sql1="insert into log_table (description,action, created_time, user_id) values('Role Status Changed','Status Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Status Successfully Updated');

		redirect('user/roles');
	}
	
	public function sensors()
    {   
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql="select * from picogeneral_nodes";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		//echo '<pre>';print_r($business_data);exit;
		$this->load->view('templates/layout');
		$this->load->view('sensor/sensor',array('sensor_list'=>$business_data));
		$this->load->view('templates/footer');

	}
	public function sensorDetails($sensor) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		//$sql="select * from picogeneral_data where node_id='$sensor' limit 5000";    
		$sql="select p.*,u.id as uid,u.notes as utype_id from picogeneral_data p left join unified_type u on u.id = p.type_id where node_id='$sensor' limit 100";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/sensor_details',array('sensor_list'=>$business_data,'sensor_id'=>$sensor));
		$this->load->view('templates/footer');
	}
	public function addSensor() {
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->load->view('templates/layout');
		$this->load->view('sensor/add_sensor');
		$this->load->view('templates/footer');
	}
	
	public function saveSensor() {
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sensor_name = $_POST['sensor'];
		
		$query = "insert into sensor(sensor, status) values('".$sensor_name."','1')";

		$insert_query = $this->db->query($query);	
		$this->session->set_flashdata('message_name', 'Sensor Added Successfully');
		
		redirect('sensor/sensors');	
	}
	public function editSensor($id) {
		
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			
			redirect('login');
		}
		$sql1="select * from sensor where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		
		if(empty($business_data)) {
			
			redirect('sensor/sensors');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		
		$this->session->set_userdata('menu','sensor');
		
		$this->load->view('templates/layout');
		$this->load->view('project/edit_sensor',array('sensor_data'=>$business_data));		
		$this->load->view('templates/footer');
	
	}
	public function updateSensor() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		
		$project_name = $_POST['project_name'];
		$project_description = $_POST['project_description'];
		$start_date = $_POST['start_date'];
		$end_date = $_POST['end_date'];
		$project_status = $_POST['status'];
		$sql = "update projects set project_name='$project_name',project_description='$project_description' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Project Details Successfully Updated');

		redirect('project/allProject');
		
	}
	
	public function deleteSensor($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$project = "delete from sensor where id='$id'";
		$query = $this->db->query($project);
		$status_data = $query->result_array();
		redirect('sensor/sensors');
		
	}
	public function changeSensorStatus($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('user_menu','Master');
		$sql="select * from sensor where id='$id'";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$business_data  = $business_data[0];
		if($business_data['status']=='1') {
			$sql="update sensor set status='0' where id='$id'"; 
		} else {
			$sql="update sensor set status='1' where id='$id'"; 
		}
		$query = $this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		$login_id = $this->session->userdata('id');
		$sql1="insert into log_table (description,action, created_time, user_id) values('Sensor Status Changed','Status Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Status Successfully Updated');

		redirect('sensor/sensors');
	}
	
	public function saveSensors() {
		
		$id = $_POST['id'];
		$column = $_POST['column'];
		$value = $_POST['value'];
		if($column=='interval') {
			$da = $this->db->query("update picogeneral_nodes set interval='$value' where id='$id'");
		}
		if($column=='connect_cloud') {
			$da = $this->db->query("update picogeneral_nodes set connect_cloud='$value' where id='$id'");
		}
		if($column=='pm_sampling_time') {
			$da = $this->db->query("update picogeneral_nodes set pm_sampling_time='$value' where id='$id'");
		}
		if($column=='gps_on') {
			$da = $this->db->query("update picogeneral_nodes set gps_on='$value' where id='$id'");
		}
		if($column=='cell_location') {
			$da = $this->db->query("update picogeneral_nodes set cell_location='$value' where id='$id'");
		}
		if($column=='reset_modem') {
			$da = $this->db->query("update picogeneral_nodes set reset_modem='$value' where id='$id'");
		}
		if($column=='do_sleep') {
			$da = $this->db->query("update picogeneral_nodes set do_sleep='$value' where id='$id'");
		}if($column=='battery_sleep_time') {
			$da = $this->db->query("update picogeneral_nodes set battery_sleep_time='$value' where id='$id'");
		}
	}
	
	public function ediiEmployees() {
		
		$data = $this->db->query("select * from picogeneral_nodes order by id desc")->result_array();
		$this->load->view('templates/layout');
		$this->load->view('sensor/sensor',array('projects'=>$data));
	}
	
	public function saveConfig() {
		$id = $_POST['id'];
		$status = $_POST['status'];
		$d_name = $_POST['d_name'];
		if($d_name=='connect_cloud' || $d_name=='gps_on' || $d_name=='reset_modem' || $d_name=='do_sleep' || $d_name=='remote_control' || $d_name=='ntp' || $d_name=='exact_minute' || $d_name=='erase_fs' || $d_name=='resetgps' || $d_name=='updategpsrate' || $d_name=='restorevars' || $d_name=='hard_reset' || $d_name=='sample_size' || $d_name=='tcp_log') {
			$update_query = $this->db->query("update picogeneral_nodes set $d_name='$status' where id='$id'");
		}
		echo true;
	}
	public function saveInput() {
		$id = $_POST['id'];
		$status = $_POST['value'];
		$d_name = $_POST['field'];
		if($d_name=='interval' || $d_name=='pm_sampling_time' || $d_name=='cell_location' || $d_name=='battery_sleep_time' || $d_name=='cloud_time_timeout' || $d_name=='cell_location_timeout' || $d_name=='sample_size' || $d_name=='wifi_connect' || $d_name=='alert_sms' || $d_name=='error_log_email' || $d_name=='offset_measures') {
			//echo "update picogeneral_nodes set $d_name='$status' where id='$id'";exit;
			$update_query = $this->db->query("update picogeneral_nodes set $d_name=$status where id='$id'");
		}
		 echo json_encode(['success' => true, 'message' => 'Configuration updated successfully.']);
		
	}
	public function inputColor() {
		$id = $_POST['id'];
		$field = $_POST['field'];
		$value = $_POST['value'];
		
		$select_query = $this->db->query("select * from picogeneral_nodes where id='$id'")->result_array();
		if($field=='bme_setup') {
			$old_value = $select_query[0]['bme_setup'];
		}
		if($field=='sgp_setup') {
			$old_value = $select_query[0]['sgp_setup'];
		}
		if($field=='pm_setup') {
			$old_value = $select_query[0]['pm_setup'];
		}
		if($field=='gps_setup') {
			$old_value = $select_query[0]['gps_setup'];
		}
		if($field=='fs_used') {
			$old_value = $select_query[0]['fs_used'];
		}
		if($old_value=='0') {
			$value = '1';
		} else {
			$value = '0';
		}
		if($field=='bme_setup' || $field=='sgp_setup' || $field=='pm_setup' || $field=='gps_setup' || $field=='fs_used') {
			//echo "update picogeneral_nodes set $d_name='$status' where id='$id'";exit;
			$update_query = $this->db->query("update picogeneral_nodes set $field=$value where id='$id'");
		}
		 echo 'success';
	}
	
	public function map($id) {
		$data = $this->db->query("select * from picogeneral_nodes where id='$id'")->result_array();
		$this->load->view('templates/layout');
		$this->load->view('sensor/admin_map',array('data'=>$data));
	}
	
	public function userAccess() {
		$this->load->view('templates/layout');
		$this->load->view('users/user_access');
	}
	
	/**
	 * AJAX: Get authorities enabled for selected companies
	 * For User role creation - shows only enabled authorities for selected companies
	 */
	public function getAuthoritiesByCompanies() {
		$company_ids = $this->input->post('company_ids');
		
		if (empty($company_ids) || !is_array($company_ids)) {
			echo json_encode(['success' => false, 'authorities' => []]);
			return;
		}
		
		// Get authorities that are enabled for ANY of the selected companies
		$placeholders = implode(',', array_fill(0, count($company_ids), '?'));
		$sql = "SELECT DISTINCT a.id, a.authority_name 
				FROM authority a
				INNER JOIN company_authorities ca ON ca.authority_id = a.id AND ca.is_enabled = true
				WHERE a.status = '1' AND ca.company_id IN ({$placeholders})
				ORDER BY a.authority_name ASC";
		
		$authorities = $this->db->query($sql, $company_ids)->result_array();
		
		echo json_encode(['success' => true, 'authorities' => $authorities]);
	}
	
	/**
	 * AJAX: Get document heads by selected authorities and companies
	 * For User role creation - shows document heads linked to selected authorities
	 */
	public function getDocHeadsByAuthorities() {
		$authority_ids = $this->input->post('authority_ids');
		$company_ids = $this->input->post('company_ids');
		
		if (empty($authority_ids) || !is_array($authority_ids)) {
			echo json_encode(['success' => false, 'doc_heads' => []]);
			return;
		}
		
		// Get document heads for selected authorities that are enabled for the companies
		$auth_placeholders = implode(',', array_fill(0, count($authority_ids), '?'));
		
		$params = $authority_ids;
		
		$sql = "SELECT DISTINCT st.id, st.type_name, st.authority_id, a.authority_name
				FROM sub_type st
				LEFT JOIN authority a ON a.id::text = st.authority_id
				WHERE st.status = '1' AND st.authority_id IN ({$auth_placeholders})";
		
		// If company_ids provided, also filter by enabled document heads for those companies
		if (!empty($company_ids) && is_array($company_ids)) {
			$comp_placeholders = implode(',', array_fill(0, count($company_ids), '?'));
			$sql .= " AND st.id IN (
				SELECT cdh.type_id FROM company_document_heads cdh 
				WHERE cdh.is_enabled = true AND cdh.company_id IN ({$comp_placeholders})
			)";
			$params = array_merge($params, $company_ids);
		}
		
		$sql .= " ORDER BY a.authority_name, st.type_name ASC";
		
		$doc_heads = $this->db->query($sql, $params)->result_array();
		
		echo json_encode(['success' => true, 'doc_heads' => $doc_heads]);
	}


}
