

<style>
td img {
  width: 20px;
  height: 20px;
  border-radius: 100%;
}
.dropdown .dropdown-menu .dropdown-item {
  font-size: 1rem;
  padding: 0.9rem 1.5rem;
}
/* Optional: Stylish toggle switch */
    .switch {
      position: relative;
      display: inline-block;
      width: 50px;
      height: 28px;
      margin-left: 10px;
    }
    .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }
    .slider {
      position: absolute;
      cursor: pointer;
      top: 0; left: 0; right: 0; bottom: 0;
      background-color: #ccc;
      transition: 0.4s;
      border-radius: 34px;
    }
    .slider:before {
      position: absolute;
      content: "";
      height: 20px; width: 20px;
      left: 4px; bottom: 4px;
      background-color: white;
      transition: 0.4s;
      border-radius: 50%;
    }
    input:checked + .slider {
      background-color: #4CAF50;
    }
    input:checked + .slider:before {
      transform: translateX(22px);
    }
</style>
<div class="main-panel">
	<div class="content-wrapper">
			<div class="row purchace-popup">
              <div class="col-12 stretch-card grid-margin">
                <div class="card card-secondary alert-info">
                  <span class="card-body d-lg-flex align-items-center">
                    <p class="mb-lg-0"><h4>User Access Configuration</h4></p>
                    
                   
                  </span>
                </div>
              </div>
            </div>
			<div class="col-lg-12 grid-margin stretch-card">
			<form name="access_form" id="access_form" method="post" action="<?php echo base_url();?>dashboard/saveAccess">
                <div class="card">
                  <div class="card-body">
                    <table class="table table-bordered">
						<thead class="thead-light">
							<tr>
								<td>Role</td>
								<td colspan="2">
								<select name="role_id" id="role_id" class="form-control">
								<option value="">Select Role</option>
								<?php foreach($role_data as $data) { ?>
								<option value="<?php echo $data['id'];?>"><?php echo $data['role_name'];?></option>
								<?php } ?>
								</select>
								</td>
							</tr>
							<tr>
								<th>Module</th>
								<th>View</th>
								<th>Edit</th>
							</tr>
						</thead>
						<tbody>
							<?php 
								$modules = ['authority', 'type_master', 'role_master', 'company_creation', 'user_access', 'smtp', 'email_templates'];
								foreach ($modules as $module) { ?>
								<tr>
									<td><?php echo ucfirst($module); ?></td>
									<td>
										<label class="switch">
											<input type="checkbox" class="access-checkbox switch" name="view[]" value="<?php echo $module; ?>" data-type="view" data-module="<?php echo $module; ?>">
											<span class="slider"></span>
										</label>
									</td>
									<td>
										<label class="switch">
											<input type="checkbox" class="access-checkbox switch" name="edit[]" value="<?php echo $module; ?>" data-type="edit" data-module="<?php echo $module; ?>">
											<span class="slider"></span>
										</label>
									</td>
								</tr>
								<?php } ?>
						  
						  <!-- Add more modules as needed -->
						</tbody>
					  </table>
                  </div>
                </div>
				</form>
              </div>
             
		</div>
		
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function escapeSelector(s) {
    return s.replace(/([ #;&,.+*~\':"!^$[\]()=>|\/@])/g, "\\$1");
}

$('#role_id').on('change', function () {
    var roleId = $(this).val();

    if (roleId) {
        $.ajax({
            url: "<?php echo base_url('dashboard/getRoleAccess'); ?>",
            type: "POST",
            data: { role_id: roleId },
            dataType: "json",
            success: function (response) {
                // Clear all checkboxes
                $("input[type=checkbox]").prop("checked", false);

                // Check view permissions
                if (response.view) {
                    response.view.forEach(function (val) {
                        let safeVal = escapeSelector(val);
                        $("input[name='view[]'][value='" + safeVal + "']").prop("checked", true);
                    });
                }

                // Check edit permissions
                if (response.edit) {
                    response.edit.forEach(function (val) {
                        let safeVal = escapeSelector(val);
                        $("input[name='edit[]'][value='" + safeVal + "']").prop("checked", true);
                    });
                }
            }
        });
    } else {
        $("input[type=checkbox]").prop("checked", false);
    }
});
$(document).on('change', '.access-checkbox', function () {
    var roleId = $('#role_id').val();
    if (!roleId) return alert("Please select a role first");

    var module = $(this).data('module');
    var accessType = $(this).data('type'); // 'view' or 'edit'
    var checked = $(this).is(':checked') ? 1 : 0;

    $.ajax({
        url: "<?php echo base_url('dashboard/updateSingleAccess'); ?>",
        type: "POST",
        data: {
            role_id: roleId,
            module: module,
            access_type: accessType,
            value: checked
        },
        success: function (res) {
            console.log("Access updated");
        }
    });
});
</script>