<!-- Main Content -->
<style>
.info-card { background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); }
.info-label { font-weight: 600; color: #495057; }
.badge-pill { font-size: 0.75rem; }
</style>

<div class="content">
    <div class="card position-relative shadow-sm rounded-4 view-card">
        <div class="fab-top-group" style="display: flex; gap: 8px; position: absolute; top: 8px; right: 25px; z-index: 10;">
            <a href="<?= base_url('type/allType/' . $this->session->userdata('company_id')) ?>" class="btn btn-outline-secondary btn-sm" title="Back to List" style="border-radius: 50%; width: 36px; height: 36px; padding: 0; display: flex; align-items: center; justify-content: center;">
                <i class="fa fa-arrow-left"></i>
            </a>
        </div>
        
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom" style="padding-right: 52px;">
                <h5 class="mb-0">
                    <i class="fas fa-eye text-primary"></i> View Document Head
                </h5>
                <span class="badge bg-warning text-dark">
                    <i class="fas fa-lock"></i> Read Only - <?= $upload_count ?> document(s) uploaded
                </span>
            </div>
            
            <!-- Basic Info -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card info-card">
                        <div class="card-body">
                            <h6 class="card-title text-primary"><i class="fas fa-info-circle"></i> Basic Information</h6>
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="info-label" width="40%">Document Head:</td>
                                    <td><?= htmlspecialchars($type_data['type_name']) ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Alias:</td>
                                    <td><?= htmlspecialchars($type_data['alias_name']) ?: '-' ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Authority:</td>
                                    <td><?= htmlspecialchars($type_data['authority_name']) ?: '-' ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Frequency:</td>
                                    <td><span class="badge bg-info"><?= ucfirst($type_data['frequency']) ?></span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card info-card">
                        <div class="card-body">
                            <h6 class="card-title text-primary"><i class="fas fa-calendar"></i> Due Date Settings</h6>
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="info-label" width="40%">Start Date:</td>
                                    <td><?= !empty($type_data['document_start_date']) ? date('d-M-Y', strtotime($type_data['document_start_date'])) : '-' ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Due Day:</td>
                                    <td><?= $type_data['frequency_start_date'] ?: '-' ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Due Month:</td>
                                    <td><?= ($type_data['due_in_same_next_month'] == '1') ? 'Next Month' : 'Same Month' ?></td>
                                </tr>
                                <tr>
                                    <td class="info-label">Status:</td>
                                    <td>
                                        <?php if ($type_data['status'] == '1'): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents & Reminders -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header bg-info text-white py-2">
                            <h6 class="mb-0"><i class="fas fa-file-alt"></i> Mandatory Documents (<?= count($assigned_documents) ?>)</h6>
                        </div>
                        <div class="card-body" style="max-height: 250px; overflow-y: auto;">
                            <?php if (!empty($assigned_documents)): ?>
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Document</th>
                                        <th>Mandatory</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach ($assigned_documents as $doc): ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td><?= htmlspecialchars($doc['document_name']) ?></td>
                                        <td>
                                            <?php if ($doc['mandatory'] == '1' || strtolower($doc['mandatory']) == 'yes'): ?>
                                                <span class="badge bg-danger">Yes</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">No</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <?php else: ?>
                            <p class="text-muted mb-0">No documents assigned.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header bg-warning py-2">
                            <h6 class="mb-0"><i class="fas fa-bell"></i> Reminders (<?= count($reminders) ?>)</h6>
                        </div>
                        <div class="card-body" style="max-height: 250px; overflow-y: auto;">
                            <?php if (!empty($reminders)): ?>
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Days Before</th>
                                        <th>To User</th>
                                        <th>To Admin</th>
                                        <th>To Super</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($reminders as $reminder): ?>
                                    <tr>
                                        <td><?= $reminder['reminder_no'] ?></td>
                                        <td><?= $reminder['days_before'] ?> days</td>
                                        <td><?= ($reminder['reminder_to_user'] == 'true' || $reminder['reminder_to_user'] === true) ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-muted"></i>' ?></td>
                                        <td><?= ($reminder['reminder_to_admin'] == 'true' || $reminder['reminder_to_admin'] === true) ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-muted"></i>' ?></td>
                                        <td><?= ($reminder['reminder_to_super_admin'] == 'true' || $reminder['reminder_to_super_admin'] === true) ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-muted"></i>' ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <?php else: ?>
                            <p class="text-muted mb-0">No reminders configured.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <hr class="my-4">
            <div class="text-center">
                <a href="<?= base_url('type/allType') ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Back to List
                </a>
            </div>
        </div>
    </div>
</div>

