<!-- Main Content -->
<?php $is_view_only = isset($is_view_only) && $is_view_only; ?>
<div class="content">
  <div class="formcard">
			<?php if ($this->session->flashdata('message_name')): ?>
			<div class="alert alert-<?= $this->session->flashdata('message_type') == 'error' ? 'danger' : $this->session->flashdata('message_type') ?> alert-dismissible fade show" role="alert">
			  <?= $this->session->flashdata('message_name') ?>
			  <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
			</div>
			<?php endif; ?>
			<?php if (!empty($company_name)): ?>
			<div class="mb-3">
			  <span class="badge" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 6px 14px; font-size: 0.9rem;">
				<i class="fas fa-building"></i> <?= htmlspecialchars($company_name) ?>
			  </span>
			</div>
			<?php endif; ?>
			<?php if ($is_view_only): ?>
			<div class="alert alert-info mb-3">
				<i class="fas fa-eye"></i> <strong>View Only Mode:</strong> This document has <?= $has_uploads ?> uploaded file(s) and cannot be edited.
			</div>
			<?php endif; ?>
			
			<form class="authority_form" id="authority_form" method="post" action="<?php echo base_url();?>document/updateDocument">
			<input type="hidden" name="id" value="<?php echo $authority_data[0]['id'];?>">	

            <div class="form-group">
                <i class="fas fa-user-shield icon"></i>
				<input type="text" class="form-control" name="document_name" id="document_name" value="<?php echo $authority_data[0]['document_name'];?>" <?= $is_view_only ? 'disabled' : '' ?>>
                <label for="authority_name">Document Name</label>
            </div>
            <div class="col-md-12">
                <?php if (!$is_view_only): ?>
                <button class="btn btn-primary">Edit</button>
                <?php endif; ?>
				<a class="btn btn-danger" href="<?= site_url('document/allDocuments/'.$this->session->userdata('company_id')) ?>">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>/public/assets/js/jquery.validate.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<script>
$(document).ready(function () {
	// Initialize the validation
	$('#authority_form').validate({
		errorClass: 'is-invalid',
		validClass: 'is-valid',
		errorElement: 'div',
		errorPlacement: function(error, element) {
			error.addClass('invalid-feedback');
			error.insertAfter(element.closest('.input-group').length ? element.closest('.input-group') : element);
		},
		highlight: function(element) {
			$(element).addClass('is-invalid').removeClass('is-valid');
		},
		unhighlight: function(element) {
			$(element).removeClass('is-invalid').addClass('is-valid');
		},
		rules: {
			document_name: {
				required: true,
			},
		},
		messages: {
			document_name: {
				required: "Please enter Document Name",
			},
		},
		submitHandler: function (form) {
			form.submit();
		},
	});
});
</script>