<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>/public/assets/js/jquery.validate.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
.error {
  color: red;
  font-weight: bold;
  text-decoration: none;
}
select.form-control, select.typeahead, select.tt-query, select.tt-hint, .select2-container--default .select2-selection--single select.select2-search__field, .select2-container--default select.select2-selection--single {
  padding: 1rem 0.75rem;
  border: 0;
  outline: 1px solid #f3f3f3;
  color: #312828;
  appearance: none;
  background-repeat: no-repeat;
  background-position: 99% center;
}
/* Custom floating label for select */
.form-floating > select.form-control:focus ~ label,
.form-floating > select.form-control:not(:placeholder-shown) ~ label {
  opacity: 1;
  transform: scale(.85) translateY(-1.5rem) translateX(.15rem);
}
</style>

<div class="content">
	<div class="formcard">
		<form class="company_form" id="company_form" method="post" action="<?php echo base_url();?>company/updateCompany">
			<input type="hidden" name="id" id="company_id" value="<?php echo $company_data[0]['id'];?>">
			
			<div class="form-group">
				<label class="form-label" for="company_name">Company Name <span class="text-danger">*</span></label>
				<input type="text" class="form-control" name="company_name" id="company_name" value="<?php echo $company_data[0]['company_name'];?>" placeholder="Enter company name" required>
			</div>

			<div class="form-group">
				<label class="form-label" for="short_name">Company Short Name</label>
				<input type="text" class="form-control" name="short_name" id="short_name" value="<?php echo $company_data[0]['short_name'];?>" placeholder="Enter short name">
			</div>

			<?php $fiscal_year = FINANCIAL_YEAR;?>
			<div class="form-floating mb-3">
				<select name="financial_year" class="form-control" id="financialYear" required>
					<?php foreach($fiscal_year as $year) { ?>
						<?php $selected = ($company_data[0]['fiscal_year']==$year) ? 'selected' : ''; ?>
						<option value="<?php echo $year;?>" <?php echo $selected;?>><?php echo $year;?></option>
					<?php } ?>
				</select>
				<label for="financialYear">Financial Year</label>
			</div>

			<div class="form-group">
				<label class="form-label" for="company_person">Contact Person</label>
				<input type="text" class="form-control" name="company_person" id="company_person" value="<?php echo $company_data[0]['contact_person'];?>" placeholder="Enter contact person name">
			</div>

			<div class="form-group">
				<label class="form-label" for="company_email">Contact Email</label>
				<input type="email" class="form-control" name="company_email" id="company_email" value="<?php echo $company_data[0]['contact_email'];?>" placeholder="Enter contact email">
			</div>

			<div class="form-group">
				<label class="form-label" for="company_start_date">Co. Start Date</label>
				<input type="text" class="form-control datepicker" name="company_start_date" id="company_start_date" value="<?php echo $company_data[0]['co_start_date'];?>" placeholder="Select start date" autocomplete="off">
			</div>

			<div class="form-group">
				<label class="form-label" for="phoneNumber">Phone Number</label>
				<input type="text" class="form-control" id="phoneNumber" name="phone_number" value="<?php echo $company_data[0]['phone'];?>" placeholder="Enter phone number">
			</div>

			<div class="form-group">
				<label class="form-label" for="address">Address</label>
				<textarea class="form-control" name="address" id="address" rows="2" style="min-height: 80px;" placeholder="Enter company address"><?php echo isset($company_data[0]['address']) ? $company_data[0]['address'] : ''; ?></textarea>
			</div>

			<?php $current_country = isset($company_data[0]['country']) ? $company_data[0]['country'] : ''; ?>
			<div class="form-floating mb-3">
				<select name="country" id="country" class="form-control" required>
					<option value="">-- Select Country --</option>

					<optgroup label="Africa">
						<option value="Algeria" <?php echo $current_country == 'Algeria' ? 'selected' : ''; ?>>Algeria</option>
						<option value="Angola" <?php echo $current_country == 'Angola' ? 'selected' : ''; ?>>Angola</option>
						<option value="Benin" <?php echo $current_country == 'Benin' ? 'selected' : ''; ?>>Benin</option>
						<option value="Botswana" <?php echo $current_country == 'Botswana' ? 'selected' : ''; ?>>Botswana</option>
						<option value="Burkina Faso" <?php echo $current_country == 'Burkina Faso' ? 'selected' : ''; ?>>Burkina Faso</option>
						<option value="Burundi" <?php echo $current_country == 'Burundi' ? 'selected' : ''; ?>>Burundi</option>
						<option value="Cameroon" <?php echo $current_country == 'Cameroon' ? 'selected' : ''; ?>>Cameroon</option>
						<option value="Cape Verde" <?php echo $current_country == 'Cape Verde' ? 'selected' : ''; ?>>Cape Verde</option>
						<option value="Central African Republic" <?php echo $current_country == 'Central African Republic' ? 'selected' : ''; ?>>Central African Republic</option>
						<option value="Chad" <?php echo $current_country == 'Chad' ? 'selected' : ''; ?>>Chad</option>
						<option value="Comoros" <?php echo $current_country == 'Comoros' ? 'selected' : ''; ?>>Comoros</option>
						<option value="Congo" <?php echo $current_country == 'Congo' ? 'selected' : ''; ?>>Congo</option>
						<option value="DR Congo" <?php echo $current_country == 'DR Congo' ? 'selected' : ''; ?>>DR Congo</option>
						<option value="Djibouti" <?php echo $current_country == 'Djibouti' ? 'selected' : ''; ?>>Djibouti</option>
						<option value="Egypt" <?php echo $current_country == 'Egypt' ? 'selected' : ''; ?>>Egypt</option>
						<option value="Ethiopia" <?php echo $current_country == 'Ethiopia' ? 'selected' : ''; ?>>Ethiopia</option>
						<option value="Gabon" <?php echo $current_country == 'Gabon' ? 'selected' : ''; ?>>Gabon</option>
						<option value="Gambia" <?php echo $current_country == 'Gambia' ? 'selected' : ''; ?>>Gambia</option>
						<option value="Ghana" <?php echo $current_country == 'Ghana' ? 'selected' : ''; ?>>Ghana</option>
						<option value="Kenya" <?php echo $current_country == 'Kenya' ? 'selected' : ''; ?>>Kenya</option>
						<option value="Lesotho" <?php echo $current_country == 'Lesotho' ? 'selected' : ''; ?>>Lesotho</option>
						<option value="Liberia" <?php echo $current_country == 'Liberia' ? 'selected' : ''; ?>>Liberia</option>
						<option value="Libya" <?php echo $current_country == 'Libya' ? 'selected' : ''; ?>>Libya</option>
						<option value="Malawi" <?php echo $current_country == 'Malawi' ? 'selected' : ''; ?>>Malawi</option>
						<option value="Mali" <?php echo $current_country == 'Mali' ? 'selected' : ''; ?>>Mali</option>
						<option value="Mauritius" <?php echo $current_country == 'Mauritius' ? 'selected' : ''; ?>>Mauritius</option>
						<option value="Morocco" <?php echo $current_country == 'Morocco' ? 'selected' : ''; ?>>Morocco</option>
						<option value="Mozambique" <?php echo $current_country == 'Mozambique' ? 'selected' : ''; ?>>Mozambique</option>
						<option value="Namibia" <?php echo $current_country == 'Namibia' ? 'selected' : ''; ?>>Namibia</option>
						<option value="Niger" <?php echo $current_country == 'Niger' ? 'selected' : ''; ?>>Niger</option>
						<option value="Nigeria" <?php echo $current_country == 'Nigeria' ? 'selected' : ''; ?>>Nigeria</option>
						<option value="Rwanda" <?php echo $current_country == 'Rwanda' ? 'selected' : ''; ?>>Rwanda</option>
						<option value="Senegal" <?php echo $current_country == 'Senegal' ? 'selected' : ''; ?>>Senegal</option>
						<option value="Seychelles" <?php echo $current_country == 'Seychelles' ? 'selected' : ''; ?>>Seychelles</option>
						<option value="Sierra Leone" <?php echo $current_country == 'Sierra Leone' ? 'selected' : ''; ?>>Sierra Leone</option>
						<option value="Somalia" <?php echo $current_country == 'Somalia' ? 'selected' : ''; ?>>Somalia</option>
						<option value="South Africa" <?php echo $current_country == 'South Africa' ? 'selected' : ''; ?>>South Africa</option>
						<option value="South Sudan" <?php echo $current_country == 'South Sudan' ? 'selected' : ''; ?>>South Sudan</option>
						<option value="Sudan" <?php echo $current_country == 'Sudan' ? 'selected' : ''; ?>>Sudan</option>
						<option value="Tanzania" <?php echo $current_country == 'Tanzania' ? 'selected' : ''; ?>>Tanzania</option>
						<option value="Togo" <?php echo $current_country == 'Togo' ? 'selected' : ''; ?>>Togo</option>
						<option value="Tunisia" <?php echo $current_country == 'Tunisia' ? 'selected' : ''; ?>>Tunisia</option>
						<option value="Uganda" <?php echo $current_country == 'Uganda' ? 'selected' : ''; ?>>Uganda</option>
						<option value="Zambia" <?php echo $current_country == 'Zambia' ? 'selected' : ''; ?>>Zambia</option>
						<option value="Zimbabwe" <?php echo $current_country == 'Zimbabwe' ? 'selected' : ''; ?>>Zimbabwe</option>
					</optgroup>

					<optgroup label="Asia">
						<option value="India" <?php echo $current_country == 'India' ? 'selected' : ''; ?>>India</option>
						<option value="UAE" <?php echo $current_country == 'UAE' ? 'selected' : ''; ?>>United Arab Emirates</option>
						<option value="Saudi Arabia" <?php echo $current_country == 'Saudi Arabia' ? 'selected' : ''; ?>>Saudi Arabia</option>
						<option value="Singapore" <?php echo $current_country == 'Singapore' ? 'selected' : ''; ?>>Singapore</option>
						<option value="China" <?php echo $current_country == 'China' ? 'selected' : ''; ?>>China</option>
						<option value="Japan" <?php echo $current_country == 'Japan' ? 'selected' : ''; ?>>Japan</option>
					</optgroup>

					<optgroup label="Europe">
						<option value="UK" <?php echo $current_country == 'UK' ? 'selected' : ''; ?>>United Kingdom</option>
						<option value="Germany" <?php echo $current_country == 'Germany' ? 'selected' : ''; ?>>Germany</option>
						<option value="France" <?php echo $current_country == 'France' ? 'selected' : ''; ?>>France</option>
						<option value="Italy" <?php echo $current_country == 'Italy' ? 'selected' : ''; ?>>Italy</option>
					</optgroup>

					<optgroup label="Americas">
						<option value="USA" <?php echo $current_country == 'USA' ? 'selected' : ''; ?>>United States</option>
						<option value="Canada" <?php echo $current_country == 'Canada' ? 'selected' : ''; ?>>Canada</option>
						<option value="Brazil" <?php echo $current_country == 'Brazil' ? 'selected' : ''; ?>>Brazil</option>
					</optgroup>

					<optgroup label="Oceania">
						<option value="Australia" <?php echo $current_country == 'Australia' ? 'selected' : ''; ?>>Australia</option>
						<option value="New Zealand" <?php echo $current_country == 'New Zealand' ? 'selected' : ''; ?>>New Zealand</option>
					</optgroup>
				</select>
				<label for="country">Country</label>
			</div>

			<div class="col-md-12">
				<button class="btn btn-primary">Update</button>
				<a class="btn btn-danger" href="<?php echo site_url();?>company">Cancel</a>
			</div>
		</form>
	</div>
</div>

<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
$(document).ready(function () {
	// Initialize Flatpickr datepicker
	flatpickr(".datepicker", {
		dateFormat: "Y-m-d",
		allowInput: true
	});

	// Initialize the validation
	var base_url = "<?php echo base_url(); ?>";
	$('#company_form').validate({
		errorClass: 'is-invalid',
		validClass: 'is-valid',
		errorElement: 'div',
		errorPlacement: function(error, element) {
			error.addClass('invalid-feedback');
			if (element.hasClass('select2-hidden-accessible')) {
				error.insertAfter(element.next('.select2-container'));
			} else if (element.closest('.form-group').length) {
				error.insertAfter(element);
			} else {
				error.insertAfter(element);
			}
		},
		highlight: function(element) {
			$(element).addClass('is-invalid').removeClass('is-valid');
		},
		unhighlight: function(element) {
			$(element).removeClass('is-invalid').addClass('is-valid');
		},
		rules: {
			company_name: {
				required: true,
				remote: {
					url: base_url + "company/checkCompanyName",
					type: "post",
					data: {
						company_name: function () {
							return $("#company_name").val();
						},
						id: function () {
							return $("#company_id").val();
						}
					}
				}
			},
			short_name: {
				required: true
			},
			company_email: {
				email: true
			}
		},
		messages: {
			company_name: {
				required: "Please enter Company Name",
				remote: "This company name already exists"
			},
			short_name: {
				required: "Please enter Short Name"
			},
			company_email: {
				email: "Please enter a valid email address"
			}
		},
		submitHandler: function (form) {
			form.submit();
		}
	});
});
</script>
