<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>/public/assets/js/jquery.validate.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<style>
.error {
  color: red;
  font-weight: bold;
  text-decoration: none;
}
select.form-control {
  padding: 1rem 0.75rem;
  border: 0;
  outline: 1px solid #f3f3f3;
  color: #312828;
  appearance: none;
  background-repeat: no-repeat;
  background-position: 99% center;
}
/* Custom floating label for select */
.form-floating > select.form-control:focus ~ label,
.form-floating > select.form-control:not(:placeholder-shown) ~ label {
  opacity: 1;
  transform: scale(.85) translateY(-1.5rem) translateX(.15rem);
}
</style>

<div class="content">
	<div class="formcard">
		<form class="company_form" id="company_form" method="post" action="<?php echo base_url();?>company/saveCompany">
			
			<div class="form-group">
				<label class="form-label" for="company_name">Company Name <span class="text-danger">*</span></label>
				<input type="text" class="form-control" name="company_name" id="company_name" placeholder="Enter company name" required>
			</div>

			<div class="form-group">
				<label class="form-label" for="short_name">Company Short Name</label>
				<input type="text" class="form-control" name="short_name" id="short_name" placeholder="Enter short name">
			</div>

			<?php $fiscal_year = FINANCIAL_YEAR;?>
			<div class="form-floating mb-3">
				<select name="financial_year" class="form-control" id="financialYear" required>
					<option value="" disabled selected hidden></option>
					<?php foreach($fiscal_year as $year) { ?>
						<option value="<?php echo $year;?>"><?php echo $year;?></option>
					<?php } ?>
				</select>
				<label for="financialYear">Financial Year</label>
			</div>

			<div class="form-group">
				<label class="form-label" for="company_person">Contact Person</label>
				<input type="text" class="form-control" name="company_person" id="company_person" placeholder="Enter contact person name">
			</div>

			<div class="form-group">
				<label class="form-label" for="company_email">Contact Email</label>
				<input type="email" class="form-control" name="company_email" id="company_email" placeholder="Enter contact email">
			</div>

			<div class="form-group">
				<label class="form-label" for="co_start_date">Co. Start Date</label>
				<input type="text" class="form-control datepicker" name="co_start_date" id="co_start_date" placeholder="Select start date" autocomplete="off">
			</div>

			<div class="form-group">
				<label class="form-label" for="phoneNumber">Phone Number</label>
				<input type="text" class="form-control" id="phoneNumber" name="phone_number" placeholder="Enter phone number">
			</div>

			<div class="form-group">
				<label class="form-label" for="address">Address</label>
				<textarea class="form-control" name="address" id="address" rows="2" style="min-height: 80px;" placeholder="Enter company address"></textarea>
			</div>

			<div class="form-floating mb-3">
				<select name="country" id="country" class="form-control" required>
					<option value="">-- Select Country --</option>

					<optgroup label="Africa">
						<option value="Algeria">Algeria</option>
						<option value="Angola">Angola</option>
						<option value="Benin">Benin</option>
						<option value="Botswana">Botswana</option>
						<option value="Burkina Faso">Burkina Faso</option>
						<option value="Burundi">Burundi</option>
						<option value="Cameroon">Cameroon</option>
						<option value="Cape Verde">Cape Verde</option>
						<option value="Central African Republic">Central African Republic</option>
						<option value="Chad">Chad</option>
						<option value="Comoros">Comoros</option>
						<option value="Congo">Congo</option>
						<option value="DR Congo">DR Congo</option>
						<option value="Djibouti">Djibouti</option>
						<option value="Egypt">Egypt</option>
						<option value="Ethiopia">Ethiopia</option>
						<option value="Gabon">Gabon</option>
						<option value="Gambia">Gambia</option>
						<option value="Ghana">Ghana</option>
						<option value="Kenya">Kenya</option>
						<option value="Lesotho">Lesotho</option>
						<option value="Liberia">Liberia</option>
						<option value="Libya">Libya</option>
						<option value="Malawi">Malawi</option>
						<option value="Mali">Mali</option>
						<option value="Mauritius">Mauritius</option>
						<option value="Morocco">Morocco</option>
						<option value="Mozambique">Mozambique</option>
						<option value="Namibia">Namibia</option>
						<option value="Niger">Niger</option>
						<option value="Nigeria">Nigeria</option>
						<option value="Rwanda">Rwanda</option>
						<option value="Senegal">Senegal</option>
						<option value="Seychelles">Seychelles</option>
						<option value="Sierra Leone">Sierra Leone</option>
						<option value="Somalia">Somalia</option>
						<option value="South Africa">South Africa</option>
						<option value="South Sudan">South Sudan</option>
						<option value="Sudan">Sudan</option>
						<option value="Tanzania">Tanzania</option>
						<option value="Togo">Togo</option>
						<option value="Tunisia">Tunisia</option>
						<option value="Uganda">Uganda</option>
						<option value="Zambia">Zambia</option>
						<option value="Zimbabwe">Zimbabwe</option>
					</optgroup>

					<optgroup label="Asia">
						<option value="India">India</option>
						<option value="UAE">United Arab Emirates</option>
						<option value="Saudi Arabia">Saudi Arabia</option>
						<option value="Singapore">Singapore</option>
						<option value="China">China</option>
						<option value="Japan">Japan</option>
					</optgroup>

					<optgroup label="Europe">
						<option value="UK">United Kingdom</option>
						<option value="Germany">Germany</option>
						<option value="France">France</option>
						<option value="Italy">Italy</option>
					</optgroup>

					<optgroup label="Americas">
						<option value="USA">United States</option>
						<option value="Canada">Canada</option>
						<option value="Brazil">Brazil</option>
					</optgroup>

					<optgroup label="Oceania">
						<option value="Australia">Australia</option>
						<option value="New Zealand">New Zealand</option>
					</optgroup>
				</select>
				<label for="country">Country</label>
			</div>

			<div class="col-md-12">
				<button class="btn btn-primary">Create</button>
				<a class="btn btn-danger" href="<?php echo site_url();?>company">Cancel</a>
			</div>
		</form>
	</div>
</div>

<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
$(document).ready(function () {
	// Initialize Flatpickr datepicker
	flatpickr(".datepicker", {
		dateFormat: "Y-m-d",
		allowInput: true
	});

	// Initialize the validation
	var base_url = "<?php echo base_url(); ?>";
	$('#company_form').validate({
		errorClass: 'is-invalid',
		validClass: 'is-valid',
		errorElement: 'div',
		errorPlacement: function(error, element) {
			error.addClass('invalid-feedback');
			if (element.closest('.form-group').length) {
				error.insertAfter(element);
			} else {
				error.insertAfter(element);
			}
		},
		highlight: function(element) {
			$(element).addClass('is-invalid').removeClass('is-valid');
		},
		unhighlight: function(element) {
			$(element).removeClass('is-invalid').addClass('is-valid');
		},
		rules: {
			company_name: {
				required: true,
				remote: {
					url: base_url + "company/checkCompanyName",
					type: "post",
					data: {
						company_name: function () {
							return $("#company_name").val();
						},
						id: function () {
							return $("#company_id").val();
						}
					}
				}
			},
			short_name: {
				required: true
			},
			company_email: {
				email: true
			}
		},
		messages: {
			company_name: {
				required: "Please enter Company Name",
				remote: "This company name already exists"
			},
			short_name: {
				required: "Please enter Short Name"
			},
			company_email: {
				email: "Please enter a valid email address"
			}
		},
		submitHandler: function (form) {
			form.submit();
		}
	});
});
</script>
