<!-- Main Content -->
<div class="content">
  <div class="formcard">
        <?php if (!empty($company_name)): ?>
        <div class="mb-3">
          <span class="badge" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 6px 14px; font-size: 0.9rem;">
            <i class="fas fa-building"></i> <?= htmlspecialchars($company_name) ?>
          </span>
        </div>
        <?php endif; ?>
        <?php if (!empty($error_message)): ?>
          <div class="alert alert-danger"><?= $error_message; ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="form-group">
                <i class="fas fa-user-shield icon"></i>
                <input type="text" id="authority_name" name="authority_name" placeholder=" " required>
                <label for="authority_name">Authority Name</label>
                <div class="hint">Enter the official authority name.</div>
                <?php echo form_error('authority_name', '<div class="error">', '</div>'); ?>
            </div>
            <div class="form-group">
                <i class="fas fa-tag icon"></i>
                <input type="text" id="alias" name="alias" placeholder=" ">
                <label for="alias">Alias</label>
                <div class="hint">A short alias for quick reference.</div>
            </div>

            <div class="col-md-12">
                <button class="btn btn-primary">Create</button>
                <a class="btn btn-danger" href="<?= site_url('authority/index/'.$this->session->userdata('company_id')) ?>">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script>
  // Real-time validation
  const form = document.getElementById('authorityForm');
  const inputs = form.querySelectorAll('input, textarea');

  inputs.forEach(input => {
    input.addEventListener('input', () => {
      const parent = input.parentElement;
      if (input.checkValidity()) {
        parent.classList.remove('invalid');
        parent.classList.add('valid');
      } else {
        parent.classList.remove('valid');
        parent.classList.add('invalid');
      }
    });
  });
</script>