# DMS Application - Complete Test Documentation

## Version: 2.0
## Date: 2026-02-10

---

## Table of Contents

1. [Overview](#overview)
2. [Database Tables](#database-tables)
3. [Test Scripts](#test-scripts)
4. [Test Credentials](#test-credentials)
5. [Test Scenarios](#test-scenarios)
6. [Running Tests](#running-tests)

---

## Overview

This document provides comprehensive documentation for the DMS (Document Management System) automated testing suite. The test suite covers all major features including:

- Master Data Management (Companies, Authorities, Document Heads, Documents)
- User Management with Role-Based Access Control (RBAC)
- Permission System (View, Add/Edit, Delete)
- Document Upload and Management
- Favourites Functionality
- Holiday Management
- Reminder System

---

## Database Tables

### Core Tables (28 total)

| # | Table Name | Description | FK Dependencies |
|---|------------|-------------|-----------------|
| 1 | `users` | User accounts | None |
| 2 | `role` | User roles (Super Admin, Admin, User) | None |
| 3 | `company` | Company master data | None |
| 4 | `authority` | Authority master data | None |
| 5 | `sub_type` | Document heads (types) | authority |
| 6 | `documents` | Document master data | None |
| 7 | `mandatory_documents` | Links documents to document heads | sub_type, documents |
| 8 | `sub_type_reminders` | Reminder settings for document heads | sub_type |
| 9 | `uploaded_documents` | Uploaded document records | company, sub_type |
| 10 | `document_groups` | Document groupings | documents |
| 11 | `holidays` | Holiday calendar | None |
| 12 | `favourites` | User favourites | users, uploaded_documents |
| 13 | `reminder_logs` | Reminder system logs | company, sub_type |

### Company-Specific Tables

| # | Table Name | Description |
|---|------------|-------------|
| 14 | `company_authorities` | Company-authority links |
| 15 | `company_documents` | Company-document links |
| 16 | `company_document_heads` | Company-document head links |
| 17 | `company_mandatory_documents` | Company mandatory documents |
| 18 | `company_document_head_reminders` | Company reminder settings |
| 19 | `company_document_groups` | Company document groups |
| 20 | `company_templates` | Company templates |
| 21 | `company_template_document_heads` | Template document heads |

### User Assignment Tables

| # | Table Name | Description |
|---|------------|-------------|
| 22 | `user_companies` | User-company assignments |
| 23 | `user_authorities` | User-authority assignments |
| 24 | `user_document_types` | User-document type assignments |
| 25 | `user_permissions` | User permission settings |

### Permission Tables

| # | Table Name | Description |
|---|------------|-------------|
| 26 | `role_permissions` | Role-based permissions |
| 27 | `role_access` | Role access settings |
| 28 | `user_priviledges` | User privileges |

### Additional Tables

| # | Table Name | Description |
|---|------------|-------------|
| 29 | `child_document_mandatory` | Child document mandatory settings |

---

## Test Scripts

### Files

| File | Description |
|------|-------------|
| `complete_truncate.sql` | Comprehensive database truncate script |
| `complete_test_suite.php` | Main PHP test automation script |
| `run_complete_tests.ps1` | PowerShell test runner |
| `run_complete_tests.bat` | Windows batch test runner |

### Test Categories

1. **Master Data Tests** - Company, Authority, Document Head, Document creation
2. **User Management Tests** - User creation, permissions, assignments
3. **RBAC Tests** - Role-based access control verification
4. **Holiday Tests** - Holiday management
5. **Data Integrity Tests** - Foreign keys, required fields, duplicates
6. **API Tests** - HTTP endpoint testing

---

## Test Credentials

### After Truncate (Default Super Admin)

| Field | Value |
|-------|-------|
| Email | `superadmin@dms.com` |
| Password | `Admin@123` |
| Role | Super Admin (role_id = 1) |
| Permissions | Full access (View, Add/Edit, Delete) |

### Test Users Created by Seed

| User | Email | Password | Role | Companies | Permissions |
|------|-------|----------|------|-----------|-------------|
| Admin 1 | `testadmin1@test.com` | `Test@123` | Admin | Company 1 | View, Add/Edit |
| Admin 2 | `testadmin2@test.com` | `Test@123` | Admin | Company 2, 3 | Full |
| User 1 | `testuser1@test.com` | `Test@123` | User | Company 1 | View Only |
| User 2 | `testuser2@test.com` | `Test@123` | User | Company 1 | View, Add/Edit |

---

## Test Scenarios

### Scenario 1: Super Admin Full Access

**User:** Super Admin  
**Expected Behavior:**
- Can see ALL companies
- Can see ALL authorities
- Can see ALL document heads
- Can add/edit/delete any data
- Can manage users
- Can access all reports

### Scenario 2: Admin Company Restriction

**User:** Admin 1 (Company 1 only)  
**Expected Behavior:**
- Can ONLY see Company 1 data
- Cannot see Company 2 or 3 data
- Can add/edit data for Company 1
- Cannot delete (no delete permission)
- Cannot manage users
- Dashboard shows only Company 1 counts

### Scenario 3: Admin Multiple Companies

**User:** Admin 2 (Companies 2 & 3)  
**Expected Behavior:**
- Can see Company 2 and 3 data
- Cannot see Company 1 data
- Can add/edit/delete data for assigned companies
- Dashboard shows combined counts for Company 2 & 3

### Scenario 4: User View Only

**User:** User 1 (View Only)  
**Expected Behavior:**
- Can ONLY view data
- Cannot add new records
- Cannot edit existing records
- Cannot delete records
- Cannot upload documents
- Upload menu should be disabled
- User menu should be disabled
- Can only see Holiday list in Masters

### Scenario 5: User with Add/Edit

**User:** User 2 (View + Add/Edit)  
**Expected Behavior:**
- Can view data
- Can add new records
- Can edit existing records
- Cannot delete records
- Can upload documents
- Restricted to assigned authorities only

### Scenario 6: Single Company Auto-Redirect

**User:** Any user with single company assignment  
**Expected Behavior:**
- When clicking menu items, should auto-redirect to that company
- No company selection modal should appear
- Direct navigation to the relevant page

---

## Running Tests

### Prerequisites

1. PHP 7.4+ installed and in PATH
2. PostgreSQL installed with psql in PATH
3. Database `new_dms_type` exists
4. Web server running (for API tests)

### Using PowerShell (Recommended)

```powershell
# Navigate to test directory
cd C:\xampp\htdocs\dmsnew\application\tests

# Show help
.\run_complete_tests.ps1 help

# Truncate database (clears all data)
.\run_complete_tests.ps1 truncate

# Seed test data
.\run_complete_tests.ps1 seed

# Run all tests (truncate + seed + tests)
.\run_complete_tests.ps1 all

# Run specific test category
.\run_complete_tests.ps1 master
.\run_complete_tests.ps1 users
.\run_complete_tests.ps1 rbac
.\run_complete_tests.ps1 holidays
.\run_complete_tests.ps1 integrity
.\run_complete_tests.ps1 api

# Run all tests without truncate/seed
.\run_complete_tests.ps1
```

### Using Command Prompt (Batch)

```batch
# Navigate to test directory
cd C:\xampp\htdocs\dmsnew\application\tests

# Show help
run_complete_tests.bat help

# Truncate database
run_complete_tests.bat truncate

# Run all tests
run_complete_tests.bat all
```

### Using PHP Directly

```bash
# Navigate to test directory
cd C:\xampp\htdocs\dmsnew\application\tests

# Run all tests
php complete_test_suite.php

# Run with specific option
php complete_test_suite.php --truncate
php complete_test_suite.php --seed
php complete_test_suite.php --all
php complete_test_suite.php --master
php complete_test_suite.php --users
php complete_test_suite.php --rbac
```

### Manual SQL Truncate

If you prefer to run the truncate SQL directly:

```bash
# Using psql
psql -U postgres -d new_dms_type -f complete_truncate.sql

# Or in pgAdmin:
# 1. Open pgAdmin
# 2. Connect to new_dms_type database
# 3. Open Query Tool
# 4. Load and execute complete_truncate.sql
```

---

## Expected Test Output

### Successful Run

```
=== DMS COMPLETE TEST SUITE ===
Database: new_dms_type
Base URL: http://localhost/dmsnew/
Date: 2026-02-10 10:00:00

=== MASTER DATA TESTS ===
--- Company Creation Tests ---
✓ Created company: Test Company 1 (ID: 1)
✓ Created company: Test Company 2 (ID: 2)
✓ Created company: Test Company 3 (ID: 3)
...

=== TEST SUMMARY ===

✓ Passed: 45
Failed: 0
Skipped: 2

Total: 47
```

### Failed Test

```
✗ Admin 1 can see Company 2 data: Should not have access
   Reason: RBAC not properly enforced
```

---

## Troubleshooting

### Common Issues

1. **"psql not found"**
   - Add PostgreSQL bin directory to PATH
   - Or specify full path in script

2. **"Database connection failed"**
   - Verify database credentials in script
   - Ensure PostgreSQL is running

3. **"Permission denied"**
   - Run PowerShell as Administrator
   - Check file permissions

4. **"Foreign key constraint violation"**
   - Tables must be deleted in correct order
   - Use the complete_truncate.sql script

5. **"Data still visible after truncate"**
   - Verify correct database name
   - Check if transaction was committed

---

## Version History

| Version | Date | Changes |
|---------|------|---------|
| 2.0 | 2026-02-10 | Complete rewrite with all tables covered |
| 1.0 | 2026-02-08 | Initial test suite |

