-- Add deactivation fields to sub_type table
-- Created: 2026-02-14
-- Purpose: Store deactivation date and remarks when document heads are deactivated

-- Add deactivation_date column (nullable, only filled when status = '0')
ALTER TABLE sub_type ADD COLUMN IF NOT EXISTS deactivation_date DATE;

-- Add deactivation_remarks column (nullable, text field for deactivation reason)
ALTER TABLE sub_type ADD COLUMN IF NOT EXISTS deactivation_remarks TEXT;

-- Add comment to clarify usage
COMMENT ON COLUMN sub_type.deactivation_date IS 'Date when document head was deactivated (required when status = 0)';
COMMENT ON COLUMN sub_type.deactivation_remarks IS 'Reason/remarks for deactivation (required when status = 0)';

