-- =====================================================
-- Add per-company permissions to user_companies table
-- Users can have different permissions for different companies
-- =====================================================

-- Add permission columns to user_companies
ALTER TABLE user_companies 
ADD COLUMN IF NOT EXISTS can_add_edit BOOLEAN DEFAULT FALSE,
ADD COLUMN IF NOT EXISTS can_delete BOOLEAN DEFAULT FALSE;

-- Create index for faster permission lookups
CREATE INDEX IF NOT EXISTS idx_uc_user_company ON user_companies(user_id, company_id);

-- Comment on new columns
COMMENT ON COLUMN user_companies.can_add_edit IS 'Whether user can add/edit documents in this company';
COMMENT ON COLUMN user_companies.can_delete IS 'Whether user can delete documents in this company';

