<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('get_month_number')) {
    /**
     * Get month number (01-12) by month name.
     * 
     * @param string $monthName Full month name (e.g. "January", "March", "December")
     * @return string|null      Returns 2-digit month number or null if not found
     */
    function get_month_number($monthName) {
        $months = [
            "January"   => "01",
            "February"  => "02",
            "March"     => "03",
            "April"     => "04",
            "May"       => "05",
            "June"      => "06",
            "July"      => "07",
            "August"    => "08",
            "September" => "09",
            "October"   => "10",
            "November"  => "11",
            "December"  => "12"
        ];

        $monthName = ucfirst(strtolower(trim($monthName))); // Normalize input
        return isset($months[$monthName]) ? $months[$monthName] : null;
    }
}
