<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */

	function __construct(){ 
        parent::__construct();
		ini_set('display_errors', 1);
    }

	public function index()
	{
		redirect('user/users');
	}
	
	public function users()
    {   
		$this->session->set_userdata('menu','user');
		$login_id = $this->session->userdata('id');
		$role_id = $this->session->userdata('role_id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// View-only users cannot access user management
		if (function_exists('is_user') && is_user() && function_exists('can_edit') && !can_edit()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'You do not have permission to access user management.');
			redirect('dashboard');
			return;
		}
		
		// Super Admin sees all Admins and Users (but not other Super Admins)
		if (is_super_admin()) {
			$sql = "SELECT * FROM users WHERE role_id IN ('2', '3') ORDER BY id DESC";
			$query = $this->db->query($sql);
			$user_list = $query->result_array();
		} else {
			// Admin sees only Users (role_id = 3) who share at least one company with them
			$allowed_companies = get_allowed_companies();
			
			if (!empty($allowed_companies)) {
				// Get users whose user_company field has any overlap with admin's companies
				// OR users in user_companies table with matching companies
				$company_ids_str = implode(',', $allowed_companies);
				
				$sql = "SELECT DISTINCT u.* FROM users u 
					LEFT JOIN user_companies uc ON u.id = uc.user_id
					WHERE u.role_id = '3'
					AND (
						-- Check user_companies table
						uc.company_id IN ({$company_ids_str})
						OR
						-- Check old CSV field for backward compatibility
						EXISTS (
							SELECT 1 FROM unnest(string_to_array(u.user_company, ',')) AS comp_id
							WHERE comp_id::text IN ('" . implode("','", $allowed_companies) . "')
						)
					)
					ORDER BY u.id DESC";
				$query = $this->db->query($sql);
				$user_list = $query->result_array();
			} else {
				$user_list = [];
			}
		}
		
		$this->load->view('templates/header');
		$this->load->view('users/users', array('user_list' => $user_list));
	}
	public function details($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
				$this->session->set_userdata('menu','user');

		$sql="select * from users where id = '$id' order by id desc "; 
		$query = $this->db->query($sql);
		$user_list = $query->result_array();
		
		$this->load->view('templates/layout.php');
        $this->load->view('users/details',array('user_details'=>$user_list));
	}

	public function addUser() {		
		$this->session->set_userdata('menu','user');
		$CI = & get_instance();
		$login_id = $this->session->userdata('id');
		$current_role_id = $this->session->userdata('role_id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Role list - Admin can only create User role (3), not Super Admin or Admin
		if (is_super_admin()) {
			$sql = "SELECT * FROM role WHERE status='1' ORDER BY id ASC";
		} else {
			// Admin can only create User role
			$sql = "SELECT * FROM role WHERE status='1' AND id = '3' ORDER BY id ASC";
		}
		$query = $this->db->query($sql);
		$role_list = $query->result_array();
		
		// Company list - Admin can only assign their own companies
		if (is_super_admin()) {
			$company = "SELECT * FROM company WHERE status='1' ORDER BY company_name ASC";
			$company_query = $this->db->query($company);
			$company_list = $company_query->result_array();
		} else {
			// Admin can only see/assign their own companies
			$allowed_companies = get_allowed_companies();
			if (!empty($allowed_companies)) {
				$this->db->select('*')
					->from('company')
					->where('status', '1')
					->where_in('id', $allowed_companies)
					->order_by('company_name', 'ASC');
				$company_list = $this->db->get()->result_array();
			} else {
				$company_list = [];
			}
		}
		
		$sub_type = "SELECT t.*, a.authority_name FROM sub_type t LEFT JOIN authority a ON a.id::text=t.authority_id WHERE t.status='1' ORDER BY a.authority_name, t.type_name ASC";
		$sub_type_query = $this->db->query($sub_type);
		$sub_type_list = $sub_type_query->result_array();
		
		// Load authorities for user assignment
		$authority = "SELECT * FROM authority WHERE status='1' ORDER BY authority_name ASC";
		$authority_query = $this->db->query($authority);
		$authority_list = $authority_query->result_array();
		
        $this->load->view('templates/header.php');
        $this->load->view('users/add_user', array(
			'role_list' => $role_list,
			'company_list' => $company_list,
			'sub_type_list' => $sub_type_list,
			'authority_list' => $authority_list,
			'current_user_role' => $current_role_id
		));
	}

	public function saveUser() {
	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		
		$userdata = $_POST;
		$first_name = $this->db->escape_str($_POST['first_name']);
		$last_name = $this->db->escape_str($_POST['last_name']);
		$password = md5($_POST['password']);
		$email_id = $this->db->escape_str($_POST['email_id']);
		$role = $_POST['role'];
		
		// New: Handle company access cards format
		$company_access = isset($_POST['company_access']) ? $_POST['company_access'] : [];
		
		// Check for duplicate email
		$existing_email = $this->db->where('email_id', $email_id)->get('users')->row();
		if ($existing_email) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Email address already exists! Please use a different email.');
			redirect('user/addUser');
			return;
		}
		
		// Get permission flags
		$can_view = true; // View is always true
		$can_add_edit = false;
		$can_delete = false;
		
		// For Admin/User roles, calculate global permissions from company permissions
		if (($role == '2' || $role == '3') && !empty($company_access)) {
			foreach ($company_access as $card) {
				// If user has permission in ANY company, set global permission to true
				if (isset($card['can_add_edit']) && $card['can_add_edit'] == '1') {
					$can_add_edit = true;
				}
				if (isset($card['can_delete']) && $card['can_delete'] == '1') {
					$can_delete = true;
				}
			}
		}
		// For Super Admin, check direct POST
		else if ($role == '1') {
			$can_add_edit = isset($_POST['can_add_edit']) ? true : false;
			$can_delete = isset($_POST['can_delete']) ? true : false;
		}
		
		// Users (role 3) can never delete
		if ($role == '3') {
			$can_delete = false;
		}
		
		// Process company access cards to legacy format (for backward compatibility)
		$company_data = '';
		$type_data = '';
		$authority_data = '';
		$all_companies = [];
		$all_authorities = [];
		$all_doc_heads = [];
		
		if (!empty($company_access)) {
			foreach ($company_access as $card) {
				if (!empty($card['company_id'])) {
					$all_companies[] = $card['company_id'];
				}
				if (!empty($card['authorities']) && is_array($card['authorities'])) {
					$all_authorities = array_merge($all_authorities, $card['authorities']);
				}
				if (!empty($card['doc_heads']) && is_array($card['doc_heads'])) {
					$all_doc_heads = array_merge($all_doc_heads, $card['doc_heads']);
				}
			}
			$company_data = implode(',', array_unique($all_companies));
			$authority_data = implode(',', array_unique($all_authorities));
			$type_data = implode(',', array_unique($all_doc_heads));
		}
		
		$created_date = date('Y-m-d h:i:s');
		$status = '1';
		
		// Insert user
		$query = "insert into users (first_name, last_name, password, email_id, status, parent_id,user_company,user_type,user_authority,role_id, mobile_number) values('".$first_name."','".$last_name."','".$password."','".$email_id."','".$status."','".$login_id."','".$company_data."','".$type_data."','".$authority_data."','".$role."','".$this->db->escape_str($_POST['mobile_number'] ?? '')."')";
		$sql = $this->db->query($query);
		
		// Get the new user's ID
		$new_user_id = $this->db->insert_id();
		
		// Save user permissions
		if ($new_user_id) {
			$this->Permission_model->save_user_permissions($new_user_id, $can_view, $can_add_edit, $can_delete);
			
			// Save to normalized tables with company-scoped access
			if (!empty($company_access)) {
				foreach ($company_access as $card) {
					$company_id = $card['company_id'] ?? null;
					if (!$company_id) continue;
					
					// Get per-company permissions from the card
					$company_can_add_edit = isset($card['can_add_edit']) && $card['can_add_edit'] == '1' ? 'TRUE' : 'FALSE';
					$company_can_delete = isset($card['can_delete']) && $card['can_delete'] == '1' ? 'TRUE' : 'FALSE';
					
					// Save user company with per-company permissions
					$this->db->query("INSERT INTO user_companies (user_id, company_id, can_add_edit, can_delete) 
						VALUES (?, ?, $company_can_add_edit, $company_can_delete) 
						ON CONFLICT (user_id, company_id) 
						DO UPDATE SET can_add_edit = $company_can_add_edit, can_delete = $company_can_delete", 
						[$new_user_id, $company_id]);
					
					// Save user authorities for this company
					if (!empty($card['authorities']) && is_array($card['authorities'])) {
						foreach ($card['authorities'] as $auth_id) {
							$this->db->query("INSERT INTO user_authorities (user_id, company_id, authority_id) VALUES (?, ?, ?) ON CONFLICT DO NOTHING", 
								[$new_user_id, $company_id, $auth_id]);
						}
					}
					
					// Save user document types for this company (User role only)
					if ($role == '3' && !empty($card['doc_heads']) && is_array($card['doc_heads'])) {
						foreach ($card['doc_heads'] as $type_id) {
							$this->db->query("INSERT INTO user_document_types (user_id, company_id, type_id) VALUES (?, ?, ?) ON CONFLICT DO NOTHING", 
								[$new_user_id, $company_id, $type_id]);
						}
					}
				}
			}
		}
		
		$log_query ="insert into log_table(description, action, created_time, user_id) values('New User Added Successfully','New User Added','$created_date','$login_id')";
		$log_insert = $this->db->query($log_query);

		redirect('user/users');
	}
	public function changeUserStatus() {
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		// Convert 'Active' to 0 and anything else to 1
		$new_status = ($status == '0') ? '0' : '1';

		$sql = "UPDATE users SET status='$new_status' WHERE id='$id'";
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.',
				'new_status' => $new_status
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	

	public function modifyUser($id) {	
		error_reporting(0);
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		$current_role_id = $this->session->userdata('role_id');
		$login_id = $this->session->userdata('id');
		
		$sql1 = "SELECT * FROM users WHERE id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/users');
		}
		
		$business_data = $business_data[0];
		$user_id = $business_data['id'];
		
		// Admin cannot edit Super Admin or other Admin users
		if (!is_super_admin()) {
			if ($business_data['role_id'] == '1' || $business_data['role_id'] == '2') {
				$this->session->set_flashdata('message_type', 'error');
				$this->session->set_flashdata('message_name', 'You do not have permission to edit this user.');
				redirect('user/users');
			}
			
			// Check if user belongs to Admin's companies
			$allowed_companies = get_allowed_companies();
			$user_companies = array_filter(explode(',', $business_data['user_company'] ?? ''));
			$has_access = !empty(array_intersect($user_companies, $allowed_companies));
			
			if (!$has_access) {
				$this->session->set_flashdata('message_type', 'error');
				$this->session->set_flashdata('message_name', 'You do not have permission to edit this user.');
				redirect('user/users');
			}
		}
		
		$this->session->set_userdata('menu','user');
		
		// Company list - Admin can only see their own companies
		if (is_super_admin()) {
			$company = "SELECT * FROM company WHERE status='1' ORDER BY company_name ASC";
			$company_query = $this->db->query($company);
			$company_list = $company_query->result_array();
		} else {
			$allowed_companies = get_allowed_companies();
			if (!empty($allowed_companies)) {
				$this->db->select('*')
					->from('company')
					->where('status', '1')
					->where_in('id', $allowed_companies)
					->order_by('company_name', 'ASC');
				$company_list = $this->db->get()->result_array();
			} else {
				$company_list = [];
			}
		}
		
		$sub_type = "SELECT t.*, a.authority_name FROM sub_type t LEFT JOIN authority a ON a.id::text=t.authority_id WHERE t.status='1' ORDER BY a.authority_name, t.type_name ASC";
		$sub_type_query = $this->db->query($sub_type);
		$sub_type_list = $sub_type_query->result_array();
		
		// Role list - Admin can only assign User role
		if (is_super_admin()) {
			$sql = "SELECT * FROM role WHERE status='1' ORDER BY id ASC";
		} else {
			$sql = "SELECT * FROM role WHERE status='1' AND id = '3' ORDER BY id ASC";
		}
		$query = $this->db->query($sql);
		$role_list = $query->result_array();
		
		// Load authorities for user assignment
		$authority = "SELECT * FROM authority WHERE status='1' ORDER BY authority_name ASC";
		$authority_query = $this->db->query($authority);
		$authority_list = $authority_query->result_array();
		
		// Load user permissions (global, not company-specific)
		$user_permissions = $this->Permission_model->get_user_permissions($user_id);
		
		// Load company-specific access data from normalized tables (including per-company permissions)
		$user_company_access = $this->db->query("
			SELECT 
				uc.company_id,
				uc.can_add_edit,
				uc.can_delete,
				ARRAY_AGG(DISTINCT ua.authority_id) FILTER (WHERE ua.authority_id IS NOT NULL) as authority_ids,
				ARRAY_AGG(DISTINCT udt.type_id) FILTER (WHERE udt.type_id IS NOT NULL) as doc_head_ids
			FROM user_companies uc
			LEFT JOIN user_authorities ua ON ua.user_id = uc.user_id AND ua.company_id = uc.company_id
			LEFT JOIN user_document_types udt ON udt.user_id = uc.user_id AND udt.company_id = uc.company_id
			WHERE uc.user_id = ?
			GROUP BY uc.company_id, uc.can_add_edit, uc.can_delete
			ORDER BY uc.company_id
		", [$user_id])->result_array();
		
		// Convert PostgreSQL array format to PHP arrays
		foreach ($user_company_access as &$access) {
			// PostgreSQL returns arrays as {1,2,3} format - convert to PHP array
			if (!empty($access['authority_ids'])) {
				$access['authority_ids'] = trim($access['authority_ids'], '{}');
				$access['authority_ids'] = $access['authority_ids'] ? explode(',', $access['authority_ids']) : [];
			} else {
				$access['authority_ids'] = [];
			}
			
			if (!empty($access['doc_head_ids'])) {
				$access['doc_head_ids'] = trim($access['doc_head_ids'], '{}');
				$access['doc_head_ids'] = $access['doc_head_ids'] ? explode(',', $access['doc_head_ids']) : [];
			} else {
				$access['doc_head_ids'] = [];
			}
		}
		unset($access); // Clean up reference
		
		log_message('debug', 'Edit User ID ' . $user_id . ' - Raw user data: company=' . ($business_data['user_company'] ?? 'NULL') . ', authority=' . ($business_data['user_authority'] ?? 'NULL') . ', type=' . ($business_data['user_type'] ?? 'NULL'));
		log_message('debug', 'Edit User ID ' . $user_id . ' - Normalized table data count: ' . count($user_company_access));
		
		// FALLBACK: If no data in normalized tables, construct from legacy CSV fields
		if (empty($user_company_access)) {
			log_message('debug', 'Edit User ID ' . $user_id . ' - Using FULL FALLBACK to legacy CSV fields');
			$legacy_companies = !empty($business_data['user_company']) ? explode(',', $business_data['user_company']) : [];
			$legacy_authorities = !empty($business_data['user_authority']) ? explode(',', $business_data['user_authority']) : [];
			$legacy_doc_heads = !empty($business_data['user_type']) ? explode(',', $business_data['user_type']) : [];
			
			// Create one entry per company with all authorities and doc heads
			// (Old system didn't have company-specific relationships)
			foreach ($legacy_companies as $company_id) {
				$company_id = trim($company_id);
				if (!empty($company_id)) {
					$user_company_access[] = [
						'company_id' => $company_id,
						'authority_ids' => array_map('trim', $legacy_authorities),
						'doc_head_ids' => array_map('trim', $legacy_doc_heads)
					];
				}
			}
		} else {
			// PARTIAL FALLBACK: If doc_head_ids is empty, fall back to legacy user_type field
			$legacy_doc_heads = !empty($business_data['user_type']) ? array_map('trim', explode(',', $business_data['user_type'])) : [];
			
			if (!empty($legacy_doc_heads)) {
				log_message('debug', 'Edit User ID ' . $user_id . ' - Using PARTIAL FALLBACK for doc_heads from legacy field: ' . print_r($legacy_doc_heads, true));
				foreach ($user_company_access as &$access) {
					if (empty($access['doc_head_ids'])) {
						$access['doc_head_ids'] = $legacy_doc_heads;
					}
				}
				unset($access);
			}
		}
		
		log_message('debug', 'Edit User ID ' . $user_id . ' - Final Company Access Data: ' . print_r($user_company_access, true));
		
		$this->load->view('templates/header.php');
        $this->load->view('users/edit_user', array(
			'user_data' => $business_data,
			'company_list' => $company_list,
			'sub_type_list' => $sub_type_list,
			'role_list' => $role_list,
			'authority_list' => $authority_list,
			'user_permissions' => $user_permissions,
			'current_user_role' => $current_role_id,
			'user_company_access' => $user_company_access
		));	
		$this->load->view('templates/footer.php');
	}
	public function updateUser() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - edit permission required
		require_edit_permission('user/users');
		
		$this->load->model('Permission_model');
		
		$id = $_POST['id'];
		$first_name = $this->db->escape_str($_POST['first_name']);
		$last_name = $this->db->escape_str($_POST['last_name']);
		$email_id = $this->db->escape_str($_POST['email_id']);
		$role = $_POST['role'];
		
		// New: Handle company access cards format
		$company_access = isset($_POST['company_access']) ? $_POST['company_access'] : [];
		
		// Check for duplicate email (excluding current user)
		$existing_email = $this->db->where('email_id', $email_id)->where('id !=', $id)->get('users')->row();
		if ($existing_email) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Email address already exists! Please use a different email.');
			redirect('user/modifyUser/' . $id);
			return;
		}
		
		// Get permission flags
		$can_view = true; // View is always true
		$can_add_edit = false;
		$can_delete = false;
		
		// For Admin/User roles, calculate global permissions from company permissions
		if (($role == '2' || $role == '3') && !empty($company_access)) {
			foreach ($company_access as $card) {
				// If user has permission in ANY company, set global permission to true
				if (isset($card['can_add_edit']) && $card['can_add_edit'] == '1') {
					$can_add_edit = true;
				}
				if (isset($card['can_delete']) && $card['can_delete'] == '1') {
					$can_delete = true;
				}
			}
		}
		// For Super Admin, check direct POST
		else if ($role == '1') {
			$can_add_edit = isset($_POST['can_add_edit']) ? true : false;
			$can_delete = isset($_POST['can_delete']) ? true : false;
		}
		
		// Users (role 3) can never delete
		if ($role == '3') {
			$can_delete = false;
		}
		
		// Process company access cards to legacy format (for backward compatibility)
		$company_data = '';
		$type_data = '';
		$authority_data = '';
		$all_companies = [];
		$all_authorities = [];
		$all_doc_heads = [];
		
		if (!empty($company_access)) {
			foreach ($company_access as $card) {
				if (!empty($card['company_id'])) {
					$all_companies[] = $card['company_id'];
				}
				if (!empty($card['authorities']) && is_array($card['authorities'])) {
					$all_authorities = array_merge($all_authorities, $card['authorities']);
				}
				if (!empty($card['doc_heads']) && is_array($card['doc_heads'])) {
					$all_doc_heads = array_merge($all_doc_heads, $card['doc_heads']);
				}
			}
			$company_data = implode(',', array_unique($all_companies));
			$authority_data = implode(',', array_unique($all_authorities));
			$type_data = implode(',', array_unique($all_doc_heads));
		}
		
		$sql = "update users set first_name='$first_name',last_name='$last_name', email_id='$email_id',role_id='$role',user_company='$company_data',user_type='$type_data',user_authority='$authority_data' where id='$id'";
		$query1 = $this->db->query($sql);
		
		// Save user permissions
		$this->Permission_model->save_user_permissions($id, $can_view, $can_add_edit, $can_delete);
		
		// Clear existing normalized table entries
		$this->db->where('user_id', $id)->delete('user_companies');
		$this->db->where('user_id', $id)->delete('user_authorities');
		$this->db->where('user_id', $id)->delete('user_document_types');
		
		// Save to normalized tables with company-scoped access
		if (!empty($company_access)) {
			foreach ($company_access as $card) {
				$company_id = $card['company_id'] ?? null;
				if (!$company_id) continue;
				
				// Get per-company permissions from the card
				$company_can_add_edit = isset($card['can_add_edit']) && $card['can_add_edit'] == '1' ? 'TRUE' : 'FALSE';
				$company_can_delete = isset($card['can_delete']) && $card['can_delete'] == '1' ? 'TRUE' : 'FALSE';
				
				// Save user company with per-company permissions
				$this->db->query("INSERT INTO user_companies (user_id, company_id, can_add_edit, can_delete) 
					VALUES (?, ?, $company_can_add_edit, $company_can_delete) 
					ON CONFLICT (user_id, company_id) 
					DO UPDATE SET can_add_edit = $company_can_add_edit, can_delete = $company_can_delete", 
					[$id, $company_id]);
				
				// Save user authorities for this company
				if (!empty($card['authorities']) && is_array($card['authorities'])) {
					foreach ($card['authorities'] as $auth_id) {
						$this->db->query("INSERT INTO user_authorities (user_id, company_id, authority_id) VALUES (?, ?, ?) ON CONFLICT DO NOTHING", 
							[$id, $company_id, $auth_id]);
					}
				}
				
				// Save user document types for this company (User role only)
				if ($role == '3' && !empty($card['doc_heads']) && is_array($card['doc_heads'])) {
					foreach ($card['doc_heads'] as $type_id) {
						$this->db->query("INSERT INTO user_document_types (user_id, company_id, type_id) VALUES (?, ?, ?) ON CONFLICT DO NOTHING", 
							[$id, $company_id, $type_id]);
					}
				}
			}
		}
		
		$date = date('Y-m-d h:i:s');
		$sql1="insert into log_table (description,action, created_time, user_id) values('User updated','Modify User','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Successfully Updated');

		redirect('user/users');
		
	}
	
	public function changePassword($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$users = $this->db->where('id',$id)->get('users')->result_array();
		if(empty($users)) {
			redirect('user/users');
		}
		$users=$users[0];
		$parent_id = $users['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		$this->load->view('templates/layout.php');
        $this->load->view('users/change_password',array('users'=>$users));	
		$this->load->view('templates/footer.php');
		
	}
	public function passwordChange() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		$users = $this->db->where('id',$id)->get('users')->result_array();
		if(empty($users)) {
			redirect('user/users');
		}
		$users=$users[0];
		$parent_id = $users['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		$password = md5($_POST['password']);
		$sql = "update users set password = '$password' where id='$id'";
		$this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		
		$sql1="insert into log_table (description,action, created_time, user_id) values('Password Changed Successfully','Password Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		//$this->session->set_flashdata('message_name', 'Password Successfully Changed');
		redirect('user/users');
	}
	public function deleteUser($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Permission check - delete permission required
		require_delete_permission('user/users');
		
		$sql1="select * from users where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/users');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['parent_id'];
		if($parent_id != $login_id) {
			redirect('user/users');
		}
		else {
			// Soft delete - set status to '0' instead of deleting
			$this->db->where('id', $id)->update('users', ['status' => '0']);
			$this->session->set_flashdata('message_type', 'success');
			$this->session->set_flashdata('message_name', 'User Deleted Successfully');
		}
		
		redirect('user/users');
		
	}
	
	public function userProjects($id) {
		$this->session->set_userdata('user_menu','Users');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$sql="select * from projects where user_id = '$id' ";    
		$query = $this->db->query($sql);
		$project_list = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/user_projects',array('project_list'=>$project_list,'user_id'=>$id));
		$this->load->view('templates/footer');
		
		
	}
	
	public function roles() {
		$this->session->set_userdata('user_menu','Users');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','users');

		$sql="select * from role where user_id = '$login_id' order by role_name asc ";    
		$query = $this->db->query($sql);
		$user_list = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/role',array('user_list'=>$user_list));
		$this->load->view('templates/footer');
	}
	public function addRole() {		
		$this->session->set_userdata('user_menu','Users');
		$CI = & get_instance();
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
        $this->load->view('templates/layout.php');
        $this->load->view('users/add_role');
		$this->load->view('templates/footer');
	}

	public function saveRole() {
	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$userdata = $_POST;
		$role_name = $_POST['role_name'];
		$status = '1';
		$query = "insert into role (role_name, user_id,status) values('".$role_name."','".$login_id."','".$status."')";
		$sql = $this->db->query($query);
				$this->session->set_flashdata('message_name', 'Role Created Successfully');

		redirect('user/roles');
	}
	public function editRole($id) {	
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql1="select * from role where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/roles');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		if($parent_id != $login_id) {
			redirect('user/roles');
		}
		
		$this->load->view('templates/layout.php');
        $this->load->view('users/edit_role',array('user_data'=>$business_data));	
		$this->load->view('templates/footer.php');
		
	}
	public function updateRole() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		$role_name = $_POST['role_name'];
		
		$sql = "update role set role_name='$role_name' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Role Successfully Updated');

		redirect('user/roles');
		
	}
	public function deleteRole($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql1="select * from role where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		if(empty($business_data)) {
			redirect('user/roles');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		if($parent_id != $login_id) {
			redirect('user/roles');
		}
		// Soft delete - set status to '0' instead of deleting
		$this->db->where('id', $id)->update('role', ['status' => '0']);
		$this->session->set_flashdata('message_name', 'Role Successfully Deleted');
		$this->session->set_flashdata('message_type', 'success');
		
		redirect('user/roles');
		
	}
	public function changeRoleStatus($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('user_menu','Master');
		$sql="select * from role where id='$id'";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$business_data  = $business_data[0];
		if($business_data['status']=='1') {
			$sql="update role set status='0' where id='$id'"; 
		} else {
			$sql="update role set status='1' where id='$id'"; 
		}
		$query = $this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		$login_id = $this->session->userdata('id');
		$sql1="insert into log_table (description,action, created_time, user_id) values('Role Status Changed','Status Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Status Successfully Updated');

		redirect('user/roles');
	}
	
	public function sensors()
    {   
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql="select * from picogeneral_nodes";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		//echo '<pre>';print_r($business_data);exit;
		$this->load->view('templates/layout');
		$this->load->view('sensor/sensor',array('sensor_list'=>$business_data));
		$this->load->view('templates/footer');

	}
	public function sensorDetails($sensor) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		//$sql="select * from picogeneral_data where node_id='$sensor' limit 5000";    
		$sql="select p.*,u.id as uid,u.notes as utype_id from picogeneral_data p left join unified_type u on u.id = p.type_id where node_id='$sensor' limit 100";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('users/sensor_details',array('sensor_list'=>$business_data,'sensor_id'=>$sensor));
		$this->load->view('templates/footer');
	}
	public function addSensor() {
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->load->view('templates/layout');
		$this->load->view('sensor/add_sensor');
		$this->load->view('templates/footer');
	}
	
	public function saveSensor() {
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sensor_name = $_POST['sensor'];
		
		$query = "insert into sensor(sensor, status) values('".$sensor_name."','1')";

		$insert_query = $this->db->query($query);	
		$this->session->set_flashdata('message_name', 'Sensor Added Successfully');
		
		redirect('sensor/sensors');	
	}
	public function editSensor($id) {
		
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			
			redirect('login');
		}
		$sql1="select * from sensor where id='$id'";
		$query1 = $this->db->query($sql1);
		
		$business_data = $query1->result_array();
		
		if(empty($business_data)) {
			
			redirect('sensor/sensors');
		}
		$business_data = $business_data[0];
		$parent_id = $business_data['user_id'];
		
		$this->session->set_userdata('menu','sensor');
		
		$this->load->view('templates/layout');
		$this->load->view('project/edit_sensor',array('sensor_data'=>$business_data));		
		$this->load->view('templates/footer');
	
	}
	public function updateSensor() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$id = $_POST['id'];
		
		$project_name = $_POST['project_name'];
		$project_description = $_POST['project_description'];
		$start_date = $_POST['start_date'];
		$end_date = $_POST['end_date'];
		$project_status = $_POST['status'];
		$sql = "update projects set project_name='$project_name',project_description='$project_description' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Project Details Successfully Updated');

		redirect('project/allProject');
		
	}
	
	public function deleteSensor($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$project = "delete from sensor where id='$id'";
		$query = $this->db->query($project);
		$status_data = $query->result_array();
		redirect('sensor/sensors');
		
	}
	public function changeSensorStatus($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('user_menu','Master');
		$sql="select * from sensor where id='$id'";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$business_data  = $business_data[0];
		if($business_data['status']=='1') {
			$sql="update sensor set status='0' where id='$id'"; 
		} else {
			$sql="update sensor set status='1' where id='$id'"; 
		}
		$query = $this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		$login_id = $this->session->userdata('id');
		$sql1="insert into log_table (description,action, created_time, user_id) values('Sensor Status Changed','Status Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'User Status Successfully Updated');

		redirect('sensor/sensors');
	}
	
	public function saveSensors() {
		
		$id = $_POST['id'];
		$column = $_POST['column'];
		$value = $_POST['value'];
		if($column=='interval') {
			$da = $this->db->query("update picogeneral_nodes set interval='$value' where id='$id'");
		}
		if($column=='connect_cloud') {
			$da = $this->db->query("update picogeneral_nodes set connect_cloud='$value' where id='$id'");
		}
		if($column=='pm_sampling_time') {
			$da = $this->db->query("update picogeneral_nodes set pm_sampling_time='$value' where id='$id'");
		}
		if($column=='gps_on') {
			$da = $this->db->query("update picogeneral_nodes set gps_on='$value' where id='$id'");
		}
		if($column=='cell_location') {
			$da = $this->db->query("update picogeneral_nodes set cell_location='$value' where id='$id'");
		}
		if($column=='reset_modem') {
			$da = $this->db->query("update picogeneral_nodes set reset_modem='$value' where id='$id'");
		}
		if($column=='do_sleep') {
			$da = $this->db->query("update picogeneral_nodes set do_sleep='$value' where id='$id'");
		}if($column=='battery_sleep_time') {
			$da = $this->db->query("update picogeneral_nodes set battery_sleep_time='$value' where id='$id'");
		}
	}
	
	public function ediiEmployees() {
		
		$data = $this->db->query("select * from picogeneral_nodes order by id desc")->result_array();
		$this->load->view('templates/layout');
		$this->load->view('sensor/sensor',array('projects'=>$data));
	}
	
	public function saveConfig() {
		$id = $_POST['id'];
		$status = $_POST['status'];
		$d_name = $_POST['d_name'];
		if($d_name=='connect_cloud' || $d_name=='gps_on' || $d_name=='reset_modem' || $d_name=='do_sleep' || $d_name=='remote_control' || $d_name=='ntp' || $d_name=='exact_minute' || $d_name=='erase_fs' || $d_name=='resetgps' || $d_name=='updategpsrate' || $d_name=='restorevars' || $d_name=='hard_reset' || $d_name=='sample_size' || $d_name=='tcp_log') {
			$update_query = $this->db->query("update picogeneral_nodes set $d_name='$status' where id='$id'");
		}
		echo true;
	}
	public function saveInput() {
		$id = $_POST['id'];
		$status = $_POST['value'];
		$d_name = $_POST['field'];
		if($d_name=='interval' || $d_name=='pm_sampling_time' || $d_name=='cell_location' || $d_name=='battery_sleep_time' || $d_name=='cloud_time_timeout' || $d_name=='cell_location_timeout' || $d_name=='sample_size' || $d_name=='wifi_connect' || $d_name=='alert_sms' || $d_name=='error_log_email' || $d_name=='offset_measures') {
			//echo "update picogeneral_nodes set $d_name='$status' where id='$id'";exit;
			$update_query = $this->db->query("update picogeneral_nodes set $d_name=$status where id='$id'");
		}
		 echo json_encode(['success' => true, 'message' => 'Configuration updated successfully.']);
		
	}
	public function inputColor() {
		$id = $_POST['id'];
		$field = $_POST['field'];
		$value = $_POST['value'];
		
		$select_query = $this->db->query("select * from picogeneral_nodes where id='$id'")->result_array();
		if($field=='bme_setup') {
			$old_value = $select_query[0]['bme_setup'];
		}
		if($field=='sgp_setup') {
			$old_value = $select_query[0]['sgp_setup'];
		}
		if($field=='pm_setup') {
			$old_value = $select_query[0]['pm_setup'];
		}
		if($field=='gps_setup') {
			$old_value = $select_query[0]['gps_setup'];
		}
		if($field=='fs_used') {
			$old_value = $select_query[0]['fs_used'];
		}
		if($old_value=='0') {
			$value = '1';
		} else {
			$value = '0';
		}
		if($field=='bme_setup' || $field=='sgp_setup' || $field=='pm_setup' || $field=='gps_setup' || $field=='fs_used') {
			//echo "update picogeneral_nodes set $d_name='$status' where id='$id'";exit;
			$update_query = $this->db->query("update picogeneral_nodes set $field=$value where id='$id'");
		}
		 echo 'success';
	}
	
	public function map($id) {
		$data = $this->db->query("select * from picogeneral_nodes where id='$id'")->result_array();
		$this->load->view('templates/layout');
		$this->load->view('sensor/admin_map',array('data'=>$data));
	}
	
	public function userAccess() {
		$this->load->view('templates/layout');
		$this->load->view('users/user_access');
	}
	
	/**
	 * AJAX: Get authorities enabled for selected companies
	 * For User role creation - shows only enabled authorities for selected companies
	 */
	public function getAuthoritiesByCompanies() {
		$company_ids = $this->input->post('company_ids');
		
		if (empty($company_ids) || !is_array($company_ids)) {
			echo json_encode(['success' => false, 'authorities' => []]);
			return;
		}
		
		// Updated to use company_id directly in authority (no more company_authorities bridge table)
		// Get authorities for ANY of the selected companies
		$placeholders = implode(',', array_fill(0, count($company_ids), '?'));
		$sql = "SELECT DISTINCT a.id, a.authority_name 
				FROM authority a
				WHERE a.status = '1' 
				AND a.company_id IN ({$placeholders})
				ORDER BY a.authority_name ASC";
		
		$authorities = $this->db->query($sql, $company_ids)->result_array();
		
		echo json_encode(['success' => true, 'authorities' => $authorities]);
	}
	
	/**
	 * AJAX: Get authorities for a specific company
	 * For cascading selection in user add/edit
	 * Only returns authorities that have at least one document head configured
	 */
	public function getAuthoritiesByCompany() {
		$company_id = $this->input->post('company_id');
		
		if (empty($company_id)) {
			echo json_encode(['success' => false, 'authorities' => [], 'message' => 'Company ID required']);
			return;
		}
		
		// Get authorities that have at least one document head in this company
		// Use company_id directly in sub_type (no more company_document_heads bridge table)
		// Cast authority_id to INTEGER for comparison with a.id
		$sql = "SELECT DISTINCT a.id, a.authority_name, a.alias_name
				FROM authority a
				INNER JOIN sub_type st ON CAST(st.authority_id AS INTEGER) = a.id AND st.company_id = ?
				WHERE a.company_id = ?
				AND a.status = '1'
				AND a.is_delete = '0'
				AND st.is_enabled = TRUE
				AND st.status = '1'
				ORDER BY a.authority_name ASC";
		
		$authorities = $this->db->query($sql, [$company_id, $company_id])->result_array();
		
		echo json_encode(['success' => true, 'authorities' => $authorities]);
	}
	
	/**
	 * AJAX: Get all document heads for a company (grouped by authority)
	 * For Admin/User role creation - shows all document heads for a company
	 */
	public function getDocHeadsByCompany() {
		$company_id = $this->input->post('company_id');
		
		if (empty($company_id)) {
			echo json_encode(['success' => false, 'doc_heads' => [], 'message' => 'Company ID required']);
			return;
		}
		
		// Get all document heads for this company with authority information
		$sql = "SELECT st.id, st.type_name, st.authority_id, a.authority_name
				FROM sub_type st
				LEFT JOIN authority a ON a.id::text = st.authority_id
				WHERE st.status = '1' 
				AND st.is_enabled = TRUE
				AND st.company_id = ?
				ORDER BY a.authority_name, st.type_name ASC";
		
		$doc_heads = $this->db->query($sql, [$company_id])->result_array();
		
		echo json_encode(['success' => true, 'doc_heads' => $doc_heads]);
	}
	
	/**
	 * AJAX: Get document heads by selected authorities for a specific company
	 * For User role creation - shows document heads linked to selected authorities
	 */
	public function getDocHeadsByAuthorities() {
		$authority_ids = $this->input->post('authority_ids');
		$company_id = $this->input->post('company_id');
		
		if (empty($authority_ids) || !is_array($authority_ids)) {
			echo json_encode(['success' => false, 'doc_heads' => []]);
			return;
		}
		
		if (empty($company_id)) {
			echo json_encode(['success' => false, 'doc_heads' => [], 'message' => 'Company ID required']);
			return;
		}
		
		// Get document heads for selected authorities within this company
		$auth_placeholders = implode(',', array_fill(0, count($authority_ids), '?'));
		
		$sql = "SELECT DISTINCT st.id, st.type_name, st.authority_id, a.authority_name
				FROM sub_type st
				LEFT JOIN authority a ON a.id::text = st.authority_id
				WHERE st.status = '1' 
				AND st.company_id = ?
				AND st.authority_id IN ({$auth_placeholders})
				ORDER BY a.authority_name, st.type_name ASC";
		
		$params = array_merge([$company_id], $authority_ids);
		
		$doc_heads = $this->db->query($sql, $params)->result_array();
		
		echo json_encode(['success' => true, 'doc_heads' => $doc_heads]);
	}
	
	/**
	 * AJAX: Save user company access
	 * For adding company access with authorities and document heads
	 */
	public function saveUserCompanyAccess() {
		$user_id = $this->input->post('user_id');
		$company_id = $this->input->post('company_id');
		$authority_ids = $this->input->post('authority_ids');
		$doc_head_ids = $this->input->post('doc_head_ids');
		
		if (empty($user_id) || empty($company_id)) {
			echo json_encode(['success' => false, 'message' => 'User ID and Company ID required']);
			return;
		}
		
		// Begin transaction
		$this->db->trans_start();
		
		// 1. Add to user_companies if not exists
		$exists = $this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->count_all_results('user_companies');
		
		if (!$exists) {
			$this->db->insert('user_companies', [
				'user_id' => $user_id,
				'company_id' => $company_id
			]);
		}
		
		// 2. Delete existing authorities for this user+company
		$this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->delete('user_authorities');
		
		// 3. Insert new authorities
		if (!empty($authority_ids) && is_array($authority_ids)) {
			foreach ($authority_ids as $auth_id) {
				$this->db->insert('user_authorities', [
					'user_id' => $user_id,
					'company_id' => $company_id,
					'authority_id' => $auth_id
				]);
			}
		}
		
		// 4. Delete existing document types for this user+company
		$this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->delete('user_document_types');
		
		// 5. Insert new document types
		if (!empty($doc_head_ids) && is_array($doc_head_ids)) {
			foreach ($doc_head_ids as $type_id) {
				$this->db->insert('user_document_types', [
					'user_id' => $user_id,
					'company_id' => $company_id,
					'type_id' => $type_id
				]);
			}
		}
		
		$this->db->trans_complete();
		
		if ($this->db->trans_status() === FALSE) {
			echo json_encode(['success' => false, 'message' => 'Failed to save company access']);
		} else {
			echo json_encode(['success' => true, 'message' => 'Company access saved successfully']);
		}
	}
	
	/**
	 * AJAX: Remove user company access
	 */
	public function removeUserCompanyAccess() {
		$user_id = $this->input->post('user_id');
		$company_id = $this->input->post('company_id');
		
		if (empty($user_id) || empty($company_id)) {
			echo json_encode(['success' => false, 'message' => 'User ID and Company ID required']);
			return;
		}
		
		// Begin transaction
		$this->db->trans_start();
		
		// Remove from user_companies
		$this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->delete('user_companies');
		
		// Remove authorities for this user+company
		$this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->delete('user_authorities');
		
		// Remove document types for this user+company
		$this->db->where('user_id', $user_id)
			->where('company_id', $company_id)
			->delete('user_document_types');
		
		$this->db->trans_complete();
		
		if ($this->db->trans_status() === FALSE) {
			echo json_encode(['success' => false, 'message' => 'Failed to remove company access']);
		} else {
			echo json_encode(['success' => true, 'message' => 'Company access removed successfully']);
		}
	}
	
	/**
	 * AJAX: Get user's company access details
	 */
	public function getUserCompanyAccess() {
		$user_id = $this->input->post('user_id');
		
		if (empty($user_id)) {
			echo json_encode(['success' => false, 'access' => []]);
			return;
		}
		
		// Get all companies this user has access to
		$companies = $this->db->select('uc.company_id, c.company_name')
			->from('user_companies uc')
			->join('company c', 'c.id = uc.company_id')
			->where('uc.user_id', $user_id)
			->where('c.status', '1')
			->get()
			->result_array();
		
		$access = [];
		foreach ($companies as $company) {
			$company_id = $company['company_id'];
			
			// Get authorities for this company
			$authorities = $this->db->select('ua.authority_id, a.authority_name')
				->from('user_authorities ua')
				->join('authority a', 'a.id = ua.authority_id')
				->where('ua.user_id', $user_id)
				->where('ua.company_id', $company_id)
				->get()
				->result_array();
			
			// Get document heads for this company
			$doc_heads = $this->db->select('udt.type_id, st.type_name')
				->from('user_document_types udt')
				->join('sub_type st', 'st.id = udt.type_id')
				->where('udt.user_id', $user_id)
				->where('udt.company_id', $company_id)
				->get()
				->result_array();
			
			$access[] = [
				'company_id' => $company_id,
				'company_name' => $company['company_name'],
				'authorities' => $authorities,
				'doc_heads' => $doc_heads
			];
		}
		
		echo json_encode(['success' => true, 'access' => $access]);
	}


}
