<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Role extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function index()
	{
		redirect('role/allrole');
	}
	
	public function allrole()
    {   
		$this->session->set_userdata('menu','role');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can access Role management
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied. Only Super Admin can manage user roles.');
			redirect('dashboard/dashboard');
		}
		
		$sql="select * from role order by id asc ";  
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$this->load->view('templates/header');
		$this->load->view('role/all_role',array('role_list'=>$business_data));
		//$this->load->view('templates/footer');

	}
	public function addRole() {
		$this->session->set_userdata('menu','project');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can add roles
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied. Only Super Admin can manage user roles.');
			redirect('dashboard/dashboard');
		}
		
		$this->load->view('templates/header');
		$this->load->view('role/add_role');
		//$this->load->view('templates/footer');
	}
	
	public function saveRole() {
		
		$this->session->set_userdata('menu','role');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can save roles
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied.');
			redirect('dashboard/dashboard');
		}
		
		$role_name = $_POST['role_name'];
		
		$query = "insert into role(role_name,status) values('".$role_name."','1')";
		
		$insert_query = $this->db->query($query);	
		
		$this->session->set_flashdata('message_name', 'Role Created Successfully');
		
		redirect('role');	
	}
	
	public function deleteRole($id)
	{
		$this->session->set_userdata('menu','role');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can delete roles
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied.');
			redirect('dashboard/dashboard');
		}
		
		$query = $this->db->get_where('role', ['id' => $id]);

		if ($query->num_rows() === 0) {
			redirect('role/allrole');
		} else {
			// Soft delete - set status to '0' instead of deleting
			$this->db->where('id', $id)->update('role', ['status' => '0']);
			$this->session->set_flashdata('message_name', 'Role Deleted Successfully');
			$this->session->set_flashdata('message_type', 'success');
			redirect('role/allrole');
		}
	}
	
	public function editRole($id) {
		
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can edit roles
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied.');
			redirect('dashboard/dashboard');
		}
		
		$this->session->set_userdata('menu','role');
		
		$sql = "select * from role where id='$id'";

		$type_query = $this->db->query($sql);
		$type_data = $type_query->result_array();

		if(empty($type_data)) {
			redirect('role/allrole');
		}
		
		$this->load->view('templates/header');
		$this->load->view('role/edit_role',array('role_data'=>$type_data));		
		
	}
	
	public function updateRole() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		// Only Super Admin can update roles
		if (!is_super_admin()) {
			$this->session->set_flashdata('message_type', 'error');
			$this->session->set_flashdata('message_name', 'Access denied.');
			redirect('dashboard/dashboard');
		}
		
		$this->session->set_userdata('menu','role');
		$id = $_POST['id'];
		
		$role_name = $_POST['role_name'];
		
		$sql = "update role set role_name='$role_name' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Role Details Successfully Updated');

		redirect('role/allrole');
		
	}
	
	public function changeStatus()
	{
		// Only Super Admin can change role status
		if (!is_super_admin()) {
			echo json_encode(['success' => false, 'message' => 'Access denied.']);
			return;
		}
		
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		// Convert 'Active' to 0 and anything else to 1
		$new_status = ($status == '0') ? '0' : '1';

		$sql = "UPDATE role SET status='$new_status' WHERE id='$id'";
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.',
				'new_status' => $new_status
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	
	
	
}
