<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once APPPATH.'third_party/FPDF/fpdf.php';
require_once APPPATH . 'third_party/FPDI/src/autoload.php';
use setasign\Fpdi\Fpdi;

class Company extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper(['url', 'form', 'download']);
        $this->load->library(['session', 'upload']);
        $this->load->model('Company_model');

      
        // Ensure Composer autoload is loaded
        require_once APPPATH.'third_party/FPDI/src/Fpdi.php'; // FPDI
    } 
	public function index()
	{
		redirect('company/companies');
	}
	
	public function companies()
    {   
		$this->session->set_userdata('menu','company');
		$login_id = $this->session->userdata('id');
		$role_id = $this->session->userdata('role_id');
		if($login_id=='') {
			redirect('login');
		}
		
		if ($role_id == '3') {
			$user = $this->db->select('user_company')
				->from('users')
				->where('id', $login_id)
				->get()
				->row_array();

			$company_array = explode(',', $user['user_company']);

			$this->db->select('*')
				->from('company')
				->where_in('id', $company_array)
				->order_by('id', 'ASC');
		} else {
			$this->db->select('*')
				->from('company')
				->order_by('id', 'ASC');
		}

		$query = $this->db->get();
		$business_data = $query->result_array();
		
		$sql1="select * from authority where status='1' order by id asc ";  
		
		$authority_query = $this->db->query($sql1);
		$authority_data = $authority_query->result_array();
		
		$this->load->view('templates/header');
		$this->load->view('company/all_company',array('company_list'=>$business_data,'authority_data'=>$authority_data));
		//$this->load->view('templates/footer');

	}
	public function addCompany() {
		$this->session->set_userdata('menu','company');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$sql="select * from authority where status='1' order by id asc ";  
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$frequency = PAYMENT_OPTIONS;
		$this->load->view('templates/header');
		$this->load->view('company/add_company',array('authority'=>$business_data,'frequency'=>$frequency));
		//$this->load->view('templates/footer');
	}
	public function getTypeByAuthority() {
		$this->session->set_userdata('menu','company');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$authority_id = $this->input->post('authority_id');

		$this->db->where('authority_id', $authority_id);
		$query = $this->db->get('sub_type');
		$result = $query->result_array();

		if ($result) {
			echo json_encode([
				'success' => true,
				'types' => $result // each row should have `id`, `type`
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'No types found for this authority.'
			]);
		}
	}
	public function getFrequencyByType() {
		$this->session->set_userdata('menu','company');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		 $type_id = $this->input->post('type_id');

		$this->db->where('id', $type_id);
		$query = $this->db->get('sub_type');
		$row = $query->row_array();

		if ($row) {
			echo json_encode([
				'success' => true,
				'frequency' => $row['frequency']
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Frequency not found.'
			]);
		}
	}
	/*public function getDocumentsByType() {
		$this->load->model('Company_model');
		$type_id = $this->input->post('type_id');
		$documents = $this->Company_model->getDocumentsForType($type_id); // handle CSV IDs
		if(!empty($documents)){
			echo json_encode(['success'=>true, 'documents'=>$documents]);
		} else {
			echo json_encode(['success'=>false]);
		}
	}*/
	public function getDocumentsByType() {
		error_reporting(E_ALL);
		ini_set('display_errors', 1);
		$this->load->model('Company_model');
		$type_id = $this->input->post('type_id');
		$documents = $this->Company_model->getDocumentsForType($type_id);
		if (!empty($documents)) {
			echo json_encode(['success' => true, 'documents' => $documents]);
		} else {
			echo json_encode(['success' => false]);
		}
	}

	public function submit() {
		$company_id   = $this->input->post('company_id');
		$type_ids     = $this->input->post('type_id');
		$document_ids = $this->input->post('document_id');

		$upload_path = FCPATH . 'uploads/documents/';
		if (!is_dir($upload_path)) mkdir($upload_path, 0777, true);

		foreach ($type_ids as $rowIndex => $type_id) {
			if (empty($_FILES['document_file']['name'][$rowIndex])) continue;

			foreach ($_FILES['document_file']['name'][$rowIndex] as $docIndex => $name) {
				if ($name == '') continue;

				$_FILES['file']['name']     = $_FILES['document_file']['name'][$rowIndex][$docIndex];
				$_FILES['file']['type']     = $_FILES['document_file']['type'][$rowIndex][$docIndex];
				$_FILES['file']['tmp_name'] = $_FILES['document_file']['tmp_name'][$rowIndex][$docIndex];
				$_FILES['file']['error']    = $_FILES['document_file']['error'][$rowIndex][$docIndex];
				$_FILES['file']['size']     = $_FILES['document_file']['size'][$rowIndex][$docIndex];

				$config['upload_path']   = $upload_path;
				$config['allowed_types'] = 'pdf'; // ✅ only pdf
				$config['max_size']      = 2048;  // 2MB
				$config['file_name']     = time() . '_' . $_FILES['file']['name'];

				$this->load->library('upload', $config);

				if ($this->upload->do_upload('file')) {
					$uploadData = $this->upload->data();
					$filePath = 'uploads/documents/' . $uploadData['file_name'];

					$this->db->insert('uploaded_documents', [
						'company_id'    => $company_id,
						'type_id'       => $type_id,
						'document_id'   => $document_ids[$rowIndex][$docIndex],
						'document_name' => $_FILES['file']['name'],
						'file_path'     => $filePath
					]);
				} else {
					$error = $this->upload->display_errors();
					$this->session->set_flashdata('error', $error);
					redirect('company');
				}
			}
		}

		$this->session->set_flashdata('success', 'Documents uploaded successfully!');
		redirect('company');
	}

	public function saveCompany() {
		
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		$company_name = $_POST['company_name'];
		$company_person = $_POST['company_person'];
		$company_email = $_POST['company_email'];
		$short_name = $_POST['short_name'];
		$country_code = $_POST['country_code'];
		$phone_number = $_POST['phone_number'];
		$financial_year = $_POST['financial_year'];
		$created_at = date('d-m-y');
		$query = "insert into company(company_name,contact_person,contact_email,status,created_at,fiscal_year,short_name, country_code, phone) values('".$company_name."','".$company_person."','".$company_email."','1','".$created_at."','".$financial_year."','".$short_name."','".$country_code."','".$phone_number."')";
		
		$insert_query = $this->db->query($query);	
		
		$this->session->set_flashdata('message_name', 'Company Created Successfully');
		
		redirect('company/companies');	
	}
	public function checkCompanyName()
	{
		/*$company_name = trim($this->input->post('company_name'));
		$id = $this->input->post('id'); // in case of edit mode

		$this->db->where('company_name', $company_name);

		if (!empty($id)) {
			// Exclude current record if editing
			$this->db->where('id !=', $id);
		}

		$exists = $this->db->get('company')->num_rows() > 0;

		echo $exists ? "false" : "true"; */
		$company_name = $this->input->post('company_name');
		$id           = $this->input->post('id'); // for edit mode

		// Normalize: remove spaces + lowercase
		$normalized = strtolower(str_replace(' ', '', $company_name));

		$this->db->select('id, company_name');
		$this->db->from('company');
		$query = $this->db->get();

		$exists = false;
		foreach ($query->result() as $row) {
			$db_normalized = strtolower(str_replace(' ', '', $row->company_name));
			if ($db_normalized === $normalized) {
				if (!empty($id) && $row->id == $id) {
					continue; // ignore self in edit mode
				}
				$exists = true;
				break;
			}
		}

		echo $exists ? "false" : "true"; 
		// "true" means available, "false" means duplicate
	}
	public function deleteCompany($id)
	{
		$this->session->set_userdata('menu','company');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		$query = $this->db->get_where('company', ['id' => $id]);

		if ($query->num_rows() === 0) {
			redirect('company/companies');
		} else {
			$this->db->where('id', $id)->delete('company');
			$this->session->set_flashdata('message_name', 'Company Deleted Successfully');
			$this->session->set_flashdata('message_type', 'success'); // optional: success, error, info, warning
			redirect('company/companies');
		}
	}
	
	public function editCompany($id) {
		
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','company');
		
		$sql = "select * from company where id='$id'";

		$type_query = $this->db->query($sql);
		$type_data = $type_query->result_array();
		
		if(empty($type_data)) {
			redirect('company/companies');
		}
		
		$this->load->view('templates/header');
		$this->load->view('company/edit_company',array('company_data'=>$type_data));		
		
	}
	public function updateCompany() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','type');
		$id = $_POST['id'];
		$company_name = $_POST['company_name'];
		$company_person = $_POST['company_person'];
		$company_email = $_POST['company_email'];
		$short_name = $_POST['short_name'];
		$financial_year = $_POST['financial_year'];
		$country_code = $_POST['country_code'];
		$phone_number = $_POST['phone_number'];
		$created_at = date('d-m-y');

		$query = "update company set company_name='$company_name', contact_person='$company_person', contact_email='$company_email', short_name='$short_name', country_code='$country_code', phone='$phone_number',fiscal_year='$financial_year' where id='$id'";
		$insert_query = $this->db->query($query);	
		
		$this->session->set_flashdata('message_name', 'Company updated Successfully');
		
		redirect('company/companies');	
		
	}
	
	/*public function uploadDocuments($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','company');
		$sql="select * from company where status='1' order by id asc ";  
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$sql1="select * from authority where status='1' order by id asc ";  
		
		$authority_query = $this->db->query($sql1);
		$authority_data = $authority_query->result_array();
		
		$this->load->view('templates/layout');
		$this->load->view('company/upload_documents',array('company_list'=>$business_data,'authority_data'=>$authority_data));
	}*/
	
	public function allDocument($company_id, $type_id)
	{
		// Include FPDF & FPDI (only if not already included elsewhere)
		if (!class_exists('FPDF')) {
			require_once APPPATH . 'third_party/FPDF/fpdf.php';
		}
		if (!class_exists('\setasign\Fpdi\Fpdi')) {
			require_once APPPATH . 'third_party/FPDI/src/autoload.php';
		}
		
		$c_id = $this->db
			->select('company_id')
			->from('uploaded_documents')
			->where('id', $company_id)
			->get()
			->result_array();
		
		$c__id = $c_id[0]['company_id'];

		// Fetch uploaded rows for the company and type (only rows with a file_name)
		$rows = $this->db
			->select('file_path, file_name')
			->from('uploaded_documents')
			->where('company_id', (int)$c__id)
			->where('type_id', (int)$type_id)
			->where('file_name IS NOT NULL', null, false)
			->get()
			->result_array();
		if (empty($rows)) {
			show_error("No uploaded documents found for this company and type.");
			return;
		}

		// Build absolute paths, keep only existing files, remove duplicates
		$paths = [];
		foreach ($rows as $r) {
			// normalize and protect against leading slashes
			$relative = ltrim($r['file_path'], '/\\');
			$full = FCPATH . $relative;

			if (file_exists($full) && is_readable($full)) {
				$paths[] = $full;
			} else {
				log_message('error', "allDocument: file missing or unreadable: {$full}");
			}
		}

		$paths = array_values(array_unique($paths));

		if (empty($paths)) {
			show_error("No physical files found on server for the selected documents.");
			return;
		}

		// Instantiate FPDI
		$pdf = new \setasign\Fpdi\Fpdi();

		// Merge files (skip encrypted/invalid ones)
		foreach ($paths as $file) {
			try {
				$pageCount = $pdf->setSourceFile($file);
			} catch (\setasign\Fpdi\PdfParser\CrossReference\CrossReferenceException $e) {
				// encrypted or malformed PDF — skip it
				log_message('error', "allDocument: encrypted/invalid PDF skipped: {$file} — " . $e->getMessage());
				continue;
			} catch (\Exception $e) {
				log_message('error', "allDocument: could not read PDF {$file} — " . $e->getMessage());
				continue;
			}

			for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
				$templateId = $pdf->importPage($pageNo);
				$size = $pdf->getTemplateSize($templateId);
				$pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
				$pdf->useTemplate($templateId);
			}
		}

		// Final filename
		$outName = "Company_{$company_id}_Type_{$type_id}.pdf";

		// Clear any output buffering that might corrupt PDF
		if (ob_get_length()) {
			@ob_end_clean();
		}

		// Force download
		$pdf->Output($outName, 'D');
	}

	public function uploadDocuments() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','company');
		$sql="select * from company where status='1' order by id asc ";  
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$sql1="select * from authority where status='1' order by id asc ";  
		
		$authority_query = $this->db->query($sql1);
		$authority_data = $authority_query->result_array();
		
		$this->load->view('templates/layout');
		$this->load->view('company/upload_documents',array('company_list'=>$business_data,'authority_data'=>$authority_data));
	}
	public function viewDocuments($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->load->model('Company_model');
		$this->session->set_userdata('menu','company');
		$sql="select * from company where status='1' and id='$id' order by id asc ";  
		$company_query = $this->db->query($sql);
		$business_data = $company_query->result_array();
		$data['type_list'] = $this->Company_model->get_all_types();
		
		$sql="select * from authority where status='1' order by id asc ";  
		$query = $this->db->query($sql);
		$authority_data = $query->result_array();
		
		$type_sql="select * from sub_type where status='1' order by type_name asc ";  
		$type_query = $this->db->query($type_sql);
		$type_data = $type_query->result_array();
		//$data['company_files'] = $this->Company_model->get_all_files();
		
		$authority = $this->input->post('authority');
		$month = $this->input->post('monthly');
		$year = $this->input->post('year');
		if($year=='') {
			$year = date('Y');
		}
		// Fetch filtered data from DB
		$data['type_data'] = $this->Company_model->getFilteredDocuments($id, $authority, $month, $year);
		$this->load->view('templates/header');
		$this->load->view('company/view_documents',array('company_list'=>$business_data,'data'=>$data,'type_data'=>$type_data,'authority_data'=>$authority_data,'type_data'=>$data['type_data']));
	}
	public function filter()
	{
		error_reporting(1);
		$this->load->model('Company_model');
		$authority = $this->input->post('authority');
		$month = $this->input->post('monthly');
		$year = $this->input->post('year');
		$company_id = $this->input->post('company_id');

		// Fetch filtered data from DB
		$data['type_data'] = $this->Company_model->getFilteredDocuments($company_id, $authority, $month, $year);
			// Load only partial view
		if (empty($data['type_data'])) {
			echo "<p class='text-center text-warning'>No record found</p>";
		} else {
			$this->load->view('company/_documents_table', $data);
		}
	}
	public function addDocument() {
		$doc_id = $this->input->post('doc_id');

		// Windows safe path
		$upload_path = FCPATH . 'uploads' . DIRECTORY_SEPARATOR . 'documents' . DIRECTORY_SEPARATOR;

		// Ensure folder exists
		if (!is_dir($upload_path)) {
			mkdir($upload_path, 0777, true);
		}

		//$config['upload_path']   = $upload_path;
		$config['upload_path'] = 'C:/xampp/htdocs/dms_new/uploads/documents/';
		$config['allowed_types'] = 'pdf';
		$config['max_size']      = 3048;
		$config['overwrite']     = TRUE;
		
		//$this->load->library('upload', $config);
		$this->load->library('upload');
		$this->upload->initialize($config);

		if ($this->upload->do_upload('file')) {
			$uploadData = $this->upload->data();

			$data = [
				'document_name' => $uploadData['file_name'],
				'file_path' => $uploadData['file_name'],
				'uploaded_at'   => date('Y-m-d H:i:s')
			];

			$this->db->where('id', $doc_id);
			$this->db->update('uploaded_documents', $data);
			
			echo json_encode([
				"status" => "success",
				"message" => "File uploaded successfully!"
			]);
		} else {
			echo json_encode([
				"status" => "error",
				"message" => strip_tags($this->upload->display_errors())
			]);
		}
	}
	public function getDocument(){
		$doc_id = $this->input->post('doc_id', true);

		//$doc = $this->db->get_where('uploaded_documents', ['id' => $doc_id])->row_array();
		$this->db->select('ud.*, st.id as docu_id , st.document_name');
		$this->db->from('uploaded_documents ud');
		$this->db->join('documents st', 'ud.document_id = st.id', 'left');
		$this->db->where('ud.id', $doc_id);
		$doc = $this->db->get()->row_array();
		if($doc){
			echo json_encode([
				'status' => 'success',
				'data' => $doc
			]);
		} else {
			echo json_encode([
				'status' => 'error',
				'message' => 'Document not found.'
			]);
		}
	}
	public function updateDocument() {
		$doc_id = $this->input->post('doc_id', true); // this should be uploaded_documents.id
		$document_name = $this->input->post('document_name', true);

		$data = ['document_name' => $document_name];

		// Handle file upload if new file provided
		if(!empty($_FILES['file']['name'])){
			$config['upload_path']   = FCPATH . 'uploads/documents/';
			$config['allowed_types'] = 'pdf';
			$config['max_size']      = 3048;
			$config['overwrite']     = TRUE;

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload('file')){
				$uploadData = $this->upload->data();
				$data['file_name']   = $uploadData['file_name'];
				$data['file_path']   = 'uploads/documents/' . $uploadData['file_name'];
				$data['uploaded_at'] = date('Y-m-d H:i:s');
				$data['document_month'] = date('m');
				$data['document_year']  = date('Y');
			} else {
				echo json_encode([
					'status'=>'error',
					'message'=>strip_tags($this->upload->display_errors())
				]);
				return;
			}
		}

		// Update row
		$this->db->where('id', $doc_id);
		$this->db->update('uploaded_documents', $data);
		

		// Fetch updated row
		$doc = $this->db->get_where('uploaded_documents', ['id'=>$doc_id])->row_array();

		if ($doc) {
			echo json_encode([
				'status'=>'success',
				'message'=>'Document updated successfully!',
				'data'=>$doc
			]);
		} else {
			echo json_encode([
				'status'=>'error',
				'message'=>'Document not found',
				'data'=>null
			]);
		}
	}
	public function downloadDocument($doc_id){
		$doc = $this->db->get_where('uploaded_documents', ['id' => $doc_id])->row_array();
		if(empty($doc)) {
			redirect('company/companies');
		}
		if(empty($doc['file_name'])){
			show_404();
		}

		$file_path = FCPATH . 'uploads/documents/' . $doc['file_name'];
		if(file_exists($file_path)){
			// Force download
			$this->load->helper('download');
			force_download($file_path, NULL);
		} else {
			show_404();
		}
	}
	
	
	public function fullDownload($company_id, $type_id)
	{
		// 🔹 Fetch uploaded documents from DB
		$files = $this->db->select('file_path')
			->from('uploaded_documents')
			->where('company_id', $company_id)
			->where('type_id', $type_id)
			->where('file_name IS NOT NULL', null, false) // only uploaded files
			->get()
			->result_array();

		if (empty($files)) {
			show_error("No documents found for this company and type.");
			return;
		}

		// Initialize FPDI
		$pdf = new Fpdi();

		foreach ($files as $row) {
			$file = FCPATH . $row['file_path']; // assumes file_path is relative
			if (file_exists($file)) {
				$pageCount = $pdf->setSourceFile($file);

				// Import all pages of the file
				for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
					$templateId = $pdf->importPage($pageNo);
					$size = $pdf->getTemplateSize($templateId);

					$pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
					$pdf->useTemplate($templateId);
				}
			}
		}

		// Force download merged file
		$pdf->Output("Company_{$company_id}_Type_{$type_id}.pdf", 'D');
	}
	/*public function submit()
	{
		echo '<pre>'; print_R($_POST);echo '</pre>';
		$company_id    = $this->input->post('company_id');
		$type_ids      = $this->input->post('type_id');
		$document_ids  = $this->input->post('document_id');
		$mandatory     = $this->input->post('mandatory'); // from mandatory_documents table
		 if (empty($type_ids) || count($type_ids) == 0) {
			$this->session->set_flashdata('error', 'Please select at least one type.');
			redirect('type');
			return;
		}
		$upload_path = FCPATH . 'uploads/documents/';
		
		if (!is_dir($upload_path)) {
			mkdir($upload_path, 0777, true);
		}

		foreach ($type_ids as $rowIndex => $type_id) {
			$docGroupIndex = $rowIndex + 1;
				if (!isset($document_ids[$docGroupIndex])) {
					continue;
				}
			foreach ($document_ids[$docGroupIndex] as $docIndex => $document_id) {
				
				$uploaded = false;
				$filePath = null;
				$originalFileName = null;

				// check if file uploaded
				if (isset($_FILES['document_file']['name'][$docGroupIndex][$docIndex]) &&
					$_FILES['document_file']['name'][$docGroupIndex][$docIndex] != '') {

					// Prepare file data
					$_FILES['file']['name']     = $_FILES['document_file']['name'][$docGroupIndex][$docIndex];
					$_FILES['file']['type']     = $_FILES['document_file']['type'][$docGroupIndex][$docIndex];
					$_FILES['file']['tmp_name'] = $_FILES['document_file']['tmp_name'][$docGroupIndex][$docIndex];
					$_FILES['file']['error']    = $_FILES['document_file']['error'][$docGroupIndex][$docIndex];
					$_FILES['file']['size']     = $_FILES['document_file']['size'][$docGroupIndex][$docIndex];

					// Upload config
					$config['upload_path']   = $upload_path;
					$config['allowed_types'] = 'pdf';
					$config['max_size']      = 2048; // 2MB
					$config['file_name']     = time() . '_' . preg_replace('/[^A-Za-z0-9_\-\.]/', '_', $_FILES['file']['name']);

					$this->load->library('upload');
					$this->upload->initialize($config);

					if ($this->upload->do_upload('file')) {
						$uploadData       = $this->upload->data();
						$fileName         = $uploadData['file_name'];
						$filePath         = 'uploads/documents/' . $fileName;
						$originalFileName = $fileName;
						$uploaded         = true;
					} else {
						$error = $this->upload->display_errors();
						log_message('error', 'File upload error: ' . $error);
					}
				}

				// ✅ Always insert a row — uploaded or not
				$data = [
					'company_id'     => $company_id,
					'type_id'        => $type_id,
					'document_id'    => $document_id,
					'document_name'  => $originalFileName,
					'file_path'      => $filePath,
					'document_month' => date('m'),
					'document_year'  => date('Y'),
					'uploaded_at'=>date('Y-m-d h:i:s')
				];
				$this->db->insert('uploaded_documents', $data);
			}
			
		}

		redirect('company/uploadDocuments');
	}*/
		
	
	public function changeProjectStatus($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('user_menu','Master');
		$sql="select * from projects where id='$id'";    
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$business_data  = $business_data[0];
		
		if($business_data['status']=='1') {
			$sql="update projects set status='0' where id='$id'"; 
		} else {
			$sql="update projects set status='1' where id='$id'"; 
		}
		$query = $this->db->query($sql);
		$date = date('Y-m-d h:i:s');
		$login_id = $this->session->userdata('id');
		$sql1="insert into log_table (description,action, created_time, user_id) values('Project Status Changed','Status Changed','".$date."','".$login_id."')";
		$query1 = $this->db->query($sql1);
		$this->session->set_flashdata('message_name', 'Project Status Successfully Updated');

		redirect('project/myProjects');
	}
	
	public function sendDocumentEmail(){
		$doc_id = $this->input->post('doc_id', true);
		$recipient = $this->input->post('recipient_email', true);

		$doc = $this->db->get_where('uploaded_documents', ['id'=>$doc_id])->row_array();
		if(empty($doc['file_path'])){
			echo json_encode(['status'=>'error','message'=>'Document not found']);
			return;
		}

		$file_path = FCPATH . 'uploads/documents/' . $doc['file_path'];
		if(!file_exists($file_path)){
			echo json_encode(['status'=>'error','message'=>'File not found on server']);
			return;
		}

		$this->load->library('email');

		$this->email->from('rajeshjoshi@eighttechprojects.com','Rajesh Joshi');
		$this->email->to($recipient);
		$this->email->subject('Document: ' . $doc['document_name']);
		$this->email->message('Please find the attached document.');

		$this->email->attach($file_path);

		if($this->email->send()){
			echo json_encode(['status'=>'success','message'=>'Email sent successfully!']);
		} else {
			echo json_encode(['status'=>'error','message'=>'Failed to send email.']);
		}
	}
	
	public function changeStatus()
	{
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		// Convert 'Active' to 0 and anything else to 1
		$new_status = ($status == '0') ? '0' : '1';

		$sql = "UPDATE company SET status='$new_status' WHERE id='$id'"; 
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.',
				'new_status' => $new_status
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	
	public function deleteDocument(){
		$doc_id = $this->input->post('id', true);
		
		// Get file path if you want to remove the file from uploads
		$doc = $this->db->get_where('uploaded_documents', ['id' => $doc_id])->row_array();
		if(!$doc){
			echo json_encode(['status'=>'error','message'=>'Document not found']);
			return;
		}

		// Delete file from server
		if(!empty($doc['file_name'])){
			$file_path = FCPATH . 'uploads/documents/' . $doc['file_name'];
			if(file_exists($file_path)){
				unlink($file_path);
			}
		}
		$data['file_name'] = '';
		$data['file_path'] = '';
		$data['document_month'] = '';
		$data['document_year'] = '';
		// Delete DB record
		$this->db->where('id', $doc_id);
		$this->db->update('uploaded_documents', $data);
		$doc = $this->db->get_where('uploaded_documents', ['id'=>$doc_id])->row_array();
		
		echo json_encode(['status'=>'success','message'=>'Document deleted successfully!']);
	}

	public function reminderSent(){
		//exit('in ReminderSent function');
	}

	public function send_due_reminders()
    {
		//$this->load->model('Company_model');
        //$this->Company_model->send_reminders();
		$this->load->model('Company_Model');
			$reminder_data = $this->Company_model->getReminders();

			foreach ($reminder_data as $row) {
				//echo $row['document_name'];
				//echo "</br>";
				switch ($row['reminder_type']) {
					case 'today':
						//echo 'today'.$row['document_name'];
						$pending_docs = $this->Company_model->getUnuploadedDocuments($row['document_name']);
						// Send "Due Today" email
						break;
					case '1_day':
						//echo 'one day'.$row['document_name'];
						$pending_docs = $this->Company_model->getUnuploadedDocuments($row['document_name']);
						// Send "Due Tomorrow" email
						break;
					case '5_days':
						//echo 'five days'.$row['document_name'];
						$pending_docs = $this->Company_model->getUnuploadedDocuments($row['document_name']);
						// Send "Due in 5 Days" email
						break;
					case '10_days':
						//echo 'Ten days'.$row['document_name'];
						$pending_docs= $this->Company_model->getUnuploadedDocuments($row['document_name']);
						// Send "Due in 10 Days" email
						break;
				}
				/*echo '<pre>';
				print_r($row['reminder_type']);
				echo '<pre>';
				print_r($pending_docs);*/

				if (!empty($row['reminder_type']) && $row['reminder_type'] == '10_days'){
					echo 'Mail sent for 10 days';
				}
				if (!empty($row['reminder_type']) && $row['reminder_type'] == '5_days'){
					echo 'Mail sent for 5 days';
				}
				if (!empty($row['reminder_type']) && $row['reminder_type'] == '1_day'){
					echo 'Mail sent for 1 days';
				}
				if (!empty($row['reminder_type']) && $row['reminder_type'] == 'today'){
					echo 'Mail sent for todays';
				}
			}
			

			/*echo '<pre>';
			print_r($pending_docs_one_days);

			echo '<pre>';
			print_r($pending_docs_five_days);

			echo '<pre>';
			print_r($pending_docs_ten_days);*/

			exit;
		    // Get the day of month for today
			$today = (int) date('j');  // 1 to 31

			// Build raw SQL (or use Query Builder with where clause strings)
			$sql = "
				SELECT *
				FROM sub_type
				WHERE frequency = 'Monthly' AND status = '1'
				AND (
					frequency_start_date::int = {$today}
					OR frequency_start_date::int = (
						CASE
							WHEN {$today} < 31 THEN {$today} + 1
							ELSE 1
						END
					)
					OR (
						{$today} <= 26
						AND frequency_start_date::int BETWEEN {$today} AND ({$today} + 5)
					)
					OR (
						{$today} > 26
						AND (
							frequency_start_date::int BETWEEN {$today} AND 31
							OR frequency_start_date::int BETWEEN 1 AND (({$today} + 5) - 31)
						)
					)
					OR (
						{$today} <= 21
						AND frequency_start_date::int BETWEEN {$today} AND ({$today} + 10)
					)
					OR (
						{$today} > 21
						AND (
							frequency_start_date::int BETWEEN {$today} AND 31
							OR frequency_start_date::int BETWEEN 1 AND (({$today} + 10) - 31)
						)
					)
				);
			";

			$query = $this->db->query($sql);

			echo '<pre>';
			print_r($query->result_array());
			exit;
			





		//================================================================

		$today = date('j'); // Current day of the month (1–31)
		$plus1 = ($today + 1) > 31 ? ($today + 1) - 31 : $today + 1;
		$plus3 = ($today + 3) > 31 ? ($today + 3) - 31 : $today + 3;
		$plus10 = ($today + 10) > 31 ? ($today + 10) - 31 : $today + 10;

		$days_to_match = [$today, $plus1, $plus3, $plus10];

		echo '<pre>';
		print_r($days_to_match);
		
		/*$this->db->select('*');
		$this->db->from('sub_type');
		$this->db->where('frequency', 'Monthly');
		$this->db->where('status', '1');
		$this->db->where_in('CAST(frequency_start_date AS INTEGER)', $days_to_match);
		$query = $this->db->get();
		$result = $query->result_array();

		echo '<pre>';
		print_r($result);exit;*/

		if($today){
			echo 'Today is '.date('j');

			$this->db->select('*');
			$this->db->from('sub_type');
			$this->db->where('frequency', 'Monthly');
			$this->db->where('status', '1');
			$this->db->where_in('CAST(frequency_start_date AS INTEGER)', $today);
			$query = $this->db->get();
			$result = $query->result_array();

			echo '<pre>';
			print_r($result);
			if (!empty($result)){
				echo 'Main sent';
			}
			else{
				echo 'No any document pending for today';
			}

			//SQL for same day reminder
		/*
		SELECT *
FROM sub_type
WHERE frequency = 'Monthly'
  AND status = '1'
  AND frequency_start_date::int = EXTRACT(DAY FROM CURRENT_DATE)::int;*/
		}
		elseif ($plus1 == '13') {
			echo 'Next day';

			//SQL for 1 days reminder
		/*
		SELECT *
FROM sub_type
WHERE frequency = 'Monthly'
  AND status = '1'
  AND (
    (
      EXTRACT(DAY FROM CURRENT_DATE) <= 30
      AND frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND (EXTRACT(DAY FROM CURRENT_DATE)::int + 1)
    )
    OR (
      EXTRACT(DAY FROM CURRENT_DATE) > 30
      AND (
        frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND 31
        OR frequency_start_date::int BETWEEN 1 AND ((EXTRACT(DAY FROM CURRENT_DATE)::int + 1) - 31)
      )
    )
  );
*/
		}
		elseif ($plus3){
			echo 'Three days';
//SQL for 3 days reminder

		/*
		SELECT *
FROM sub_type
WHERE frequency = 'Monthly'
  AND status = '1'
  AND (
    (
      EXTRACT(DAY FROM CURRENT_DATE) <= 28
      AND frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND (EXTRACT(DAY FROM CURRENT_DATE)::int + 3)
    )
    OR (
      EXTRACT(DAY FROM CURRENT_DATE) > 28
      AND (
        frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND 31
        OR frequency_start_date::int BETWEEN 1 AND ((EXTRACT(DAY FROM CURRENT_DATE)::int + 3) - 31)
      )
    )
  );
*/

		}
		elseif ($plus10){
			echo 'Ten days';
			//SQL for 10 days reminder
			/*SELECT *
				FROM sub_type
				WHERE frequency = 'Monthly'
				AND status = '1'
				AND (
					(
					EXTRACT(DAY FROM CURRENT_DATE) <= 21
					AND frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND (EXTRACT(DAY FROM CURRENT_DATE)::int + 10)
					)
					OR (
					EXTRACT(DAY FROM CURRENT_DATE) > 21
					AND (
						frequency_start_date::int BETWEEN EXTRACT(DAY FROM CURRENT_DATE)::int AND 31
						OR frequency_start_date::int BETWEEN 1 AND ((EXTRACT(DAY FROM CURRENT_DATE)::int + 10) - 31)
					)
					)
				);
				*/
		}
		else {
			echo 'No Any remider for today';
		}
exit;
		
        $this->load->model('Company_model');
        $this->Company_model->send_reminders();
		echo "Reminder email(s) sent.";
    }
}
