--
-- PostgreSQL database dump
--

\restrict 0R9flTTITJohj3odjNgohFMBngxtoZcqSripWFYxNH0bDnMCHY0SR96YeDoxDYE

-- Dumped from database version 18.1
-- Dumped by pg_dump version 18.1

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: authority; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.authority (
    id integer NOT NULL,
    authority_name character varying(255),
    status character varying(1),
    alias_name character varying(50),
    is_delete character varying(10),
    created_date date
);


ALTER TABLE public.authority OWNER TO postgres;

--
-- Name: authority_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.authority_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.authority_id_seq OWNER TO postgres;

--
-- Name: authority_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.authority_id_seq OWNED BY public.authority.id;


--
-- Name: child_document_mandatory; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.child_document_mandatory (
    id integer NOT NULL,
    parent_document_id integer NOT NULL,
    child_document_id integer NOT NULL,
    is_mandatory integer DEFAULT 0,
    company_id integer NOT NULL,
    type_id integer NOT NULL,
    document_month character varying(2) NOT NULL,
    document_year character varying(4) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.child_document_mandatory OWNER TO postgres;

--
-- Name: child_document_mandatory_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.child_document_mandatory ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.child_document_mandatory_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: company; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.company (
    id integer NOT NULL,
    company_name character varying(100),
    contact_person character varying(100),
    contact_email character varying(60),
    status character varying(1),
    created_at character varying(25),
    fiscal_year character varying(15),
    short_name character varying(50),
    country_code character varying(15),
    phone character varying(15),
    co_start_date date
);


ALTER TABLE public.company OWNER TO postgres;

--
-- Name: company_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.company_files (
    id integer NOT NULL,
    company_id character varying(10),
    authority_id character varying(10),
    type_id character varying(10),
    date character varying(20),
    file_name character varying(100),
    created_at character varying(20)
);


ALTER TABLE public.company_files OWNER TO postgres;

--
-- Name: company_files_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.company_files_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.company_files_id_seq OWNER TO postgres;

--
-- Name: company_files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.company_files_id_seq OWNED BY public.company_files.id;


--
-- Name: company_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.company_id_seq OWNER TO postgres;

--
-- Name: company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.company_id_seq OWNED BY public.company.id;


--
-- Name: document_groups; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.document_groups (
    id integer NOT NULL,
    document_id character varying(11),
    grouped_doc_id character varying(100) DEFAULT NULL::character varying
);


ALTER TABLE public.document_groups OWNER TO postgres;

--
-- Name: document_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.document_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.document_groups_id_seq OWNER TO postgres;

--
-- Name: document_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.document_groups_id_seq OWNED BY public.document_groups.id;


--
-- Name: documents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.documents (
    id integer NOT NULL,
    document_name character varying(255),
    status character varying(1)
);


ALTER TABLE public.documents OWNER TO postgres;

--
-- Name: documents_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.documents_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_id_seq OWNER TO postgres;

--
-- Name: documents_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.documents_id_seq OWNED BY public.documents.id;


--
-- Name: email_templates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.email_templates (
    id integer NOT NULL,
    template_name character varying(255),
    template_description text,
    status character varying(10)
);


ALTER TABLE public.email_templates OWNER TO postgres;

--
-- Name: email_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.email_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.email_templates_id_seq OWNER TO postgres;

--
-- Name: email_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.email_templates_id_seq OWNED BY public.email_templates.id;


--
-- Name: favourites; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.favourites (
    id integer NOT NULL,
    upload_id integer NOT NULL,
    user_id character varying(50) NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.favourites OWNER TO postgres;

--
-- Name: favourites_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.favourites_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.favourites_id_seq OWNER TO postgres;

--
-- Name: favourites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.favourites_id_seq OWNED BY public.favourites.id;


--
-- Name: holidays; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.holidays (
    id integer NOT NULL,
    holiday_date date NOT NULL,
    holiday_name character varying(255) NOT NULL,
    holiday_year integer NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    is_deleted integer DEFAULT 0
);


ALTER TABLE public.holidays OWNER TO postgres;

--
-- Name: holidays_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.holidays_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.holidays_id_seq OWNER TO postgres;

--
-- Name: holidays_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.holidays_id_seq OWNED BY public.holidays.id;


--
-- Name: log_table; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.log_table (
    id integer NOT NULL,
    description text,
    action character varying(255),
    created_time character varying(20),
    user_id character varying(10)
);


ALTER TABLE public.log_table OWNER TO postgres;

--
-- Name: log_table_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.log_table_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.log_table_id_seq OWNER TO postgres;

--
-- Name: log_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.log_table_id_seq OWNED BY public.log_table.id;


--
-- Name: mandatory_documents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mandatory_documents (
    id integer NOT NULL,
    type_id integer NOT NULL,
    document_id integer NOT NULL,
    mandatory character varying(5) DEFAULT false
);


ALTER TABLE public.mandatory_documents OWNER TO postgres;

--
-- Name: mandatory_documentsa; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mandatory_documentsa (
    id integer NOT NULL,
    type_id character varying(255),
    document_id character varying(255),
    mandatory character varying(255)
);


ALTER TABLE public.mandatory_documentsa OWNER TO postgres;

--
-- Name: mandatory_documents_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mandatory_documents_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mandatory_documents_id_seq OWNER TO postgres;

--
-- Name: mandatory_documents_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mandatory_documents_id_seq OWNED BY public.mandatory_documentsa.id;


--
-- Name: mandatory_documents_id_seq1; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mandatory_documents_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mandatory_documents_id_seq1 OWNER TO postgres;

--
-- Name: mandatory_documents_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mandatory_documents_id_seq1 OWNED BY public.mandatory_documents.id;


--
-- Name: role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role (
    id integer NOT NULL,
    role_name character varying(50),
    status character(1)
);


ALTER TABLE public.role OWNER TO postgres;

--
-- Name: role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.role_id_seq OWNER TO postgres;

--
-- Name: role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.role_id_seq OWNED BY public.role.id;


--
-- Name: smtp_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.smtp_details (
    id integer NOT NULL,
    smtp_host character varying(255),
    smtp_port character varying(255),
    smtp_user character varying(255),
    smtp_pass character varying(255),
    smtp_crypto character varying(255)
);


ALTER TABLE public.smtp_details OWNER TO postgres;

--
-- Name: smtp_details_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.smtp_details_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.smtp_details_id_seq OWNER TO postgres;

--
-- Name: smtp_details_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.smtp_details_id_seq OWNED BY public.smtp_details.id;


--
-- Name: sub_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sub_type (
    id integer NOT NULL,
    type_name text,
    authority_id character varying(10) NOT NULL,
    status character(1),
    frequency character varying(15),
    doc_type character varying(50),
    frequency_start_date character varying(50),
    document_expiry_date character varying(50),
    document_name text,
    alias_name text,
    document_month character varying(10),
    document_year character varying(10),
    created_by character varying(25),
    due_in_same_next_month integer DEFAULT 0 NOT NULL,
    document_start_date date
);


ALTER TABLE public.sub_type OWNER TO postgres;

--
-- Name: sub_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sub_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sub_type_id_seq OWNER TO postgres;

--
-- Name: sub_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sub_type_id_seq OWNED BY public.sub_type.id;


--
-- Name: sub_type_reminders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sub_type_reminders (
    id integer NOT NULL,
    sub_type_id integer NOT NULL,
    reminder_no integer NOT NULL,
    days_before integer NOT NULL,
    reminder_to_user boolean DEFAULT false,
    reminder_to_admin boolean DEFAULT false,
    reminder_to_super_admin boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT now(),
    CONSTRAINT sub_type_reminders_reminder_no_check CHECK (((reminder_no >= 1) AND (reminder_no <= 5)))
);


ALTER TABLE public.sub_type_reminders OWNER TO postgres;

--
-- Name: sub_type_reminders_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sub_type_reminders_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sub_type_reminders_id_seq OWNER TO postgres;

--
-- Name: sub_type_reminders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sub_type_reminders_id_seq OWNED BY public.sub_type_reminders.id;


--
-- Name: uploaded_documents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.uploaded_documents (
    id integer NOT NULL,
    company_id integer NOT NULL,
    type_id integer NOT NULL,
    document_id integer NOT NULL,
    document_name character varying(255),
    file_name character varying(255),
    file_path character varying(500),
    uploaded_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    document_month character varying(10),
    document_year character varying(4),
    user_id character varying(5),
    is_deleted integer DEFAULT 0 NOT NULL,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    deleted_at timestamp without time zone
);


ALTER TABLE public.uploaded_documents OWNER TO postgres;

--
-- Name: uploaded_documentsa; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.uploaded_documentsa (
    id integer NOT NULL,
    company_id integer,
    type_id integer,
    document_id integer,
    document_name character varying(255),
    file_path character varying(255),
    uploaded_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    document_month character varying(10),
    document_year character varying(4),
    file_name character varying(255)
);


ALTER TABLE public.uploaded_documentsa OWNER TO postgres;

--
-- Name: uploaded_documents_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.uploaded_documents_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uploaded_documents_id_seq OWNER TO postgres;

--
-- Name: uploaded_documents_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.uploaded_documents_id_seq OWNED BY public.uploaded_documentsa.id;


--
-- Name: uploaded_documents_id_seq1; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.uploaded_documents_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uploaded_documents_id_seq1 OWNER TO postgres;

--
-- Name: uploaded_documents_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.uploaded_documents_id_seq1 OWNED BY public.uploaded_documents.id;


--
-- Name: user_priviledges; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_priviledges (
    p_id integer NOT NULL,
    role_id character varying(255),
    view character varying(255),
    edit character varying(255)
);


ALTER TABLE public.user_priviledges OWNER TO postgres;

--
-- Name: user_priviledges_p_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_priviledges_p_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.user_priviledges_p_id_seq OWNER TO postgres;

--
-- Name: user_priviledges_p_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_priviledges_p_id_seq OWNED BY public.user_priviledges.p_id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    id integer NOT NULL,
    first_name character varying(50),
    last_name character varying(50),
    email_id character varying(100),
    mobile_number character varying(20),
    status character(1),
    role_id character varying(3),
    password character varying(50),
    user_company character varying(255),
    user_type character varying(255),
    parent_id character varying(5)
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.users_id_seq OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: authority id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.authority ALTER COLUMN id SET DEFAULT nextval('public.authority_id_seq'::regclass);


--
-- Name: company id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company ALTER COLUMN id SET DEFAULT nextval('public.company_id_seq'::regclass);


--
-- Name: company_files id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company_files ALTER COLUMN id SET DEFAULT nextval('public.company_files_id_seq'::regclass);


--
-- Name: document_groups id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_groups ALTER COLUMN id SET DEFAULT nextval('public.document_groups_id_seq'::regclass);


--
-- Name: documents id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documents ALTER COLUMN id SET DEFAULT nextval('public.documents_id_seq'::regclass);


--
-- Name: email_templates id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.email_templates ALTER COLUMN id SET DEFAULT nextval('public.email_templates_id_seq'::regclass);


--
-- Name: favourites id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.favourites ALTER COLUMN id SET DEFAULT nextval('public.favourites_id_seq'::regclass);


--
-- Name: holidays id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays ALTER COLUMN id SET DEFAULT nextval('public.holidays_id_seq'::regclass);


--
-- Name: log_table id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.log_table ALTER COLUMN id SET DEFAULT nextval('public.log_table_id_seq'::regclass);


--
-- Name: mandatory_documents id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mandatory_documents ALTER COLUMN id SET DEFAULT nextval('public.mandatory_documents_id_seq1'::regclass);


--
-- Name: mandatory_documentsa id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mandatory_documentsa ALTER COLUMN id SET DEFAULT nextval('public.mandatory_documents_id_seq'::regclass);


--
-- Name: role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role ALTER COLUMN id SET DEFAULT nextval('public.role_id_seq'::regclass);


--
-- Name: smtp_details id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.smtp_details ALTER COLUMN id SET DEFAULT nextval('public.smtp_details_id_seq'::regclass);


--
-- Name: sub_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_type ALTER COLUMN id SET DEFAULT nextval('public.sub_type_id_seq'::regclass);


--
-- Name: sub_type_reminders id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_type_reminders ALTER COLUMN id SET DEFAULT nextval('public.sub_type_reminders_id_seq'::regclass);


--
-- Name: uploaded_documents id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.uploaded_documents ALTER COLUMN id SET DEFAULT nextval('public.uploaded_documents_id_seq1'::regclass);


--
-- Name: uploaded_documentsa id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.uploaded_documentsa ALTER COLUMN id SET DEFAULT nextval('public.uploaded_documents_id_seq'::regclass);


--
-- Name: user_priviledges p_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_priviledges ALTER COLUMN p_id SET DEFAULT nextval('public.user_priviledges_p_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Name: authority authority_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.authority
    ADD CONSTRAINT authority_pkey PRIMARY KEY (id);


--
-- Name: child_document_mandatory child_document_mandatory_parent_document_id_child_document__key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.child_document_mandatory
    ADD CONSTRAINT child_document_mandatory_parent_document_id_child_document__key UNIQUE (parent_document_id, child_document_id, company_id, type_id, document_month, document_year);


--
-- Name: child_document_mandatory child_document_mandatory_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.child_document_mandatory
    ADD CONSTRAINT child_document_mandatory_pkey PRIMARY KEY (id);


--
-- Name: company_files company_files_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company_files
    ADD CONSTRAINT company_files_pkey PRIMARY KEY (id);


--
-- Name: company company_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.company
    ADD CONSTRAINT company_pkey PRIMARY KEY (id);


--
-- Name: document_groups document_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.document_groups
    ADD CONSTRAINT document_groups_pkey PRIMARY KEY (id);


--
-- Name: documents documents_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documents
    ADD CONSTRAINT documents_pkey PRIMARY KEY (id);


--
-- Name: email_templates email_templates_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.email_templates
    ADD CONSTRAINT email_templates_pkey PRIMARY KEY (id);


--
-- Name: favourites favourites_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.favourites
    ADD CONSTRAINT favourites_pkey PRIMARY KEY (id);


--
-- Name: holidays holidays_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays
    ADD CONSTRAINT holidays_pkey PRIMARY KEY (id);


--
-- Name: log_table log_table_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.log_table
    ADD CONSTRAINT log_table_pkey PRIMARY KEY (id);


--
-- Name: mandatory_documentsa mandatory_documents_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mandatory_documentsa
    ADD CONSTRAINT mandatory_documents_pkey PRIMARY KEY (id);


--
-- Name: mandatory_documents mandatory_documents_pkey1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mandatory_documents
    ADD CONSTRAINT mandatory_documents_pkey1 PRIMARY KEY (id);


--
-- Name: role role_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- Name: smtp_details smtp_details_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.smtp_details
    ADD CONSTRAINT smtp_details_pkey PRIMARY KEY (id);


--
-- Name: sub_type sub_type_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_type
    ADD CONSTRAINT sub_type_pkey PRIMARY KEY (id);


--
-- Name: sub_type_reminders sub_type_reminders_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_type_reminders
    ADD CONSTRAINT sub_type_reminders_pkey PRIMARY KEY (id);


--
-- Name: uploaded_documentsa uploaded_documents_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.uploaded_documentsa
    ADD CONSTRAINT uploaded_documents_pkey PRIMARY KEY (id);


--
-- Name: uploaded_documents uploaded_documents_pkey1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.uploaded_documents
    ADD CONSTRAINT uploaded_documents_pkey1 PRIMARY KEY (id);


--
-- Name: user_priviledges user_priviledges_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_priviledges
    ADD CONSTRAINT user_priviledges_pkey PRIMARY KEY (p_id);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: idx_fav_unique; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_fav_unique ON public.favourites USING btree (upload_id, user_id);


--
-- Name: idx_fav_upload; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fav_upload ON public.favourites USING btree (upload_id);


--
-- Name: idx_fav_user; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_fav_user ON public.favourites USING btree (user_id);


--
-- Name: idx_holiday_date; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_holiday_date ON public.holidays USING btree (holiday_date);


--
-- Name: idx_holiday_year; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_holiday_year ON public.holidays USING btree (holiday_year);


--
-- Name: mandatory_documents fk_mandatory_document; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mandatory_documents
    ADD CONSTRAINT fk_mandatory_document FOREIGN KEY (document_id) REFERENCES public.documents(id) ON DELETE CASCADE;


--
-- Name: sub_type_reminders fk_sub_type; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_type_reminders
    ADD CONSTRAINT fk_sub_type FOREIGN KEY (sub_type_id) REFERENCES public.sub_type(id) ON DELETE CASCADE;


--
-- Name: uploaded_documents fk_uploaded_document; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.uploaded_documents
    ADD CONSTRAINT fk_uploaded_document FOREIGN KEY (document_id) REFERENCES public.documents(id) ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--

\unrestrict 0R9flTTITJohj3odjNgohFMBngxtoZcqSripWFYxNH0bDnMCHY0SR96YeDoxDYE

