<div class="content">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fas fa-database"></i> Multi-Company Migration Tool</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle"></i> <strong>Warning:</strong> 
                This tool migrates existing master data to company-specific tables. 
                Only run this on a fresh company or for testing purposes.
            </div>

            <form action="<?= base_url('migration/run') ?>" method="get" id="migrationForm">
                <div class="form-group mb-3">
                    <label for="company_id" class="form-label">Select Company to Migrate</label>
                    <select name="company_id" id="company_id" class="form-control" required>
                        <option value="">-- Select Company --</option>
                        <?php foreach ($companies as $company): ?>
                        <option value="<?= $company->id ?>"><?= htmlspecialchars($company->company_name) ?> (ID: <?= $company->id ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Migration will:</label>
                    <ul class="list-group">
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Copy all Authorities to company_authorities (enabled)</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Copy all Documents to company_documents (enabled)</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Copy all Document Heads to company_document_heads (enabled)</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Copy all Mandatory Documents to company_mandatory_documents</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Copy all Reminders to company_document_head_reminders</li>
                        <li class="list-group-item"><i class="fas fa-check text-success"></i> Update uploaded documents with company ID (if not set)</li>
                    </ul>
                </div>

                <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to run the migration?')">
                    <i class="fas fa-play"></i> Run Migration
                </button>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('migrationForm').addEventListener('submit', function(e) {
    var companyId = document.getElementById('company_id').value;
    if (companyId) {
        this.action = '<?= base_url('migration/run') ?>/' + companyId;
    }
});
</script>

