<style>
/* --- Compliance Card --- */
        .compliance-card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
            transition: box-shadow 0.3s;
        }
        
        .compliance-card:hover {
             box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
        }

        .card-title h2 {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 4px;
        }

        .card-title p {
            color: var(--text-light);
            font-size: 0.9rem;
        }
        
        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.8rem;
            color: #fff;
        }
        
        .status-incomplete {
            background-color: var(--status-incomplete);
        }
        .status-complete {
            background-color: var(--status-complete);
        }

        .card-body {
            padding: 20px;
        }

        .progress-bar {
            margin-bottom: 20px;
        }
        
        .progress-bar p {
            font-size: 0.9rem;
            font-weight: 500;
            margin-bottom: 8px;
            color: var(--text-light);
        }

        .progress-track {
            width: 100%;
            height: 8px;
            background-color: #e9ecef;
            border-radius: 4px;
        }
        
        .progress-fill {
            height: 100%;
            width: 0%; /* JS will update this */
            background-color: var(--status-complete);
            border-radius: 4px;
            transition: width 0.4s ease-in-out;
        }

        /* --- File Upload Grid --- */
        .file-upload-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 15px;
        }

        /* --- Drag and Drop Zone Styles --- */
        .drop-zone {
            position: relative;
            border: 2px dashed var(--border-color);
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 140px; /* Ensure sufficient height */
            background-color: #fdfdfd;
        }

        .drop-zone:hover {
            border-color: var(--primary-accent);
            background-color: #f0f4f9;
        }

        .drop-zone.drag-over {
            border-color: var(--drag-hover-border);
            background-color: #e6f0fa;
            transform: scale(1.02);
        }

        .drop-zone i {
            font-size: 2.2rem;
            color: var(--text-light);
            margin-bottom: 10px;
            transition: color 0.3s;
        }

        .drop-zone p {
            font-weight: 500;
            font-size: 0.9rem;
            color: var(--text-dark);
            margin-bottom: 5px;
        }
        
        .drop-zone .file-upload-info {
            font-size: 0.8rem;
            color: var(--text-light);
            word-break: break-all;
            line-height: 1.4;
        }

        .drop-zone input[type="file"] {
            display: none;
        }
        
        /* Uploaded state */
        .drop-zone.uploaded {
            border-style: solid;
            border-color: var(--status-complete);
            background-color: var(--file-uploaded-bg);
        }
        
        .drop-zone.uploaded i {
            color: var(--status-complete);
        }
        .drop-zone.uploaded p {
             color: var(--status-complete);
        }

        .drop-zone .file-details {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            width: 100%;
            padding-top: 5px;
        }

        .drop-zone .file-details .file-name {
            font-weight: 500;
            color: var(--text-dark);
            margin-bottom: 5px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 90%;
        }

        .drop-zone .file-details .file-size,
        .drop-zone .file-details .status {
            font-size: 0.8rem;
            color: var(--text-light);
            margin-bottom: 5px;
        }

        .drop-zone .file-details .remove-btn {
            background: none;
            border: none;
            color: var(--status-error);
            font-size: 0.8rem;
            cursor: pointer;
            margin-top: 5px;
            transition: color 0.2s;
        }
        .drop-zone .file-details .remove-btn:hover {
            color: #cc0000;
        }

        /* Progress within drop zone (simulated) */
        .drop-zone .uploading-progress {
            width: calc(100% - 20px); /* Adjust for padding */
            height: 4px;
            background-color: #e0e0e0;
            border-radius: 2px;
            margin-top: 10px;
            overflow: hidden;
            display: none; /* Hidden by default, shown during upload */
        }
        .drop-zone .uploading-progress-fill {
            height: 100%;
            width: 0%;
            background-color: var(--primary-accent);
            border-radius: 2px;
            transition: width 0.3s ease-in-out;
        }
        .drop-zone.uploading .uploading-progress {
            display: block;
        }
</style>
<div class="compliance-card">
            <div class="card-header">
                <div class="card-title">
                    <h2>PAYEE - Monthly</h2>
                    <p>Tanzania Revenue Authority</p>
                </div>
                <div class="status-badge status-incomplete">Incomplete</div>
            </div>
            <div class="card-body">
                <div class="progress-bar">
                    <p class="progress-text">0 of 5 documents uploaded</p>
                    <div class="progress-track">
                        <div class="progress-fill"></div>
                    </div>
                </div>
                <div class="file-upload-grid">
                    <div class="drop-zone" id="dropZoneReturn" onclick="this.querySelector('input').click()">
                        <i class="fa-solid fa-file-invoice"></i>
                        <p>Return <span class="required">*</span></p>
                        <span class="file-upload-info">Drag & drop files here or click to browse</span>
                        <input type="file" required onchange="handleFileSelect(this)">
                        <div class="file-details" style="display: none;">
                            <span class="file-name"></span>
                            <span class="file-size"></span>
                            <span class="status">Uploaded</span>
                            <button type="button" class="remove-btn" onclick="removeFile(event, this)">Remove</button>
                        </div>
                        <div class="uploading-progress"><div class="uploading-progress-fill"></div></div>
                    </div>

                    <div class="drop-zone" id="dropZoneAck" onclick="this.querySelector('input').click()">
                        <i class="fa-solid fa-thumbs-up"></i>
                        <p>Acknowledgement <span class="required">*</span></p>
                        <span class="file-upload-info">Drag & drop files here or click to browse</span>
                        <input type="file" required onchange="handleFileSelect(this)">
                        <div class="file-details" style="display: none;">
                            <span class="file-name"></span>
                            <span class="file-size"></span>
                            <span class="status">Uploaded</span>
                            <button type="button" class="remove-btn" onclick="removeFile(event, this)">Remove</button>
                        </div>
                        <div class="uploading-progress"><div class="uploading-progress-fill"></div></div>
                    </div>

                    <div class="drop-zone" id="dropZoneAssessment" onclick="this.querySelector('input').click()">
                        <i class="fa-solid fa-magnifying-glass-chart"></i>
                        <p>Assessment <span class="required">*</span></p>
                        <span class="file-upload-info">Drag & drop files here or click to browse</span>
                        <input type="file" required onchange="handleFileSelect(this)">
                        <div class="file-details" style="display: none;">
                            <span class="file-name"></span>
                            <span class="file-size"></span>
                            <span class="status">Uploaded</span>
                            <button type="button" class="remove-btn" onclick="removeFile(event, this)">Remove</button>
                        </div>
                        <div class="uploading-progress"><div class="uploading-progress-fill"></div></div>
                    </div>

                    <div class="drop-zone" id="dropZoneControl" onclick="this.querySelector('input').click()">
                        <i class="fa-solid fa-file-lines"></i>
                        <p>Control Form <span class="required">*</span></p>
                        <span class="file-upload-info">Drag & drop files here or click to browse</span>
                        <input type="file" required onchange="handleFileSelect(this)">
                        <div class="file-details" style="display: none;">
                            <span class="file-name"></span>
                            <span class="file-size"></span>
                            <span class="status">Uploaded</span>
                            <button type="button" class="remove-btn" onclick="removeFile(event, this)">Remove</button>
                        </div>
                        <div class="uploading-progress"><div class="uploading-progress-fill"></div></div>
                    </div>

                    <div class="drop-zone" id="dropZonePop" onclick="this.querySelector('input').click()">
                        <i class="fa-solid fa-building-columns"></i>
                        <p>Bank POP <span class="required">*</span></p>
                        <span class="file-upload-info">Drag & drop files here or click to browse</span>
                        <input type="file" required onchange="handleFileSelect(this)">
                        <div class="file-details" style="display: none;">
                            <span class="file-name"></span>
                            <span class="file-size"></span>
                            <span class="status">Uploaded</span>
                            <button type="button" class="remove-btn" onclick="removeFile(event, this)">Remove</button>
                        </div>
                        <div class="uploading-progress"><div class="uploading-progress-fill"></div></div>
                    </div>
                </div>
            </div>
        </div>
     