-- =====================================================
-- SEED DATA FOR MULTI-COMPANY SYSTEM (FIXED)
-- Version: 1.1
-- Date: 2026-01-15
-- =====================================================

-- =====================================================
-- SEED DEFAULT TEMPLATE (All Document Heads)
-- =====================================================

-- Get first user ID for created_by
INSERT INTO company_templates (template_name, description, is_active, created_by)
SELECT 'Default - All Document Heads', 'Includes all available document heads', TRUE, 
    (SELECT id FROM users ORDER BY id LIMIT 1)
WHERE NOT EXISTS (SELECT 1 FROM company_templates WHERE template_name = 'Default - All Document Heads');

-- Add all existing document heads to default template
INSERT INTO company_template_document_heads (template_id, type_id)
SELECT 
    ct.id,
    st.id
FROM company_templates ct, sub_type st
WHERE ct.template_name = 'Default - All Document Heads'
  AND st.status = '1'
ON CONFLICT (template_id, type_id) DO NOTHING;

-- =====================================================
-- MIGRATE EXISTING USER CSV DATA TO NEW TABLES
-- (Only valid references)
-- =====================================================

-- Migrate users.user_company to user_companies (only valid company IDs)
INSERT INTO user_companies (user_id, company_id)
SELECT DISTINCT
    u.id,
    company_id::int
FROM users u,
     unnest(string_to_array(u.user_company, ',')) AS company_id
WHERE u.user_company IS NOT NULL 
  AND u.user_company != ''
  AND u.user_company != 'NULL'
  AND EXISTS (SELECT 1 FROM company c WHERE c.id = company_id::int)
ON CONFLICT (user_id, company_id) DO NOTHING;

-- Migrate users.user_type to user_document_types (only valid type IDs)
INSERT INTO user_document_types (user_id, type_id)
SELECT DISTINCT
    u.id,
    type_id::int
FROM users u,
     unnest(string_to_array(u.user_type, ',')) AS type_id
WHERE u.user_type IS NOT NULL 
  AND u.user_type != ''
  AND u.user_type != 'NULL'
  AND EXISTS (SELECT 1 FROM sub_type st WHERE st.id = type_id::int)
ON CONFLICT (user_id, type_id) DO NOTHING;

-- =====================================================
-- INITIALIZE EXISTING COMPANIES WITH ALL DOC HEADS
-- (For backward compatibility - all enabled by default)
-- =====================================================

-- Create company_authorities for existing companies (enabled for backward compat)
INSERT INTO company_authorities (company_id, authority_id, is_enabled, enabled_at)
SELECT DISTINCT
    c.id,
    a.id,
    TRUE,
    CURRENT_TIMESTAMP
FROM company c
CROSS JOIN authority a
WHERE a.status = '1'
ON CONFLICT (company_id, authority_id) DO NOTHING;

-- Create company_document_heads for existing companies (enabled for backward compat)
INSERT INTO company_document_heads (company_id, type_id, is_enabled, is_reviewed, enabled_at, custom_start_date)
SELECT 
    c.id,
    st.id,
    TRUE,
    TRUE,
    CURRENT_TIMESTAMP,
    CASE 
        WHEN st.document_start_date ~ '^\d{4}-\d{2}-\d{2}$' THEN st.document_start_date::date
        ELSE NULL
    END
FROM company c
CROSS JOIN sub_type st
WHERE st.status = '1'
ON CONFLICT (company_id, type_id) DO NOTHING;

-- Create company_mandatory_documents for existing companies (enabled)
INSERT INTO company_mandatory_documents (company_id, type_id, document_id, is_mandatory, is_enabled, sort_order)
SELECT 
    c.id,
    md.type_id,
    md.document_id,
    CASE WHEN md.mandatory = '1' THEN TRUE ELSE FALSE END,
    TRUE,
    ROW_NUMBER() OVER (PARTITION BY c.id, md.type_id ORDER BY md.id)::int
FROM company c
CROSS JOIN mandatory_documents md
WHERE EXISTS (SELECT 1 FROM sub_type st WHERE st.id = md.type_id AND st.status = '1')
ON CONFLICT (company_id, type_id, document_id) DO NOTHING;

-- Create company_document_head_reminders for existing companies (enabled)
INSERT INTO company_document_head_reminders (company_id, type_id, reminder_no, days_before, 
    reminder_to_user, reminder_to_admin, reminder_to_super_admin, is_enabled)
SELECT 
    c.id,
    sr.sub_type_id,
    sr.reminder_no,
    sr.days_before,
    CASE WHEN sr.reminder_to_user = 'true' THEN TRUE ELSE FALSE END,
    CASE WHEN sr.reminder_to_admin = 'true' THEN TRUE ELSE FALSE END,
    CASE WHEN sr.reminder_to_super_admin = 'true' THEN TRUE ELSE FALSE END,
    TRUE
FROM company c
CROSS JOIN sub_type_reminders sr
WHERE EXISTS (SELECT 1 FROM sub_type st WHERE st.id = sr.sub_type_id AND st.status = '1')
ON CONFLICT (company_id, type_id, reminder_no) DO NOTHING;

-- Create company_documents for existing companies (enabled)
INSERT INTO company_documents (company_id, document_id, is_enabled, enabled_at)
SELECT DISTINCT
    c.id,
    d.id,
    TRUE,
    CURRENT_TIMESTAMP
FROM company c
CROSS JOIN documents d
WHERE d.status = '1'
ON CONFLICT (company_id, document_id) DO NOTHING;

-- Create company_document_groups for existing companies (enabled)
-- Note: document_id in document_groups is varchar, cast to int
INSERT INTO company_document_groups (company_id, parent_document_id, child_document_ids, is_enabled)
SELECT 
    c.id,
    dg.document_id::int,
    dg.grouped_doc_id,
    TRUE
FROM company c
CROSS JOIN document_groups dg
WHERE dg.document_id IS NOT NULL 
  AND dg.document_id != ''
  AND dg.document_id ~ '^\d+$'
ON CONFLICT (company_id, parent_document_id) DO NOTHING;

