<!-- Reorder Documents for Single Type - Modern UI -->
<style>
@import url('https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap');

.reorder-single-container {
    font-family: 'Outfit', sans-serif;
    padding: 1.5rem;
}

.reorder-single-card {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    overflow: hidden;
    max-width: 600px;
    margin: 0 auto;
}

.reorder-header {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    padding: 1.25rem 1.5rem;
}

.reorder-header h3 {
    margin: 0;
    font-size: 1.125rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.reorder-body {
    padding: 1.5rem;
}

.doc-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.doc-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.875rem 1rem;
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    margin-bottom: 0.5rem;
    cursor: move;
    transition: all 0.2s;
}

.doc-item:hover {
    border-color: #3b82f6;
    background: #eff6ff;
    box-shadow: 0 2px 8px rgba(59, 130, 246, 0.15);
}

.doc-item.ui-sortable-helper {
    background: #dbeafe !important;
    border-color: #3b82f6 !important;
    box-shadow: 0 8px 20px rgba(59, 130, 246, 0.25) !important;
    transform: rotate(1deg);
}

.doc-item.ui-sortable-placeholder {
    background: #e0f2fe;
    border: 2px dashed #3b82f6;
    visibility: visible !important;
}

.drag-handle {
    color: #94a3b8;
    font-size: 1rem;
    cursor: grab;
}

.doc-number {
    background: linear-gradient(135deg, #64748b 0%, #475569 100%);
    color: #fff;
    min-width: 28px;
    height: 28px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.8rem;
    font-weight: 600;
}

.doc-name {
    flex: 1;
    font-size: 0.9rem;
    color: #334155;
    font-weight: 500;
}

.reorder-footer {
    padding: 1rem 1.5rem;
    border-top: 1px solid #e2e8f0;
    display: flex;
    justify-content: flex-end;
}

.save-btn {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-size: 0.9rem;
    font-weight: 500;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.2s;
}

.save-btn:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
}

.success-toast {
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
    padding: 1rem 1.5rem;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(16, 185, 129, 0.3);
    display: none;
    align-items: center;
    gap: 0.75rem;
    z-index: 1000;
}

.success-toast.show {
    display: flex;
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from { transform: translateX(100%); opacity: 0; }
    to { transform: translateX(0); opacity: 1; }
}
</style>

<div class="reorder-single-container content">
    <div class="reorder-single-card">
        <div class="reorder-header">
            <h3>
                <i class="fa fa-arrows-alt"></i>
                Reorder Documents
            </h3>
        </div>
        
        <div class="reorder-body">
            <ul id="docList" class="doc-list">
                <?php $index = 1; foreach ($documents as $d): ?>
                    <li class="doc-item">
                        <span class="drag-handle"><i class="fa fa-grip-vertical"></i></span>
                        <span class="doc-number"><?= $index++ ?></span>
                        <span class="doc-name"><?= htmlspecialchars($d) ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        
        <div class="reorder-footer">
            <button id="saveOrder" class="save-btn">
                <i class="fa fa-save"></i> Save Order
            </button>
        </div>
    </div>
</div>

<div class="success-toast" id="successToast">
    <i class="fa fa-check-circle"></i>
    <span>Order saved successfully!</span>
</div>

<!-- jQuery UI -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<script>
$(function() {
    // Initialize sortable
    $("#docList").sortable({
        handle: ".drag-handle",
        placeholder: "doc-item ui-sortable-placeholder",
        axis: "y",
        update: function(event, ui) {
            $("#docList .doc-item").each(function(i) {
                $(this).find(".doc-number").text(i + 1);
            });
        }
    });
    
    // Save Order
    $("#saveOrder").click(function() {
        const $btn = $(this);
        let order = [];
        
        $("#docList .doc-item").each(function() {
            order.push($(this).find(".doc-name").text().trim());
        });
        
        $btn.prop("disabled", true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        $.ajax({
            url: "<?= base_url('type/save_order'); ?>",
            type: "POST",
            data: {
                type_id: <?= $type_id ?>,
                sequence: order.join(',')
            },
            success: function(response) {
                $btn.prop("disabled", false).html('<i class="fa fa-save"></i> Save Order');
                
                // Show success toast
                $("#successToast").addClass("show");
                setTimeout(function() {
                    $("#successToast").removeClass("show");
                }, 3000);
            },
            error: function(xhr) {
                $btn.prop("disabled", false).html('<i class="fa fa-save"></i> Save Order');
                console.log("Error:", xhr.responseText);
                alert("Error saving order. Please try again.");
            }
        });
    });
});
</script>
