<!-- Main Content -->
<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
      <div class="fab-top-group" style="display: flex; gap: 8px; position: absolute; top: 8px; right: 25px; z-index: 10;">
        <button type="button" class="btn btn-outline-secondary btn-sm" onclick="resetSearch()" title="Reset Search" style="border-radius: 50%; width: 36px; height: 36px; padding: 0;">
              <i class="fa fa-undo"></i>
        </button>
        <a href="<?= base_url('authority/create') ?>" class="btn btn-primary btn-sm" style="border-radius: 50%; width: 36px; height: 36px; padding: 0; display: flex; align-items: center; justify-content: center;">
          <i class="fa-solid fa-plus"></i>
        </a>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table id="example" class="table align-middle text-center mb-0">
              <thead>
                  <tr>
                  <!--<th>ID</th>-->
                      <th width="5%">#</th>
                      <th width="11%">Authority Name</th>
                      <th width="9%">Alias</th>
                      <th width="10%">Created On</th>
                      <th width="8%">Action</th>
                  </tr>
                  <tr class="column-search-row">
                      <th></th>
                      <th><input type="text" class="column-search" data-column="1" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="2" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="3" placeholder="Search..."></th>
                      <th></th>
                  </tr>
              </thead>
            <tbody>
              
              <?php if(empty($authorities)): ?>
              <tr>
                  <td colspan="7" class="text-center">No authority types found</td>
              </tr>
              <?php else: ?>
                  <?php foreach($authorities as $row): ?>
                  <tr>
                      <td><?= $row->id ?></td>
                      <td style="text-align:left;"><?= $row->authority_name ?></td>
                      <td style="text-align:left;"><?= $row->alias_name ?></td>
                      <td><?= date("d-M-Y", strtotime($row->created_date)); ?></td>
                      <td>
                          <a href="<?= base_url('authority/edit/'.$row->id) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
                          <a href="<?= base_url('authority/delete/'.$row->id) ?>" class="btn btn-danger btn-icon" onclick="return confirm('Are you sure to Delete?')"><i class="fas fa-trash-alt"></i></a>
                          <?php if ($row->status == '1'): ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-success btn-icon rounded-circle" 
                                  onclick="return confirm('Are you sure to deactivate?');" title="Active">
                                      <i class="fas fa-check"></i>
                                  </a>
                          <?php else: ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-secondary btn-icon rounded-circle"
                                  onclick="return confirm('Are you sure to activate?');" title="Inactive">
                                      <i class="fas fa-times"></i>
                                  </a>
                          <?php endif; ?>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              <?php endif; ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<style>

table thead tr:first-child th {
  background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
  color: #fff;
  border: none;
}

table thead tr:first-child th a,
table thead tr:first-child th i {
  color: #fff;
}

/* === Hide Default Search === */
.dataTables_filter label,
.dataTables_filter input,
.dt-search label,
.dt-search input {
  display: none;
}

</style>

<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>

let table;

$(document).ready(function () {

  table = $('#example').DataTable({
    orderCellsTop: true,
    fixedHeader: true,
    pageLength: 10,
    
    // ✅ Default sort: Created On DESC
    order: [[3, 'desc']],
    

    // ✅ Disable sorting only where needed
    columnDefs: [
      { orderable: false, targets: [0, 4] },
      { orderSequence: ['desc', 'asc'], targets: [1, 2, 3] }
    ]
  });

  // Column search
  $('#example .column-search').on('keyup change', function () {
    let colIdx = $(this).data('column');
    table.column(colIdx).search(this.value).draw();
  });

  function moveDtControls() {
      const $wrapper = $('#example_wrapper');

      // Top controls
      const $topRow     = $wrapper.children('.row').first();
      const $dtLength   = $topRow.find('.dt-length');

      // Bottom controls
      const $bottomRow  = $wrapper.children('.row').last();
      const $bottomLeft = $bottomRow.find('.dt-layout-start');
      const $bottomRight= $bottomRow.find('.dt-layout-end');
      const $dtInfo     = $bottomRow.find('.dt-info');

      // Move "Show entries" to bottom-left
      if (!$bottomLeft.find('.dt-length').length) {
          $dtLength.appendTo($bottomLeft);
      }

      // Move "Showing X to Y" next to pagination
      if (!$bottomRight.find('.dt-info').length) {
          $dtInfo.prependTo($bottomRight);
      }
  }

  function replaceLengthDropdown() {
    const $wrapper = $('#example_wrapper');
    const $lengthContainer = $wrapper.find('.dt-length');

    if ($lengthContainer.find('.dt-length-buttons').length) return;

    const pageLengths = [10, 20, 50, -1]; // -1 = All
    const currentLength = table.page.len();

    // Hide default select + label
    $lengthContainer.find('select, label').hide();

    let html = '<ul class="pagination pagination-sm mb-0 dt-length-buttons">';

    pageLengths.forEach(len => {
      const label = len === -1 ? 'All' : len;
      const isActive =
        (len === -1 && currentLength === -1) ||
        (len !== -1 && currentLength === len);

      html += `
        <li class="page-item ${isActive ? 'active' : ''}">
          <button class="page-link dt-len-btn" data-len="${len}">
            ${label}
          </button>
        </li>
      `;
    });

    html += '</ul>';

    $lengthContainer.append(html);
  }

  $(document).on('click', '.dt-len-btn', function () {
    const len = parseInt($(this).data('len'), 10);

    table.page.len(len).draw();

    // Update active state
    $(this)
      .closest('.dt-length-buttons')
      .find('.page-item')
      .removeClass('active');

    $(this)
      .parent('.page-item')
      .addClass('active');
  });

  // Run once after init
  moveDtControls();
  replaceLengthDropdown();

  // Run again on redraw (pagination, length change, sort)
  table.on('draw.dt', function () {
      moveDtControls();
      replaceLengthDropdown();
  });

});

  // SweetAlert confirm delete (uses id param)
  function confirmDelete(itemId) {
    Swal.fire({
      title: 'Are you sure?',
      text: "This will permanently delete the record!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = `<?= base_url('type/deleteType/') ?>${itemId}`;
      }
    });
  }

  // SweetAlert confirm status change (AJAX)
  function statusChange(itemId, status) {
    let actionText = (status === '1') ? 'activate' : 'deactivate';
    Swal.fire({
      title: 'Are you sure?',
      text: `Do you really want to ${actionText} this record?`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonText: `Yes, ${actionText} it!`,
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: '<?= base_url("type/changeStatus"); ?>',
          method: 'POST',
          data: { id: itemId, status: status },
          success: function(response) {
            let res = JSON.parse(response);
            if (res.success) {
              Swal.fire('Success!', res.message, 'success').then(() => {
                location.reload();
              });
            } else {
              Swal.fire('Error!', res.message, 'error');
            }
          },
          error: function() {
            Swal.fire('Error!', 'Something went wrong!', 'error');
          }
        });
      }
    });
  }

    // Column search functionality
    $('#example .column-search').on('keyup change', function() {
        var columnIdx = $(this).data('column');
        table.column(columnIdx).search(this.value).draw();
    });
    
    function resetSearch() {
  $('#example .column-search').val('');
  table.search('').columns().search('');
  table.order([[3, 'desc']]); // reset sort
  table.page('first');
  table.draw();
}

</script>