<?php
class Authority_model extends CI_Model {

    private $table = 'authority';

    public function get_all() {
        $this->db->order_by('authority_name', 'ASC');
            return $this->db->get_where($this->table, [
                'is_delete' => '0',
                'status'    => '1'   // add your active check here
            ])->result();
    }

    public function get($id) {
        return $this->db->get_where($this->table, ['id' => $id])->row();
    }

    public function insert($data) {
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function delete($id) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, ['is_delete' => 1]);
    }

    public function update_status($id, $status) {
        $this->db->where('id', $id)
                 ->update($this->table, ['status' => $status]);
    }

    public function isAuthorityExists($name, $exclude_id = null)
    {
        $normalized = preg_replace('/\s+/', '', strtolower($name));

        $sql = "
            SELECT id 
            FROM {$this->table}
            WHERE REPLACE(LOWER(authority_name), ' ', '') = ?
            AND is_delete = '0' AND status='1'
        ";

        $params = [$normalized];

        // Exclude current ID if provided (for edit)
        if ($exclude_id) {
            $sql .= " AND id != ?";
            $params[] = $exclude_id;
        }

        $sql .= " LIMIT 1";

        $query = $this->db->query($sql, $params);
        return $query->num_rows() > 0;
    }
}
