<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Type extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function index()
	{
		redirect('type/allType');
	}
	
	public function allType()
    {   
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		$company_id = $this->session->userdata('company_id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		//$sql="select s.*,a.authority_name from sub_type s LEFT JOIN authority a ON a.id = CAST(s.authority_id AS INTEGER) order by type_name asc ";  

	/*	$sql = "SELECT 
				s.*, 
				a.authority_name, 
				string_agg(d.document_name, ', ') AS document_names,
				u.first_name,
				u.last_name,
				u.email_id
				FROM sub_type s
				LEFT JOIN authority a ON a.id = CAST(NULLIF(s.authority_id, '') AS INTEGER)
				LEFT JOIN documents d ON CAST(d.id AS TEXT) = ANY(string_to_array(s.document_name, ','))
				LEFT JOIN users u ON CAST(u.id as TEXT) = s.created_by
				where s.status = '1' 
				GROUP BY s.id, a.authority_name,u.first_name,u.last_name,u.email_id
				ORDER BY s.type_name ASC";
*/
				$sql = "SELECT 
				s.*, 
				a.authority_name, 
				string_agg(d.document_name, ', ' ORDER BY strpos(s.document_name, d.id::text)) AS document_names,
				u.first_name,
				u.last_name,
				u.email_id
			FROM sub_type s
			LEFT JOIN authority a 
				ON a.id = CAST(NULLIF(s.authority_id, '') AS INTEGER)
			LEFT JOIN documents d 
				ON CAST(d.id AS TEXT) = ANY(string_to_array(s.document_name, ','))
			LEFT JOIN users u 
				ON CAST(u.id AS TEXT) = s.created_by
			WHERE s.status = '1'
			GROUP BY s.id, a.authority_name, u.first_name, u.last_name, u.email_id
			ORDER BY s.type_name ASC";

		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		$frequency = PAYMENT_OPTIONS;
		
		$this->load->view('templates/header');
		$this->load->view('type/all_type',array('authority_list'=>$business_data));
		$this->load->view('templates/footer');

	}
	public function addType() {
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		$company_id = $this->session->userdata('company_id');

		if($login_id=='') {
			redirect('login');
		}
		$sql="select * from authority where status='1' order by id asc ";  
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$document_sql = "select * from documents where status='1'";
		$document_query = $this->db->query($document_sql);
		$document_data = $document_query->result_array();

		$company_sql = "select * from company where status='1' and id=$company_id"; 
		$company_query = $this->db->query($company_sql);
		$company_data = $company_query->result_array();
		
		$frequency = PAYMENT_OPTIONS;
		$this->load->view('templates/header');
		$this->load->view('type/add_type',array('authority'=>$business_data,'frequency'=>$frequency,'document_data'=>$document_data, 'company_data'=>$company_data));
		//$this->load->view('templates/footer');
	}
	
	public function saveType() {
		
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		$company_id = $this->session->userdata('company_id');
		
		if($login_id=='') {
			redirect('login');
		}

		//echo $this->session->userdata('full_name');

		//echo '<pre>'; print_r($_POST);exit;
		$post = $this->input->post();
		$sub_type = $post['sub_type'];
		$alias_name = $post['alias'];
		$authority_id = $post['authority_id'];
		$frequency = $post['frequency'];
		$doc_type = $post['doc_type'];
		$document_date = $post['document_date'] ?? null;
		$doc_start_date = $post['document_start_date'];
		$due_month = $post['due_month'];
		$next_due_date = $post['next_due_date'] ?? null;

		if($due_month == 'same')
			$due_month = 0;
		else 
			$due_month = 1;
		//$frequency_start_date = $post['frequency_start_date'] ?? null;
		//$monthly_days = $post['monthly_days'] ?? null;
		if($frequency=='Monthly') {
            $frequency_start_date = $_POST['monthly_days'];
        }
        else {
			$frequency_start_date = $_POST['monthly_days'];
            //$frequency_start_date = $_POST['frequency_start_date'];
        }
		$created_by = $this->session->userdata('full_name') ?? null;

		$documents = $post['document'] ?? []; // selected documents
		$mandatory = $post['mandatory'] ?? []; // mandatory mapping

		// Insert into type table
		$typeData = [
			'type_name' => $sub_type,
			'alias_name' => $alias_name,
			'authority_id' => $authority_id,
			'frequency' => $frequency,
			'doc_type' => $doc_type,
			'frequency_start_date' => $frequency_start_date,
			'document_name'=>implode(',',$documents),
			'document_start_date' => $doc_start_date,
			'created_by'=> $login_id,
			'due_in_same_next_month' => $due_month,
			'status'                => 1
		];
		
		//echo $document_date;exit;
		/*if (!empty($document_date)) {
			$typeData['document_expiry_date'] = $document_date;
		}*/

		if (!empty($next_due_date)) {
			$typeData['document_expiry_date'] = $next_due_date;
		}

		$this->db->insert('sub_type', $typeData);
		$type_id = $this->db->insert_id();

		// Insert into type_documents table
		foreach ($documents as $docId) {
			$this->db->insert('mandatory_documents', [
				'type_id' => $type_id,
				'document_id' => $docId,
				'mandatory' => isset($mandatory[$docId]) ? $mandatory[$docId] : 0
			]);
		}

			// ================== INSERT INTO sub_type_reminders ==================
		// We read: no_of_reminders, reminder_days[], reminder_to[][]
		$no_of_reminders = (int) ($post['no_of_reminders'] ?? 0);
		$reminder_days   = $post['reminder_days'] ?? [];   // e.g. [1 => "30", 2 => "15", ...]
		$reminder_to     = $post['reminder_to']   ?? [];   // e.g. [1 => ['User','Admin'], 2 => ['User'], ...]

		if ($no_of_reminders > 0 && is_array($reminder_days)) {

			// respect DB constraint (1..5)
			$no_of_reminders = min($no_of_reminders, 5);

			for ($i = 1; $i <= $no_of_reminders; $i++) {

				if (!isset($reminder_days[$i])) {
					continue; // no row data
				}

				$days_before = (int) $reminder_days[$i];

				// who to remind?
				$toArray = isset($reminder_to[$i]) ? (array) $reminder_to[$i] : [];

				$to_user        = in_array('User',        $toArray);
				$to_admin       = in_array('Admin',       $toArray);
				$to_super_admin = in_array('Super Admin', $toArray);

				$reminderRow = [
					'sub_type_id'             => $type_id,  // FK to sub_type(id)
					'reminder_no'             => $i,        // 1..5
					'days_before'             => $days_before,
					'reminder_to_user'        => $to_user ? 'true' : 'false',
					'reminder_to_admin'       => $to_admin ? 'true' : 'false',
					'reminder_to_super_admin' => $to_super_admin ? 'true' : 'false',
				];

				/*echo '<pre>';
				print_r($reminderRow);
				exit; */

				$this->db->insert('sub_type_reminders', $reminderRow);
			} 
		}

		$this->session->set_flashdata('message_name', 'Sub Type Created Successfully');
		redirect('type');	
	}
	public function deleteType($id)
	{
		$this->session->set_userdata('menu','type');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}

		//Check is authoiry is mapped with any type and user
        if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Delete not allowed — Document head in use.');
            redirect('type/allType');
            return;
        }
		
		$query = $this->db->get_where('sub_type', ['id' => $id]);

		if ($query->num_rows() === 0) {
			redirect('type');
		} else {
			//echo "in else";exit;
			$this->db->where('id', $id)->update('sub_type', ['status' => 0]);
			$this->session->set_flashdata('message_name', 'Type Deleted Successfully');
			$this->session->set_flashdata('message_type', 'success'); // optional: success, error, info, warning
			redirect('type/allType');
		}
	}
	
	
	public function editType($id) {
		
		 $login_id = $this->session->userdata('id');
		if ($login_id == '') {
			redirect('login');
		}
		$this->session->set_userdata('menu', 'type');

        if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Edit not allowed — Document head in use.');
            redirect('type/allType');
            return;
        }

		// Get type data
		$sql = "SELECT * FROM sub_type WHERE id = ?";
		$type_query = $this->db->query($sql, array($id));
		$type_data = $type_query->row_array(); // single row is enough

		if (empty($type_data)) {
			redirect('type/allType');
		}

		// Get authority
		$sql1 = "SELECT * FROM authority WHERE status = '1'";
		$query1 = $this->db->query($sql1);
		$authority_data = $query1->result_array();

		// Get all documents
		$document_sql = "SELECT * FROM documents WHERE status='1'";
		$document_query = $this->db->query($document_sql);
		$document_data = $document_query->result_array();

		// ✅ Get already assigned documents (with mandatory flag)
		$assigned_sql = "SELECT document_id, mandatory FROM mandatory_documents WHERE type_id = ?";
		$assigned_query = $this->db->query($assigned_sql, array($id));
		$assigned_documents = $assigned_query->result_array();
		
		// Convert assigned docs into [doc_id => mandatory]
		$selected_docs = [];
		foreach ($assigned_documents as $doc) {
			$selected_docs[$doc['document_id']] = $doc['mandatory'];
		}
		$frequency = PAYMENT_OPTIONS;

		$company_sql = "select * from company where status='1' and id=2"; 
		$company_query = $this->db->query($company_sql);
		$company_data = $company_query->result_array();

		$this->load->view('templates/header');
		$this->load->view(
			'type/edit_type',
			array(
				'authority_data'   => $authority_data,
				'type_data'        => $type_data,
				'frequency'        => $frequency,
				'document_data'    => $document_data,
				'selected_docs'    => $selected_docs,
				'company_data'     => $company_data
			)
		);
	}
		
	public function updateType() {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','type');
		$id = $_POST['type_id'];
		//echo '<pre>'; print_r($_POST);exit;
		$sub_type = $_POST['sub_type'];
		$alias_name = $_POST['alias'];
		$monthly_days = $_POST['monthly_days'];
		$authority_id = $_POST['authority_id'];
		$frequency = $_POST['frequency'];
		$doc_type = $_POST['doc_type'];
		$due_month = $_POST['due_month'];

		if($due_month == 'same'){
			$due_month = 0;
		} else {
			$due_month = 1;
		}	

		if($frequency=='Monthly') {
			$frequency_start_date = $_POST['monthly_days'];
		}
		else {
			$frequency_start_date = $_POST['frequency_start_date'];
		}
		$document_expiry_date = $_POST['document_expiry_date'];
		$document_date = $_POST['document_date'];
		$document =  implode(',',$_POST['document']);
		//$created_by = $this->session->userdata('full_name') ?? null;
		//$document =  implode(',', $_POST['document']);
		
		//$sql = "update sub_type set type_name='$sub_type',authority_id='$authority_id', frequency = '$frequency',doc_type='$doc_type',frequency_start_date='$frequency_start_date', document_expiry_date='$document_expiry_date',document_name='$document',alias_name='$alias_name'  where id='$id'";
		//$query1 = $this->db->query($sql);
		$this->db->where('id', $id);
		$this->db->update('sub_type', array_merge([
    'type_name'            => $sub_type,
    'authority_id'         => $authority_id,
    'frequency'            => $frequency,
    'status'               => 1,
    'doc_type'             => $doc_type,
    'frequency_start_date' => $frequency_start_date,
    'document_name'        => $document,
    'alias_name'           => $alias_name,
    'created_by'           => $login_id,
	'due_in_same_next_month' => $due_month
], !empty($document_date) ? ['document_expiry_date' => $document_date] : []));

		$delete_query  = "delete from mandatory_documents where type_id = '$id'";
		$delete_data = $this->db->query($delete_query);
		
		$documents = $_POST['document'] ?? []; // selected documents
		$mandatory = $_POST['mandatory'] ?? []; // mandatory mapping

		// Insert into type_documents table
		foreach ($documents as $docId) {
			$this->db->insert('mandatory_documents', [
				'type_id' => $id,
				'document_id' => $docId,
				'mandatory' => isset($mandatory[$docId]) ? $mandatory[$docId] : 0
			]);
		}
		$this->session->set_flashdata('message_name', 'Type Details Successfully Updated');

		redirect('type/allType');
		
	}
	
	public function viewProject($id) {
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$sql="select * from projects where id= '$id'";   
		$project_query = $this->db->query($sql);
		$project_data = $project_query->result_array();
		$this->load->view('templates/layout');
		$this->load->view('project/view_project',array('project_data'=>$project_data));
	}
	
	public function changeStatus()
	{
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		if ($this->id_exists('uploaded_documents', $id)) {
            echo json_encode([
				'success' => false,
				'message' => 'Deactivation not allowed — Document head in use.'
			]);
			return;
        }

		// Convert 'Active' to 0 and anything else to 1
		if($status=='1') {
			$new_status ='0';
		} else {
			$new_status = '1';	
		}
		$sql = "UPDATE sub_type SET status='$new_status' WHERE id='$id'";
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.'
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	 // 🔹 Private helper function to check if a record exists
    private function id_exists($table, $id)
    {
        return $this->db->where('type_id', $id)
                ->where('is_deleted', 0)
                ->limit(1)
                ->count_all_results($table) > 0;
    }

	public function reorder_all()
	{
		// Fetch all types in alphabetical order
		$sub_types = $this->db
			->where('status', '1') 
			//->order_by('type_name', 'ASC')
			->get('sub_type')
			->result_array();

		foreach ($sub_types as &$row) {

			// Convert CSV IDs -> array
			$doc_ids = array_filter(array_map('trim', explode(',', $row['document_name'])));

			$documents = [];
			if (!empty($doc_ids)) {

				// Fetch documents IN THE SAME ORDER as stored sequence
				$doc_list = $this->db
					->where_in('id', $doc_ids)
					->where('status', '1')
					->get('documents')
					->result_array();

				// Index by ID for quick lookup
				$docIndexed = [];
				foreach ($doc_list as $d) {
					$docIndexed[$d['id']] = $d['document_name'];
				}

				// Keep ordering same as sub_type.document_name
				foreach ($doc_ids as $doc_id) {
					if (isset($docIndexed[$doc_id])) {
						$documents[] = [
							'id' => $doc_id,
							'name' => $docIndexed[$doc_id]
						];
					}
				}
			}

			// Attach final structured list
			$row['documents'] = $documents;
		}

		$data['sub_types'] = $sub_types;

		$this->load->view('templates/header');
		$this->load->view('type/reorder_all_view', $data);
		//$this->load->view('templates/footer');
	}

	public function save_order()
	{
		$type_id = $this->input->post('type_id');
		$sequence = $this->input->post('sequence');

		$docs = implode(',', $sequence);

		$this->db->where('id', $type_id)
				->update('sub_type', ['document_name' => $docs]);

		echo json_encode(['status' => 'success']);
	}

	public function getFiscalYear()
	{
		$this->db->select('fiscal_year');
		$this->db->from('company');
		$this->db->where('id',2);
		$this->db->limit(1);
		$query = $this->db->get();

		$result = $query->row();

		echo json_encode([
			'fiscal_year' => $result ? $result->fiscal_year : ''
		]);
	}

	/**
	 * Get child documents for a parent document from document_groups
	 * Used for auto-selecting children when creating/editing Document Head
	 */
	public function getChildDocuments()
	{
		$document_id = $this->input->post('document_id');
		
		if (empty($document_id)) {
			echo json_encode(['children' => []]);
			return;
		}
		
		// Get the group where this document is the parent
		$group = $this->db->where('document_id', $document_id)
						  ->get('document_groups')
						  ->row_array();
		
		if (empty($group) || empty($group['grouped_doc_id'])) {
			echo json_encode(['children' => [], 'is_parent' => false]);
			return;
		}
		
		// Parse child document IDs
		$child_ids = array_map('trim', explode(',', $group['grouped_doc_id']));
		$child_ids = array_filter($child_ids);
		
		if (empty($child_ids)) {
			echo json_encode(['children' => [], 'is_parent' => false]);
			return;
		}
		
		// Get child document details
		$children = $this->db->where_in('id', $child_ids)
							 ->where('status', '1')
							 ->get('documents')
							 ->result_array();
		
		echo json_encode([
			'is_parent' => true,
			'children' => $children
		]);
	}

	/**
	 * Get all document groups for reference
	 * Returns a map of parent_id => [child_ids]
	 */
	public function getAllDocumentGroups()
	{
		$groups = $this->db->get('document_groups')->result_array();
		
		$groupMap = [];
		foreach ($groups as $g) {
			$parent_id = $g['document_id'];
			$child_ids = array_map('trim', explode(',', $g['grouped_doc_id']));
			$child_ids = array_filter($child_ids);
			$groupMap[$parent_id] = $child_ids;
		}
		
		echo json_encode(['groups' => $groupMap]);
	}

	/**
	 * Check if a document is a child in any group
	 * Returns the parent document if it is a child
	 */
	public function checkDocumentParent()
	{
		$document_id = $this->input->post('document_id');
		
		if (empty($document_id)) {
			echo json_encode(['is_child' => false]);
			return;
		}
		
		// Check all groups to see if this document is a child
		$groups = $this->db->get('document_groups')->result_array();
		
		foreach ($groups as $g) {
			$child_ids = array_map('trim', explode(',', $g['grouped_doc_id']));
			if (in_array($document_id, $child_ids)) {
				// This document is a child - get parent details
				$parent = $this->db->where('id', $g['document_id'])
								   ->get('documents')
								   ->row_array();
				
				echo json_encode([
					'is_child' => true,
					'parent_id' => $g['document_id'],
					'parent_name' => $parent ? $parent['document_name'] : ''
				]);
				return;
			}
		}
		
		echo json_encode(['is_child' => false]);
	}
}
