<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Document extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function index()
	{
		redirect('document/allDocuments');
	}
	
	public function allDocuments()
    {   
		$this->session->set_userdata('menu','document');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		
		$sql="select * from documents order by id asc ";  
		
		$query = $this->db->query($sql);
		$business_data = $query->result_array();
		
		$this->load->view('templates/header');
		$this->load->view('document/all_document',array('authority_list'=>$business_data));
		//$this->load->view('templates/footer');

	}
	public function addDocument() {
		$this->session->set_userdata('menu','document');
		$login_id = $this->session->userdata('id');
		if($login_id=='') {
			redirect('login');
		}
		$this->load->view('templates/header');
		$this->load->view('document/add_document');
		//$this->load->view('templates/footer');
	}
	
	public function saveDocument() {
		
		$this->session->set_userdata('menu','document');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$document_name = $_POST['document_name'];
		
		$query = "insert into documents(document_name,status) values('".$document_name."','1')";
		
		$insert_query = $this->db->query($query);	
		
		$this->session->set_flashdata('message_name', 'New Document Created Successfully');
		
		redirect('document/allDocuments');	
	}
	public function deleteDocument($id)
	{
		$this->session->set_userdata('menu','document');
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}

		if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Delete is not allowed — Document in use.');
            redirect('document/allDocuments');
            return;
        }
		
		$query = $this->db->get_where('documents', ['id' => $id]);

		if ($query->num_rows() === 0) {
			redirect('document/allDocuments');
		} else {
			$delete_query  = "delete from documents where id= '$id'";
			$delete_data = $this->db->query($delete_query);
			
			$this->session->set_flashdata('message_name', 'Document Deleted Successfully');
			redirect('document/allDocuments');
		}
	}
	
	public function editDocument($id) {
		
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','document');

		if ($this->id_exists('uploaded_documents', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Edit not allowed — Document in use.');
            redirect('document/allDocuments');
            return;
        }
		
		$sql = "select * from documents where id='$id'";

		$type_query = $this->db->query($sql);
		$type_data = $type_query->result_array();

		if(empty($type_data)) {
			redirect('document/allDocuments');
		}
		
		$this->load->view('templates/header');
		$this->load->view('document/edit_document',array('authority_data'=>$type_data));		
		
	}
	public function updateDocument() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$this->session->set_userdata('menu','document');
		$id = $_POST['id'];
		
		$document_name = $_POST['document_name'];
		
		$sql = "update documents set document_name='$document_name' where id='$id'";
		$query1 = $this->db->query($sql);
		$this->session->set_flashdata('message_name', 'Document Successfully Updated');

		redirect('document/allDocuments');
		
	}
	public function changeStatus()
	{
		$id     = $this->input->post('id');
		$status = $this->input->post('status');

		// Convert 'Active' to 0 and anything else to 1
		$new_status = $status ;

		if ($this->id_exists('uploaded_documents', $id)) {
            echo json_encode([
				'success' => false,
				'message' => 'Deactivation not allowed — Document in use.'
			]);
			return;
        }

		$sql = "UPDATE documents SET status='$new_status' WHERE id='$id'"; 
		$query = $this->db->query($sql);

		if ($query) {
			echo json_encode([
				'success'    => true,
				'message'    => 'Status updated successfully.',
				'new_status' => $new_status
			]);
		} else {
			echo json_encode([
				'success' => false,
				'message' => 'Failed to update status.'
			]);
		}
	}
	
	public function addDocumentGroup() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		$sql = "select * from documents";

		$document_query = $this->db->query($sql);
		$document_data = $document_query->result_array();

		if(empty($document_data)) {
			redirect('document/groupList');
		}
		
		$this->load->view('templates/header');
		$this->load->view('document/add_group',array('document_data'=>$document_data));	
	}
	
	public function saveGroup() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$main_id = $_POST['main_document'];
		$child = implode(',',$_POST['child_document']);
		
		$query = "insert into document_groups(document_id, grouped_doc_id) values ('$main_id','$child')";
		$data = $this->db->query($query);
		
		redirect('document/groupList');
		
	}
	
	public function groupList() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$sql = "SELECT 
					g.id,
					g.document_id,
					d.document_name AS main_doc_name,
					string_agg(d2.document_name, ', ') AS grouped_doc_names
				FROM document_groups g
				LEFT JOIN documents d 
					ON d.id = g.document_id::int                -- cast to int
				LEFT JOIN LATERAL (
					SELECT document_name
					FROM documents
					WHERE id IN (
						SELECT unnest(string_to_array(g.grouped_doc_id, ',')::int[])
					)
				) AS d2 ON TRUE
				GROUP BY g.id, g.document_id, d.document_name
				ORDER BY g.id ASC;";
		$document_query = $this->db->query($sql);
		$document_data = $document_query->result_array();
		
		$this->load->view('templates/header');
		$this->load->view('document/group_list',array('document_data'=>$document_data));
	}
	
	public function groupEdit($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		
		$sql = "select * from documents";

		$document_query = $this->db->query($sql);
		$document_data = $document_query->result_array();

		$query = "select * from document_groups where id='$id'";
		$group_query = $this->db->query($query);
		$group_data = $group_query->result_array();
		
		if(empty($document_data)) {
			redirect('document/groupList');
		}
		
		$this->load->view('templates/header');
		$this->load->view('document/edit_group',array('document_data'=>$document_data,'group_data'=>$group_data));	
		
	}
	
	public function updateGroup() {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$main_id = $_POST['main_document'];
		$id = $_POST['id'];
		$child = implode(',',$_POST['child_document']);
		
		$query = "update document_groups set document_id='$main_id',grouped_doc_id='$child' where id='$id'";
		$run_query = $this->db->query($query);
		redirect('document/groupList');
	}
	
	public function groupDelete($id) {
		$login_id = $this->session->userdata('id');
		
		if($login_id=='') {
			redirect('login');
		}
		$query = "delete from document_groups where id='$id'";
		$run_query = $this->db->query($query);
		redirect('document/groupList');
	}
	
	// 🔹 Private helper function to check if a record exists
    private function id_exists($table, $id)
    {
        return $this->db->where('document_id', $id)
                ->where('is_deleted', 0)
                ->limit(1)
                ->count_all_results($table) > 0;
    }
}
