<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/userguide3/general/urls.html
	 */
	public function __construct() {
        parent::__construct();
        // Load the language based on user preference or default to English
        $language =  $this->session->userdata('language'); // Language can be set in URL as first segment
		if($this->session->userdata('language')=='') {
			$this->session->set_userdata('language', 'english');
		}
        if (in_array($language, ['english', 'spanish', 'french','german','espinol','italian'])) {
			
            $this->lang->load('message', $language);
            $this->session->set_userdata('language', $language); // Store language preference in session
        } else {
            $this->lang->load('message', 'english'); // Default language
        }
    }
	
	public function index()
	{
		
		redirect('login');
		$this->load->view('welcome_message');
	}
	public function set_language($language = 'english') {
        // Check if the language is supported (you can add more languages as needed)
        if (in_array($language, ['english', 'spanish','french','german','espinol','italian'])) {
            // Set the selected language in session
            $this->session->set_userdata('language', $language);
        }

        // Redirect to the same page after setting the language
        redirect('welcome');
    }
}
