<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Authority extends CI_Controller {

    public function __construct() {
        parent::__construct();
        ini_set('display_error',1);
        $this->load->model('Authority_model');
        $this->load->library('form_validation');
    }
     public function index() {
        error_reporting(1);
        //echo "Authority Controller Works!";
        //exit;
        ini_set('display_error',1);
        $data['authorities'] = $this->Authority_model->get_all();

       
        $this->load->view('templates/header');
        $this->load->view('authority/index', $data);
        $this->load->view('layout/footer');
    }

    public function create() {

        $authority_name = trim($this->input->post('authority_name'));
        $alias = trim($this->input->post('alias'));

        // Mandatory field
        $this->form_validation->set_rules('authority_name', 'Authority Name', 'required|trim',
            array('required' => 'The %s field is mandatory.')
        );

        // Non-mandatory field (no 'required' rule)
        $this->form_validation->set_rules('alias', 'Alias', 'trim');
        $this->form_validation->set_rules('authority_name', 'authority_name', 'required|callback_alpha_num_space_apo');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('templates/header');
            $this->load->view('authority/create');
            $this->load->view('layout/footer');
        } else {
            if ($this->input->post()) {  
                // Check if authority name already exists
                $exists = $this->Authority_model->isAuthorityExists($authority_name);

                if ($exists) {
                    $data['error_message'] = 'Authority name already exists!';
                    $this->load->view('templates/header');
                    $this->load->view('authority/create', $data);
                    $this->load->view('layout/footer');
                    return;
                }

                $this->Authority_model->insert([
                    'authority_name' => $this->input->post('authority_name'),
                    'alias_name' => $this->input->post('alias'),
                    'status' => '1',
                    'is_delete' => 0,
                    'creation_date' => date('Y-m-d')
                ]);

                $this->session->set_flashdata('message_type', 'success');
                $this->session->set_flashdata('message_name', 'Authority added successfully!');
                redirect('authority');
            }
        }
    }

    public function edit($id) {
        //Check is authoiry is mapped with any type and user
        if ($this->id_exists('sub_type', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Edit not allowed — Authority in use.');
            redirect('authority');
            return;
        }

        $data['authority'] = $this->Authority_model->get($id);
         // Mandatory field
        $this->form_validation->set_rules('authority_name', 'Authority Name', 'required|trim',
            array('required' => 'The %s field is mandatory.')
        );

        // Non-mandatory field (no 'required' rule)
        $this->form_validation->set_rules('alias', 'Alias', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('templates/header');
            $this->load->view('authority/edit_authority', $data);
            $this->load->view('layout/footer');
        } else {
            $authority_name = trim($this->input->post('authority_name'));

            // ✅ Check for duplicate (excluding current record)
            $exists = $this->Authority_model->isAuthorityExists($authority_name, $id);

            if ($exists) {
                $data['error_message'] = 'Authority name already exists!';
                $this->load->view('templates/header');
                $this->load->view('authority/edit_authority', $data);
                $this->load->view('layout/footer');
                return;
            }

            $this->Authority_model->update($id, [
                'authority_name' => $this->input->post('authority_name'),
                'alias_name' => $this->input->post('alias_name')
            ]);

            $this->session->set_flashdata('message_type', 'success');
            $this->session->set_flashdata('message_name', 'Authority updated successfully!');
            redirect('authority');
        }
    }

    public function delete($id) {
        //Check is authoiry is mapped with any type and user
        if ($this->id_exists('sub_type', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Delete not allowed — Authority in use.');
            redirect('authority');
            return;
        }

        $this->Authority_model->delete($id);

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('message_type', 'success');
            $this->session->set_flashdata('message_name', 'Authority deleted successfully!');
        }
        else {
        $this->session->set_flashdata('message_type', 'error');
        $this->session->set_flashdata('message_name', 'Authority not found or already deleted.');
        }

        redirect('authority');
    }

    public function toggle_status($id) {

        //Check is authoiry is mapped with any type and user
        if ($this->id_exists('sub_type', $id)) {
            $this->session->set_flashdata('message_type', 'error');
            $this->session->set_flashdata('message_name', 'Deactivation not allowed — authority in use.');
            redirect('authority');
            return;
        }

        $authority = $this->Authority_model->get($id); 

        if ($authority) {
            $new_status = ($authority->status == '0') ? '1' : '0';
            $this->Authority_model->update_status($id, $new_status);

            if ($this->db->affected_rows() > 0) {
                $this->session->set_flashdata('message_type', 'success');
                $this->session->set_flashdata('message_name', 'Authority deleted successfully!');
            }
            else {
                $this->session->set_flashdata('message_type', 'error');
                $this->session->set_flashdata('message_name', 'Authority not found or already deleted.');
            }
        }

        redirect('authority');
    }

    public function alpha_num_space_apo($str)
    {
        if (preg_match("/^[a-zA-Z0-9' ]+$/", $str)) {
            return TRUE;
        } else {
            $this->form_validation->set_message('alpha_num_space_apo', 'The {field} field may only contain alphabets, numbers, spaces, and apostrophes.');
            return FALSE;
        }
    }

    // 🔹 Private helper function to check if a record exists
    private function id_exists($table, $id)
    {
        return $this->db->where('authority_id', $id)
                        ->where('status', '1')
                        ->limit(1)
                        ->count_all_results($table) > 0;
    }
}