<!-- Main Content -->
<style>
/* Column Search Styles */
.column-search-row input {
    width: 100%;
    padding: 6px 10px;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    font-size: 0.8rem;
    background: #fff;
    transition: all 0.2s;
}
.column-search-row input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);
}
.column-search-row input::placeholder {
    color: #94a3b8;
}
.column-search-row th {
    background: #f8fafc !important;
    padding: 8px 10px !important;
}

/* Smaller input height to match header */
.filters-row input.column-search {
  padding: 46px 6px;
  font-size: 13px;
  box-sizing: border-box;
}
#example thead th { white-space: nowrap; }

table thead tr:first-child th {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    border: none;
}

table thead tr:first-child th a,
table thead tr:first-child th i {
    color: #fff; /* icons / links white */
}
</style>

<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Action buttons fixed inside card -->
      <div class="fab-top-group" style="display: flex; gap: 8px; position: absolute; top: 15px; right: 15px; z-index: 10;">
        <button type="button" class="btn btn-outline-secondary btn-sm" onclick="resetSearch()" title="Reset Search" style="border-radius: 50%; width: 36px; height: 36px; padding: 0;">
          <i class="fa fa-undo"></i>
        </button>
        <a href="<?= base_url('document/addDocumentGroup') ?>" class="btn btn-primary btn-sm" style="border-radius: 50%; width: 36px; height: 36px; padding: 0; display: flex; align-items: center; justify-content: center;">
          <i class="fa-solid fa-plus"></i>
        </a>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table align-middle text-center mb-0" id="example">
              <thead>
                  <tr>
                      <th style="text-align:center; width: 80px;">Sr.No</th>
                      <th style="text-align:left;">Document Name</th>
                      <th style="text-align:left;">Group Document</th>
                      <th style="text-align:center; width: 120px;">Action</th>
                  </tr>
                  <tr class="column-search-row">
                      <th></th>
                      <th><input type="text" class="column-search" data-column="1" placeholder="Search document..."></th>
                      <th><input type="text" class="column-search" data-column="2" placeholder="Search group..."></th>
                      <th></th>
                  </tr>
              </thead>
            <tbody>
                <?php $i=1;?>
                <?php foreach($document_data as $aut) { ?>
                <tr>
                    <td><?php echo $i;?></td>
                    <td style="text-align:left;"><?php echo $aut['main_doc_name'];?></td>
                    <td style="text-align:left;"> 
                        <?php echo $aut['grouped_doc_names'];?>
                    </td>
                    <td>
                        <a href="<?= base_url('document/groupEdit/'.$aut['id']) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
                        <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </td>
                </tr>
                <?php $i++; }  ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // DataTable with column search
    var table = new DataTable('#example', {
        orderCellsTop: true,
        autoWidth: false,
        columnDefs: [
            { orderable: false, targets: [0, 3] },
            { searchable: false, targets: [0, 3] }
        ]
    });

    // Column search functionality
    $('#example .column-search').on('keyup change', function() {
        var columnIdx = $(this).data('column');
        table.column(columnIdx).search(this.value).draw();
    });
    
    // Reset search function
    function resetSearch() {
        $('#example .column-search').val('');
        table.columns().search('').draw();
    }

    // SweetAlert flash message
    <?php if ($this->session->flashdata('message_name')): ?>
        Swal.fire({
            icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
            title: '<?= $this->session->flashdata('message_name') ?>',
            showConfirmButton: false,
            timer: 2000
        });
    <?php endif; ?>

    // SweetAlert confirm delete
    function confirmDelete(itemId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = `<?= base_url('document/groupDelete/') ?>${itemId}`;
            }
        });
    }
</script>
