<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/jquery.validate.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/choices.min.js"></script>	

<!-- Bootstrap Multiselect / Choices -->
<link rel="stylesheet" href="<?php echo base_url();?>public/assets/css/choices.min.css">

<style>
/* Fix for Document Group Form */
.group-form-container .form-group {
    margin-bottom: 1.5rem;
}
.group-form-container .form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
    position: relative;
    top: auto;
    left: auto;
    transform: none;
    background: transparent;
    padding: 0;
}
.group-form-container .choices {
    margin-top: 0.25rem;
}
.group-form-container .choices__inner {
    min-height: 44px;
    padding: 0.5rem;
    border: 1px solid #ced4da;
    border-radius: 6px;
    background: #fff;
}
.group-form-container .choices__list--multiple .choices__item {
    background: #3b82f6;
    border: none;
    border-radius: 4px;
    margin: 2px;
}
.group-form-container .choices__input {
    margin-top: 4px;
    display: block;
    width: 100% !important;
}
.group-form-container select.form-control {
    height: 44px;
    border: 1px solid #ced4da;
    border-radius: 6px;
}
</style>

<div class="content">
	<div class="formcard group-form-container">
		<form class="type_form" id="type_form" method="post" action="<?php echo base_url();?>document/saveGroup">
			<div class="form-group">
				<label for="main_document" class="form-label">Group Document</label>
				<select name="main_document" class="form-control" id="main_document">
					<option value="">-- Select Document --</option>
					<?php foreach($document_data as $document) { ?>
					<option value="<?php echo $document['id'];?>"><?php echo $document['document_name'];?></option>
					<?php } ?>
				</select>
			</div>
			<div class="form-group">
				<label for="choices-multiple-remove-button" class="form-label">Select Documents to Group</label>
				<select name="child_document[]" id="choices-multiple-remove-button" class="form-control" multiple>
					<?php foreach($document_data as $document) { ?>
					<option value="<?php echo $document['id'];?>"><?php echo $document['document_name'];?></option>
					<?php } ?>
				</select>
			</div>
			<div class="formbtn-group">
				<button type="submit" class="formbtn formbtn-save">Save</button>
				<a href="javascript:history.back()" class="formbtn formbtn-cancel">Cancel</a>
			</div>
		</form>
	</div>
</div>	
<script>
$(document).ready(function(){
    // Store all documents for reference
    const allDocuments = [
        <?php foreach($document_data as $document) { ?>
        { value: '<?php echo $document['id'];?>', label: '<?php echo addslashes($document['document_name']);?>' },
        <?php } ?>
    ];

    // Initialize Choices.js multi-select for child documents
    const childChoices = new Choices('#choices-multiple-remove-button', {
        removeItemButton: true,
        maxItemCount: 50,
        searchResultLimit: 50,
        renderChoiceLimit: 50,
        searchPlaceholderValue: 'Type to search...',
        placeholderValue: 'Select documents...'
    });

    // When parent document is selected, disable it in child dropdown
    $('#main_document').on('change', function() {
        let parentId = $(this).val();
        
        // Get currently selected child values
        let selectedChildren = childChoices.getValue(true) || [];
        
        // If selected parent is in children, remove it
        if (parentId && selectedChildren.includes(parentId)) {
            selectedChildren = selectedChildren.filter(id => id !== parentId);
        }
        
        // Clear and rebuild choices with parent disabled
        childChoices.clearStore();
        
        let newChoices = allDocuments.map(doc => ({
            value: doc.value,
            label: doc.label,
            selected: selectedChildren.includes(doc.value),
            disabled: doc.value === parentId
        }));
        
        childChoices.setChoices(newChoices, 'value', 'label', true);
    });

    // When child documents are selected, disable them in parent dropdown
    document.getElementById('choices-multiple-remove-button').addEventListener('change', function() {
        let selectedChildren = childChoices.getValue(true) || [];
        
        // Update parent dropdown - disable selected children
        $('#main_document option').each(function() {
            let optVal = $(this).val();
            if (optVal && selectedChildren.includes(optVal)) {
                $(this).prop('disabled', true);
            } else {
                $(this).prop('disabled', false);
            }
        });
        
        // If current parent is now in selected children, reset parent
        let currentParent = $('#main_document').val();
        if (currentParent && selectedChildren.includes(currentParent)) {
            $('#main_document').val('');
            alert('The selected parent document was added as a child. Please select a different parent.');
        }
    });

    // Form validation
    $('#type_form').on('submit', function(e) {
        let parentId = $('#main_document').val();
        let childIds = childChoices.getValue(true) || [];
        
        if (!parentId) {
            e.preventDefault();
            alert('Please select a Parent Document.');
            return false;
        }
        
        if (childIds.length === 0) {
            e.preventDefault();
            alert('Please select at least one Child Document.');
            return false;
        }
        
        if (childIds.includes(parentId)) {
            e.preventDefault();
            alert('Parent document cannot be the same as a child document.');
            return false;
        }
        
        return true;
    });
});
</script>