<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Dashboard Styles -->
  <style>
  @import url('https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap');
  
  .dashboard-container {
    font-family: 'Outfit', sans-serif;
    background: linear-gradient(135deg, #f5f7fa 0%, #e4e8ec 100%);
    min-height: 100vh;
    padding: 1.5rem;
  }
  
  /* Stats Cards */
  .stats-grid {
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    gap: 1rem;
    margin-bottom: 1.5rem;
  }
  
  @media (max-width: 1200px) {
    .stats-grid {
      grid-template-columns: repeat(3, 1fr);
    }
  }
  
  @media (max-width: 768px) {
    .stats-grid {
      grid-template-columns: repeat(2, 1fr);
    }
  }
  
  .stat-card {
    background: #fff;
    border-radius: 16px;
    padding: 1.25rem;
    position: relative;
    overflow: hidden;
    cursor: pointer;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: 2px solid transparent;
  }
  
  .stat-card:hover {
      transform: translateY(-4px);
    box-shadow: 0 12px 24px rgba(0,0,0,0.1);
  }
  
  .stat-card.active {
    border-color: var(--card-accent);
    box-shadow: 0 8px 20px rgba(0,0,0,0.12);
  }
  
  .stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 4px;
    background: var(--card-accent);
  }
  
  .stat-card--favourite { --card-accent: #3b82f6; }
  .stat-card--pending { --card-accent: #f59e0b; }
  .stat-card--overdue { --card-accent: #ef4444; }
  .stat-card--upcoming { --card-accent: #5b21b6; }
  .stat-card--uploaded { --card-accent: #10b981; }
  
  .stat-card__icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    margin-bottom: 0.75rem;
  }
  
  .stat-card--favourite .stat-card__icon { background: #dbeafe; color: #3b82f6; }
  .stat-card--pending .stat-card__icon { background: #fef3c7; color: #f59e0b; }
  .stat-card--overdue .stat-card__icon { background: #fee2e2; color: #ef4444; }
  .stat-card--upcoming .stat-card__icon { background: #e0e7ff; color: #5b21b6; }
  .stat-card--uploaded .stat-card__icon { background: #d1fae5; color: #10b981; }
  
  .stat-card__count {
    font-size: 2rem;
    font-weight: 700;
    color: #1e293b;
    line-height: 1;
    margin-bottom: 0.25rem;
  }
  
  .stat-card__label {
    font-size: 0.875rem;
    color: #64748b;
    font-weight: 500;
  }
  
  /* Tab Content Area */
  .tab-content-area {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    overflow: hidden;
  }
  
  .tab-header {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    padding: 0.5rem 1rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    transition: background 0.3s ease;
  }
  
  /* Tab-specific header colors */
  .tab-header--favourite { background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); }
  .tab-header--pending { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); }
  .tab-header--overdue { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
  .tab-header--upcoming { background: linear-gradient(135deg, #7c3aed 0%, #5b21b6 100%); }
  .tab-header--uploaded { background: linear-gradient(135deg,  #10b981 0%, #059669 100%); }
  
  .tab-header h3 {
    margin: 0;
    font-size: 1.125rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }
  
  .tab-header__badge {
    background: rgba(255,255,255,0.2);
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
  }
  
  /* Sortable table headers */
  .data-table th.sortable {
    cursor: pointer;
    user-select: none;
    position: relative;
    padding-right: 1.5rem;
  }
  
  .data-table th.sortable:hover {
    background: #e2e8f0;
  }
  
  .data-table th.sortable::after {
    content: '↕';
    position: absolute;
    right: 0.5rem;
    opacity: 0.3;
    font-size: 0.7rem;
  }
  
  .data-table th.sortable.sort-asc::after {
    content: '↑';
    opacity: 1;
  }
  
  .data-table th.sortable.sort-desc::after {
    content: '↓';
    opacity: 1;
  }
  
  /* Reset search button */
  .btn-reset-search {
    background: rgba(255,255,255,0.15);
    border: 1px solid rgba(255,255,255,0.25);
    color: #fff;
    padding: 0.5rem 0.75rem;
    border-radius: 8px;
    font-size: 0.8rem;
    cursor: pointer;
    transition: all 0.2s;
    display: flex;
    align-items: center;
    gap: 0.375rem;
  }
  
  .btn-reset-search:hover {
    background: rgba(255,255,255,0.25);
  }
  
  .tab-actions {
    display: flex;
    gap: 0.5rem;
  }
  
  .tab-actions .btn {
    background: rgba(255,255,255,0.15);
    border: 1px solid rgba(255,255,255,0.25);
    color: #fff;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.2s;
  }
  
  .tab-actions .btn:hover {
    background: rgba(255,255,255,0.25);
  }
  
  .tab-body {
    padding: 0;
    max-height: 500px;
    overflow-y: auto;
  }
  
  /* Table Styles */
  .data-table {
    width: 100%;
    border-collapse: collapse;
  }
  
  .data-table thead {
    background: #f8fafc;
    position: sticky;
    top: 0;
    z-index: 10;
  }
  
  .data-table th {
    padding: 0.875rem 1rem;
    text-align: left;
    font-weight: 600;
    color: #475569;
    font-size: 0.8rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid #e2e8f0;
  }
  
  .data-table td {
    padding: 0.875rem 1rem;
    font-size: 0.875rem;
    color: #334155;
    border-bottom: 1px solid #f1f5f9;
    vertical-align: middle;
  }
  
  .data-table tbody tr:hover {
    background: #f8fafc;
  }
  
  .data-table tbody tr:last-child td {
    border-bottom: none;
  }

  /* Column Search Row */
  .data-table thead tr.column-search th {
    padding: 0.5rem;
    background: #f1f5f9;
    border-bottom: 1px solid #e2e8f0;
  }

  .column-search-input {
    width: 100%;
    padding: 0.375rem 0.5rem;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    font-size: 0.75rem;
    color: #334155;
    background: #fff;
    transition: all 0.2s;
  }

  .column-search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);
  }

  .column-search-input::placeholder {
    color: #94a3b8;
  }

  /* Hide rows that don't match */
  .data-table tbody tr.hidden-row {
    display: none;
  }
  
  /* Document Pills */
  .doc-pills {
    display: flex;
    flex-wrap: wrap;
    gap: 0.375rem;
  }
  
  .doc-pill {
    background: #f1f5f9;
    color: #475569;
    padding: 0.25rem 0.625rem;
    border-radius: 6px;
    font-size: 0.75rem;
    font-weight: 500;
  }
  
  .doc-pill--uploaded {
    background: #d1fae5;
    color: #059669;
  }
  
  .doc-pill--pending {
    background: #fee2e2;
    color: #dc2626;
  }
  
  .doc-count {
    font-size: 0.7rem;
    margin-left: 0.5rem;
    padding: 0.125rem 0.375rem;
    border-radius: 4px;
  }
  
  .doc-count--uploaded {
    background: #d1fae5;
    color: #059669;
  }
  
  .doc-count--pending {
    background: #fee2e2;
    color: #dc2626;
  }
  
  /* Frequency Badge */
  .frequency-badge {
    display: inline-block;
    background: #f0f9ff;
    color: #0369a1;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
  }
  
  /* Status Badges */
  .status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
  }
  
  .status-badge--overdue {
    background: #fee2e2;
    color: #dc2626;
  }
  
  .status-badge--pending {
    background: #e0e7ff;
    color: #4f46e5;
  }
  
  .status-badge--upcoming {
    background: #d1fae5;
    color: #059669;
  }
  
  /* Favourite Button */
  .fav-btn {
    background: none;
    border: none;
    cursor: pointer;
    font-size: 1.125rem;
    color: #cbd5e1;
    transition: all 0.2s;
    padding: 0.25rem;
  }
  
  .fav-btn:hover {
    color: #f59e0b;
    /*transform: scale(1.1);*/
  }
  
  .fav-btn.active {
    color: #f59e0b;
  }
  
  /* Due Date Styles */
  .due-date {
    display: flex;
    align-items: center;
    gap: 0.375rem;
    font-size: 0.8rem;
  }
  
  .due-date__day {
    background: #fee2e2;
    color: #dc2626;
    min-width: 28px;
    height: 28px;
    padding: 0 6px;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 0.8rem;
  }
  
  .due-date span:last-child {
    color: #64748b;
    font-weight: 500;
    white-space: nowrap;
  }
  
  .due-date--upcoming .due-date__day {
    background: #d1fae5;
    color: #059669;
  }
  
  /* Empty State */
  .empty-state {
    text-align: center;
    padding: 3rem 1rem;
    color: #94a3b8;
  }
  
  .empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
  }
  
  .empty-state p {
    font-size: 0.875rem;
    margin: 0;
  }
  
  /* Loading Spinner */
  .tab-loading {
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 3rem;
  }
  
  .spinner {
    width: 40px;
    height: 40px;
    border: 3px solid #e2e8f0;
    border-top-color: #3b82f6;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
  }
  
  @keyframes spin {
    to { transform: rotate(360deg); }
  }
  
  /* Month Badge */
  .month-badge {
    background: #f1f5f9;
    color: #475569;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
  }
  
  /* Company Badge */
  .company-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
    padding: 0.25rem 0.625rem;
    border-radius: 6px;
    font-size: 0.75rem;
    font-weight: 500;
  }
  
  /* Action buttons */
  .action-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border-radius: 8px;
    border: none;
    cursor: pointer;
    transition: all 0.2s;
    color: #64748b;
    background: #f1f5f9;
  }
  
  .action-btn:hover {
    background: #e2e8f0;
    color: #334155;
  }
  
  .action-btn--view:hover { color: #3b82f6; }
  .action-btn--download:hover { color: #10b981; }
  .action-btn--pdf { color: #dc2626; }
  .action-btn--pdf:hover { color: #b91c1c; }
  .action-btn--menu { 
    cursor: pointer;
  }
  
  /* Dashboard Action Dropdown Wrapper */
  .action-dropdown-wrapper {
    position: relative;
    display: inline-block;
  }
  .action-dropdown-menu {
    position: absolute;
    right: 0;
    top: 100%;
    background: white;
    border-radius: 8px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    min-width: 140px;
    z-index: 1000;
    display: none;
    padding: 6px 0;
    margin-top: 4px;
  }
  .action-dropdown-wrapper.open .action-dropdown-menu {
    display: block;
  }
  .action-dropdown-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 8px 14px;
    color: #374151;
    text-decoration: none;
    font-size: 0.85rem;
    transition: background 0.15s;
  }
  .action-dropdown-item:hover {
    background: #f3f4f6;
    color: #111827;
  }
  .action-dropdown-item i {
    width: 16px;
    text-align: center;
  }
  .action-dropdown-divider {
    height: 1px;
    background: #e5e7eb;
    margin: 4px 0;
  }
  
  /* Action Dropdown Styles */
  .action-dropdown {
    position: relative;
    display: inline-block;
  }
  
  .action-dropdown__btn {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border: none;
    padding: 0.4rem 0.75rem;
    border-radius: 6px;
    font-size: 0.75rem;
    font-weight: 500;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 0.375rem;
    transition: all 0.2s;
  }
  
  .action-dropdown__btn:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
    transform: translateY(-1px);
  }
  
  .action-dropdown__btn--danger {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
  }
  
  .action-dropdown__btn--danger:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
  }

  .action-dropdown__btn--info {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
  }
  
  .action-dropdown__btn--info:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
  }

  .action-dropdown__btn--warning {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
  }
  
  .action-dropdown__btn--warning:hover {
    background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
  }
  
  .action-dropdown__btn--success {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
  }
  
  .action-dropdown__btn--success:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
  }
  
  .action-dropdown__menu {
    position: absolute;
    top: 100%;
    right: 0;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    min-width: 180px;
    z-index: 1000;
    opacity: 0;
    visibility: hidden;
    transform: translateY(-10px);
    transition: all 0.2s ease;
  }
  
  .action-dropdown.open .action-dropdown__menu {
    opacity: 1;
    visibility: visible;
    transform: translateY(5px);
  }
  
  .action-dropdown__item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.625rem 1rem;
    color: #374151;
    text-decoration: none;
    font-size: 0.8rem;
    cursor: pointer;
    transition: all 0.15s;
    border: none;
    background: none;
    width: 100%;
    text-align: left;
  }
  
  .action-dropdown__item:first-child {
    border-radius: 8px 8px 0 0;
  }
  
  .action-dropdown__item:last-child {
    border-radius: 0 0 8px 8px;
  }
  
  .action-dropdown__item:hover {
    background: #f3f4f6;
    color: #111827;
  }
  
  .action-dropdown__item i {
    width: 16px;
    text-align: center;
  }
  
  .action-dropdown__item--view:hover { background: #dbeafe; color: #1d4ed8; }
  .action-dropdown__item--download:hover { background: #cffafe; color: #0891b2; }
  .action-dropdown__item--favourite:hover { background: #fef3c7; color: #d97706; }
  .action-dropdown__item--upload:hover { background: #dbeafe; color: #1d4ed8; }
  .action-dropdown__item--mail:hover { background: #fef3c7; color: #d97706; }
  .action-dropdown__item--whatsapp:hover { background: #d1fae5; color: #059669; }
  
  .action-dropdown__divider {
    height: 1px;
    background: #e5e7eb;
    margin: 0.25rem 0;
  }
  
  .action-dropdown__submenu-label {
    display: block;
    padding: 0.375rem 1rem;
    font-size: 0.7rem;
    color: #9ca3af;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
  }
  
  /* Hide original dropdown menu - we use floating clone instead */
  .action-dropdown .action-dropdown__menu {
    display: none !important;
  }
  
  
  /* Dashboard Filters */
  .dashboard-filters {
    background: #fff;
    border-radius: 12px;
    padding: 1rem 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    display: flex;
    align-items: center;
    gap: 1.5rem;
    flex-wrap: wrap;
  }
  
  .dashboard-filters__title {
    font-weight: 600;
    color: #1e3a5f;
    font-size: 0.9rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }
  
  .dashboard-filters__group {
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }
  
  .dashboard-filters__label {
    font-size: 0.8rem;
    color: #64748b;
    font-weight: 500;
  }
  
  .dashboard-filters__select {
    padding: 0.5rem 0.75rem;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    font-size: 0.85rem;
    color: #334155;
    background: #fff;
    min-width: 180px;
    cursor: pointer;
    transition: all 0.2s;
  }
  
  .dashboard-filters__select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
  }
  
  .dashboard-filters__select[multiple] {
    min-height: 38px;
    max-height: 120px;
  }
  
  .dashboard-filters__btn {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border: none;
    padding: 0.5rem 1.25rem;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 500;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.2s;
  }
  
  .dashboard-filters__btn:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
    transform: translateY(-1px);
  }
  
  .dashboard-filters__btn--reset {
    background: #f1f5f9;
    color: #64748b;
  }
  
  .dashboard-filters__btn--reset:hover {
    background: #e2e8f0;
    color: #334155;
    transform: translateY(-1px);
  }
  
  .filter-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-left: auto;
  }
  
  .filter-tag {
    background: #e0f2fe;
    color: #0369a1;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.375rem;
  }
  
  .filter-tag__remove {
    cursor: pointer;
    opacity: 0.7;
  }
  
  .filter-tag__remove:hover {
    opacity: 1;
  }
  
  .filter-tag--info {
    background: #dbeafe;
    color: #1d4ed8;
  }
  
  /* Custom Company Dropdown */
  .company-dropdown-wrapper {
    position: relative;
  }
  
  .company-dropdown-btn {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 0.5rem;
    padding: 0.5rem 0.75rem;
    min-width: 220px;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    background: #fff;
    color: #334155;
    font-size: 0.85rem;
    cursor: pointer;
    transition: all 0.2s;
    user-select: none;
  }
  
  .company-dropdown-btn:hover {
    border-color: #3b82f6;
    background: #f8fafc;
  }
  
  .company-dropdown-btn:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
  }
  
  .company-dropdown-wrapper.open .company-dropdown-btn {
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
  }
  
  .company-dropdown-arrow {
    font-size: 0.7rem;
    color: #64748b;
    transition: transform 0.2s;
  }
  
  .company-dropdown-wrapper.open .company-dropdown-arrow {
    transform: rotate(180deg);
  }
  
  .company-dropdown-menu {
    display: none;
    position: absolute;
    top: calc(100% + 4px);
    left: 0;
    min-width: 280px;
    max-height: 300px;
    background: #fff;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 9999;
    overflow: hidden;
  }
  
  .company-dropdown-wrapper.open .company-dropdown-menu {
    display: block !important;
  }
  
  .company-dropdown-actions {
    display: flex;
    gap: 0.5rem;
    padding: 0.5rem;
    border-bottom: 1px solid #e2e8f0;
    background: #f8fafc;
  }
  
  .company-action-btn {
    flex: 1;
    padding: 0.375rem 0.5rem;
    font-size: 0.75rem;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    background: #fff;
    color: #64748b;
    cursor: pointer;
    transition: all 0.2s;
  }
  
  .company-action-btn:hover {
    background: #3b82f6;
    border-color: #3b82f6;
    color: #fff;
  }
  
  .company-dropdown-list {
    max-height: 240px;
    overflow-y: auto;
    padding: 0.5rem;
  }
  
  .company-checkbox-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem;
    border-radius: 4px;
    cursor: pointer;
    transition: background 0.15s;
  }
  
  .company-checkbox-item:hover {
    background: #f1f5f9;
  }
  
  .company-checkbox-item input[type="checkbox"] {
    width: 16px;
    height: 16px;
    accent-color: #3b82f6;
  }
  
  .company-checkbox-item span {
    font-size: 0.85rem;
    color: #334155;
  }
  
  /* Company restriction note - shown inline in filters for non-admin users */
  .company-restriction-note {
    font-size: 0.75rem;
    color: #64748b;
    display: flex;
    align-items: center;
    gap: 0.25rem;
    margin-left: auto;
    padding: 0.25rem 0.75rem;
    background: #fef3c7;
    border-radius: 6px;
    border: 1px solid #fcd34d;
  }
  
  .company-restriction-note i {
    color: #f59e0b;
    }

    .days-badge {
  display: inline-block;
  margin-left: 6px;
  padding: 2px 6px;
  font-size: 0.7rem;
  border-radius: 6px;
  font-weight: 600;
}

.days-badge--remaining {
  background: #e0f2fe;
  color: #0369a1;
}

.days-badge--overdue {
  background: #fee2e2;
  color: #dc2626;
}

/* Upcoming tab action button */
.action-dropdown__btn--upcoming {
  background: linear-gradient(135deg, #10b981 0%, #059669 100%);
  color: #fff;
  border: none;
  box-shadow: 0 2px 6px rgba(16, 185, 129, 0.35);
}

.action-dropdown__btn--upcoming:hover {
  box-shadow: 0 4px 10px rgba(16, 185, 129, 0.45);
  transform: translateY(-1px);
}

/* Pending / Current (Indigo) */
.action-dropdown__btn--pending {
  background: linear-gradient(135deg, #7c3aed 0%, #5b21b6 100%);
  color: #fff;
  border: none;
  box-shadow: 0 2px 6px rgba(99, 102, 241, 0.35);
}
.action-dropdown__btn--pending:hover {
  box-shadow: 0 4px 10px rgba(99, 102, 241, 0.45);
  transform: translateY(-1px);
}

/* Uploaded (Blue) */
.action-dropdown__btn--uploaded {
  background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
  color: #fff;
  border: none;
  box-shadow: 0 2px 6px rgba(59, 130, 246, 0.35);
}
.action-dropdown__btn--uploaded:hover {
  box-shadow: 0 4px 10px rgba(59, 130, 246, 0.45);
  transform: translateY(-1px);
}

.status-wrapper {
  display: inline-flex;
  flex-direction: column;
  align-items: center;   /* ⬅ centers days to badge width */
  gap: 4px;
}

.status-days {
  font-size: 0.75rem;
  font-weight: 600;
  /*color: #dc2626;*/
  text-align: center;
}

.action-dropdown__btn--pending:hover,
.action-dropdown__btn--pending:focus,
.action-dropdown__btn--pending:active {
  background: linear-gradient(135deg, #5b21b6 0%, #4c1d95 100%);
  color: #fff;
}

.action-dropdown__btn--upcoming:hover,
.action-dropdown__btn--upcoming:focus,
.action-dropdown__btn--upcoming:active {
  background: linear-gradient(135deg, #059669 0%, #047857 100%);
  color: #fff;
}

.due-adjusted-badge {
  display: inline-flex;
  align-items: center;
  gap: 4px;
  margin-left: 6px;
  padding: 2px 8px;
  font-size: 0.75rem;
  font-weight: 500;
  border-radius: 6px;
  background: #fff3cd;
  color: #92400e;
  border: 1px solid #fcd34d;
  white-space: nowrap;
}

.due-adjusted-badge i {
  font-size: 0.8rem;
}
  
</style>

<div class="dashboard-container content">
  <!-- Dashboard Filters -->
  <div class="dashboard-filters">
    <div class="dashboard-filters__group">
      <label class="dashboard-filters__label">Company:</label>
      <div class="company-dropdown-wrapper">
        <button type="button" class="company-dropdown-btn" id="company-dropdown-btn" onclick="toggleCompanyDropdown(event)">
          <span id="company-dropdown-text">
            <?php 
              $selectedCount = empty($selected_companies) ? count($companies) : count($selected_companies);
              $totalCount = count($companies);
              if ($selectedCount == $totalCount) {
                echo 'All Companies (' . $totalCount . ')';
              } elseif ($selectedCount == 0) {
                echo 'Select Companies...';
              } else {
                echo $selectedCount . ' of ' . $totalCount . ' Companies';
              }
            ?>
          </span>
          <i class="fa fa-chevron-down company-dropdown-arrow"></i>
        </button>
        <div class="company-dropdown-menu" id="company-dropdown-menu">
          <div class="company-dropdown-actions">
            <button type="button" class="company-action-btn" onclick="event.stopPropagation(); selectAllCompanies();">Select All</button>
            <button type="button" class="company-action-btn" onclick="event.stopPropagation(); deselectAllCompanies();">Clear All</button>
      </div>
          <div class="company-dropdown-list">
            <?php if (!empty($companies)): ?>
              <?php foreach ($companies as $company): 
                $isSelected = empty($selected_companies) || in_array($company['id'], $selected_companies);
              ?>
                <!--<label class="company-checkbox-item">
                  <input type="checkbox" class="company-checkbox" value="<?= $company['id'] ?>" <?= $isSelected ? 'checked' : '' ?>>
                  <span><?= htmlspecialchars($company['company_name']) ?></span>
                </label>-->

                <?php
                  $startYear = 2024; // default fallback

                  if (!empty($company['co_start_date']) && $company['co_start_date'] !== '0000-00-00') {
                      $ts = strtotime($company['co_start_date']);
                      if ($ts !== false) {
                          $startYear = date('Y', $ts);
                      }
                  }
                ?>
                <label class="company-checkbox-item">
                  <input type="checkbox" class="company-checkbox" value="<?= $company['id'] ?>" data-start-year="<?= $startYear ?>" <?= $isSelected ? 'checked' : '' ?>>
                  <span><?= htmlspecialchars($company['company_name']) ?></span>
                </label>
              <?php endforeach; ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <!-- Hidden select for form submission -->
      <select id="filter-company" class="dashboard-filters__select" multiple style="display: none;">
        <?php if (!empty($companies)): ?>
          <?php foreach ($companies as $company): 
            $isSelected = empty($selected_companies) || in_array($company['id'], $selected_companies);
          ?>
            <option value="<?= $company['id'] ?>" <?= $isSelected ? 'selected' : '' ?>><?= htmlspecialchars($company['company_name']) ?></option>
          <?php endforeach; ?>
        <?php endif; ?>
      </select>
  </div>

    <div class="dashboard-filters__group">
      <label class="dashboard-filters__label">Year: <?php echo $selected_year; ?></label>
        <select id="filter-year" class="dashboard-filters__select">
          <option value="all" <?= $selected_year === 'all' ? 'selected' : '' ?>>Select All</option>
          <?php 
              $currentYear = date('Y');
              for ($y = $currentYear; $y >= 2020; $y--): 
          ?>
              <option value="<?= $y ?>" <?= $selected_year == $y ? 'selected' : '' ?>><?= $y ?></option>
          <?php endfor; ?>
      </select>
    </div>

    <button type="button" class="dashboard-filters__btn" onclick="applyFilters()">
      <i class="fa fa-search"></i> Apply
    </button>
    
    <button type="button" class="dashboard-filters__btn dashboard-filters__btn--reset" onclick="resetFilters()">
      <i class="fa fa-undo"></i> Reset
    </button>
    
    <?php if (!$is_admin): ?>
    <div class="company-restriction-note">
      <i class="fa fa-info-circle"></i>
      Showing <?= count($companies) ?> assigned <?= count($companies) == 1 ? 'company' : 'companies' ?>
      </div>
    <?php endif; ?>
    
    <!--<div class="filter-tags" id="filter-tags">
       Active filter tags will appear here 
    </div>-->
  </div>

  <!-- Stats Cards -->
  <div class="stats-grid">
    <!-- Favourite Card -->
    <div class="stat-card stat-card--favourite active" data-tab="favourite">
      <div class="stat-card__icon">
        <i class="fa fa-star"></i>
      </div>
      <div class="stat-card__count" id="count-favourite"><?= isset($counts['favourites']) ? $counts['favourites'] : 0 ?></div>
      <div class="stat-card__label">Favourites</div>
      </div>

    <!-- Current Card -->
    <div class="stat-card stat-card--pending" data-tab="pending">
      <div class="stat-card__icon">
        <i class="fa fa-clock"></i>
    </div>
      <div class="stat-card__count" id="count-pending"><?= isset($counts['pending']) ? $counts['pending'] : 0 ?></div>
      <div class="stat-card__label">Current (<?= date('M Y') ?>)</div>
  </div>

    <!-- Overdue Card -->
    <div class="stat-card stat-card--overdue" data-tab="overdue">
      <div class="stat-card__icon">
        <i class="fa fa-exclamation-triangle"></i>
      </div>
      <div class="stat-card__count" id="count-overdue"><?= isset($counts['overdue']) ? $counts['overdue'] : 0 ?></div>
      <div class="stat-card__label">Overdue</div>
      </div>

    <!-- Upcoming Card -->
    <div class="stat-card stat-card--upcoming" data-tab="upcoming">
      <div class="stat-card__icon">
        <i class="fa fa-calendar-alt"></i>
    </div>
      <div class="stat-card__count" id="count-upcoming"><?= isset($counts['upcoming']) ? $counts['upcoming'] : 0 ?></div>
      <div class="stat-card__label">Upcoming (<?= date('M Y', strtotime('+1 month')) ?>)</div>
  </div>

    <!-- Uploaded Card -->
    <div class="stat-card stat-card--uploaded" data-tab="uploaded">
      <div class="stat-card__icon">
        <i class="fa fa-check-circle"></i>
      </div>
      <div class="stat-card__count" id="count-uploaded"><?= isset($counts['uploaded']) ? $counts['uploaded'] : 0 ?></div>
      <div class="stat-card__label">Completed</div>
      </div>
    </div>

  <!-- Tab Content Area -->
  <div class="tab-content-area">
    <!-- Tab Header -->
    <div class="tab-header tab-header--favourite" id="tab-header">
      <h3 id="tab-title">
        <i class="fa fa-star"></i>
        <span>Favourite Documents</span>
        <span class="tab-header__badge" id="tab-count"><?= isset($counts['favourites']) ? $counts['favourites'] : 0 ?> items</span>
      </h3>
      <div class="tab-actions">
        <button type="button" class="btn btn-reset-search" onclick="resetColumnSearch()" title="Reset Search">
          <i class="fa fa-undo"></i> Reset
        </button>
        <a href="javascript:void(0)" class="btn" id="export-excel-btn" onclick="exportCurrentTab()">
          <i class="fa fa-download"></i> Export Excel
        </a>
      </div>
    </div>

    <!-- Tab Body -->
    <div class="tab-body" id="tab-content">
      <!-- Uploaded Tab -->
      <div id="tab-uploaded" class="tab-pane" style="display:none;">
        <table class="data-table" id="uploaded-table">
          <thead>
            <tr>
              <th width="5%">#</th>
              <th width="11%" class="sortable" data-sort="company">Company</th>
              <th width="9%" class="sortable" data-sort="authority">Authority</th>
              <th width="14%" class="sortable" data-sort="dochead">Document Head</th>
              <th width="9%" class="sortable" data-sort="frequency">Frequency</th>
              <th width="9%" class="sortable sort-desc" data-sort="period">Period</th>
              <th width="10%" class="sortable" data-sort="uploaded">Uploaded</th>
              <th width="8%">Action</th>
            </tr>
            <tr class="column-search">
              <th></th>
              <th><input type="text" class="column-search-input" data-column="1" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="2" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="3" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="4" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="5" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="6" placeholder="Search..."></th>
              <th></th>
            </tr>
          </thead>
           <tbody>
            <?php if (!empty($lazy_loading)): ?>
              <!-- Lazy loading: Show loading placeholder -->
              <tr class="loading-row">
                <td colspan="8">
                  <div class="tab-loading">
                    <div class="spinner"></div>
                    <span style="margin-left: 10px;">Loading uploaded documents...</span>
                  </div>
                </td>
              </tr>
            <?php elseif (!empty($show_documents)): ?>
              <?php $i = 1; foreach ($show_documents as $row): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><span class="company-badge"><i class="fa fa-building"></i> <?= htmlspecialchars($row['company_name'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($row['authority_name'] ?? '') ?></td>
                  <td>
                    <strong><?= htmlspecialchars($row['type_name'] ?? '') ?></strong>
                    <br>
                    <small>
                      <span class="doc-count doc-count--uploaded"><?= $row['uploaded_count'] ?? 0 ?> uploaded</span>
                    </small>
                  </td>
                  <td><span class="frequency-badge"><?= htmlspecialchars($row['frequency'] ?? '') ?></span></td>
                  <td>
                    <?php 
                      $monthNum = (int)($row['document_month'] ?? 0);
                      $monthName = ($monthNum >= 1 && $monthNum <= 12) ? date("M", mktime(0, 0, 0, $monthNum, 1)) : '';
                    ?>
                    <span class="month-badge" style="background:#d1fae5; color:#059669;">
                      <?= $monthName ?> <?= $row['document_year'] ?? '' ?>
                    </span>
                  </td>
                  <td><?= !empty($row['uploaded_date']) ? date("d M Y", strtotime($row['uploaded_date'])) : '' ?></td>
                  <td>
                    <?php if (!empty($row['documents'])): ?>
                      <?php 
                        $monthNum = (int)($row['document_month'] ?? 1);
                        $monthName = date('F', mktime(0, 0, 0, $monthNum, 1));
                        $viewUrl = base_url('company/view_documents') . '/' . ($row['type_id'] ?? '') . '/' . ($row['company_id'] ?? '') . '/' . ($row['document_year'] ?? '') . '/' . $monthName;
                        $downloadUrl = base_url('company/download_month') . '/' . ($row['type_id'] ?? '') . '/' . ($row['company_id'] ?? '') . '/' . ($row['document_year'] ?? '') . '/' . $monthName;
                      ?>
                      <div class="action-dropdown">
                        <button class="action-dropdown__btn action-dropdown__btn--upcoming" onclick="toggleActionDropdown(this)">
                          <i class="fa fa-cog"></i> Action<i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
                        </button>
                        <div class="action-dropdown__menu">
                          <a href="<?= $viewUrl ?>" target="_blank" class="action-dropdown__item action-dropdown__item--view"><i class="fa fa-eye text-primary"></i> View</a>
                          <a href="<?= $downloadUrl ?>" class="action-dropdown__item action-dropdown__item--download"><i class="fa fa-download text-success"></i> Download</a>
                          <div class="action-dropdown__divider"></div>
                          <div class="action-dropdown__submenu-label">Share Documents</div>
                          <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail" onclick="handleUploadedNotification('mail', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $monthName ?>', '<?= $row['document_year'] ?? '' ?>', '<?= $row['type_id'] ?? '' ?>', '<?= $row['company_id'] ?? '' ?>')"><i class="fa fa-envelope"></i> Email</a>
                          <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp" onclick="handleUploadedNotification('whatsapp', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $monthName ?>', '<?= $row['document_year'] ?? '' ?>', '<?= $row['type_id'] ?? '' ?>', '<?= $row['company_id'] ?? '' ?>')"><i class="fab fa-whatsapp"></i> WhatsApp</a>
                        </div>
                      </div>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="8">
                  <div class="empty-state">
                    <i class="fa fa-folder-open"></i>
                    <p>No uploaded documents found</p>
                  </div>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- Favourite Tab (Default) -->
      <div id="tab-favourite" class="tab-pane">
        <table class="data-table" id="favourite-table">
          <thead>
            <tr>
              <th width="5%">#</th>
              <th width="12%" class="sortable" data-sort="company">Company</th>
              <th width="10%" class="sortable" data-sort="authority">Authority</th>
              <th width="12%" class="sortable" data-sort="dochead">Document Head</th>
              <th width="18%" class="sortable" data-sort="document">Document</th>
              <th width="8%" class="sortable" data-sort="frequency">Frequency</th>
              <th width="6%" class="sortable sort-desc" data-sort="period">Year</th>
              <th width="8%" class="sortable" data-sort="month">Month</th>
              <th width="11%">Action</th>
            </tr>
            <tr class="column-search">
              <th></th>
              <th><input type="text" class="column-search-input" data-column="1" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="2" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="3" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="4" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="5" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="6" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="7" placeholder="Search..."></th>
              <th></th>
            </tr>
          </thead>
          
          <tbody id="favourite-tbody">
            <?php if (!empty($favourites)): ?>
              <?php $i = 1; foreach ($favourites as $row): ?>
                <?php
                  $favMonthNum = (int)($row['document_month'] ?? 0);
                  $favMonthName = ($favMonthNum >= 1 && $favMonthNum <= 12) ? date("F", mktime(0, 0, 0, $favMonthNum, 1)) : '';
                  $favMonthShort = ($favMonthNum >= 1 && $favMonthNum <= 12) ? date("M", mktime(0, 0, 0, $favMonthNum, 1)) : '';
                  $favYear = $row['document_year'] ?? '';
                  $favTypeId = $row['type_id'] ?? '';
                  $favCompanyId = $row['company_id'] ?? '';
                  
                  // Build View and Download URLs for favourite
                  $favViewUrl = base_url('company/view_documents') . '/' . $favTypeId . '/' . $favCompanyId . '/' . $favYear . '/' . $favMonthName;
                  $favDownloadUrl = !empty($row['file_path']) ? base_url($row['file_path']) : '#';
                ?>
                <tr data-upload-id="<?= $row['upload_id'] ?>">
                  <td><?= $i++ ?></td>
                  <td><span class="company-badge"><i class="fa fa-building"></i> <?= htmlspecialchars($row['company_name'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($row['authority_name'] ?? '') ?></td>
                  <td><strong><?= htmlspecialchars($row['type_name'] ?? '') ?></strong></td>
                  <td><?= htmlspecialchars($row['document_name'] ?? '') ?></td>
                  <td><span class="frequency-badge"><?= htmlspecialchars($row['frequency'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($favYear) ?></td>
                  <td><?= $favMonthShort ?></td>
                  <td>
                    <div class="action-dropdown">
                      <button class="action-dropdown__btn action-dropdown__btn--info" onclick="toggleActionDropdown(this)">
                        <i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
                      </button>
                      <div class="action-dropdown__menu">
                        <?php if (!empty($row['file_path'])): ?>
                          <a href="<?= base_url($row['file_path']) ?>" target="_blank" class="action-dropdown__item action-dropdown__item--view">
                            <i class="fa fa-eye text-primary"></i> View
                          </a>
                          <a href="<?= base_url($row['file_path']) ?>" download class="action-dropdown__item action-dropdown__item--download">
                            <i class="fa fa-download text-success"></i> Download
                          </a>
                        <?php endif; ?>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--favourite fav-btn" data-upload-id="<?= $row['upload_id'] ?>">
                          <i class="fa fa-star text-warning"></i> Remove Favourite
                        </a>
                        <div class="action-dropdown__divider"></div>
                        <div class="action-dropdown__submenu-label">Share Documents</div>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail"
                           onclick="handleUploadedNotification('mail', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $favMonthName ?>', '<?= $favYear ?>', '<?= $favTypeId ?>', '<?= $favCompanyId ?>', '<?= $row['upload_id'] ?>')">
                          <i class="fa fa-envelope"></i> Email
                        </a>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp"
                           onclick="handleUploadedNotification('whatsapp', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $favMonthName ?>', '<?= $favYear ?>', '<?= $favTypeId ?>', '<?= $favCompanyId ?>', '<?= $row['upload_id'] ?>')">
                          <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                      </div>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="9">
                  <div class="empty-state">
                    <i class="fa fa-star"></i>
                    <p>No favourite documents yet. Click the star icon on any document to add it here.</p>
          </div>
                </td>
                  </tr>
            <?php endif; ?>
          </tbody>
        </table>
        </div>

      <!-- Pending Tab -->
      <div id="tab-pending" class="tab-pane" style="display:none;">
        <table class="data-table" id="pending-table">
          <thead>
            <tr>
              <th width="5%">#</th>
              <th width="11%" class="sortable" data-sort="company">Company</th>
              <th width="9%" class="sortable" data-sort="authority">Authority</th>
              <th width="14%" class="sortable" data-sort="dochead">Document Head</th>
              <th width="9%" class="sortable" data-sort="frequency">Frequency</th>
              <th width="9%" class="sortable" data-sort="period">Period</th>
              <th width="10%" class="sortable sort-asc" data-sort="due-date">Due Date</th>
              <th width="8%" class="sortable" data-sort="status">Status</th>
              <th width="10%">Action</th>
            </tr>
            <tr class="column-search">
              <th></th>
              <th><input type="text" class="column-search-input" data-column="1" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="2" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="3" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="4" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="5" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="6" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="7" placeholder="Search..."></th>
              <th></th>
            </tr>
          </thead>
          <tbody id="pending-tbody">
            <?php if (!empty($lazy_loading)): ?>
              <tr class="loading-row">
                <td colspan="9">
                  <div class="tab-loading">
                    <div class="spinner"></div>
                    <span style="margin-left: 10px;">Loading pending documents...</span>
                  </div>
                </td>
              </tr>
            <?php elseif (!empty($pending_documents)): ?>
              <?php $i = 1; foreach ($pending_documents as $row): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><span class="company-badge"><i class="fa fa-building"></i> <?= htmlspecialchars($row['company_name'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($row['authority_name'] ?? '') ?></td>
                  <td>
                    <strong><?= htmlspecialchars($row['type_name'] ?? '') ?></strong>
                    <br>
                    <small>
                      <span class="doc-count doc-count--uploaded"><?= $row['uploaded_count'] ?? 0 ?> uploaded</span>
                      <span class="doc-count doc-count--pending"><?= $row['pending_count'] ?? 0 ?> pending</span>
                    </small>
                  </td>
                  <td><span class="frequency-badge"><?= htmlspecialchars($row['frequency'] ?? 'Monthly') ?></span></td>
                  <td>
                    <?php 
                      $periodMonth = isset($row['doc_period_month']) ? (int)$row['doc_period_month'] : (int)date('n');
                      $periodYear = isset($row['doc_period_year']) ? $row['doc_period_year'] : date('Y');
                      $periodMonthName = ($periodMonth >= 1 && $periodMonth <= 12) ? date("M", mktime(0, 0, 0, $periodMonth, 1)) : '';
                    ?>
                    <span class="month-badge" style="background:#fef3c7; color:#d97706;">
                      <?= $periodMonthName ?> <?= $periodYear ?>
                    </span>
                  </td>
                  <td>
                    <?php 
                      // Calculate due month based on due_in_same_next_month
                      $dueInNext = isset($row['due_in_same_next_month']) && $row['due_in_same_next_month'] == 1;
                      if ($dueInNext) {
                        $dueMonth = $periodMonth + 1;
                        $dueYear = $periodYear;
                        if ($dueMonth > 12) { $dueMonth = 1; $dueYear++; }
                      } else {
                        $dueMonth = $periodMonth;
                        $dueYear = $periodYear;
                      }
                      $dueMonthName = date("M", mktime(0, 0, 0, $dueMonth, 1));
                    ?>
                    <?php
                      // Get adjusted due day if available
                      $displayDueDay = isset($row['adjusted_due_day']) ? $row['adjusted_due_day'] : ($row['due_day'] ?? '-');
                      $hasAdjustment = isset($row['adjusted_due_reason']) && !empty($row['adjusted_due_reason']);
                      $adjustReason = isset($row['adjusted_due_reason']) ? $row['adjusted_due_reason'] : '';
                    ?>
                    <div class="due-date" <?= $hasAdjustment ? 'title="Original: ' . ($row['due_day'] ?? '-') . '. ' . htmlspecialchars($adjustReason) . '"' : '' ?>>
                      <span class="due-date__day"><?= $displayDueDay ?></span>
                      <span><?= $dueMonthName ?> <?= $dueYear ?></span>
                      <?php if ($hasAdjustment): ?>
                        <i class="fa fa-info-circle text-warning" style="font-size:0.7rem; margin-left:3px;" title="<?= htmlspecialchars($adjustReason) ?>"></i>
                      <?php endif; ?>
                    </div>
                  </td>
                  <td><span class="status-badge status-badge--pending"><i class="fa fa-clock"></i> Pending</span></td>
                  <td>
                    <?php 
                      $uploadMonth = str_pad($row['doc_period_month'] ?? date('n'), 2, '0', STR_PAD_LEFT);
                      $uploadYear = $row['doc_period_year'] ?? date('Y');
                      $companyId = $row['company_id'] ?? '';
                      $authorityId = $row['authority_id'] ?? '';
                      $typeId = $row['type_id'] ?? '';
                      $pendingCount = $row['pending_count'] ?? 0;
                      $totalDocs = ($row['uploaded_count'] ?? 0) + $pendingCount;
                    ?>
                    <div class="action-dropdown">
                      <button class="action-dropdown__btn action-dropdown__btn--warning" onclick="toggleActionDropdown(this)">
                        <i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
                      </button>
                      <div class="action-dropdown__menu">
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" 
                           onclick="handleUploadClick(<?= $companyId ?>, <?= $authorityId ?>, <?= $typeId ?>, '<?= $uploadMonth ?>', <?= $uploadYear ?>, <?= $pendingCount ?>, <?= $totalDocs ?>)">
                          <i class="fa fa-upload"></i> Upload
                        </a>
                        <div class="action-dropdown__divider"></div>
                        <div class="action-dropdown__submenu-label">Send Notification</div>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail"
                           onclick="handleNotification('mail', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fa fa-envelope"></i> Mail
                        </a>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp"
                           onclick="handleNotification('whatsapp', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                      </div>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="9">
                  <div class="empty-state">
                    <i class="fa fa-check-circle"></i>
                    <p>All documents for this month are uploaded!</p>
        </div>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
      <!-- Overdue Tab -->
      <div id="tab-overdue" class="tab-pane" style="display:none;">
        <table class="data-table" id="overdue-table">
          <thead>
            <tr>
              <th width="5%">#</th>
              <th width="10%" class="sortable" data-sort="company">Company</th>
              <th width="9%" class="sortable" data-sort="authority">Authority</th>
              <th width="13%" class="sortable" data-sort="dochead">Document Head</th>
              <th width="9%" class="sortable" data-sort="frequency">Frequency</th>
              <th width="10%" class="sortable" data-sort="period">Period</th>
              <th width="11%" class="sortable sort-asc" data-sort="due-date">Due Date</th>
              <th width="9%" class="sortable" data-sort="status">Status</th>
              <th width="10%">Action</th>
            </tr>
            <tr class="column-search">
              <th></th>
              <th><input type="text" class="column-search-input" data-column="1" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="2" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="3" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="4" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="5" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="6" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="7" placeholder="Search..."></th>
              <th></th>
            </tr>
          </thead>
          <tbody id="overdue-tbody">
            <?php if (!empty($lazy_loading)): ?>
              <tr class="loading-row">
                <td colspan="9">
                  <div class="tab-loading">
                    <div class="spinner"></div>
                    <span style="margin-left: 10px;">Loading overdue documents...</span>
                  </div>
                </td>
              </tr>
            <?php elseif (!empty($overdue_documents)): ?>

              <?php $i = 1; foreach ($overdue_documents as $row): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><span class="company-badge"><i class="fa fa-building"></i> <?= htmlspecialchars($row['company_name'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($row['authority_name'] ?? '') ?></td>
                  <td>
                    <strong><?= htmlspecialchars($row['type_name'] ?? '') ?></strong>
                    <br>
                    <small>
                      <span class="doc-count doc-count--uploaded"><?= $row['uploaded_count'] ?? 0 ?> uploaded</span>
                      <span class="doc-count doc-count--pending"><?= $row['pending_count'] ?? 0 ?> pending</span>
                    </small>
                  </td>
                  <td><span class="frequency-badge"><?= htmlspecialchars($row['frequency'] ?? 'Monthly') ?></span></td>
                  <td>
                            <?php 
                      $overdueMonth = isset($row['overdue_month']) ? (int)$row['overdue_month'] : (int)date('n');
                      $overdueYear = isset($row['overdue_year']) ? $row['overdue_year'] : date('Y');
                      $monthName = ($overdueMonth >= 1 && $overdueMonth <= 12) ? date("M", mktime(0, 0, 0, $overdueMonth, 1)) : '';
                    ?>
                    <span class="month-badge" style="background:#fee2e2; color:#dc2626;">
                      <?= $monthName ?> <?= $overdueYear ?>
                    </span>
                  </td>
                  <td>
                    <?php 
                      // Calculate due month based on due_in_same_next_month
                      $dueInNext = isset($row['due_in_same_next_month']) && $row['due_in_same_next_month'] == 1;
                      if ($dueInNext) {
                        $dueMonth = $overdueMonth + 1;
                        $dueYear = $overdueYear;
                        if ($dueMonth > 12) { $dueMonth = 1; $dueYear++; }
                      } else {
                        $dueMonth = $overdueMonth;
                        $dueYear = $overdueYear;
                      }
                      $dueMonthName = date("M", mktime(0, 0, 0, $dueMonth, 1));
                    ?>
                    <?php
                      // Get adjusted due day if available for overdue
                      $displayDueDay = isset($row['adjusted_due_day']) ? $row['adjusted_due_day'] : ($row['due_day'] ?? '-');
                      $hasAdjustment = isset($row['adjusted_due_reason']) && !empty($row['adjusted_due_reason']);
                      $adjustReason = isset($row['adjusted_due_reason']) ? $row['adjusted_due_reason'] : '';
                    ?>
                    <div class="due-date" <?= $hasAdjustment ? 'title="Original: ' . ($row['due_day'] ?? '-') . '. ' . htmlspecialchars($adjustReason) . '"' : '' ?>>
                      <span class="due-date__day"><?= $displayDueDay ?></span>
                      <span><?= $dueMonthName ?> <?= $dueYear ?></span>
                      <?php if ($hasAdjustment): ?>
                        <i class="fa fa-info-circle text-warning" style="font-size:0.7rem; margin-left:3px;" title="<?= htmlspecialchars($adjustReason) ?>"></i>
                      <?php endif; ?>
                    </div>
                  </td>
                  <td><span class="status-badge status-badge--overdue"><i class="fa fa-exclamation-circle"></i> Overdue</span></td>
                          <td>
                          <?php 
                      $uploadMonth = str_pad($row['overdue_month'] ?? date('n'), 2, '0', STR_PAD_LEFT);
                      $uploadYear = $row['overdue_year'] ?? date('Y');
                      $companyId = $row['company_id'] ?? '';
                      $authorityId = $row['authority_id'] ?? '';
                      $typeId = $row['type_id'] ?? '';
                      $pendingCount = $row['pending_count'] ?? 0;
                      $totalDocs = ($row['uploaded_count'] ?? 0) + $pendingCount;
                    ?>
                    <div class="action-dropdown">
                      <button class="action-dropdown__btn action-dropdown__btn--danger" onclick="toggleActionDropdown(this)">
                        <i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
                      </button>
                      <div class="action-dropdown__menu">
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" 
                           onclick="handleUploadClick(<?= $companyId ?>, <?= $authorityId ?>, <?= $typeId ?>, '<?= $uploadMonth ?>', <?= $uploadYear ?>, <?= $pendingCount ?>, <?= $totalDocs ?>)">
                          <i class="fa fa-upload"></i> Upload
                        </a>
                        <div class="action-dropdown__divider"></div>
                        <div class="action-dropdown__submenu-label">Send Notification</div>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail"
                           onclick="handleNotification('mail', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fa fa-envelope"></i> Mail
                        </a>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp"
                           onclick="handleNotification('whatsapp', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                      </div>
                    </div>
                          </td>
                      </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="9">
                  <div class="empty-state">
                    <i class="fa fa-smile"></i>
                    <p>Great! No overdue documents.</p>
  </div>
                </td>
                  </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      
      <!-- Upcoming Tab -->
      <div id="tab-upcoming" class="tab-pane" style="display:none;">
        <table class="data-table" id="upcoming-table">
          <thead>
            <tr>
              <th width="5%">#</th>
              <th width="10%" class="sortable" data-sort="company">Company</th>
              <th width="9%" class="sortable" data-sort="authority">Authority</th>
              <th width="13%" class="sortable" data-sort="dochead">Document Head</th>
              <th width="9%" class="sortable" data-sort="frequency">Frequency</th>
              <th width="10%" class="sortable" data-sort="period">Period</th>
              <th width="11%" class="sortable sort-asc" data-sort="due-date">Due Date</th>
              <th width="9%" class="sortable" data-sort="status">Status</th>
              <th width="10%">Action</th>
            </tr>
            <tr class="column-search">
              <th></th>
              <th><input type="text" class="column-search-input" data-column="1" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="2" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="3" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="4" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="5" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="6" placeholder="Search..."></th>
              <th><input type="text" class="column-search-input" data-column="7" placeholder="Search..."></th>
              <th></th>
            </tr>
          </thead>
          <tbody id="upcoming-tbody">
            <?php if (!empty($lazy_loading)): ?>
              <tr class="loading-row">
                <td colspan="9">
                  <div class="tab-loading">
                    <div class="spinner"></div>
                    <span style="margin-left: 10px;">Loading upcoming documents...</span>
                  </div>
                </td>
              </tr>
            <?php elseif (!empty($upcoming_documents)): ?>
              <?php $i = 1; foreach ($upcoming_documents as $row): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><span class="company-badge"><i class="fa fa-building"></i> <?= htmlspecialchars($row['company_name'] ?? '') ?></span></td>
                  <td><?= htmlspecialchars($row['authority_name'] ?? '') ?></td>
                  <td>
                    <strong><?= htmlspecialchars($row['type_name'] ?? '') ?></strong>
                    <br>
                    <small>
                      <span class="doc-count doc-count--uploaded"><?= $row['uploaded_count'] ?? 0 ?> uploaded</span>
                      <span class="doc-count doc-count--pending"><?= $row['pending_count'] ?? 0 ?> pending</span>
                    </small>
                  </td>
                  <td><span class="frequency-badge"><?= htmlspecialchars($row['frequency'] ?? 'Monthly') ?></span></td>
                  <td>
                    <?php 
                      $upcomingPeriodMonth = isset($row['doc_period_month']) ? (int)$row['doc_period_month'] : (int)date('n', strtotime('+1 month'));
                      $upcomingPeriodYear = isset($row['doc_period_year']) ? $row['doc_period_year'] : date('Y', strtotime('+1 month'));
                      $upcomingMonthName = ($upcomingPeriodMonth >= 1 && $upcomingPeriodMonth <= 12) ? date("M", mktime(0, 0, 0, $upcomingPeriodMonth, 1)) : '';
                    ?>
                    <span class="month-badge" style="background:#dbeafe; color:#2563eb;">
                      <?= $upcomingMonthName ?> <?= $upcomingPeriodYear ?>
                    </span>
                  </td>
                  <td>
                    <?php 
                      // Calculate due month based on due_in_same_next_month
                      $dueInNext = isset($row['due_in_same_next_month']) && $row['due_in_same_next_month'] == 1;
                      if ($dueInNext) {
                        $dueMonth = $upcomingPeriodMonth + 1;
                        $dueYear = $upcomingPeriodYear;
                        if ($dueMonth > 12) { $dueMonth = 1; $dueYear++; }
                      } else {
                        $dueMonth = $upcomingPeriodMonth;
                        $dueYear = $upcomingPeriodYear;
                      }
                      $dueMonthName = date("M", mktime(0, 0, 0, $dueMonth, 1));
                    ?>
                    <?php
                      // Get adjusted due day if available for upcoming
                      $displayDueDay = isset($row['adjusted_due_day']) ? $row['adjusted_due_day'] : ($row['due_day'] ?? '-');
                      $hasAdjustment = isset($row['adjusted_due_reason']) && !empty($row['adjusted_due_reason']);
                      $adjustReason = isset($row['adjusted_due_reason']) ? $row['adjusted_due_reason'] : '';
                    ?>
                    <div class="due-date due-date--upcoming" <?= $hasAdjustment ? 'title="Original: ' . ($row['due_day'] ?? '-') . '. ' . htmlspecialchars($adjustReason) . '"' : '' ?>>
                      <span class="due-date__day"><?= $displayDueDay ?></span>
                      <span><?= $dueMonthName ?> <?= $dueYear ?></span>
                      <?php if ($hasAdjustment): ?>
                        <i class="fa fa-info-circle text-warning" style="font-size:0.7rem; margin-left:3px;" title="<?= htmlspecialchars($adjustReason) ?>"></i>
                      <?php endif; ?>
                    </div>
                  </td>
                  <td><span class="status-badge status-badge--upcoming"><i class="fa fa-calendar"></i> Upcoming</span></td>
                  <td>
                    <?php 
                      $uploadMonth = str_pad($row['doc_period_month'] ?? $upcomingPeriodMonth, 2, '0', STR_PAD_LEFT);
                      $uploadYear = $row['doc_period_year'] ?? $upcomingPeriodYear;
                      $companyId = $row['company_id'] ?? '';
                      $authorityId = $row['authority_id'] ?? '';
                      $typeId = $row['type_id'] ?? '';
                      $pendingCount = $row['pending_count'] ?? 0;
                      $totalDocs = ($row['uploaded_count'] ?? 0) + $pendingCount;
                    ?>
                    <div class="action-dropdown">
                      <button class="action-dropdown__btn action-dropdown__btn--pending" onclick="toggleActionDropdown(this)">
                        <i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
                      </button>
                      <div class="action-dropdown__menu">
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" 
                           onclick="handleUploadClick(<?= $companyId ?>, <?= $authorityId ?>, <?= $typeId ?>, '<?= $uploadMonth ?>', <?= $uploadYear ?>, <?= $pendingCount ?>, <?= $totalDocs ?>, 'upcoming')">
                          <i class="fa fa-upload"></i> Upload
                        </a>
                        <div class="action-dropdown__divider"></div>
                        <div class="action-dropdown__submenu-label">Send Notification</div>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail"
                           onclick="handleNotification('mail', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fa fa-envelope"></i> Mail
                        </a>
                        <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp"
                           onclick="handleNotification('whatsapp', '<?= htmlspecialchars($row['type_name'] ?? '') ?>', '<?= htmlspecialchars($row['company_name'] ?? '') ?>', '<?= $uploadMonth ?>', '<?= $uploadYear ?>', '<?= $typeId ?>', '<?= $companyId ?>', '<?= $authorityId ?>')">
                          <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
      </div>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="9">
                  <div class="empty-state">
                    <i class="fa fa-calendar-check"></i>
                    <p>No upcoming documents for next month.</p>
                  </div>
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  </div>

<script>

function calculateDayDifference(dueDateStr) {
  const today = new Date();
  today.setHours(0,0,0,0);

  const dueDate = new Date(dueDateStr);
  dueDate.setHours(0,0,0,0);

  const diffMs = dueDate - today;
  return Math.ceil(diffMs / (1000 * 60 * 60 * 24));
}

// Track current active tab for export (global scope)
var currentActiveTab = 'favourite';

$(document).ready(function() {
  const baseUrl = '<?= base_url() ?>';
  
  // Tab configurations
  const tabConfig = {
    favourite: {
      icon: 'fa-star',
      title: 'Favourite Documents',
      color: '#f59e0b'
    },
    pending: {
      icon: 'fa-clock',
      title: 'Current Documents (<?= date("M Y") ?>)',
      color: '#6366f1'
    },
    overdue: {
      icon: 'fa-exclamation-triangle',
      title: 'Overdue Documents',
      color: '#ef4444'
    },
    upcoming: {
      icon: 'fa-calendar-alt',
      title: 'Upcoming Documents (<?= date("M Y", strtotime("+1 month")) ?>)',
      color: '#10b981'
    },
    uploaded: {
      icon: 'fa-check-circle',
      title: 'Completed Documents',
      color: '#3b82f6'
    }
  };
  
  // Track which tabs have been loaded (for lazy loading)
  const loadedTabs = { favourite: true }; // Favourite is loaded by default
  
  // Handle stat card clicks
  $('.stat-card').on('click', function() {
    const tab = $(this).data('tab');
    currentActiveTab = tab;
    
    // Update active state
    $('.stat-card').removeClass('active');
    $(this).addClass('active');
    
    // Update header with tab-specific color
    const config = tabConfig[tab];
    $('#tab-header')
      .removeClass('tab-header--favourite tab-header--pending tab-header--overdue tab-header--upcoming tab-header--uploaded')
      .addClass('tab-header--' + tab);
    
    $('#tab-title').html(`
      <i class="fa ${config.icon}"></i>
      <span>${config.title}</span>
      <span class="tab-header__badge" id="tab-count">${$('#count-' + tab).text()} items</span>
    `);
    
    // Show/hide tab panes
    $('.tab-pane').hide();
    $('#tab-' + tab).show();
    
    // Reset column search when switching tabs
    resetColumnSearch();
    
    // Lazy load tab data if not already loaded
    if (!loadedTabs[tab]) {
      loadTabData(tab);
    } else {
      // Apply default sorting for each tab
      applyDefaultSorting(tab);
    }
  });
  
  // Lazy load tab data via AJAX
  function loadTabData(tab) {
    const selectedYear = '<?= $selected_year ?? date("Y") ?>';
    const selectedCompanies = '<?= is_array($selected_companies ?? null) ? implode(",", $selected_companies) : "" ?>';
    
    $.ajax({
      url: baseUrl + 'dashboard/getTabData',
      type: 'POST',
      data: { 
        tab: tab,
        year: selectedYear,
        companies: selectedCompanies
      },
      dataType: 'json',
      success: function(response) {
        if (response.success) {
          loadedTabs[tab] = true;
          renderTabData(tab, response.data);
          applyDefaultSorting(tab);
        } else {
          showEmptyState(tab, response.message || 'Failed to load data');
        }
      },
      error: function() {
        showEmptyState(tab, 'Error loading data. Please try again.');
      }
    });
  }
  
  // Render tab data based on tab type
  function renderTabData(tab, data) {
    const tbodyId = '#' + tab + '-tbody';
    let $tbody = $(tbodyId);
    
    // For uploaded tab, tbody doesn't have an id, find it differently
    if (tab === 'uploaded') {
      $tbody = $('#uploaded-table tbody');
    }
    
    if (!$tbody.length) return;
    
    $tbody.empty();
    
    if (!data || data.length === 0) {
      showEmptyState(tab);
      return;
    }
    
    // Render based on tab type
    if (tab === 'uploaded') {
      renderUploadedTab($tbody, data);
    } else if (tab === 'pending') {
      renderPendingTab($tbody, data);
    } else if (tab === 'overdue') {
      renderOverdueTab($tbody, data);
    } else if (tab === 'upcoming') {
      renderUpcomingTab($tbody, data);
    }
  }
  
  function showEmptyState(tab, message) {
    const tbodyId = tab === 'uploaded' ? '#uploaded-table tbody' : '#' + tab + '-tbody';
    const $tbody = $(tbodyId);
    const emptyMessages = {
      uploaded: 'No uploaded documents found',
      pending: 'All documents for this month are uploaded!',
      overdue: 'No overdue documents. Great job!',
      upcoming: 'No upcoming documents for next month'
    };
    const icons = {
      uploaded: 'fa-folder-open',
      pending: 'fa-check-circle',
      overdue: 'fa-thumbs-up',
      upcoming: 'fa-calendar-check'
    };
    
    $tbody.html(`
      <tr>
        <td colspan="9">
          <div class="empty-state">
            <i class="fa ${icons[tab] || 'fa-folder-open'}"></i>
            <p>${message || emptyMessages[tab] || 'No data found'}</p>
          </div>
        </td>
      </tr>
    `);
  }
  
  // Render functions for each tab type
  function renderUploadedTab($tbody, data) {
    let html = '';
    data.forEach((row, index) => {
      const monthNum = parseInt(row.document_month) || 0;
      const periodMonth = parseInt(row.document_month) || 0;
      const periodYear  = parseInt(row.document_year) || 0;
      const monthName = monthNum >= 1 && monthNum <= 12 ? new Date(2000, monthNum - 1, 1).toLocaleString('en', {month: 'short'}) : '';
      const monthNameFull = monthNum >= 1 && monthNum <= 12 ? new Date(2000, monthNum - 1, 1).toLocaleString('en', {month: 'long'}) : '';
      const viewUrl = baseUrl + 'company/view_documents/' + (row.type_id || '') + '/' + (row.company_id || '') + '/' + (row.document_year || '') + '/' + monthNameFull;
      const downloadUrl = baseUrl + 'company/download_month/' + (row.type_id || '') + '/' + (row.company_id || '') + '/' + (row.document_year || '') + '/' + monthNameFull;
      const uploadedDate = row.uploaded_date ? new Date(row.uploaded_date).toLocaleDateString('en-GB', {day: '2-digit', month: 'short', year: 'numeric'}) : '';
      
      html += `<tr>
        <td>${index + 1}</td>
        <td><span class=""><i class="fa fa-building"></i> ${escapeHtml(row.company_name || '')}</span></td>
        <td>${escapeHtml(row.authority_name || '')}</td>
        <td><strong>${escapeHtml(row.type_name || '')}</strong><br><small><span class="doc-count doc-count--uploaded">${row.uploaded_count || 0} uploaded</span></small></td>
        <td><span class="frequency-badge">${escapeHtml(row.frequency || '')}</span></td>
        <td data-sort-date="${periodYear}-${String(periodMonth).padStart(2,'0')}-01"><span class="month-badge" style="background:#d1fae5; color:#059669;">${monthName} ${row.document_year || ''}</span></td>
        <td>${uploadedDate}</td>
         <td>
            <div class="action-dropdown">
              <button class="action-dropdown__btn action-dropdown__btn--upcoming"
                onclick="toggleActionDropdown(this)">
                <i class="fa fa-cog"></i> Action
                <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i>
              </button>

              <div class="action-dropdown__menu">
                <a href="${viewUrl}" target="_blank" class="action-dropdown__item action-dropdown__item action-dropdown__item--view">
                  <i class="fa fa-eye text-primary"></i> View
                </a>

                <a href="${downloadUrl}" class="action-dropdown__item action-dropdown__item action-dropdown__item--download">
                  <i class="fa fa-download text-success"></i> Download
                </a>

                <div class="action-dropdown__divider"></div>
                <div class="action-dropdown__submenu-label">Share Documents</div>

                <a href="javascript:void(0)"
                  class="action-dropdown__item action-dropdown__item--mail"
                  onclick="handleUploadedNotification(
                    'mail',
                    '${escapeHtml(row.type_name || '')}',
                    '${escapeHtml(row.company_name || '')}',
                    '${monthNameFull}',
                    '${row.document_year}',
                    '${row.type_id}',
                    '${row.company_id}'
                  )">
                  <i class="fa fa-envelope"></i> Email
                </a>

                <a href="javascript:void(0)"
                  class="action-dropdown__item action-dropdown__item--whatsapp"
                  onclick="handleUploadedNotification(
                    'whatsapp',
                    '${escapeHtml(row.type_name || '')}',
                    '${escapeHtml(row.company_name || '')}',
                    '${monthNameFull}',
                    '${row.document_year}',
                    '${row.type_id}',
                    '${row.company_id}'
                  )">
                  <i class="fab fa-whatsapp"></i> WhatsApp
                </a>
              </div>
            </div>
          </td>
        </tr>`;
    });
    $tbody.html(html);
  }
  
  function renderPendingTab($tbody, data) {
    let html = '';
    data.forEach((row, index) => {
      const periodMonth = parseInt(row.doc_period_month) || parseInt(new Date().getMonth() + 1);
      const periodYear = row.doc_period_year || new Date().getFullYear();
      const periodMonthName = new Date(2000, periodMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const dueInNext = row.due_in_same_next_month == 1;
      let dueMonth = periodMonth, dueYear = periodYear;
      if (dueInNext) { dueMonth++; if (dueMonth > 12) { dueMonth = 1; dueYear++; } }
      const dueMonthName = new Date(2000, dueMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const displayDueDay = row.adjusted_due_day || row.due_day || '-';
      const uploadMonth = String(periodMonth).padStart(2, '0');
      
      const dueDateStr = `${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}`;
      const diffDays = calculateDayDifference(dueDateStr);

      let daysHtml = '';
      if (diffDays >= 0) {
        daysHtml = `<span class="days-badge days-badge--remaining">Due in ${diffDays} days</span>`;
      }

      const adjustReason = row.adjusted_due_reason || '';
      const isPublicHolidayAdjustment = adjustReason && !/sunday/i.test(adjustReason);
      const adjustedBadgeHtml = isPublicHolidayAdjustment
      ? `<span class="due-adjusted-badge" title="${escapeHtml(adjustReason)}">
          <i class="fa fa-info-circle"></i>
        </span>`
      : '';
      
      html += `<tr>
        <td>${index + 1}</td>
        <td><span class="company-badge"><i class="fa fa-building"></i> ${escapeHtml(row.company_name || '')}</span></td>
        <td>${escapeHtml(row.authority_name || '')}</td>
        <td><strong>${escapeHtml(row.type_name || '')}</strong><br><small><span class="doc-count doc-count--uploaded">${row.uploaded_count || 0} uploaded</span> <span class="doc-count doc-count--pending">${row.pending_count || 0} pending</span></small></td>
        <td><span class="frequency-badge">${escapeHtml(row.frequency || 'Monthly')}</span></td>
        <td data-sort-date="${periodYear}-${String(periodMonth).padStart(2,'0')}-01"><span class="month-badge" style="background:#fef3c7; color:#d97706;">${periodMonthName} ${periodYear}</span></td>
        <td data-sort-date="${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}">
          <div class="due-date">
            <span class="due-date__day">${displayDueDay}</span><span>${dueMonthName} ${dueYear}
            </span>
            ${adjustedBadgeHtml}
          </div></td>
        <td>
          <div class="status-wrapper">
            <span class="status-badge status-badge--pending"><i class="fa fa-clock"></i> <span class="status-text">Pending</span></span>
            ${diffDays >= 0 ? `<div class="status-days">${diffDays} Days</div>` : ''}
          </div>
        </td>
        <td>
          <div class="action-dropdown">
            <button class="action-dropdown__btn action-dropdown__btn--warning" onclick="toggleActionDropdown(this)"><i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i></button>
            <div class="action-dropdown__menu">
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" onclick="handleUploadClick(${row.company_id}, ${row.authority_id || 0}, ${row.type_id}, '${uploadMonth}', ${periodYear}, ${row.pending_count || 0}, ${(row.uploaded_count || 0) + (row.pending_count || 0)})"><i class="fa fa-upload"></i> Upload</a>
              <div class="action-dropdown__divider"></div>
              <div class="action-dropdown__submenu-label">Send Notification</div>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail" 
              onclick="handleNotification('mail', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${periodYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}','${displayDueDay}','${dueMonth}','${dueYear}','${escapeHtml(adjustReason)}')"><i class="fa fa-envelope"></i> Mail</a>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp" onclick="handleNotification('whatsapp', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${periodYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}')"><i class="fab fa-whatsapp"></i> WhatsApp</a>
            </div>
          </div>
        </td>
      </tr>`;
    });
    $tbody.html(html);
  }
  
  function renderOverdueTab($tbody, data) {
    let html = '';
    data.forEach((row, index) => {
      const overdueMonth = parseInt(row.overdue_month) || parseInt(new Date().getMonth() + 1);
      const overdueYear = row.overdue_year || new Date().getFullYear();
      const overdueMonthName = new Date(2000, overdueMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const dueInNext = row.due_in_same_next_month == 1;
      const periodMonth = parseInt(row.document_month) || 0;
      const periodYear  = parseInt(row.document_year) || 0;
      let dueMonth = overdueMonth, dueYear = overdueYear;
      if (dueInNext) { dueMonth++; if (dueMonth > 12) { dueMonth = 1; dueYear++; } }
      const dueMonthName = new Date(2000, dueMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const displayDueDay = row.adjusted_due_day || row.due_day || '-';
      const uploadMonth = String(overdueMonth).padStart(2, '0');

      const dueDateStr = `${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}`;
      const diffDays = calculateDayDifference(dueDateStr);

      const overdueDays = Math.abs(diffDays);

      const daysHtml = `
        <span class="days-badge days-badge--overdue">
          ${overdueDays} days overdue
        </span>
      `;

      const adjustReason = row.adjusted_due_reason || '';
      const isPublicHolidayAdjustment = adjustReason && !/sunday/i.test(adjustReason);
      const adjustedBadgeHtml = isPublicHolidayAdjustment
      ? `<span class="due-adjusted-badge" title="${escapeHtml(adjustReason)}">
          <i class="fa fa-info-circle"></i>
        </span>`
      : '';

      html += `<tr>
        <td>${index + 1}</td>
        <td><span class="company-badge"><i class="fa fa-building"></i> ${escapeHtml(row.company_name || '')}</span></td>
        <td>${escapeHtml(row.authority_name || '')}</td>
        <td><strong>${escapeHtml(row.type_name || '')}</strong><br><small><span class="doc-count doc-count--uploaded">${row.uploaded_count || 0} uploaded</span> <span class="doc-count doc-count--pending">${row.pending_count || 0} pending</span></small></td>
        <td><span class="frequency-badge">${escapeHtml(row.frequency || 'Monthly')}</span></td>
        <td data-sort-date="${overdueYear}-${String(overdueMonth).padStart(2,'0')}-01"><span class="month-badge" style="background:#fee2e2; color:#dc2626;">${overdueMonthName} ${overdueYear}</span></td>
        <td data-sort-date="${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}">
          <div class="due-date">
            <span class="due-date__day">${displayDueDay}</span><span>${dueMonthName} ${dueYear}</span>
            ${adjustedBadgeHtml}
          </div>
        </td>
        <td>
          <div class="status-wrapper">
            <span class="status-badge status-badge--overdue"><i class="fa fa-exclamation-triangle"></i> <span class="status-text">Overdue</span></span>
            <div class="status-days">${overdueDays} Days</div>
          </div>
        </td>
        <td>
          <div class="action-dropdown">
            <button class="action-dropdown__btn action-dropdown__btn--danger" onclick="toggleActionDropdown(this)"><i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i></button>
            <div class="action-dropdown__menu">
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" onclick="handleUploadClick(${row.company_id}, ${row.authority_id || 0}, ${row.type_id}, '${uploadMonth}', ${overdueYear}, ${row.pending_count || 0}, ${(row.uploaded_count || 0) + (row.pending_count || 0)})"><i class="fa fa-upload"></i> Upload</a>
              <div class="action-dropdown__divider"></div>
              <div class="action-dropdown__submenu-label">Send Notification</div>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail" onclick="handleNotification('mail', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${overdueYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}','${displayDueDay}','${String(dueMonth).padStart(2, '0')}','${dueYear}','${escapeHtml(adjustReason)}')"><i class="fa fa-envelope"></i> Mail</a>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp" onclick="handleNotification('whatsapp', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${overdueYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}')"><i class="fab fa-whatsapp"></i> WhatsApp</a>
            </div>
          </div>
        </td>
      </tr>`;
    });
    $tbody.html(html);
  }
  
  function renderUpcomingTab($tbody, data) {
    let html = '';
    data.forEach((row, index) => {
      const periodMonth = parseInt(row.doc_period_month) || parseInt(new Date().getMonth() + 2);
      const periodYear = row.doc_period_year || new Date().getFullYear();
      const periodMonthName = new Date(2000, periodMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const dueInNext = row.due_in_same_next_month == 1;
      let dueMonth = periodMonth, dueYear = periodYear;
      if (dueInNext) { dueMonth++; if (dueMonth > 12) { dueMonth = 1; dueYear++; } }
      const dueMonthName = new Date(2000, dueMonth - 1, 1).toLocaleString('en', {month: 'short'});
      const displayDueDay = row.adjusted_due_day || row.due_day || '-';
      const uploadMonth = String(periodMonth).padStart(2, '0');
      
      const dueDateStr = `${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}`;
      const diffDays = calculateDayDifference(dueDateStr);

      const adjustReason = row.adjusted_due_reason || '';
      const isPublicHolidayAdjustment = adjustReason && !/sunday/i.test(adjustReason);
      const adjustedBadgeHtml = isPublicHolidayAdjustment
      ? `<span class="due-adjusted-badge" title="${escapeHtml(adjustReason)}">
          <i class="fa fa-info-circle"></i>
        </span>`
      : '';

      html += `<tr>
        <td>${index + 1}</td>
        <td><span class="company-badge"><i class="fa fa-building"></i> ${escapeHtml(row.company_name || '')}</span></td>
        <td>${escapeHtml(row.authority_name || '')}</td>
        <td><strong>${escapeHtml(row.type_name || '')}</strong><br><small><span class="doc-count doc-count--uploaded">${row.uploaded_count || 0} uploaded</span> <span class="doc-count doc-count--pending">${row.pending_count || 0} pending</span></small></td>
        <td><span class="frequency-badge">${escapeHtml(row.frequency || 'Monthly')}</span></td>
        <td><span class="month-badge" style="background:#d1fae5; color:#059669;">${periodMonthName} ${periodYear}</span></td>
        <td data-sort-date="${dueYear}-${String(dueMonth).padStart(2,'0')}-${String(displayDueDay).padStart(2,'0')}"><div class="due-date"><span class="due-date__day">${displayDueDay}</span><span>${dueMonthName} ${dueYear}</span></div></td>
        <td>
          <div class="status-wrapper">
            <span class="status-badge status-badge--upcoming"><i class="fa fa-calendar-alt"></i> <span class="status-text">Upcoming</span></span>
            ${diffDays >= 0 ? `<div class="status-days status-days--upcoming">${diffDays} Days</div>` : ''}
            ${adjustedBadgeHtml}
          </div>
        </td>
        <td>
          <div class="action-dropdown">
            <button class="action-dropdown__btn action-dropdown__btn--pending" onclick="toggleActionDropdown(this)"><i class="fa fa-cog"></i> Action <i class="fa fa-chevron-down" style="font-size:0.6rem;"></i></button>
            <div class="action-dropdown__menu">
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--upload" onclick="handleUploadClick(${row.company_id}, ${row.authority_id || 0}, ${row.type_id}, '${uploadMonth}', ${periodYear}, ${row.pending_count || 0}, ${(row.uploaded_count || 0) + (row.pending_count || 0)}, 'upcoming')"><i class="fa fa-upload"></i> Upload</a>
              <div class="action-dropdown__divider"></div>
              <div class="action-dropdown__submenu-label">Send Notification</div>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--mail" onclick="handleNotification('mail', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${periodYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}','${displayDueDay}','${dueMonth}','${dueYear}','${escapeHtml(adjustReason)}')"><i class="fa fa-envelope"></i> Mail</a>
              <a href="javascript:void(0)" class="action-dropdown__item action-dropdown__item--whatsapp" onclick="handleNotification('whatsapp', '${escapeHtml(row.type_name || '')}', '${escapeHtml(row.company_name || '')}', '${uploadMonth}', '${periodYear}', '${row.type_id}', '${row.company_id}', '${row.authority_id || ''}')"><i class="fab fa-whatsapp"></i> WhatsApp</a>
            </div>
          </div>
        </td>
      </tr>`;
    });
    $tbody.html(html);
  }
  
  // Helper function to escape HTML
  function escapeHtml(text) {
    if (!text) return '';
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
  }
  
  // Apply default sorting based on tab
  function applyDefaultSorting(tab) {
    const tableId = '#' + tab + '-table';
    const $table = $(tableId);
    if (!$table.length) return;
    
    // Clear existing sort indicators
    $table.find('th.sortable').removeClass('sort-asc sort-desc');
    
    // Default sorting configuration per tab
    const sortConfig = {
      favourite: { column: 'period', order: 'desc' },      // Month/Year new to old
      pending: { column: 'due-date', order: 'asc' },       // Due date old to new
      overdue: { column: 'due-date', order: 'asc' },       // Due date old to new
      upcoming: { column: 'due-date', order: 'asc' },      // Due date old to new
      uploaded: { column: 'period', order: 'desc' }        // Period/uploaded date new to old
    };
    
    const config = sortConfig[tab];
    if (config) {
      const $th = $table.find('th[data-sort="' + config.column + '"]');
      if ($th.length) {
        $th.addClass(config.order === 'asc' ? 'sort-asc' : 'sort-desc');
        sortTable(tableId, $th.index(), config.order);
      }
    }
  }
  
  $(document).on('click', '.fav-btn', function (e) {
  e.preventDefault();

  const btn = $(this);
  const uploadId = btn.data('upload-id');
  if (!uploadId) return;

  // Find row (normal or floating dropdown)
  const $row =
    btn.closest('tr').length
      ? btn.closest('tr')
      : $('#floating-action-menu').data('source-row');

  // Show confirmation dialog
  Swal.fire({
    title: 'Remove from Favourites?',
    text: 'Are you sure you want to remove this document from favourites?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#f59e0b',
    cancelButtonColor: '#6b7280',
    confirmButtonText: '<i class="fa fa-star"></i> Yes, Remove',
    cancelButtonText: 'Cancel'
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: baseUrl + 'dashboard/toggleFavourite',
        type: 'POST',
        data: { upload_id: uploadId },
        dataType: 'json',
        success: function (response) {
          if (!response || !response.success) return;

          /* 🔥 1. REMOVE row from Favourite tab instantly */
          if ($row && $row.length) {
            $row.fadeOut(250, function () {
              $(this).remove();

              const remainingRows = $('#favourite-tbody tr[data-upload-id]').length;

              if (remainingRows === 0) {
                renderFavouriteEmptyState();
              }
            });
          }

          /* 🔥 2. Update favourite count */
          const $count = $('#count-favourite');
          const current = parseInt($count.text()) || 0;
          $count.text(Math.max(0, current - 1));

          /* 🔥 3. Update star icon everywhere (Uploaded / Pending / etc.) */
          $('.fav-btn[data-upload-id="' + uploadId + '"]')
            .removeClass('active')
            .find('i')
            .removeClass('fa-star')
            .addClass('fa-star-o');

          /* 🔥 4. Close floating menu */
          $('#floating-action-menu').remove();
          $('.action-dropdown').removeClass('open');

          // Show success toast
          Swal.fire({
            icon: 'success',
            title: 'Removed!',
            text: 'Document removed from favourites.',
            timer: 1500,
            showConfirmButton: false
          });
        },
        error: function () {
          Swal.fire('Error', 'Failed to remove favourite', 'error');
        }
      });
    }
  });
});

  
  // Auto-refresh of counts disabled - counts are loaded with page filters
  // If needed, manually refresh the page to update counts
  
  // Close dropdowns when clicking outside
  $(document).on('click', function(e) {
    if (!$(e.target).closest('.action-dropdown').length && !$(e.target).closest('#floating-action-menu').length) {
      $('.action-dropdown').removeClass('open');
      $('#floating-action-menu').remove();
    }
  });
  
  // Close floating menu when clicking an item
  $(document).on('click', '#floating-action-menu .action-dropdown__item', function() {
    $('#floating-action-menu').remove();
    $('.action-dropdown').removeClass('open');
  });
  
  // Initialize sortable headers
  $(document).on('click', '.data-table th.sortable', function() {
    const $th = $(this);
    const $table = $th.closest('table');
    const colIndex = $th.index();
    
    // Toggle sort direction
    let order = 'asc';
    if ($th.hasClass('sort-asc')) {
      order = 'desc';
    } else if ($th.hasClass('sort-desc')) {
      order = 'asc';
    }
    
    // Clear other column sorts
    $table.find('th.sortable').removeClass('sort-asc sort-desc');
    $th.addClass(order === 'asc' ? 'sort-asc' : 'sort-desc');
    
    // Sort the table
    sortTable('#' + $table.attr('id'), colIndex, order);
  });
  
  // Apply default sorting on page load for favourite tab
  applyDefaultSorting('favourite');
});

// Reset column search for current tab
function resetColumnSearch() {
  $('.column-search-input').val('');
  $('.data-table tbody tr').removeClass('hidden-row').show();

  // Reset sorting to tab default
  resetSortingToDefault(currentActiveTab);
}

function resetSortingToDefault(tab) {
  const tableId = '#' + tab + '-table';
  const $table = $(tableId);

  if (!$table.length) return;

  // Remove all sort arrows
  $table.find('th.sortable').removeClass('sort-asc sort-desc');

  // 🔥 Your exact defaults
  const defaults = {
    favourite: { sort: 'period',   order: 'desc' }, // Year ↓
    pending:   { sort: 'due-date', order: 'asc'  }, // Due Date ↑
    overdue:   { sort: 'due-date', order: 'asc'  }, // Due Date ↑
    upcoming:  { sort: 'due-date', order: 'asc'  }, // Due Date ↑
    uploaded:  { sort: 'period',   order: 'desc' }  // Period ↓
  };

  const cfg = defaults[tab];
  if (!cfg) return;

  const $th = $table.find(`th[data-sort="${cfg.sort}"]`);
  if (!$th.length) return;

  // Restore arrow direction
  $th.addClass(cfg.order === 'asc' ? 'sort-asc' : 'sort-desc');

  // Re-sort rows
  sortTable(tableId, $th.index(), cfg.order);
}

// Sort table function
function sortTable(tableId, colIndex, order) {

  const $table = $(tableId);
  const $tbody = $table.find('tbody');
  const rows = $tbody.find('tr').toArray();
  
  rows.sort(function (a, b) {

    const $aCell = $(a).find('td').eq(colIndex);
    const $bCell = $(b).find('td').eq(colIndex);

    // 🔥 1. If data-sort-date exists → use it (Due Date columns)
    const aSortDate = $aCell.data('sort-date');
    const bSortDate = $bCell.data('sort-date');

    if (aSortDate && bSortDate) {
      const aTime = new Date(aSortDate).getTime();
      const bTime = new Date(bSortDate).getTime();
      return order === 'asc' ? aTime - bTime : bTime - aTime;
    }

    // 🔁 2. Fallback to text sorting (other columns)
    const aText = $aCell.text().trim().toLowerCase();
    const bText = $bCell.text().trim().toLowerCase();

    // Numeric comparison
    const aNum = parseFloat(aText.replace(/[^0-9.-]/g, ''));
    const bNum = parseFloat(bText.replace(/[^0-9.-]/g, ''));

    if (!isNaN(aNum) && !isNaN(bNum)) {
      return order === 'asc' ? aNum - bNum : bNum - aNum;
    }

    // String comparison
    return order === 'asc'
      ? aText.localeCompare(bText)
      : bText.localeCompare(aText);
    });
  
  $tbody.append(rows);
}

// Parse date from table cell text
/*function parseTableDate(text) {
  // Try various date formats: "30 Jan 2025", "7th March 2025", "Jan 2025", etc.
  const months = ['jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec'];
  const monthsFull = ['january', 'february', 'march', 'april', 'may', 'june', 'july', 'august', 'september', 'october', 'november', 'december'];
  
  const lowerText = text.toLowerCase().replace(/(\d+)(st|nd|rd|th)/gi, '$1'); // Remove ordinal suffixes
  
  // First, try to extract day if present (e.g., "30 Jan 2025", "7 March 2025")
  let day = 1;
  const dayMatch = lowerText.match(/^(\d{1,2})\s/);
  if (dayMatch) {
    day = parseInt(dayMatch[1]);
  }
  
  // Also try to find day after month (e.g., "Jan 30 2025")
  const dayAfterMonthMatch = lowerText.match(/[a-z]+\s+(\d{1,2})\s+\d{4}/i);
  if (dayAfterMonthMatch) {
    day = parseInt(dayAfterMonthMatch[1]);
  }
  
  for (let i = 0; i < months.length; i++) {
    if (lowerText.includes(months[i]) || lowerText.includes(monthsFull[i])) {
      const yearMatch = text.match(/\d{4}/);
      if (yearMatch) {
        return new Date(parseInt(yearMatch[0]), i, day);
      }
    }
  }
  
  // Try DD/MM/YYYY or MM/DD/YYYY
  const dateMatch = text.match(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})/);
  if (dateMatch) {
    return new Date(dateMatch[3], dateMatch[2] - 1, dateMatch[1]);
  }
  
  // Try YYYY-MM-DD format
  const isoMatch = text.match(/(\d{4})-(\d{2})-(\d{2})/);
  if (isoMatch) {
    return new Date(isoMatch[1], isoMatch[2] - 1, isoMatch[3]);
  }
  
  return null;
}*/

// Export current tab to Excel
function exportCurrentTab() {
  const tab = currentActiveTab || 'favourite';
  // Get actual selected company name from session/page
  const companyName = '<?= addslashes($company_name ?? "Company") ?>';
  // Get selected year from filter
  const selectedYear = document.getElementById('filter-year') ? document.getElementById('filter-year').value : '<?= date("Y") ?>';
  
  // Build export URL with tab, company and year parameters
  const exportUrl = '<?= base_url("dashboard/export_documents_excel") ?>?tab=' + tab + 
    '&company=' + encodeURIComponent(companyName) + 
    '&year=' + encodeURIComponent(selectedYear);
  
  window.location.href = exportUrl;
}

// Toggle action dropdown - using fixed position popup
function toggleActionDropdown(btn) {
  event.stopPropagation();
  
  // Remove any existing floating menu
  $('#floating-action-menu').remove();
  
  const $btn = $(btn);
  const $dropdown = $btn.closest('.action-dropdown');
  const $menu = $dropdown.find('.action-dropdown__menu');

  const $row = $btn.closest('tr');
  
  // If already open, just close it
  if ($dropdown.hasClass('open')) {
    $dropdown.removeClass('open');
    return;
  }
  
  // Close other dropdowns
  $('.action-dropdown').removeClass('open');
  
  // Clone the menu and append to body with fixed positioning
  const $floatingMenu = $menu.clone().attr('id', 'floating-action-menu');

  if ($row.length) {
    $floatingMenu.data('source-row', $row); // 🔥 safe & optional
  }

  $('body').append($floatingMenu);
  
  // Get button position
  const btnRect = btn.getBoundingClientRect();
  const menuHeight = 180; // approximate menu height
  const viewportHeight = window.innerHeight;
  const spaceBelow = viewportHeight - btnRect.bottom;
  
  // Position the floating menu
  let top, left;
  left = btnRect.right - 180; // align right edge with button
  if (left < 10) left = 10;
  
  if (spaceBelow < menuHeight) {
    // Open upward
    top = btnRect.top - menuHeight - 5;
  } else {
    // Open downward
    top = btnRect.bottom + 5;
  }
  
  $floatingMenu.css({
    position: 'fixed',
    top: top + 'px',
    left: left + 'px',
    opacity: 1,
    visibility: 'visible',
    transform: 'none',
    zIndex: 99999,
    background: '#fff',
    borderRadius: '8px',
    boxShadow: '0 10px 40px rgba(0,0,0,0.2)',
    minWidth: '180px'
  });
  
  $dropdown.addClass('open');
}

// Handle upload click with confirmation - uses plain URL (encryption disabled for now)
function handleUploadClick(companyId, authorityId, typeId, month, year, pendingCount, totalDocs, sourceTab = '') {
  // Close dropdown
  $('.action-dropdown').removeClass('open');
  $('#floating-action-menu').remove();
  
  // For upcoming documents, only allow upload if it's the current month
  if (sourceTab === 'upcoming') {
    const currentMonth = new Date().getMonth() + 1; // JS months are 0-indexed
    const currentYear = new Date().getFullYear();
    const uploadMonth = parseInt(month);
    const uploadYear = parseInt(year);
    
    // Allow upload only if the period is current month or past (not future months)
    if (uploadYear > currentYear || (uploadYear === currentYear && uploadMonth > currentMonth)) {
      const monthNames = ['', 'January', 'February', 'March', 'April', 'May', 'June', 
                          'July', 'August', 'September', 'October', 'November', 'December'];
      const periodMonthName = monthNames[uploadMonth] || 'Unknown';
      const currentMonthName = monthNames[currentMonth];
      
      Swal.fire({
        title: 'Document Not Due Yet',
        html: `<p>This document is scheduled for <strong>${periodMonthName} ${uploadYear}</strong>.</p>
               <p>You can only upload documents for the current month (<strong>${currentMonthName} ${currentYear}</strong>) or earlier periods.</p>`,
        icon: 'warning',
        confirmButtonColor: '#f59e0b',
        confirmButtonText: 'OK, Got it'
      });
      return;
    }
  }
  
  // Plain URL with all parameters
  const uploadUrl = '<?= base_url('upload/index/') ?>' + companyId + 
    '?authority_id=' + authorityId + 
    '&type_id=' + typeId + 
    '&month=' + month + 
    '&year=' + year + 
    '&readonly=1&from=dashboard';
  
  console.log('Upload URL:', uploadUrl);
  
  // If all documents are already uploaded
  if (pendingCount === 0) {
    Swal.fire({
      title: 'All Documents Uploaded',
      text: 'All ' + totalDocs + ' documents are already uploaded. Do you still want to continue?',
      icon: 'info',
      showCancelButton: true,
      confirmButtonColor: '#3b82f6',
      cancelButtonColor: '#6b7280',
      confirmButtonText: 'Yes, Continue',
      cancelButtonText: 'No, Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        showLoader();
        window.location.href = uploadUrl;
      }
    });
  } else {
    // Redirect directly
    showLoader();
    window.location.href = uploadUrl;
  }
}

// Handle notification (Mail/WhatsApp)
//function handleNotification(type, typeName, companyName, month, year, typeId, companyId, authorityId) {
  function handleNotification(
  type,
  typeName,
  companyName,
  month,
  year,
  typeId,
  companyId,
  authorityId,
  dueDay = null,
  dueMonth = null,
  dueYear = null,
  adjustReason = ''
) {
// Close dropdown
  $('.action-dropdown').removeClass('open');
  $('#floating-action-menu').remove();
  
  const dueReason = adjustReason || '';
  const baseUrl = '<?= base_url() ?>';
  const monthNames = ['', 'January', 'February', 'March', 'April', 'May', 'June', 
                      'July', 'August', 'September', 'October', 'November', 'December'];
  const monthName = monthNames[parseInt(month)] || month;
  
  // Build upload URL with auth check
  const uploadUrl = baseUrl + 'upload/index/' + companyId + 
    '?authority_id=' + authorityId + 
    '&type_id=' + typeId + 
    '&month=' + month + 
    '&year=' + year +
    '&readonly=1&from=notification';
  
  if (type === 'mail') {
    // Show email dialog
    Swal.fire({
      title: 'Send Email Notification',
      html: `
        <div style="text-align: left;">
          <p style="margin-bottom: 15px; color: #666;">
            Send a reminder email for <strong>${typeName}</strong> - ${monthName} ${year}
          </p>
          <div style="margin-bottom: 10px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500;">Recipient Email:</label>
            <input type="email" id="swal-recipient" class="swal2-input" placeholder="Enter email address" style="margin: 0; width: 100%;">
      </div>
      </div>
      `,
      icon: 'info',
      showCancelButton: true,
      confirmButtonColor: '#3b82f6',
      cancelButtonColor: '#6b7280',
      confirmButtonText: '<i class="fa fa-paper-plane"></i> Send Email',
      cancelButtonText: 'Cancel',
      showLoaderOnConfirm: true,
      preConfirm: () => {
        const recipient = document.getElementById('swal-recipient').value;
        if (!recipient) {
          Swal.showValidationMessage('Please enter an email address');
          return false;
        }
        if (!recipient.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
          Swal.showValidationMessage('Please enter a valid email address');
          return false;
        }
        
        // Send email via AJAX
        return $.ajax({
          url: baseUrl + 'dashboard/sendNotificationEmail',
          type: 'POST',
          data: {
            recipient: recipient,
            type_name: typeName,
            company_name: companyName,
            month: month,
            year: year,
            type_id: typeId,
            company_id: companyId,
            authority_id: authorityId,
            due_day: dueDay,
            due_month: dueMonth,
            due_year: dueYear,
            due_reason: dueReason
          },
          dataType: 'json',
          timeout: 30000  // 30 second timeout
        }).then(response => {
          if (!response.success) {
            Swal.showValidationMessage(response.message || 'Failed to send email');
            return false;
          }
          return response;
        }).catch(error => {
          console.error('Email AJAX Error:', error);
          Swal.showValidationMessage('Network error or server timeout. Please try again.');
          return false;
        });
      },
      allowOutsideClick: true
    }).then((result) => {
      if (result.isConfirmed && result.value) {
        Swal.fire({
          icon: 'success',
          title: 'Email Sent!',
          text: result.value.message,
          confirmButtonColor: '#10b981'
        });
      }
    });
  } else if (type === 'whatsapp') {
    // WhatsApp - show phone number input
    Swal.fire({
      title: 'Send WhatsApp Message',
      html: `
        <div style="text-align: left;">
          <p style="margin-bottom: 15px; color: #666;">
            Send a reminder for <strong>${typeName}</strong> - ${monthName} ${year}
          </p>
          <div style="margin-bottom: 10px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500;">Phone Number (with country code):</label>
            <input type="tel" id="swal-phone" class="swal2-input" placeholder="e.g., 919876543210" style="margin: 0; width: 100%;">
    </div>
</div>
      `,
      icon: 'info',
      showCancelButton: true,
      confirmButtonColor: '#25D366',
      cancelButtonColor: '#6b7280',
      confirmButtonText: '<i class="fab fa-whatsapp"></i> Send WhatsApp',
      cancelButtonText: 'Cancel',
      preConfirm: () => {
        const phone = document.getElementById('swal-phone').value.replace(/\D/g, '');
        if (!phone) {
          Swal.showValidationMessage('Please enter a phone number');
          return false;
        }
        if (phone.length < 10) {
          Swal.showValidationMessage('Please enter a valid phone number with country code');
          return false;
        }
        return phone;
      }
    }).then((result) => {
      if (result.isConfirmed && result.value) {
        const phone = result.value;
        const whatsappText = '*Document Pending: ' + typeName + ' - ' + monthName + ' ' + year + '*\n\n' +
          'Company: ' + companyName + '\n' +
          'Document Head: ' + typeName + '\n' +
          'Period: ' + monthName + ' ' + year + '\n\n' +
          'Please upload the documents using this link:\n' + uploadUrl;
        
        // Open WhatsApp with phone number
        const whatsappUrl = 'https://wa.me/' + phone + '?text=' + encodeURIComponent(whatsappText);
        window.open(whatsappUrl, '_blank');
      }
    });
  }
}

// ===== Dashboard Filter Functions =====

function applyFilters() {
  const selectedCompanies = Array.from(document.getElementById('filter-company').selectedOptions)
    .map(opt => opt.value);
  const selectedYear = document.getElementById('filter-year').value;
  
  // Show loading
  showLoader();
  
  // Get encrypted URL from server
  $.ajax({
    url: '<?= base_url('dashboard/getEncryptedUrl') ?>',
    type: 'POST',
    data: {
      companies: selectedCompanies.join(','),
      year: selectedYear
    },
    dataType: 'json',
    success: function(response) {
      if (response.success && response.url) {
        window.location.href = response.url;
      } else {
        hideLoader();
        alert('Error generating secure URL');
      }
    },
    error: function() {
      hideLoader();
      alert('Error connecting to server');
    }
  });
}

function resetFilters() {
  // Select all companies
  const companySelect = document.getElementById('filter-company');
  const allCompanyIds = [];
  for (let opt of companySelect.options) {
    opt.selected = true;
    allCompanyIds.push(opt.value);
  }
  
  // Reset to current year
  const currentYear = new Date().getFullYear();
  document.getElementById('filter-year').value = currentYear;
  
  // Show loading
  showLoader();
  
  // Get encrypted URL for reset state
  $.ajax({
    url: '<?= base_url('dashboard/getEncryptedUrl') ?>',
    type: 'POST',
    data: {
      companies: allCompanyIds.join(','),
      year: currentYear
    },
    dataType: 'json',
    success: function(response) {
      if (response.success && response.url) {
        window.location.href = response.url;
      } else {
        hideLoader();
        window.location.href = '<?= base_url('dashboard/dashboard') ?>';
      }
    },
    error: function() {
      hideLoader();
      window.location.href = '<?= base_url('dashboard/dashboard') ?>';
    }
  });
}

// Initialize filter display
$(document).ready(function() {
  // Initialize company dropdown checkboxes
  $('.company-checkbox').on('change', function() {
    syncCompanySelection();
    updateCompanyDropdownText();
    //updateFilterTags();
  });
  
  // Close dropdown when clicking outside
  document.addEventListener('click', function(e) {
    var wrapper = document.querySelector('.company-dropdown-wrapper');
    if (wrapper && !wrapper.contains(e.target)) {
      wrapper.classList.remove('open');
    }
  });
  
  //updateFilterTags();
  
  // Update filter tags when year changes
  $('#filter-year').on('change', function() {
    //updateFilterTags();
  });
});

// Toggle company dropdown
function toggleCompanyDropdown(event) {
  if (event) {
    event.stopPropagation();
  }
  var wrapper = document.querySelector('.company-dropdown-wrapper');
  if (wrapper) {
    wrapper.classList.toggle('open');
  }
}

// Sync checkboxes with hidden select
function syncCompanySelection() {
  $('#filter-company option').each(function() {
    const value = $(this).val();
    const isChecked = $('.company-checkbox[value="' + value + '"]').prop('checked');
    $(this).prop('selected', isChecked);
  });
}

// Update dropdown button text
function updateCompanyDropdownText() {
  const totalCompanies = $('.company-checkbox').length;
  const selectedCount = $('.company-checkbox:checked').length;
  
  let text = '';
  if (selectedCount === 0) {
    text = 'Select Companies...';
  } else if (selectedCount === totalCompanies) {
    text = 'All Companies (' + totalCompanies + ')';
  } else {
    text = selectedCount + ' of ' + totalCompanies + ' Companies';
  }
  
  $('#company-dropdown-text').text(text);
}

// Quick select functions
function selectAllCompanies() {
  $('.company-checkbox').prop('checked', true);
  syncCompanySelection();
  updateCompanyDropdownText();
  //updateFilterTags();
}

function deselectAllCompanies() {
  $('.company-checkbox').prop('checked', false);
  syncCompanySelection();
  updateCompanyDropdownText();
  //updateFilterTags();
}

/*function updateFilterTags() {
  const tagsContainer = document.getElementById('filter-tags');
  tagsContainer.innerHTML = '';
  
  // Get selected companies
  const companySelect = document.getElementById('filter-company');
  const totalCompanies = companySelect.options.length;
  const selectedCompanies = Array.from(companySelect.selectedOptions);
  
  // Only show company tags if not all are selected
  if (selectedCompanies.length > 0 && selectedCompanies.length < totalCompanies) {
    if (selectedCompanies.length <= 2) {
      // Show individual company names
      selectedCompanies.forEach(opt => {
        tagsContainer.innerHTML += `
          <span class="filter-tag">
            <i class="fa fa-building"></i> ${opt.text}
            <span class="filter-tag__remove" onclick="removeCompanyFilter('${opt.value}')">&times;</span>
          </span>
        `;
      });
    } else {
      // Show count
      tagsContainer.innerHTML += `
        <span class="filter-tag">
          <i class="fa fa-building"></i> ${selectedCompanies.length} companies selected
        </span>
      `;
    }
  }
  
  // Show year tag if different from current year or if "all" is selected
  const yearSelect = document.getElementById('filter-year');
  const currentYear = new Date().getFullYear();
  if (yearSelect.value === 'all') {
    tagsContainer.innerHTML += `
      <span class="filter-tag filter-tag--info">
        <i class="fa fa-calendar"></i> All Years
        <span class="filter-tag__remove" onclick="resetYearFilter()">&times;</span>
      </span>
    `;
  } else if (yearSelect.value != currentYear) {
    tagsContainer.innerHTML += `
      <span class="filter-tag">
        <i class="fa fa-calendar"></i> ${yearSelect.value}
        <span class="filter-tag__remove" onclick="resetYearFilter()">&times;</span>
      </span>
    `;
  }
}*/

function removeCompanyFilter(companyId) {
  // Uncheck the checkbox
  $('.company-checkbox[value="' + companyId + '"]').prop('checked', false);
  // Sync with hidden select
  syncCompanySelection();
  updateCompanyDropdownText();
  //updateFilterTags();
}

function resetYearFilter() {
  document.getElementById('filter-year').value = new Date().getFullYear();
  //updateFilterTags();
}

function updateYearDropdown() {
    const yearSelect = document.getElementById('filter-year');
    const checkedCompanies = document.querySelectorAll('.company-checkbox:checked');
    const currentYear = new Date().getFullYear();

    let startYear;

    if (checkedCompanies.length === 1) {
        // ✅ Single company → use its co_start_date year
        startYear = parseInt(checkedCompanies[0].dataset.startYear);
    } else {
        // ✅ Multiple or zero companies → fixed start year 2024
        startYear = 2024;
    }

    // Safety fallback
    if (!startYear || startYear > currentYear) {
        startYear = currentYear;
    }

    const selectedValue = yearSelect.value;

    // Rebuild year dropdown with "All Years" option
    yearSelect.innerHTML = '';
    
    // Add "All Years" option first
    const allOpt = document.createElement('option');
    allOpt.value = 'all';
    allOpt.textContent = 'All Years';
    yearSelect.appendChild(allOpt);
    
    // Add individual year options
    for (let y = currentYear; y >= startYear; y--) {
        const opt = document.createElement('option');
        opt.value = y;
        opt.textContent = y;
        yearSelect.appendChild(opt);
    }

    // Preserve selected year if still valid
    if (selectedValue === 'all') {
        yearSelect.value = 'all';
    } else if (selectedValue >= startYear && selectedValue <= currentYear) {
        yearSelect.value = selectedValue;
    }
}

// 🔁 Update when company selection changes
document.addEventListener('change', function (e) {
    if (e.target.classList.contains('company-checkbox')) {
        updateYearDropdown();
    }
});

// 🔥 Initial load
updateYearDropdown();

// ======== Dashboard Action Dropdown ========
$(document).on('click', '.action-btn--menu', function(e) {
    e.stopPropagation();
    const wrapper = $(this).closest('.action-dropdown-wrapper');
    
    // Close all other dropdowns
    $('.action-dropdown-wrapper').not(wrapper).removeClass('open');
    
    // Toggle this dropdown
    wrapper.toggleClass('open');
});

// Close dropdown when clicking outside
$(document).on('click', function(e) {
    if (!$(e.target).closest('.action-dropdown-wrapper').length) {
        $('.action-dropdown-wrapper').removeClass('open');
    }
});

// Handle notification for uploaded documents
// uploadId is optional - if provided, only that specific document will be attached
function handleUploadedNotification(type, typeName, companyName, monthName, year, typeId, companyId, uploadId = null) {
  // Close dropdown
  $('.action-dropdown').removeClass('open');
  $('#floating-action-menu').remove();
  
  const baseUrl = '<?= base_url() ?>';
  
  if (type === 'mail') {
    // Show email dialog
    Swal.fire({
      title: '<i class="fa fa-envelope text-info"></i> Share Documents',
      html: `
        <div class="text-start">
          <p class="mb-3 text-muted">Share Documents <strong>${companyName}</strong></p>
          <div class="mb-3">
            <label class="form-label fw-bold">Subject</label>
            <input type="text" id="email-subject" class="form-control" value="Document Shared: ${companyName} - ${typeName} - ${monthName} ${year}" style="width: 100%;">
          </div>
          <div class="mb-3">
            <label class="form-label fw-bold">Recipient Email</label>
            <input type="email" id="email-recipient" class="form-control" placeholder="Enter email address" style="width: 100%;">
          </div>
          <div class="mb-3">
            <label class="form-label fw-bold">Additional Message (Optional)</label>
            <textarea id="email-message" class="form-control" rows="3" placeholder="Add any additional notes..." style="width: 100%;"></textarea>
          </div>
        </div>
      `,
      showCancelButton: true,
      confirmButtonText: '<i class="fa fa-paper-plane"></i> Send Email',
      confirmButtonColor: '#3b82f6',
      cancelButtonText: 'Cancel',
      width: '450px',
      preConfirm: () => {
        const recipient = document.getElementById('email-recipient').value;
        const subject = document.getElementById('email-subject').value;
        const message = document.getElementById('email-message').value;
        
        if (!recipient) {
          Swal.showValidationMessage('Please enter recipient email');
          return false;
        }
        if (!recipient.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
          Swal.showValidationMessage('Please enter a valid email address');
          return false;
        }
        
        return { recipient, subject, message };
      }
    }).then((result) => {
      if (result.isConfirmed) {
        // Show loading popup
        Swal.fire({
          title: 'Sending Email...',
          html: '<div class="d-flex flex-column align-items-center"><i class="fa fa-spinner fa-spin fa-3x mb-3" style="color: #3b82f6;"></i><p class="mb-0">Please wait while we send your email.</p></div>',
          allowOutsideClick: false,
          allowEscapeKey: false,
          showConfirmButton: false
        });
        
        // Build data object
        const data = {
          company_id: companyId,
          type_id: typeId,
          month: monthName,
          year: year,
          recipient: result.value.recipient,
          subject: result.value.subject,
          message: result.value.message
        };
        
        // Add upload_id if sending specific document
        if (uploadId) {
          data.upload_id = uploadId;
        }
        
        // Send email via AJAX
        $.ajax({
          url: baseUrl + 'dashboard/send_reminder_email',
          type: 'POST',
          data: data,
          dataType: 'json',
          success: function(response) {
            if (response.success) {
              Swal.fire({
                icon: 'success',
                title: 'Email Sent!',
                text: response.message || 'Email has been sent successfully.'
              });
            } else {
              Swal.fire({
                icon: 'error',
                title: 'Failed',
                text: response.message || 'Failed to send email.'
              });
            }
          },
          error: function() {
            Swal.fire({
              icon: 'error',
              title: 'Error',
              text: 'Failed to send email.'
            });
          }
        });
      }
    });
  } else if (type === 'whatsapp') {
    // WhatsApp - show phone number input
    Swal.fire({
      title: 'Send WhatsApp Message',
      html: `
        <div style="text-align: left;">
          <p style="margin-bottom: 15px; color: #666;">
            Send a message for <strong>${typeName}</strong> - ${monthName} ${year}
          </p>
          <div style="margin-bottom: 10px;">
            <label style="display: block; margin-bottom: 5px; font-weight: 500;">Phone Number (with country code):</label>
            <input type="tel" id="swal-phone" class="swal2-input" placeholder="e.g., 919876543210" style="margin: 0; width: 100%;">
          </div>
        </div>
      `,
      icon: 'info',
      showCancelButton: true,
      confirmButtonColor: '#25D366',
      cancelButtonColor: '#6b7280',
      confirmButtonText: '<i class="fab fa-whatsapp"></i> Send WhatsApp',
      cancelButtonText: 'Cancel',
      preConfirm: () => {
        const phone = document.getElementById('swal-phone').value.replace(/\D/g, '');
        if (!phone) {
          Swal.showValidationMessage('Please enter a phone number');
          return false;
        }
        if (phone.length < 10) {
          Swal.showValidationMessage('Please enter a valid phone number with country code');
          return false;
        }
        return phone;
      }
    }).then((result) => {
      if (result.isConfirmed && result.value) {
        const phone = result.value;
        const whatsappText = '*Document: ' + typeName + ' - ' + monthName + ' ' + year + '*\n\n' +
          'Company: ' + companyName + '\n' +
          'Document Head: ' + typeName + '\n' +
          'Period: ' + monthName + ' ' + year + '\n\n' +
          'Documents have been uploaded for this period.';
        
        // Open WhatsApp with phone number
        const whatsappUrl = 'https://wa.me/' + phone + '?text=' + encodeURIComponent(whatsappText);
        window.open(whatsappUrl, '_blank');
      }
    });
  }
}

// ======== Dashboard Notification Handlers ========
$(document).on('click', '.dashboard-notify', function(e) {
    e.preventDefault();
    
    const $this = $(this);
    const type = $this.data('type');
    const company = $this.data('company');
    const dochead = $this.data('dochead');
    const month = $this.data('month');
    const year = $this.data('year');
    const companyId = $this.data('company-id');
    const typeId = $this.data('type-id');
    
    // Close the dropdown
    $('.action-dropdown-wrapper').removeClass('open');
    
    const subject = `${dochead} - ${month} ${year}`;
    
    if (type === 'email') {
        Swal.fire({
            title: '<i class="fa fa-envelope text-info"></i> Send Reminder',
            html: `
                <div class="text-start">
                    <p class="mb-3 text-muted">Send reminder for <strong>${company}</strong></p>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Subject</label>
                        <input type="text" id="email-subject" class="form-control" value="${subject}" style="width: 100%;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Recipient Email</label>
                        <input type="email" id="email-recipient" class="form-control" placeholder="Enter email address" style="width: 100%;">
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Additional Message (Optional)</label>
                        <textarea id="email-message" class="form-control" rows="3" placeholder="Add any additional notes..." style="width: 100%;"></textarea>
                    </div>
                </div>
            `,
            showCancelButton: true,
            confirmButtonText: '<i class="fa fa-paper-plane"></i> Send Email',
            confirmButtonColor: '#3b82f6',
            cancelButtonText: 'Cancel',
            width: '450px',
            preConfirm: () => {
                const recipient = document.getElementById('email-recipient').value;
                const subject = document.getElementById('email-subject').value;
                const message = document.getElementById('email-message').value;
                
                if (!recipient) {
                    Swal.showValidationMessage('Please enter recipient email');
                    return false;
                }
                
                return { recipient, subject, message };
            }
        }).then((result) => {
            if (result.isConfirmed) {
                // Send email via AJAX
                $.ajax({
                    url: baseUrl + 'dashboard/send_reminder_email',
                    type: 'POST',
                    data: {
                        company_id: companyId,
                        type_id: typeId,
                        month: month,
                        year: year,
                        recipient: result.value.recipient,
                        subject: result.value.subject,
                        message: result.value.message
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Email Sent!',
                                text: 'Reminder email has been sent successfully.',
                                timer: 2000,
                                showConfirmButton: false
                            });
                        } else {
                            Swal.fire('Error', response.message || 'Failed to send email', 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'Failed to send email', 'error');
                    }
                });
            }
        });
    } else if (type === 'whatsapp') {
        const message = `Reminder: ${subject}\nCompany: ${company}\nPlease review the uploaded documents.`;
        const whatsappUrl = `https://wa.me/?text=${encodeURIComponent(message)}`;
        window.open(whatsappUrl, '_blank');
    }
});

// Column-wise search functionality
function initColumnSearch(tableId) {
    const $table = $('#' + tableId);
    if (!$table.length) return;
    
    $table.find('.column-search-input').on('keyup change', function() {
        const $inputs = $table.find('.column-search-input');
        const $rows = $table.find('tbody tr');
        
        $rows.each(function() {
            const $row = $(this);
            let show = true;
            
            $inputs.each(function() {
                const col = parseInt($(this).data('column'), 10);
                const searchVal = $(this).val().toLowerCase().trim();
                
                if (searchVal) {
                    const cellText = $row.find('td').eq(col).text().toLowerCase();
                    if (cellText.indexOf(searchVal) === -1) {
                        show = false;
                        return false; // break the loop
                    }
                }
            });
            
            if (show) {
                $row.removeClass('hidden-row');
            } else {
                $row.addClass('hidden-row');
            }
        });
        
        // Update visible row numbers
        let visibleIndex = 1;
        $rows.not('.hidden-row').each(function() {
            $(this).find('td').first().text(visibleIndex++);
        });
    });
}

// Initialize column search for all tables
$(document).ready(function() {
    initColumnSearch('uploaded-table');
    initColumnSearch('favourite-table');
    initColumnSearch('pending-table');
    initColumnSearch('overdue-table');
    initColumnSearch('upcoming-table');
});

function renderFavouriteEmptyState() {
  $('#favourite-tbody').html(`
    <tr>
      <td colspan="9">
        <div class="empty-state">
          <i class="fa fa-star"></i>
          <p>No favourite documents yet. Click the star icon on any document to add it here.</p>
        </div>
      </td>
    </tr>
  `);
}

</script>
