<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<style>
.doc-list {
  background: #fff;
  border-radius: 0.5rem;
  padding: 1rem;
  margin-bottom: .75rem;
  box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}
</style>
<div class="content">
	<div class="card shadow-sm rounded-4">
		<div class="card-body">
			
			<div class="row mb-3">
				
				<div class="col-md-3">
					<select id="year" class="form-select" name="year">
						<option value="">Select Year</option>
						<?php 
							$currentYear = date('Y');
							for ($y = $currentYear; $y >= $currentYear - 5; $y--): 
								$selected = ($y == $currentYear) ? 'selected' : '';
						?>
							<option value="<?= $y ?>" <?= $selected ?>><?= $y ?></option>
						<?php endfor; ?>
					</select>
				</div>
				<div class="col-md-3">
					<select id="month" class="form-select" name="month">
						<option value="">Select Month</option>
						<?php 
							$currentMonth = date('m'); // e.g., "10"
							for ($m = 1; $m <= 12; $m++): 
								$monthNum = str_pad($m, 2, '0', STR_PAD_LEFT); // "01", "02", ...
								$monthName = date('F', mktime(0, 0, 0, $m, 10)); // "January", "February", ...
								$selected = ($monthNum == $currentMonth) ? 'selected' : '';
						?>
							<option value="<?= $monthNum ?>" <?= $selected ?>><?= $monthName ?></option>
						<?php endfor; ?>
					</select>
				</div>
				<div class="col-md-3">
					<button id="filterBtn" class="btn btn-primary">Filter</button>
				</div>
				<div class="col-md-3" style="text-align:right;">
					<div class="formbtn-group">
						<a href="<?= base_url('company/reminderSent') ?>" class="formbtn formbtn-cancel">View Sent Reminders</a>
					</div>
				</div>
			</div>

			<div id="tableContainer">
				<?php $this->load->view('company/missing_docs_table', ['companyData' => $companyData]); ?>
			</div>
		</div>
	</div>
</div>

<script>
$(document).ready(function() {
	$('#filterBtn').click(function() {
		let month = $('#month').val();
		let year = $('#year').val();
		let user_id = <?= $this->uri->segment(3); ?>; // assuming URL: /upload/reminder/{user_id}

		$.ajax({
			url: "<?= base_url('upload/filter_missing_docs'); ?>",
			type: "POST",
			data: { month: month, year: year, user_id: user_id },
			beforeSend: function() {
				$('#tableContainer').html('<p class="text-center">Loading...</p>');
			},
			success: function(response) {
				$('#tableContainer').html(response);
			},
			error: function() {
				alert('Error fetching data');
			}
		});
	});
});
</script>