<!-- Main Content -->
<style>
/* Column Search Styles */
.column-search-row input {
    width: 100%;
    padding: 6px 10px;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    font-size: 0.8rem;
    background: #fff;
    transition: all 0.2s;
}
.column-search-row input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.1);
}
.column-search-row input::placeholder {
    color: #94a3b8;
}
.column-search-row th {
    background: #f8fafc !important;
    padding: 8px 10px !important;
}
#example td, 
#example th {
    white-space: nowrap;
}

/* Smaller input height to match header */
.filters-row input.column-search {
  padding: 46px 6px;
  font-size: 13px;
  box-sizing: border-box;
}
#example thead th { white-space: nowrap; }

table thead tr:first-child th {
    background: linear-gradient(135deg, #1e3a5f 0%, #2d4a6f 100%);
    color: #fff;
    border: none;
}

table thead tr:first-child th a,
table thead tr:first-child th i {
    color: #fff; /* icons / links white */
}

/* Hide DataTables global search box */
.dataTables_filter,
.dataTables_filter label,
.dataTables_filter input,
.dt-search {
    display: none !important;
}

/* ===== Rounded top corners ONLY for table header ===== */
#example {
    border-collapse: separate !important;
    border-spacing: 0;
    overflow: hidden;
}

/* Top-left corner */
#example thead tr:first-child th:first-child {
    border-top-left-radius: 14px;
}

/* Top-right corner */
#example thead tr:first-child th:last-child {
    border-top-right-radius: 14px;
}

/* Prevent gradient bleed */
#example thead tr:first-child th {
    background-clip: padding-box;
}



/* Right: info + pagination inline */
.dt-layout-end,
.dt-paging {
    display: flex;
    align-items: center;
    gap: 8px;
}

/* left side: 10 / 20 / 50 / All */
#example_wrapper .dt-layout-start {
  display: flex;
  align-items: center;
  gap: 6px;
}

/* right side: pagination + info */
#example_wrapper .dt-layout-end {
  display: flex;
  align-items: center;
  gap: 8px;
}


/* FORCE bottom controls into ONE flex row */
#example_wrapper > .row.mt-2.justify-content-between {
  display: flex !important;
  align-items: center !important;
  flex-wrap: nowrap !important;
}

/* LEFT: length buttons */
#example_wrapper .dt-length {
  display: flex;
  align-items: center;
  margin-right: auto; /* push rest to right */
}

/* CENTER placeholder (unused but must not break layout) */
#example_wrapper .dt-layout-start {
  display: none !important; /* 🔑 remove empty spacer */
}

/* RIGHT: info + pagination */
#example_wrapper .dt-layout-end {
  display: flex !important;
  align-items: center !important;
  gap: 8px;
  margin-left: auto;
}

/* dt-paging must be inline-flex */
#example_wrapper .dt-paging {
  display: flex;
  align-items: center;
  gap: 8px;
}

/* INFO badge baseline fix */
#example_wrapper .dt-info {
  height: 38px;
  line-height: 38px;
  padding: 0 12px;
  background: #e9ecef;
  border: 1px solid #dee2e6;
  border-radius: 6px;
  white-space: nowrap;
  margin: 0;
}

/* PAGINATION buttons baseline fix */
#example_wrapper .dt-paging .page-link {
  height: 38px;
  line-height: 38px;
  padding: 0 12px;
  display: flex;
  align-items: center;
}

</style>

<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Action buttons fixed inside card -->
      <div class="fab-top-group" style="display: flex; gap: 8px; position: absolute; top: 15px; right: 15px; z-index: 10;">
        <button type="button" class="btn btn-outline-secondary btn-sm" onclick="resetSearch()" title="Reset Search" style="border-radius: 50%; width: 36px; height: 36px; padding: 0;">
          <i class="fa fa-undo"></i>
        </button>
        <a href="<?= base_url('company/addCompany') ?>" class="btn btn-primary btn-sm" style="border-radius: 50%; width: 36px; height: 36px; padding: 0; display: flex; align-items: center; justify-content: center;">
          <i class="fa-solid fa-plus"></i>
        </a>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table id="example" class="table align-middle text-center mb-0">
              <thead>
                  <tr>
                      <th>Sr.No</th>
                      <th style="text-align:left;">Company name</th>
                      <th style="text-align:left;">Alias</th>
                      <th style="text-align:left;">Contact Person</th>
                      <th style="text-align:left;">Contact Email</th>
                      <th style="text-align:left;">Co. Start Date</th>
                      <th style="text-align:center;">Action</th>
                  </tr>
                  <tr class="column-search-row">
                      <th></th>
                      <th><input type="text" class="column-search" data-column="1" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="2" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="3" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="4" placeholder="Search..."></th>
                      <th><input type="text" class="column-search" data-column="5" placeholder="Search..."></th>
                      <th></th>
                  </tr>
              </thead>
            <tbody>
                <?php $i=1;?>
                <?php foreach($company_list as $aut) { ?>
                <tr>
                    <td><?php echo $i;?></td>
                    <td style="text-align:left;"><?php echo $aut['company_name'];?></td>
                    <td style="text-align:left;" ><?php echo $aut['short_name'];?></td>
                    <td style="text-align:left;"><?php echo $aut['contact_person'];?></td>
                    <td style="text-align:left;"><?php echo $aut['contact_email'];?></td>
                    <td style="text-align:left;"><?php echo $aut['co_start_date'];?></td>
                    <?php if($aut['status']=='1') { $status = 'Active';} else { $status='InActive';}?>
                    
                    <td class="text-center">
                        <a href="<?= base_url('company/editCompany/'.$aut['id']) ?>" class="btn btn-warning btn-icon">
                        <i class="fas fa-edit"></i>
                      </a>
                      <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon">
                        <i class="fas fa-trash-alt"></i>
                      </button>
                      <?php if ($aut['status'] == '1'): ?>
                        <button onclick="statusChange(<?= $aut['id'] ?>, '0')" 
                                class="btn btn-success btn-icon rounded-circle" 
                                title="Active">
                          <i class="fas fa-check"></i>
                        </button>
                      <?php else: ?>
                        <button onclick="statusChange(<?= $aut['id'] ?>, '1')" 
                                class="btn btn-secondary btn-icon rounded-circle"
                                title="Inactive">
                          <i class="fas fa-times"></i>
                        </button>
                      <?php endif; ?>    
                        
                    </td>
                </tr>
                
                <?php $i++; }  ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Scripts -->
<!--<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>-->
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<!--<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>-->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // DataTable with column search
    var table = $('#example').DataTable({
        orderCellsTop: true,
        autoWidth: false,

        pageLength: 10,
        lengthMenu: [[10, 20, 50, -1], [10, 20, 50, 'All']],

        columnDefs: [
            { orderable: false, targets: [0, 6] },
            { searchable: false, targets: [0, 6] }
        ]
    });


    // Column search functionality
    $('#example .column-search').on('keyup change', function() {
        var columnIdx = $(this).data('column');
        table.column(columnIdx).search(this.value).draw();
    });
    
    // Reset search function
    function resetSearch() {
        $('#example .column-search').val('');
        table.columns().search('').draw();
    }

    // SweetAlert flash message
    <?php if ($this->session->flashdata('message_name')): ?>
        Swal.fire({
            icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
            title: '<?= $this->session->flashdata('message_name') ?>',
            showConfirmButton: false,
            timer: 2000
        });
    <?php endif; ?>

    // SweetAlert confirm delete
    function confirmDelete(itemId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = `<?= base_url('company/deleteCompany/') ?>${itemId}`;
            }
        });
    }
    function statusChange(itemId, status) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, change status!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?= base_url("company/changeStatus"); ?>',
                    method: 'POST',
                    data: { id: itemId, status: status },
                    success: function(response) {
                        var res = JSON.parse(response);
                        if (res.success) {
                            Swal.fire('Success!', res.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error!', res.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error!', 'Something went wrong!', 'error');
                    }
                });
            }
        });
    }

    function moveBottomControls() {
        const wrapper = document.querySelector('#example_wrapper');
        if (!wrapper) return;

        const rows = wrapper.querySelectorAll('.row');
        if (rows.length < 2) return;

        const topRow = rows[0];
        const bottomRow = rows[rows.length - 1];

        const length = topRow.querySelector('.dataTables_length, .dt-length');
        const info   = bottomRow.querySelector('.dataTables_info, .dt-info');
        const paging = bottomRow.querySelector('.dataTables_paginate, .dt-paging');

        if (length && !bottomRow.contains(length)) {
            bottomRow.prepend(length);
        }

        if (info && paging && !paging.contains(info)) {
            paging.prepend(info);
        }
    }

    function buildLengthButtons() {
        const wrapper = document.querySelector('#example_wrapper');
        if (!wrapper) return;

        const length = wrapper.querySelector('.dataTables_length, .dt-length');
        if (!length || length.querySelector('.dt-length-buttons')) return;

        const values = [10, 20, 50, -1];
        const current = table.page.len();

        // hide dropdown + label
        length.querySelector('select')?.classList.add('d-none');
        length.querySelector('label')?.classList.add('d-none');

        const ul = document.createElement('ul');
        ul.className = 'pagination pagination-sm dt-length-buttons mb-0';

        values.forEach(v => {
            const li = document.createElement('li');
            li.className =
                'page-item ' +
                ((v === -1 && current === -1) || current === v ? 'active' : '');

            const btn = document.createElement('button');
            btn.className = 'page-link';
            btn.textContent = v === -1 ? 'All' : v;

            btn.onclick = () => {
                table.page.len(v).draw();
                ul.querySelectorAll('.page-item').forEach(x => x.classList.remove('active'));
                li.classList.add('active');
            };

            li.appendChild(btn);
            ul.appendChild(li);
        });

        length.appendChild(ul);
    }

    // run once
    moveBottomControls();
    buildLengthButtons();

    // re-run on every redraw
    table.on('draw.dt', function () {
        moveBottomControls();
        buildLengthButtons();
    });

</script>