<div id="documentResults">
            <div class="row">
              <?php $i = 1; foreach($type_data as $type): ?>
              <div class="col-md-12 mb-3">
                <div class="card border-info">
                  <div class="card-header gradient-header collapsed" data-bs-toggle="collapse" data-bs-target="#collapse-<?= $i; ?>">
                    <div class="d-flex justify-content-between align-items-center">
                      <h5 class="mb-0"><?= ucfirst($type['type_name']); ?> (<?= $type['doc_count']; ?> Documents)</h5>
                      <i class="fa fa-chevron-down arrow-icon"></i>
                    </div>
                  </div>

                  <div id="collapse-<?= $i; ?>" class="collapse show">
                    <div class="card-body p-3">
                      <?php foreach($type['documents'] as $doc): ?>
                        <div class="doc-item d-flex justify-content-between align-items-center p-3 mb-2" id="doc-item-<?= $doc['doc_id']; ?>">
                          <div>
                            <h6 class="mb-1 fw-bold"><?= $doc['doc_name']; ?></h6>
                            <small class="text-muted file-name"><?= ($doc['file_name']) ? $doc['file_name'] : 'No file uploaded'; ?></small><br>
                            <?php if($doc['file_name']): ?>
                              <small class="text-muted uploaded-on">Uploaded: <?= $doc['uploaded_at']; ?></small>
                            <?php endif; ?>
                          </div>
                          <div class="doc-actions">
                            <?php if($doc['file_name']): ?>
                              <a href="#" class="openEditModal me-2" data-id="<?= $doc['doc_id']; ?>" title="Edit"><i class="fa fa-edit fa-lg text-primary"></i></a>
                              <a href="#" class="deleteDocument me-2" data-id="<?= $doc['doc_id']; ?>" title="Delete"><i class="fa fa-trash fa-lg text-danger"></i></a>
                              <a href="<?= base_url('uploads/documents/'.$doc['file_name']); ?>" target="_blank" title="View"><i class="fa fa-eye fa-lg text-success me-2"></i></a>
                              <a href="<?= base_url('company/downloadDocument/'.$doc['doc_id']); ?>" title="Download"><i class="fa fa-cloud-download fa-lg text-info"></i></a>
                            <?php else: ?>
                              <a href="#" class="openUploadModal" data-id="<?= $doc['doc_id']; ?>" title="Upload"><i class="fa fa-upload fa-lg text-secondary"></i></a>
                            <?php endif; ?>
                          </div>
                        </div>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>
              </div>
              <?php $i++; endforeach; ?>
            </div>
          </div>
