<?php defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('get_monthly_document_filename')) {
    function get_monthly_document_filename($type_name, $year, $month)
    {
        // Convert month name to number if needed
        if (!is_numeric($month)) {
            $month = get_month_number($month); // your existing helper
        }

        $month = str_pad($month, 2, '0', STR_PAD_LEFT);

        // 🔥 CRITICAL: Ghostscript + Windows safe
        $safeType = preg_replace('/[^A-Za-z0-9_-]/', '_', trim($type_name));

        // remove duplicate underscores
        $safeType = preg_replace('/_+/', '_', $safeType);

        return "{$safeType}_{$year}_{$month}";
    }
}
