<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/jquery.validate.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js"></script>
<style>
.form-check-input[type="checkbox"] {
  border-radius: 0.25em;
  border-color: black;
}
.text-muted, .preview-list .preview-item .preview-item-content p .content-category {
  --bs-text-opacity: 1;
  color: rgba(53, 185, 16, 0.75) !important;
}
</style>


<div class="content-wrapper">
            <!-- Main content -->
	<section class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<div class="card card-outline card-primary">
						<form id="user_form" name="user_form" method="post" action="<?php echo base_url();?>user/saveUser">
	
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group ">
											<input type="text" class="form-control" id="first_name" name="first_name">
											<label class="col-form-label">First Name</label>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group ">
											<input type="text" class="form-control" id="last_name" name="last_name">
											<label class="col-form-label">Last Name</label>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group ">
											<input type="text" class="form-control" id="email_id" name="email_id">
											<label class="col-form-label">Email ID</label>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group ">
											<input type="password" class="form-control" id="password" name="password" >
											<label class="col-form-label">Password</label>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group ">
										<select name="role" id="role" class="form-control">
										  <option value="">Select Role</option>
										  <?php foreach($role_list as $role) { ?>
											<option value="<?php echo $role['id'];?>"><?php echo $role['role_name'];?></option>
										  <?php } ?>
										</select>
										<label class="" for="user_role">User Role</label>
									</div>
								</div>
								<div class="col-md-12" id="company_row" style="display:none">
								  <label class="col-sm-3 col-form-label">Company</label>
								  <div class="col-sm-12">
									<p class="text-muted mb-2"><b>All Documents will be accessible for selected company.</b></p>
									<div class="row">
									  <?php $i = 0; ?>
									  <?php foreach ($company_list as $company): ?>
										<div class="col-md-4 mb-2">
										  <div class="form-check">
											<input type="checkbox" name="company[]" value="<?= $company['id']; ?>" class="form-check-input" id="company_<?= $i; ?>">
											<label class="form-check-label" for="company_<?= $i; ?>">
											  <?php echo $company['company_name']; ?>
											</label>
										  </div>
										</div>
										<?php $i++; ?>
									  <?php endforeach; ?>
									</div>
								  </div>
								</div>
            
								<div class="col-md-12" id="type_row" style="display:none">
								  <label class="col-sm-3 col-form-label">Type</label>
								  <div class="col-sm-12">
									<div class="row">
									  <?php $i = 0; ?>
									  <?php foreach ($sub_type_list as $type): ?>
										<div class="col-md-4 mb-2">
										  <div class="form-check">
											<input type="checkbox" name="type_name[]" value="<?= $type['id']; ?>" class="form-check-input" id="type_name<?= $i; ?>">
											<label class="form-check-label" for="type_name<?= $i; ?>">
											  <?php echo $type['type_name']; ?>
											</label>
										  </div>
										</div>
										<?php $i++; ?>
									  <?php endforeach; ?>
									</div>
								  </div>
								</div>

            <!-- User Rights Section -->
								<div class="col-md-12" id="user_rights_row" style="display:none">
								  <label class="col-sm-3 col-form-label">User Rights</label>
								  <div class="col-sm-12">
									<div class="row">
									  <div class="col-md-4 mb-2">
										<div class="form-check">
										  <input type="checkbox" name="rights[]" value="view" class="form-check-input" id="right_view">
										  <label class="form-check-label" for="right_view">View</label>
										</div>
									  </div>
									  <div class="col-md-4 mb-2">
										<div class="form-check">
										  <input type="checkbox" name="rights[]" value="edit" class="form-check-input" id="right_edit">
										  <label class="form-check-label" for="right_edit">Edit</label>
										</div>
									  </div>
									  <div class="col-md-4 mb-2">
										<div class="form-check">
										  <input type="checkbox" name="rights[]" value="delete" class="form-check-input" id="right_delete">
										  <label class="form-check-label" for="right_delete">Delete</label>
										</div>
									  </div>
									</div>
								  </div>
								</div>
								<div class="col-md-12">
									<button class="btn btn-primary">Save User</button>
									<a class="btn btn-danger" href="<?php echo site_url();?>user">Cancel</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div><!-- /.container-fluid -->
	</section>
	<!-- /.content -->
</div>

<script>
var $j = jQuery.noConflict();
$j(document).ready(function () {
  
  // Form Validation
  $j('#user_form').validate({
    errorClass: 'error', 
    rules: {
      first_name: { required: true, normalizer: function (value) { return $j.trim(value); } },
      last_name: { required: true, normalizer: function (value) { return $j.trim(value); } },
      email_id: { required: true, email: true },
      password: { required: true },
      role: { required: true }
    },
    messages: {
      first_name: { required: "Please enter First Name." },
      last_name: { required: "Please enter Last Name." },
      email_id: { required: "Please enter your email address.", email: "Please enter a valid email address." },
      password: { required: "Please provide a password.", minlength: "Your password must be at least 3 characters long." },
      role: { required: "Please Select Role" }
    },
    submitHandler: function (form) { form.submit(); }
  });

  // Role change logic
  $j('#role').on('change', function () {
    var role = $j(this).val();
    if (role === '2') {
      $j('#company_row').show('blind');
      $j('#type_row').hide('blind');
    } 
    else if (role === '3') {
      $j('#company_row').show('blind');
      $j('#type_row').show('blind');
    }
    else {
      $j('#company_row').hide('blind');
      $j('#type_row').hide('blind');
      $j('#user_rights_row').hide('blind');
    }
  });

  // Show/hide User Rights based on company selection
  $j(document).on('change', 'input[name="company[]"]', function () {
    var anyChecked = $j('input[name="company[]"]:checked').length > 0;
    if (anyChecked) {
      $j('#user_rights_row').show('blind');
    } else {
      $j('#user_rights_row').hide('blind');
    }
  });

});
</script>
