<h3>Reorder Documents for Type</h3>

<style>
    #sortable li {
        padding: 10px;
        background: #f5f5f5;
        margin-bottom: 8px;
        border: 1px solid #ccc;
        cursor: move;
        font-size: 16px;
        border-radius: 6px;
    }
</style>

<ul id="docList" class="list-group">
    <?php foreach ($documents as $d): ?>
        <li class="list-group-item"><?= $d ?></li>
    <?php endforeach; ?>
</ul>

<button id="saveOrder" class="btn btn-success mt-3">Save Order</button>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

<script>
    $(function () {

        $("#docList").sortable({
            placeholder: "ui-state-highlight",
            axis: "y"
        });

        $("#docList").disableSelection();

        $("#saveOrder").click(function () {

            let order = [];

            $("#docList li").each(function () {
                order.push($(this).text().trim());
            });

            $.ajax({
                url: "<?= base_url('type/save_order'); ?>",
                type: "POST",
                data: {
                    type_id: <?= $type_id ?>,
                    sequence: order.join(',')
                },
                success: function (response) {
                    alert("Updated successfully!");
                },
                error: function (xhr) {
                    console.log("Error:", xhr.responseText);
                }
            });

        });

    });

</script>
