<style>
/* Container Card per Type */
.type-card {
    border: 2px solid #2196f3;
    border-radius: 10px;
    padding: 12px 16px;
    margin-bottom: 16px;
    background: #f9f9f9;
}

/* Header with Expand/Collapse */
.type-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    font-size: 18px;
    font-weight: 600;
    margin-bottom: 10px;
}

/* Collapse Icon */
.toggle-icon {
    font-size: 18px;
    transition: transform 0.3s ease;
}

.toggle-icon.collapsed {
    transform: rotate(-90deg);
}

/* List Item */
.sortable li {
    display: flex;
    align-items: center;
    justify-content: start;
    gap: 12px;
    background: #ffffff;
    border: 1px solid #dcdcdc;
    padding: 10px 14px;
    margin-bottom: 8px;
    border-radius: 8px;
    cursor: move;
    transition: background 0.2s ease, box-shadow 0.2s ease;
}

/* Hover Effect */
.sortable li:hover {
    background: #f7faff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.08);
}

/* While Dragging */
.sortable li.ui-sortable-helper {
    background: #e3f2fd !important;
    box-shadow: 0 4px 10px rgba(33, 150, 243, 0.4);
}

/* Number Badge */
.num {
    background: #eeeeee;
    color: #333;
    padding: 3px 7px;
    border-radius: 6px;
    font-weight: 600;
    min-width: 30px;
    text-align: center;
}

/* Document Name Styling */
.doc-name {
    background: #fff9db;
    border: 1px solid #ffe082;
    padding: 4px 8px;
    border-radius: 6px;
    flex-grow: 1;
    font-size: 15px;
}

/* Fixed Sr No */
.sr-no {
    background: #dfe6e9;
    color: #2d3436;
    padding: 4px 10px;
    border-radius: 6px;
    min-width: 40px;
    text-align: center;
    font-weight: 600;
    pointer-events: none;
}

/* Hide type body initially */
.type-body {
    display: none;
}
</style>

<div class="content">
    <?php foreach ($sub_types as $row): ?>
        <?php if (count($row['documents']) > 1): ?>
        <div class="type-card">
            <div class="type-header" data-target="docList_<?= $row['id'] ?>">
                <?= htmlspecialchars($row['type_name']) . ' (' . htmlspecialchars($row['alias_name']) . ')' ?>
                <span class="toggle-icon collapsed">&#9654;</span>
            </div>

            <div class="type-body" id="docList_<?= $row['id'] ?>">
                <ul class="list-group sortable">
                    <?php foreach ($row['documents'] as $index => $doc): ?>
                        <li class="list-group-item d-flex align-items-center" data-id="<?= $doc['id'] ?>">
                            <span class="num sr-no"><?= $index + 1 ?></span>
                            <span class="doc-name"><?= htmlspecialchars($doc['name']) ?></span>
                        </li>
                    <?php endforeach; ?>
                </ul>
                <button class="btn btn-success saveOrderBtn mt-2" data-type="<?= $row['id'] ?>">
                    Save Order
                </button>
            </div>
        </div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- jQuery UI CSS -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<!-- jQuery UI JS -->
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.min.js"></script>

<script>
$(function () {
    // Initialize sortable
    $(".sortable").sortable({
        update: function (event, ui) {
            const listId = $(this).closest(".type-body").attr("id");
            $("#" + listId + " li").each(function(i){
                $(this).find(".sr-no").text(i + 1);
            });
        }
    });

    // Expand/Collapse functionality
    $(".type-header").on("click", function() {
        const targetId = $(this).data("target");
        const $body = $("#" + targetId);
        $body.slideToggle(200);
        $(this).find(".toggle-icon").toggleClass("collapsed");
    });

     $(".saveOrderBtn").click(function() {
        let type_id = $(this).data("type");
        let ids = [];

        $("#docList_" + type_id + " .sortable li").each(function() {
            ids.push($(this).data("id"));  // Collect document IDs
        });

        $.ajax({
            url: "<?= base_url('type/save_order') ?>",
            method: "POST",
            data: {
                type_id: type_id,
                sequence: ids
            },
            success: function(response) {
                alert("Order saved!");
            }
        });
    });
});
</script>
