<style>
.form-group {
  position: relative;
  margin-bottom: 1.5rem;
}

.form-group .icon {
  position: absolute;
  top: 50%;
  left: 8px;
  transform: translateY(-50%);
  color: #888;
}

.form-group input,
.form-group select {
  width: 100%;
  padding: 10px 10px 10px 35px;
  font-size: 16px;
  border: 1px solid #ccc;
  border-radius: 6px;
  background: none;
  outline: none;
}

.form-group label {
  position: absolute;
  left: 35px;
  top: 50%;
  transform: translateY(-50%);
  color: #666;
  font-size: 14px;
  pointer-events: none;
  transition: 0.2s ease all;
}

/* When input or select has focus OR is filled */
.form-group input:focus + label,
.form-group input:not(:placeholder-shown) + label,
.form-group select:focus + label,
.form-group select:valid + label {
  top: -6px;
  left: 30px;
  font-size: 12px;
  color: #F05B23; /* highlight color */
}

.form-group .hint {
  font-size: 12px;
  color: #999;
  margin-top: 4px;
}
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/jquery.validate.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<link rel="stylesheet" href="<?php echo base_url();?>public/assets/css/choices.min.css">
<script src="<?php echo base_url();?>public/assets/js/choices.min.js"></script>	

<!-- Bootstrap Multiselect / Choices -->
<link rel="stylesheet" href="<?php echo base_url();?>public/assets/css/choices.min.css">
<div class="content">
	<div class="formcard">
		<form class="type_form" id="type_form" method="post" action="<?php echo base_url();?>type/updateType">
			<input type="hidden" name="type_id" value="<?php echo $type_data['id'];?>">
			<div class="form-group">
				<select name="authority_id" id="authority_id" class="form-control">
					<option value="">Select Authority</option>
					<?php foreach($authority_data as $aut) { ?>
						<option value="<?php echo $aut['id'];?>" 
					  <?php echo ($type_data['authority_id'] == $aut['id']) ? 'selected' : ''; ?>>
                      <?php echo $aut['authority_name'];?>
					<?php } ?>
				</select>
				<label for="authority name">Authority Name</label>
			</div>
			<div class="form-group">
				<input type="text" id="sub_tpe" name="sub_type" placeholder=" " value="<?php echo $type_data['type_name'];?>">
				<label for="typename">Document Head Name</label>
			</div>

			<div class="form-group">
				<input type="text" id="alias" name="alias" placeholder=" " value="<?php echo $type_data['alias_name'];?>">
				<label for="alias">Alias</label>
			</div>
			<div class="form-group">
				<select name="doc_type" id="doc_type" class="form-control">
					<option value="Primary">Primary</option>
					<option value="Secondary">Secondary</option>
				</select>
				<label for="authority name">Document Type</label>
			</div>
			<div class="form-group">
				<select name="frequency" id="frequency" class="form-control">
					<?php foreach($frequency as $freq) { ?>
						<option value="<?php echo $freq;?>" 
							<?php echo ($type_data['frequency'] == $freq) ? 'selected' : ''; ?>>
							<?php echo $freq;?>
						</option>
					<?php } ?>
				</select>
				<label for="frequency">Frequency</label>
			</div>
			<div class="form-group" id="document_date_group">
				<input type="date" class="form-control" name="document_date" id="document_date" value="<?php echo $type_data['frequency_start_date'];?>">
				<label for="document_date">Document Date</label>
			</div>
			<!--<div class="form-group" id="start_date_group">
				<input type="date" class="form-control" name="frequency_start_date" id="frequency_start_date" value="<?php echo $type_data['frequency_start_date'];?>">
				<label  for="frequency_start_date">Frequency Start Date</label>
			</div>-->

            <div class="form-group" id="start_date_group">
                <input type="text" class="form-control" name="frequency_start_date" id="frequency_start_date" value="<?php echo $type_data['frequency_start_date'];?>" placeholder="Select Day & Month" readonly>
                <label for="frequency_start_date">Frequency Start Date</label>
            </div>
			
			<input type="hidden" id="monthSelect" class="form-control" value="<?php echo date('Y-m'); ?>" style="display:none">
			<div id="monthly_date">
                <div class="form-group">
                    <select id="dateDropdown" class="form-control" name="monthly_days">
                    <option value="">Select date</option>
                    </select>
                    <label for="dateDropdown">Select Date</label>
                </div>
			</div> 
            <div id="due_month_wrapper" style="display:none; margin-bottom: 20px;">
                <label style="font-size:14px; color:#666;">Due Month</label><br>

                <div style="margin-top:8px;">
                    <label style="margin-right:25px; cursor:pointer;">
                        <input type="radio" name="due_month" value="same"
                            <?= isset($type_data['due_in_same_next_month']) && $type_data['due_in_same_next_month'] == 0 ? 'checked' : '' ?>>
                        Same Month
                    </label>

                    <label style="cursor:pointer;">
                        <input type="radio" name="due_month" value="next"
                            <?= isset($type_data['due_in_same_next_month']) && $type_data['due_in_same_next_month'] == 1 ? 'checked' : '' ?>>
                        Next Month
                    </label>
                </div>
            </div>
            <!--<div class="form-group" id="document_Start_date_group">
				<input type="date" class="form-control" name="document_start_date" id="document_start_date">
				<label for="document_start_date">Document Start Date</label>
			</div>-->

            <div class="form-group" id="document_Start_date_group">
                <input type="date" class="form-control" name="document_start_date" id="document_start_date"
                    value="<?= isset($type_data['document_start_date']) ? $type_data['document_start_date'] : '' ?>">
                <label for="document_start_date">Document Start Date</label>
            </div>
			<?php 
				// selected docs (from DB)
				$document_types = explode(',', $type_data['document_name']); 
			?>

			<div class="form-group">
				<select name="document[]" id="choices-multiple-remove-button" class="form-control" multiple="multiple">
					<option value="">Select Document</option>
					<?php foreach($document_data as $document) { ?>
					<option value="<?php echo $document['id']; ?>" 
						<?php echo (is_array($document_types) && in_array($document['id'], $document_types)) ? 'selected' : ''; ?>>
						<?php echo $document['document_name']; ?>
					</option>
					<?php } ?>
				</select>
				<label for="choices-multiple-remove-button">Document</label>
			</div>

			<!-- Dynamic Mandatory Table -->
			<div id="documentOptions" class="mt-3"></div>
			
		<div class="formbtn-group">
		<button type="submit" class="formbtn formbtn-save">Update</button>
		<a href="javascript:history.back()" class="formbtn formbtn-cancel">Cancel</a>
		</div>
		</form>
	</div>
</div>

<script>
$(document).ready(function() {
  function populateDates(selectedDate = '') {
    const dateDropdown = $('#dateDropdown');
    dateDropdown.empty().append('<option value="">Select date</option>');

    for (let day = 1; day <= 31; day++) {
      const dateStr = ('0' + day).slice(-2); // format 01, 02, etc.
      const selectedAttr = (dateStr === selectedDate) ? 'selected' : '';
      dateDropdown.append(`<option value="${dateStr}" ${selectedAttr}>${dateStr}</option>`);
    }
  }

  // PHP variable from DB (e.g. "05" for 5th day)
  const selectedDate = "<?php echo isset($type_data['frequency_start_date']) ? str_pad($type_data['frequency_start_date'], 2, '0', STR_PAD_LEFT) : ''; ?>";

  populateDates(selectedDate);

  // Optional: if you want to repopulate on month change (still 1–31)
  $('#monthSelect').on('change', function() {
    populateDates(selectedDate);
  });
});

$(document).ready(function(){
    // Initialize Choices.js multi-select
    new Choices('#choices-multiple-remove-button', {
        removeItemButton: true,
        maxItemCount: 50,
        searchResultLimit: 50,
        renderChoiceLimit: 50
    });

    // Validation
    $('#type_form').validate({
        rules: {
            sub_type: { required: true }
        },
        messages: {
            sub_type: { required: "Please enter Document head name" }
        },
        submitHandler: function (form) { form.submit(); }
    });

    // Show/Hide date fields based on frequency
    function toggleDateFields(value) {
        if (value === "Monthly") {
            $('#monthly_date').show();
            $('#due_month_wrapper').show();
            $('#document_date_group').hide();
            $('#start_date_group').hide();
            $('#frequency_start_date, #document_date').val('');
        } 
        else if (value === "Yearly" || value === "Half Yearly" || value === "Quarterly") {
            $('#start_date_group').show();
            $('#due_month_wrapper').show();
            $('#monthly_date').hide();
            $('#document_date_group').hide();
            $('#monthly_days').val('');
        } 
        else if (value === "One Time") {
            $('#document_date_group').show();
            $('#monthly_date').hide();
            $('#start_date_group').hide();
            $('#due_month_wrapper').hide();
            $('#frequency_start_date').val('');
            $('#monthly_days').val('');
        } 
        else {
            $('#monthly_date, #start_date_group, #document_date_group, #due_month_wrapper').hide();
            $('#frequency_start_date').val('');
            $('#monthly_days').val('');
        }
    }

    toggleDateFields($('#frequency').val());

    $('#frequency').change(function () {
        toggleDateFields($(this).val());
    });

    // ✅ Pass PHP array (doc_id => mandatory) into JS
    var mandatoryData = <?php echo json_encode($selected_docs); ?>;

    // Function to rebuild the mandatory table
    function rebuildMandatoryTable() {
        let selectedDocs = $('#choices-multiple-remove-button').val() || []; 
        let container = $('#documentOptions');

        // Create table if not exists
        if (!container.find('table').length) {
            let table = `
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th>Document Name</th>
                            <th>Mandatory</th>
                            <th>Non-Mandatory</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            `;
            container.html(table);
        }

        let tbody = container.find('tbody');

        // Remove rows for docs that are no longer selected
        tbody.find('tr').each(function () {
            let docId = $(this).data('docid').toString();
            if (!selectedDocs.includes(docId)) {
                $(this).remove();
            }
        });

        // Add rows for new selected docs
        $('#choices-multiple-remove-button option:selected').each(function () {
            let docId = $(this).val();
            let docName = $(this).text();

            if (!tbody.find('tr[data-docid="' + docId + '"]').length) {
                // ✅ Check DB value (mandatoryData[docId]) → 1 = mandatory, 0 = non-mandatory
                let isMandatory = (mandatoryData[docId] !== undefined) ? mandatoryData[docId] : 1;

                let row = `
                    <tr data-docid="${docId}">
                        <td>${docName}</td>
                        <td>
                            <input type="radio" name="mandatory[${docId}]" value="1" ${isMandatory == 1 ? 'checked' : ''}>
                        </td>
                        <td>
                            <input type="radio" name="mandatory[${docId}]" value="0" ${isMandatory == 0 ? 'checked' : ''}>
                        </td>
                    </tr>
                `;
                tbody.append(row);
            }
        });
    }

    // On change of document select
    $('#choices-multiple-remove-button').change(function () {
        rebuildMandatoryTable();
    });

    // ✅ Trigger once on page load to pre-populate existing docs
    rebuildMandatoryTable();
});

$('#frequency_start_date').datepicker({
    format: "dd-MM",
    autoclose: true,
    todayHighlight: true,
    endDate: new Date()
});
</script>