<!-- Main Content -->
<div class="content">
  <div class="card">
  <div class="card position-relative shadow-sm rounded-4">
    <!-- Add button fixed inside card -->
    <a href="<?= base_url('type/addType') ?>" class="fab-top">
      <i class="fa-solid fa-plus"></i>
    </a>
    <div class="card-body">
      <div class="table-responsive">
        <table id="example" class="table align-middle text-center mb-0">
          <thead>
            <tr>
              <th>Sr.No</th>
              <th style="text-align:left;">Authority</th>
              <th style="text-align:left;">Document Head</th>
              <th style="text-align:left;">Alias</th>
              <th style="text-align:left;">Documents</th>
              <th style="text-align:left;">Frequency</th>
              <th style="text-align:left;">Due Date</th>
              <!--<th style="text-align:center;">Created Date</th>-->
              <th style="text-align:left;">Created By</th>
              <th style="text-align:center;">Action</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = 1; ?>
            <?php foreach ($authority_list as $aut): ?>
              <tr>
                <td><?= $i++; ?></td>
                <td style="text-align:left;"><?= $aut['authority_name']; ?></td>
                <td style="text-align:left;" ><?= $aut['type_name']; ?></td>
                <td style="text-align:left;" ><?= $aut['alias_name']; ?></td>
                <td style="text-align:left;">
                  <?php foreach (explode(',', $aut['document_names']) as $dc => $doc): ?>
    <?= ($dc + 1) . '. ' . trim($doc) ?><br>
  <?php endforeach; ?>
                </td>
                <td style="text-align:left; width: 50px;"><?= $aut['frequency']; ?></td>
                <td style="text-align:left; width: 120px;">
                  <?php
                    //$doc_date = trim($aut['doc_date']); 

                    $doc_date = !empty($aut['frequency_start_date']) 
                                    ? $aut['frequency_start_date'] 
                                    : $aut['document_expiry_date'];

                    // Check if it's a valid full date
                    if (!empty($doc_date) && strtotime($doc_date) && strlen($doc_date) >= 8) {
                        echo date('d-M-Y', strtotime($doc_date));
                    }

                    // If it's just a number (day)
                    elseif (ctype_digit($doc_date) && (int)$doc_date >= 1 && (int)$doc_date <= 31) {
                        echo 'Day: ' . str_pad($doc_date, 2, '0', STR_PAD_LEFT); // "Day: 12"
                    }
                    else {
                        echo '-';
                    }
                  ?>
                </td>
                <!--<td style="text-align:center;"><?= date('d-M-Y'); ?></td>-->
                <td style="text-align:left;"><?= $aut['first_name']." ".$aut['last_name']; ?></td>
                <td style="width: 200px;">
                  <a href="<?= base_url('type/editType/'.$aut['id']) ?>" class="btn btn-warning btn-icon">
                    <i class="fas fa-edit"></i>
                  </a>
                  <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                  <?php if ($aut['status'] == '1'): ?>
                    <button onclick="statusChange(<?= $aut['id'] ?>, '0')" 
                            class="btn btn-success btn-icon rounded-circle" 
                            title="Active">
                      <i class="fas fa-check"></i>
                    </button>
                  <?php else: ?>
                    <button onclick="statusChange(<?= $aut['id'] ?>, '1')" 
                            class="btn btn-secondary btn-icon rounded-circle"
                            title="Inactive">
                      <i class="fas fa-times"></i>
                    </button>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  </div>
</div>

<!-- Styles -->
<style>
select.form-select {
  padding: 0.4375rem 0.75rem;
  border: 0;
  outline: 1px solid #f3f3f3;
  color: #5e5151;
}
</style>

<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  // DataTable init
  new DataTable('#example');

  // SweetAlert flash message
  <?php if ($this->session->flashdata('message_name')): ?>
    Swal.fire({
      icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
      title: '<?= $this->session->flashdata('message_name') ?>',
      showConfirmButton: false,
      timer: 2000
    });
  <?php endif; ?>

  // SweetAlert confirm delete
  function confirmDelete(itemId) {
    Swal.fire({
      title: 'Are you sure?',
      text: "This will permanently delete the record!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = `<?= base_url('type/deleteType/') ?>${itemId}`;
      }
    });
  }

  // SweetAlert confirm status change
  function statusChange(itemId, status) {
    let actionText = (status === '1') ? 'activate' : 'deactivate';
    Swal.fire({
      title: 'Are you sure?',
      text: `Do you really want to ${actionText} this record?`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonText: `Yes, ${actionText} it!`,
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: '<?= base_url("type/changeStatus"); ?>',
          method: 'POST',
          data: { id: itemId, status: status },
          success: function(response) {
            let res = JSON.parse(response);
            if (res.success) {
              Swal.fire('Success!', res.message, 'success').then(() => {
                location.reload();
              });
            } else {
              Swal.fire('Error!', res.message, 'error');
            }
          },
          error: function() {
            Swal.fire('Error!', 'Something went wrong!', 'error');
          }
        });
      }
    });
  }
</script>
