<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title> DMS 2025</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 -->
  <link rel="stylesheet" href="<?= base_url('public/assets/css/bootstrap.min.css') ?>">
  <!-- FontAwesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('public/assets/css/newstyle.css') ?>">

  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
  <!-- code for curve background ends here -->
    
    <script src="<?= base_url('public/assets/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!--<script src="<?= base_url('public/assets/js/script.js') ?>"></script>-->
    <script src="<?= base_url('public/assets/js/bootstrap-datepicker.min.js') ?>"></script>

    <!-- js and css for dashboard -->
<script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://unpkg.com/lucide@latest"></script>
  <style>
    .status-card {
      transition: all 0.3s ease;
      cursor: pointer;
    }
    .status-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
    }
    table tbody tr:hover {
      background-color: #f1f5f9;
      transition: background-color 0.2s;
    }
    button:hover {
      opacity: 0.9;
    }
  </style>


    <!-- ends here for dashboard -->
</head>
<body>

<?php
// Get the first segment of URL (controller name)
  $current_menu = $this->uri->segment(1);
  $current_sub_menu = $this->uri->segment(1) . '/' . $this->uri->segment(2);
?>
<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <div class="brand">
      <i class="fa-solid fa-file-lines"></i>DMS 2025<!--<span class="brand-text">DMS 2025</span>
      <span id="sidebarToggle" class="toggle-arrow" title="Toggle Sidebar">
        <i class="fa-solid fa-angle-left"></i>
      </span>-->
    </div>

  <!-- Dashboard -->
  <a class="nav-link <?= ($current_menu == 'dashboard') ? 'active' : '' ?>" href="<?= base_url('dashboard') ?>">
      <i class="fa-solid fa-gauge"></i>
      <span class="link-text">Dashboard</span>
  </a>
    
  <!-- Masters Dropdown -->
<?php $isMasterActive = isset($isMasterActive) ? $isMasterActive : false; 

$full_name = $this->session->userdata('full_name');
$disableMaster = ($full_name === 'Rukia TZ'); 
if (!$disableMaster): ?>
    <!-- Your entire Master menu HTML here -->
  <div class="nav-item">
    <a 
      class="nav-link dropdown-toggle <?= $isMasterActive ? 'active' : '' ?>" 
      href="javascript:void(0);"
      data-bs-toggle="collapse" 
      data-bs-target="#mastersMenu"
      role="button" 
      aria-expanded="<?= $isMasterActive ? 'true' : 'false' ?>" 
      aria-controls="mastersMenu"
    >
      <i class="fa-solid fa-sitemap"></i>
      <span class="link-text">Masters</span>
      <i class="fa-solid fa-angle-down ms-auto arrow-icon"></i>
    </a>

    <div id="mastersMenu" class="collapse <?= (in_array($current_menu, ['authority', 'type', 'company', 'document']) 
        && $current_sub_menu != 'company/newDocuments') ? 'show' : '' ?>">
      <ul class="nav flex-column ms-3">
          <li>
              <a class="nav-link <?= ($current_menu == 'authority') ? 'active' : '' ?>" href="<?= base_url('authority') ?>">
                  <i class="fa-solid fa-building"></i> Authority
              </a>
          </li>
          <li>
              <a class="nav-link <?= ($current_menu == 'type' && $current_sub_menu == '') ? 'active' : '' ?>" href="<?= base_url('type') ?>">
                  <i class="fa-solid fa-diagram-project"></i> Document Head
              </a>
          </li>
          <li>
              <a class="nav-link <?= ($current_sub_menu == 'type/reorder_all') ? 'active' : '' ?>" href="<?= base_url('type/reorder_all') ?>">
                  <i class="fa-solid fa-arrow-up-short-wide"></i> Re-order Document Head
              </a>
          </li>
  
          <!--<li>
              <a class="nav-link <?= ($current_menu == 'company') ? 'active' : '' ?>" href="<?= base_url('company') ?>">
                  <i class="fa-solid fa-industry"></i> Company
              </a>
          </li>-->
          <li>
              <a class="nav-link <?= ($current_sub_menu == 'document/groupList' || $current_sub_menu == 'document/addDocumentGroup') ? 'active' : '' ?>" href="<?= base_url('document/groupList') ?>">
                  <i class="fa-solid fa-file"></i> Add Group
              </a>
          </li>
          <li>
              <a class="nav-link <?= ($current_sub_menu == 'document/allDocuments' || $current_sub_menu == 'document/addDocument') ? 'active' : '' ?>" href="<?= base_url('document/allDocuments') ?>">
                  <i class="fa-solid fa-file"></i> Document
              </a>
          </li>
          <!--<li>
               //User & Role Management
              <a class="nav-link <?= ($current_menu == 'role') ? 'active' : '' ?>" href="<?= base_url('role') ?>">
                  <i class="fa-solid fa-users-gear"></i> User Role
              </a>
          </li>
          <li>
              <a class="nav-link <?= ($current_menu == 'users') ? 'active' : '' ?>" href="<?= base_url('user') ?>">
                  <i class="fa-solid fa-user"></i> User
              </a>
          </li>-->
      </ul>
    </div>
  </div>
<?php endif; ?>

<!-- Upload Documents -->
  <a class="nav-link <?= ($current_menu == 'upload') ? 'active' : '' ?>" href="<?= base_url('upload') ?>" id="uploadMenu">
      <i class="fa-solid fa-upload"></i> Upload Documents
  </a>

  <!-- View Documents -->
  <a class="nav-link <?= ($current_sub_menu == 'company/newDocuments') ? 'active' : '' ?>" href="<?= base_url('upload/view') ?>" id="viewMenu">
      <i class="fa-solid fa-eye"></i> View Documents
  </a>

  <!-- Reminders -->
  <a class="nav-link <?= ($current_menu == 'upload/reminder') ? 'active' : '' ?>" href="<?= base_url('upload/reminder') ?>" id="reminders">
      <i class="fa-solid fa-bell"></i> Reminders
  </a>

</div>
<div class="topbar">
  <h3>
    <?php 
        //print_r($details->company_name);
        // Check if we're on View Documents or Upload Documents for a specific company
        if ($current_sub_menu === 'company/newDocuments' || $current_sub_menu === 'upload/index') {
            // Display "View" or "Upload" based on page
            $page_label = ($current_sub_menu === 'company/newDocuments') ? 'View' : 'Upload / '. $details->company_name ;
            echo $page_label;

            // Show selected company name if available
            if (!empty($company_list[0]['company_name'])) {
                echo ' / ' . htmlspecialchars($company_list[0]['company_name']);
            }
        } else {
            // Default: show current menu
            echo ucfirst($current_menu);
        }
    ?>
  </h3>
  <div class="user-profile dropdown">
    <a class="dropdown-toggle d-flex align-items-center text-decoration-none" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
        <span class="fw-semibold me-2">
            <?php echo $this->session->userdata('full_name'); ?>
        </span>
        <img src="https://cdn-icons-png.flaticon.com/512/847/847969.png" width="40" class="rounded-circle" alt="User Avatar">
    </a>
    <ul class="dropdown-menu dropdown-menu-end mt-2">
        <li><a class="dropdown-item" href="<?= base_url('login/logout') ?>">Logout</a></li>
    </ul>
</div>
</div>

<div class="modal fade" id="companyModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Select Company</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

	  <?php 
      $get_companies = get_all_company(); ?>
      <div class="modal-body">
        <label for="company" class="form-label">Choose Company:</label>
        <select id="company" class="form-select">
		
          <option value="">-- Select Company --</option>
		  <?php foreach($get_companies as $company) { ?>
          <option value="<?php echo $company['id'];?>"><?php echo $company['company_name'];?></option>
		  <?php } ?>
          
        </select>
      </div>
      <div class="modal-footer">
        <button type="button" id="goUpload" class="btn btn-success">Go to Upload</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="viewcompany" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Select Company</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
	  
	  <?php $get_companies = get_all_company();?>
      <div class="modal-body">
        <label for="company" class="form-label">Choose Company:</label>
        <select id="view_company" class="form-select">
		
          <option value="">-- Select Company --</option>
		  <?php foreach($get_companies as $company) { ?>
          <option value="<?php echo $company['id'];?>"><?php echo $company['company_name'];?></option>
		  <?php } ?>
          
        </select>
      </div>
      <div class="modal-footer">
        <button type="button" id="view" class="btn btn-success">Go to View Documents</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="viewreminder" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Select User</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
	  
	  <?php $get_user = get_all_user(); ?>
      
	  <div class="modal-body">
        <label for="company" class="form-label">Choose User:</label>
        <select id="view_user" class="form-select">
		
          <option value="">-- Select --</option>
		  <?php foreach($get_user as $user) { ?>
          <option value="<?php echo $user['id'];?>"><?php echo $user['first_name'],' '.$user['last_name'];?></option>
		  <?php } ?>
          
        </select>
      </div>
      <div class="modal-footer">
        <button type="button" id="goCompany" class="btn btn-success">Go to Companies</button>
      </div>
    </div>
  </div>
</div>


<script>

document.addEventListener('DOMContentLoaded', function () {
  const mastersMenu = document.getElementById('mastersMenu');
  const arrowIcon = document.querySelector('.arrow-icon');

  if (mastersMenu) {
    mastersMenu.addEventListener('show.bs.collapse', function () {
      arrowIcon.classList.add('rotate');
    });

    mastersMenu.addEventListener('hide.bs.collapse', function () {
      arrowIcon.classList.remove('rotate');
    });
  }
});
$(document).ready(function(){
  // Open modal on menu click
  $("#uploadMenu").click(function(e){
    e.preventDefault();
    $("#companyModal").modal("show");
  });

  // Redirect on button click
  $("#goUpload").click(function(){
    var companyId = $("#company").val();
    if(companyId){
      // Redirect (change URL as per your route)
      window.location.href = "<?php echo base_url('upload/index/'); ?>" + companyId;

    } else {
      alert("Please select a company first.");
    }
  });
  $("#viewMenu").click(function(e){
    e.preventDefault();
    $("#viewcompany").modal("show");
  });
   $("#view").click(function(){
    var companyId = $("#view_company").val();
    if(companyId){
      // Redirect (change URL as per your route)
      window.location.href = "<?php echo base_url('company/newDocuments/'); ?>" + companyId;

    } else {
      alert("Please select a company first.");
    }
  });
   $("#reminders").click(function(e){
    e.preventDefault();
    $("#viewreminder").modal("show");
  });
  $("#goCompany").click(function(){
    var userId = $("#view_user").val();
    if(userId){
      // Redirect (change URL as per your route)
      window.location.href = "<?php echo base_url('upload/reminder/'); ?>" + userId;

    } else {
      alert("Please select a User first.");
    }
  });
});

  document.addEventListener('DOMContentLoaded', function () {
    const sidebar = document.getElementById('sidebar');
    const content = document.getElementById('mainContent');
    const toggleArrow = document.getElementById('sidebarToggle');
    const icon = toggleArrow.querySelector('i');

    toggleArrow.addEventListener('click', function () {
      sidebar.classList.toggle('collapsed');
      content.classList.toggle('expanded');

      // Change arrow direction
      if (sidebar.classList.contains('collapsed')) {
        icon.classList.remove('fa-angle-left');
        icon.classList.add('fa-angle-right');
      } else {
        icon.classList.remove('fa-angle-right');
        icon.classList.add('fa-angle-left');
      }
    });
  });
</script>

<style>

.nav-link.dropdown-toggle::after {
  display: none !important;
}
.arrow-icon {
  transition: transform 0.3s ease;
}
.arrow-icon.rotate {
  transform: rotate(180deg);
}
/* Sidebar default state */
.sidebar {
  width: 250px;
  background-color: #2c3e50;
  color: white;
  height: 100vh;
  position: fixed;
  transition: width 0.3s ease;
  overflow-x: hidden;
}

/* Collapsed state */
.sidebar.collapsed {
  width: 60px;
}

.sidebar .brand {
  display: flex;
  align-items: center;
  padding: 15px 20px;
  /*justify-content: space-between;*/
}

.brand-text {
  margin-left: 10px;
  font-size: 18px;
  white-space: nowrap;
}

.sidebar.collapsed .brand-text {
  display: none;
}

.sidebar .toggle-arrow {
  cursor: pointer;
  font-size: 16px;
}

.sidebar .nav-link {
  display: flex;
  align-items: center;
  padding: 12px 20px;
  color: white;
  text-decoration: none;
  transition: background-color 0.2s;
}

.sidebar .nav-link i {
  width: 20px;
  font-size: 18px;
  text-align: center;
}

.link-text {
  margin-left: 10px;
  white-space: nowrap;
}

.sidebar.collapsed .link-text {
  display: none;
}

/* Main content area */
.content {
  margin-left: 250px;
  transition: margin-left 0.3s ease;
  padding: 20px;
}

.content.expanded {
  margin-left: 60px;
}

</style>