<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>EightTech Projects</title>
  <!-- base:css -->
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/vendors/typicons/typicons.css">
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- plugin css for this page -->
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="<?php echo site_url();?>public/assets/css/style.css">
  <style>
	.error {
		color:red;
	}
  </style>
  <!-- endinject -->
  <link rel="shortcut icon" href="<?php echo site_url();?>public/assets/images/favicon.ico" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo base_url();?>public/assets/js/jquery.validate.min.js"></script>
</head>

<body>
  <div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
      <div class="content-wrapper d-flex align-items-center auth px-0">
        <div class="row w-100 mx-0">
          <div class="col-lg-4 mx-auto">
            <div class="auth-form-light text-start py-5 px-4 px-sm-5">
              <div class="brand-logo">
                <img src="<?php echo site_url();?>public/assets/images/logo2.png" alt="logo">
              </div>
              <h4>Hello! let's get started</h4>
              <h6 class="fw-light">Sign in to continue.</h6>
			  <?php if ($this->session->flashdata('login_msg')): ?>
                  <div class="alert alert-danger text-center">
                      <?= $this->session->flashdata('login_msg'); ?>
                  </div>
              <?php endif; ?>
        <form class="login_form" id="login_form" method="post" action="<?php echo base_url();?>index.php/login/secureLogin">
                <div class="form-group">
                  <input type="email" class="form-control form-control-lg" id="user_email" name="user_email" placeholder="Username">
                </div>
                <div class="form-group">
                  <input type="password" class="form-control form-control-lg" id="user_password" name="user_password" placeholder="Password">
                </div>
                <div class="mt-3 d-grid gap-2">
					<input type="submit" name="submit" value="Submit" class="btn btn-block btn-primary btn-lg fw-medium auth-form-btn" >
                </div>
                <div class="my-2 d-flex justify-content-between align-items-center">
                  <a href="#" class="auth-link text-black">Forgot password?</a>
                </div>
                
              </form>
            </div>
          </div>
        </div>
      </div>
      <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->
  <!-- base:js -->
  <script>
	$(document).ready(function () {
		// Initialize the validation
		$('#login_form').validate({
			rules: {
				user_email: {
					required: true,
					email: true,
				},
				user_password: {
					required: true,
					minlength: 3,
				},
			},
			messages: {
				user_email: {
					required: "Please enter your email address.",
					email: "Please enter a valid email address.",
				},
				user_password: {
					required: "Please provide a password.",
					minlength: "Your password must be at least 3 characters long.",
				},
			},
			submitHandler: function (form) {
				form.submit(); // Submit the form
			},
		});
	});
</script>
</body>

</html>
