
  <!-- AdminLTE CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <!-- FontAwesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    .info-box:hover {
      transform: translateY(-4px);
      box-shadow: 0 6px 15px rgba(0,0,0,0.2);
      transition: all 0.3s ease;
    }
    .table-hover tbody tr:hover {
      background-color: #f4f6f9;
    }
  </style>

<div class="content">
  <section>
    <div class="container-fluid">
      <div class="row">
     <!-- Info Boxes -->
<!-- Info Boxes -->
<div class="d-flex flex-wrap gap-3 mb-4 justify-content-between">
  <!-- Total Uploaded Files -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-success text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countUploaded"><?= count($complete_document); ?></h3>
        <p>Uploaded</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-upload"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Pending -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-warning text-dark p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countPending"><?= count($pending_document); ?></h3>
        <p>Pending</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-clock"></i>
      </div>
      <a href="#" class="small-box-footer text-dark d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Due -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-danger text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countDue"><?= count($due_document); ?></h3>
        <p>Due</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-exclamation-triangle"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Upcoming -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-info text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countUpcoming"><?= count($upcoming_document); ?></h3>
        <p>Upcoming</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-calendar"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Uploaded After Due Date -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-secondary text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countLate">0</h3>
        <p>Uploaded After Due Date</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-clock-o"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>
</div>
      </div>

      <!-- Table and Chart -->
<div class="row g-3">
  <!-- Documents List Table -->
  <div class="col-lg-8 col-md-12">
    <div class="card shadow-sm" style="border-radius:12px;">
      <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center" style="border-top-left-radius:12px; border-top-right-radius:12px; padding:0.25rem 1rem; height:auto;">
  <h3 class="card-title mb-0" style="font-size:1rem;">
    <i class="fa fa-file-alt"></i> Documents List
  </h3>

      <div class="d-flex align-items-center">
        <select id="statusFilter" class="form-control form-control-sm me-2" style="height:32px; font-size:0.875rem;">
          <option value="all">All</option>
          <option value="uploaded">Uploaded</option>
          <option value="pending">Pending</option>
          <option value="due">Due</option>
          <option value="upcoming">Upcoming</option>
          <option value="late">Uploaded After Due</option>
        </select>
        <input id="searchInput" type="search" placeholder="Search file..." class="form-control form-control-sm me-2" style="height:32px; font-size:0.875rem;" />
        <button id="exportCsv" class="btn btn-light btn-sm shadow-sm" style="height:32px; font-size:0.875rem; padding:0 10px; border-radius:6px;">
          <i class="fa fa-download"></i>
        </button>
      </div>
    </div>

      <div class="card-body table-responsive p-3" style="max-height: 400px;">
        <table class="table table-striped table-hover text-sm mb-0">
          <thead class="bg-light">
            <tr>
              <th>File</th>
              <th>Authority</th>
              <th>Year</th>
              <th>Month</th>
              <th>Upload Date</th>
              <th>Due Date</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody id="tableBody"></tbody>
        </table>
      </div>
      <div class="card-footer d-flex justify-content-between align-items-center" style="border-top:1px solid #dee2e6;">
        <div id="tableInfo" class="text-muted small"></div>
        <div>
          <button id="prevPage" class="btn btn-outline-secondary btn-sm">Prev</button>
          <button id="nextPage" class="btn btn-outline-secondary btn-sm">Next</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Status Breakdown Chart -->
  <div class="col-lg-4 col-md-12">
    <div class="card shadow-sm" style="border-radius:12px;">
      <div class="card-header bg-info text-white" style="border-top-left-radius:12px; border-top-right-radius:12px;">
        <h3 class="card-title"><i class="fa fa-chart-pie"></i> Status Breakdown</h3>
      </div>
      <div class="card-body p-3">
        <canvas id="statusChart" height="250"></canvas>
      </div>
    </div>
  </div>
</div>
