
  <!-- AdminLTE CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <!-- FontAwesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    .info-box:hover {
      transform: translateY(-4px);
      box-shadow: 0 6px 15px rgba(0,0,0,0.2);
      transition: all 0.3s ease;
    }
    .table-hover tbody tr:hover {
      background-color: #f4f6f9;
    }
  </style>

<div class="content">
  <section>
    <div class="container-fluid">
      <div class="row">
     <!-- Info Boxes -->
<!-- Info Boxes -->
<div class="d-flex flex-wrap gap-3 mb-4 justify-content-between">
  <!-- Total Uploaded Files -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-success text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countUploaded"><?= count($complete_document); ?></h3>
        <p>Uploaded</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-upload"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Pending -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-warning text-dark p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countPending"><?= count($pending_document); ?></h3>
        <p>Pending</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-clock"></i>
      </div>
      <a href="#" class="small-box-footer text-dark d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Due -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-danger text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countDue"><?= count($due_document); ?></h3>
        <p>Due</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-exclamation-triangle"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Upcoming -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-info text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countUpcoming"><?= count($upcoming_document); ?></h3>
        <p>Upcoming</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-calendar"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <!-- Uploaded After Due Date -->
  <div class="flex-fill" style="min-width: 180px; max-width: 18%;">
    <div class="small-box bg-secondary text-white p-3" style="border-radius:12px; position:relative;">
      <div class="inner">
        <h3 id="countLate">0</h3>
        <p>Uploaded After Due Date</p>
      </div>
      <div class="icon" style="position:absolute; top:10px; right:10px; font-size:40px; opacity:0.2;">
        <i class="fa fa-clock-o"></i>
      </div>
      <a href="#" class="small-box-footer text-white d-block mt-3">More info <i class="fa fa-arrow-circle-right"></i></a>
    </div>
  </div>
</div>
      </div>

      <!-- Table and Chart -->
<div class="row g-3">
  <!-- Documents List Table -->
  <!--<div class="col-lg-8 col-md-12">-->
    <div class="col-md-12">
    <div class="card shadow-sm" style="border-radius:12px;">
      <!--<div class="card-header bg-primary text-white d-flex justify-content-between align-items-center" style="border-top-left-radius:12px; border-top-right-radius:12px; padding:0.25rem 1rem; height:auto;">-->
        <div class="card-header bg-info text-white" style="border-top-left-radius:12px; border-top-right-radius:12px;">
          <div class="d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0" style="font-size:1rem;">
              <i class="fa fa-file-alt"></i> Uploaded Documents List
            </h3>

            <a href="<?= base_url('dashboard/export_documents_excel') ?>"
              class="btn btn-success btn-sm text-white"
              title="Download as Excel">
              <i class="fa fa-download me-1"></i>
              <i class="fa fa-file-excel"></i>
              <!--<span class="ms-1">Download Excel</span>-->
            </a>
          </div>
        </div>

      <div class="card-body table-responsive p-3" style="max-height: 400px;">
        <table class="table table-striped table-hover text-sm mb-0">
          <thead class="bg-light">
            <tr>
              <th style="text-align:center;">Sr.No</th>
              <th>Authority</th>
              <th>Document Head</th>
              <th>Document Name</th>
			  <th>Document Frequency</th>
              <th>Year</th>
              <th>Month</th>
              <th>Upload Date</th>
              <!--<th>Due Date</th>-->
            </tr>
          </thead>
           <tbody>
              <?php $i = 1;
                if (!empty($show_documents)) { ?>
                
                  <?php foreach ($show_documents as $row) { ?>
                      <tr>
                          <td style="text-align:center;"><?php echo $i++; ?></td>
                          <td><?php echo $row['authority_name']; ?></td>
                          <td><?php echo $row['type_name']; ?></td>
                          <td><?php //echo implode(', ', $row['documents']); ?>
                            <?php 
                            if (!empty($row['documents'])) {
                                $num = 1;
                                foreach ($row['documents'] as $doc) {
                                    echo $num++ . '. ' . $doc . '<br>';
                                }
                            }
                            ?>
                          </td>
						  <td><?php echo $row['frequency']; ?></td>
                          <td><?php echo $row['document_year']; ?></td>
                          <td>
                          <?php 
                              echo !empty($row['document_month']) 
                                  ? date("F", mktime(0, 0, 0, $row['document_month'], 1)) 
                                  : '';
                          ?>
                          </td>
                          <td><?php echo date("d-M-Y", strtotime($row['uploaded_date'])); ?></td>
                      </tr>
                  <?php } ?>
              <?php } else { ?>
                  <tr>
                      <td colspan="8" style="text-align:center;">No records found</td>
                  </tr>
              <?php } ?>
          </tbody>
        </table>
      </div>
      
      <!--<div class="card-footer d-flex justify-content-between align-items-center" style="border-top:1px solid #dee2e6;">
        <div id="tableInfo" class="text-muted small"></div>
        <div>
          <button id="prevPage" class="btn btn-outline-secondary btn-sm">Prev</button>
          <button id="nextPage" class="btn btn-outline-secondary btn-sm">Next</button>
        </div>
      </div>
    </div>-->
  </div>

  <!-- Status Breakdown Chart 
  <div class="col-lg-4 col-md-12">
    <div class="card shadow-sm" style="border-radius:12px;">
      <div class="card-header bg-info text-white" style="border-top-left-radius:12px; border-top-right-radius:12px;">
        <h3 class="card-title"><i class="fa fa-chart-pie"></i> Status Breakdown</h3>
      </div>
      <div class="card-body p-3">
        <canvas id="statusChart" height="250"></canvas>
      </div>
    </div>
  </div> -->
</div>
