<div class="table-responsive">
	<table class="table table-hover align-middle mb-0">
		<thead>
			<tr>
				<th style="text-align:center;">Sr No</th>
				<th style="text-align:left;">Company</th>
				<th style="text-align:left;">Type</th>
				<th style="text-align:left;">Missing Document</th>
				<th class="text-center">Action</th>
			</tr>
		</thead>
		
		<tbody>
			<?php 
			$sr = 1;
			foreach ($companyData as $company => $types): 
				$companyRowspan = 0;

				// Calculate total document rows for this company
				foreach ($types as $type) {
					$companyRowspan += count(explode(',', $type['missing_documents']));
				}

				$printedSr = false; // for Sr no
				$printedCompany = false; // for company cell

				foreach ($types as $type): 
					$docType = $type['type_name'];
					$missingDocs = explode(',', $type['missing_documents']);
					$typeRowspan = count($missingDocs); // for type rowspan
					$printedType = false;

					foreach ($missingDocs as $doc): ?>
						<tr>
							<?php if (!$printedSr): ?>
								<td rowspan="<?= $companyRowspan ?>"><?= $sr++; ?></td>
								<?php $printedSr = true; ?>
							<?php endif; ?>

							<?php if (!$printedCompany): ?>
								<td style="text-align:left;" rowspan="<?= $companyRowspan ?>"><?= htmlspecialchars($company) ?></td>
								<?php $printedCompany = true; ?>
							<?php endif; ?>

							<?php if (!$printedType): ?>
								<td style="text-align:left;" rowspan="<?= $typeRowspan ?>"><?= htmlspecialchars($docType) ?></td>
								<?php $printedType = true; ?>
							<?php endif; ?>

							<td style="text-align:left;"><?= htmlspecialchars(trim($doc)) ?></td>
							<td><a class="btn btn-sm btn-primary" href="#">Send Reminder</a></td>
						</tr>
					<?php endforeach;
				endforeach;
			endforeach; ?>
		</tbody>
	</table>
</div>