<!-- Main Content -->
<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Add button fixed inside card -->
      <a href="<?= base_url('company/addCompany') ?>" class="fab-top">
          <i class="fa-solid fa-plus"></i>
      </a>
      <div class="card-body">
        <div class="table-responsive">
          <table id="example" class="table align-middle text-center mb-0">
              <thead>
                  <tr>
                  <!--<th>ID</th>-->
					<th>Sr.No</th>
					<th style="text-align:left;">Company name</th>
					<th style="text-align:left;">Alias</th>
					<th style="text-align:left;">Contact Person</th>
					<th style="text-align:left;">Contact Email</th>
					<th style="text-align:left;">Co. Start Date</th>
					<th style="text-align:center;">Action</th>
                  </tr>
              </thead>
            <tbody>
				<?php $i=1;?>
				<?php foreach($company_list as $aut) { ?>
				<tr>
					<td><?php echo $i;?></td>
					<td style="text-align:left;"><?php echo $aut['company_name'];?></td>
					<td style="text-align:left;" ><?php echo $aut['short_name'];?></td>
					<td style="text-align:left;"><?php echo $aut['contact_person'];?></td>
					<td style="text-align:left;"><?php echo $aut['contact_email'];?></td>
					<td style="text-align:left;"><?php echo $aut['co_start_date'];?></td>
					<?php if($aut['status']=='1') { $status = 'Active';} else { $status='InActive';}?>
					
					<td class="text-center">
						<a href="<?= base_url('company/editCompany/'.$aut['id']) ?>" class="btn btn-warning btn-icon">
						<i class="fas fa-edit"></i>
					  </a>
					  <button onclick="confirmDelete(<?= $aut['id'] ?>)" class="btn btn-danger btn-icon">
						<i class="fas fa-trash-alt"></i>
					  </button>
					  <?php if ($aut['status'] == '1'): ?>
						<button onclick="statusChange(<?= $aut['id'] ?>, '0')" 
								class="btn btn-success btn-icon rounded-circle" 
								title="Active">
						  <i class="fas fa-check"></i>
						</button>
					  <?php else: ?>
						<button onclick="statusChange(<?= $aut['id'] ?>, '1')" 
								class="btn btn-secondary btn-icon rounded-circle"
								title="Inactive">
						  <i class="fas fa-times"></i>
						</button>
					  <?php endif; ?>	
						
					</td>
				</tr>
				
				<?php $i++; }  ?>
			</tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // DataTable init
    //new DataTable('#example');

	new DataTable('#example', {
		autoWidth: false,
		columnDefs: [
			{ width: "60px", targets: 0 },  // Sr. No
			{ width: "200px", targets: 1 }, // Company name
			{ width: "150px", targets: 2 }, // Alias
			{ width: "180px", targets: 3 }, // Contact Person
			{ width: "220px", targets: 4 }, // Contact Email
			{ width: "140px", targets: 5 }, // Co Start Date
			{ width: "160px", targets: 6 }, // Action buttons
		]
	});


    // SweetAlert flash message
    <?php if ($this->session->flashdata('message_name')): ?>
        Swal.fire({
            icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
            title: '<?= $this->session->flashdata('message_name') ?>',
            showConfirmButton: false,
            timer: 2000
        });
    <?php endif; ?>

    // SweetAlert confirm delete
    function confirmDelete(itemId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "This action cannot be undone!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = `<?= base_url('company/deleteCompany/') ?>${itemId}`;
            }
        });
    }
	function statusChange(itemId, status) {
		Swal.fire({
			title: 'Are you sure?',
			text: "This action cannot be undone!",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'Yes, change status!',
			cancelButtonText: 'Cancel'
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
					url: '<?= base_url("company/changeStatus"); ?>',
					method: 'POST',
					data: { id: itemId, status: status },
					success: function(response) {
						var res = JSON.parse(response);
						if (res.success) {
							Swal.fire('Success!', res.message, 'success').then(() => {
								location.reload();  // Reload OR update in place
							});
						} else {
							Swal.fire('Error!', res.message, 'error');
						}
					},
					error: function() {
						Swal.fire('Error!', 'Something went wrong!', 'error');
					}
				});
			}
		});
	}
</script>
<style>
	#example td, 
	#example th {
		white-space: nowrap;
	}
</style>
