<!-- Main Content -->
<div class="content">
  <div class="card">
    <div class="card position-relative shadow-sm rounded-4">
    <!-- Add button fixed inside card -->
      <a href="<?= base_url('authority/create') ?>" class="fab-top">
          <i class="fa-solid fa-plus"></i>
      </a>
      <div class="card-body">
        <div class="table-responsive" >
          <table class="table align-middle text-center mb-0" id="example">
              <thead>
                  <tr>
                  <!--<th>ID</th>-->
					<th>Sr.No</th>
                      <th style="text-align:left;">Authority Name</th>
                      <th style="text-align:left;">Alias</th>
                      <th>Created On</th>
                      <th>Action</th>
                  </tr>
              </thead>
            <tbody>
              
              <?php if(empty($authorities)): ?>
              <tr>
                  <td colspan="7" class="text-center">No authority types found</td>
              </tr>
              <?php else: 
				 $i = 1; ?>
                  <?php foreach($authorities as $row): ?>
                  <tr>
                      <td><?= $row->id ?></td>
                      <td style="text-align:left;"><?= $row->authority_name ?></td>
                      <td style="text-align:left;"><?= $row->alias_name ?></td>
                      <td><?= date("d-M-Y", strtotime($row->created_date)); ?></td>
                      <td>
                          <a href="<?= base_url('authority/edit/'.$row->id) ?>" class="btn btn-warning btn-icon"><i class="fas fa-edit"></i></a>
                          <a href="<?= base_url('authority/delete/'.$row->id) ?>" class="btn btn-danger btn-icon" onclick="return confirm('Are you sure to Delete?')"><i class="fas fa-trash-alt"></i></a>
                          <?php if ($row->status == '1'): ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-success btn-icon rounded-circle" 
                                  onclick="return confirm('Are you sure to deactivate?');" title="Active">
                                      <i class="fas fa-check"></i>
                                  </a>
                          <?php else: ?>
                                  <a href="<?= site_url('authority/toggle_status/'.$row->id); ?>" 
                                  class="btn btn-secondary btn-icon rounded-circle"
                                  onclick="return confirm('Are you sure to activate?');" title="Inactive">
                                      <i class="fas fa-times"></i>
                                  </a>
                          <?php endif; ?>
                      </td>
                  </tr>
                  <?php endforeach; ?>
              <?php endif; ?>
              </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Styles -->
<style>
select.form-select {
  padding: 0.4375rem 0.75rem;
  border: 0;
  outline: 1px solid #f3f3f3;
  color: #5e5151;
}
</style>

<!-- Scripts -->
<script src="<?php echo site_url(); ?>public/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/dataTables.bootstrap5.js"></script>
<script src="<?php echo site_url(); ?>public/assets/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  // DataTable init
  new DataTable('#example');

  // SweetAlert flash message
  <?php if ($this->session->flashdata('message_name')): ?>
    Swal.fire({
      icon: '<?= $this->session->flashdata('message_type') ?? 'success' ?>',
      title: '<?= $this->session->flashdata('message_name') ?>',
      showConfirmButton: false,
      timer: 2000
    });
  <?php endif; ?>

  // SweetAlert confirm delete
  function confirmDelete(itemId) {
    Swal.fire({
      title: 'Are you sure?',
      text: "This will permanently delete the record!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = `<?= base_url('type/deleteType/') ?>${itemId}`;
      }
    });
  }

  // SweetAlert confirm status change
  function statusChange(itemId, status) {
    let actionText = (status === '1') ? 'activate' : 'deactivate';
    Swal.fire({
      title: 'Are you sure?',
      text: `Do you really want to ${actionText} this record?`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonText: `Yes, ${actionText} it!`,
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: '<?= base_url("type/changeStatus"); ?>',
          method: 'POST',
          data: { id: itemId, status: status },
          success: function(response) {
            let res = JSON.parse(response);
            if (res.success) {
              Swal.fire('Success!', res.message, 'success').then(() => {
                location.reload();
              });
            } else {
              Swal.fire('Error!', res.message, 'error');
            }
          },
          error: function() {
            Swal.fire('Error!', 'Something went wrong!', 'error');
          }
        });
      }
    });
  }
</script>
