<!-- Main Content -->
<div class="content">
  <div class="formcard">
        <?php if (!empty($error_message)): ?>
          <div class="alert alert-danger"><?= $error_message; ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="form-group">
                <i class="fas fa-user-shield icon"></i>
                <input type="text" id="authority_name" name="authority_name" placeholder=" " required>
                <label for="authority_name">Authority Name</label>
                <div class="hint">Enter the official authority name.</div>
                <?php echo form_error('authority_name', '<div class="error">', '</div>'); ?>
            </div>
            <div class="form-group">
                <i class="fas fa-tag icon"></i>
                <input type="text" id="alias" name="alias" placeholder=" ">
                <label for="alias">Alias</label>
                <div class="hint">A short alias for quick reference.</div>
            </div>

            <div class="formbtn-group">
                <button type="submit" class="formbtn formbtn-save">Create</button>
                <a href="javascript:history.back()" class="formbtn formbtn-cancel">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script>
  // Real-time validation
  const form = document.getElementById('authorityForm');
  const inputs = form.querySelectorAll('input, textarea');

  inputs.forEach(input => {
    input.addEventListener('input', () => {
      const parent = input.parentElement;
      if (input.checkValidity()) {
        parent.classList.remove('invalid');
        parent.classList.add('valid');
      } else {
        parent.classList.remove('valid');
        parent.classList.add('invalid');
      }
    });
  });
</script>